REM Windows 10 launcher for OpenCPN with AISDECO2
REM John Cameron 18 Sep 2021

REM Delay (in seconds) before launch. Sometimes useful if the batch file is run at PC startup.
timeout 5

REM SDR dongle parameters - set as required.
REM Device index set to 0 if only one SDR dongle is present on the system, otherwise use aisdeco2 --device_index to determine which dongle to use for AIS.
REM This is significant, for example, if you use a second SDR for HF reception on the same PC.
set aisdeco2_device_index=0
REM Receiver gain in db. Use the free application AIRSPY to determine a good value.
set aisdeco2_gain=40.2
REM Frequency correction in ppm. Use the free application AIRSPY to determine a good value. NB 0 will cause an error.
set aisdeco2_freq_correction=1
REM Set the UDP address and port. You must also set an OpenCPN "connection" to match this.  
set aisdeco2_udp_address=localhost
set aisdeco2_udp_port=4159
REM End of SDR dongle parameter settings.

REM OpenCPN command line arguments - add as required (eg /fullscreen).
REM set opencpn_arg=/fullscreen
REM End of OpenCPN command line arguments.

REM Construct AISDECO2 arguments string.
set aisdeco2_arg=--device-index %aisdeco2_device_index% --gain %aisdeco2_gain% --freq-correction %aisdeco2_freq_correction% --udp %aisdeco2_udp_address%:%aisdeco2_udp_port%

REM Expect AISDECO2 to be in a subfolder of ProgramFiles or ProgramFiles (x86).
set aisdeco2_path="%ProgramFiles%\aisdeco2\aisdeco2.exe" %aisdeco2_arg%
if exist "%ProgramFiles(x86)%\aisdeco2" set aisdeco2_path="%ProgramFiles(x86)%\aisdeco2\aisdeco2.exe" %aisdeco2_arg%
REM Launch AISDECO2 - the console window will remain open.
REM To quit AISDECO2, either type Ctrl-C in the console, or close the console window.
start "AISDECO2" %aisdeco2_path%

REM Expect OpenCPN to be in a subfolder of ProgramFiles or ProgramFiles (x86).
set opencpn_path="%ProgramFiles%\opencpn\opencpn.exe" %opencpn_arg%
if exist "%ProgramFiles(x86)%\opencpn" set opencpn_path="%ProgramFiles(x86)%\opencpn\opencpn.exe" %opencpn_arg%
REM Launch OpenCPN - The console window will close
start "Launch OpenCPN" %opencpn_path%

REM --------------------- End of File -----------------------------------
