/*
 * Decompiled with CFR 0.152.
 */
package de.bevis.frn.log4j;

import de.bevis.frn.log4j.RollingCalendar;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class DailyLimitedRollingFileAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private int maxBackupFiles = 1;
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendar rc = new RollingCalendar();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    private boolean inFilenameAdjustment;

    public DailyLimitedRollingFileAppender() {
    }

    public DailyLimitedRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setMaxBackupFiles(int maxBackups) {
        this.maxBackupFiles = maxBackups;
    }

    public int getMaxBackupFiles() {
        return this.maxBackupFiles;
    }

    public void adjustLogFilename(String fileName) {
        this.inFilenameAdjustment = true;
        this.setFile(fileName);
        super.activateOptions();
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            int type;
            int n;
            DailyLimitedRollingFileAppender dailyLimitedRollingFileAppender;
            block13: {
                this.now.setTime(System.currentTimeMillis());
                this.sdf = new SimpleDateFormat(this.datePattern);
                dailyLimitedRollingFileAppender = this;
                RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.getDefault());
                Date date = new Date(0L);
                if (dailyLimitedRollingFileAppender.datePattern != null) {
                    int n2 = 0;
                    while (n2 <= 5) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dailyLimitedRollingFileAppender.datePattern);
                        simpleDateFormat.setTimeZone(gmtTimeZone);
                        String string = simpleDateFormat.format(date);
                        rollingCalendar.type = n2;
                        Date date2 = new Date(rollingCalendar.getNextCheckMillis(date));
                        String string2 = simpleDateFormat.format(date2);
                        if (string != null && string2 != null && !string.equals(string2)) {
                            n = n2;
                            break block13;
                        }
                        ++n2;
                    }
                }
                n = -1;
            }
            int n3 = type = n;
            dailyLimitedRollingFileAppender = this;
            switch (n3) {
                case 0: {
                    LogLog.debug((String)("Appender [" + dailyLimitedRollingFileAppender.name + "] to be rolled every minute."));
                    break;
                }
                case 1: {
                    LogLog.debug((String)("Appender [" + dailyLimitedRollingFileAppender.name + "] to be rolled on top of every hour."));
                    break;
                }
                case 2: {
                    LogLog.debug((String)("Appender [" + dailyLimitedRollingFileAppender.name + "] to be rolled at midday and midnight."));
                    break;
                }
                case 3: {
                    LogLog.debug((String)("Appender [" + dailyLimitedRollingFileAppender.name + "] to be rolled at midnight."));
                    break;
                }
                case 4: {
                    LogLog.debug((String)("Appender [" + dailyLimitedRollingFileAppender.name + "] to be rolled at start of week."));
                    break;
                }
                case 5: {
                    LogLog.debug((String)("Appender [" + dailyLimitedRollingFileAppender.name + "] to be rolled at start of every month."));
                    break;
                }
                default: {
                    LogLog.warn((String)("Unknown periodicity for appender [" + dailyLimitedRollingFileAppender.name + "]."));
                }
            }
            this.rc.type = type;
            File file = new File(this.fileName);
            this.scheduledFilename = String.valueOf(this.fileName) + this.sdf.format(new Date(file.lastModified()));
        } else {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
        LogLog.debug((String)("Max backup files kept: " + this.maxBackupFiles + "."));
    }

    protected void subAppend(LoggingEvent event) {
        block18: {
            long n = System.currentTimeMillis();
            if (n >= this.nextCheck) {
                this.now.setTime(n);
                this.nextCheck = this.rc.getNextCheckMillis(this.now);
                try {
                    DailyLimitedRollingFileAppender dailyLimitedRollingFileAppender = this;
                    if (dailyLimitedRollingFileAppender.datePattern == null) {
                        dailyLimitedRollingFileAppender.errorHandler.error("Missing DatePattern option in rollOver().");
                        break block18;
                    }
                    String string = String.valueOf(dailyLimitedRollingFileAppender.fileName) + dailyLimitedRollingFileAppender.sdf.format(dailyLimitedRollingFileAppender.now);
                    if (dailyLimitedRollingFileAppender.scheduledFilename.equals(string)) break block18;
                    dailyLimitedRollingFileAppender.closeFile();
                    if (dailyLimitedRollingFileAppender.inFilenameAdjustment) {
                        dailyLimitedRollingFileAppender.inFilenameAdjustment = false;
                    } else {
                        File file;
                        File file2 = new File(dailyLimitedRollingFileAppender.scheduledFilename);
                        if (file2.exists()) {
                            file2.delete();
                        }
                        if ((file = new File(dailyLimitedRollingFileAppender.fileName)).renameTo(file2)) {
                            LogLog.debug((String)(String.valueOf(dailyLimitedRollingFileAppender.fileName) + " -> " + dailyLimitedRollingFileAppender.scheduledFilename));
                            if (dailyLimitedRollingFileAppender.maxBackupFiles > 0) {
                                File file3 = file;
                                DailyLimitedRollingFileAppender dailyLimitedRollingFileAppender2 = dailyLimitedRollingFileAppender;
                                String string2 = file3.getParent();
                                if (string2 == null) {
                                    string2 = ".";
                                }
                                File file4 = new File(string2);
                                final String string3 = file3.getName();
                                FilenameFilter filenameFilter = new FilenameFilter(){

                                    @Override
                                    public boolean accept(File dir, String name) {
                                        return name.toLowerCase().startsWith(string3);
                                    }
                                };
                                File[] fileArray = file4.listFiles(filenameFilter);
                                Arrays.sort(fileArray, Collections.reverseOrder());
                                int n2 = 0;
                                File[] fileArray2 = fileArray;
                                int n3 = fileArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    File file5 = fileArray2[n4];
                                    ++n2;
                                    try {
                                        if (n2 > dailyLimitedRollingFileAppender2.maxBackupFiles && file5.exists()) {
                                            LogLog.debug((String)("delete " + file5.getCanonicalPath()));
                                            file5.delete();
                                        }
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                    ++n4;
                                }
                            }
                        } else {
                            LogLog.error((String)("Failed to rename [" + dailyLimitedRollingFileAppender.fileName + "] to [" + dailyLimitedRollingFileAppender.scheduledFilename + "]."));
                        }
                    }
                    try {
                        DailyLimitedRollingFileAppender dailyLimitedRollingFileAppender3 = dailyLimitedRollingFileAppender;
                        dailyLimitedRollingFileAppender3.setFile(dailyLimitedRollingFileAppender3.fileName, true, dailyLimitedRollingFileAppender.bufferedIO, dailyLimitedRollingFileAppender.bufferSize);
                    }
                    catch (IOException iOException) {
                        dailyLimitedRollingFileAppender.errorHandler.error("setFile(" + dailyLimitedRollingFileAppender.fileName + ", true) call failed.");
                    }
                    dailyLimitedRollingFileAppender.scheduledFilename = string;
                }
                catch (IOException iOException) {
                    IOException ioe = iOException;
                    if (iOException instanceof InterruptedIOException) {
                        Thread.currentThread().interrupt();
                    }
                    LogLog.error((String)"rollOver() failed.", (Throwable)ioe);
                }
            }
        }
        super.subAppend(event);
    }
}

