/*
 * Decompiled with CFR 0.152.
 */
package de.bevis.frn.log4j;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class RestrictedTelnetAppender
extends AppenderSkeleton {
    private SocketHandler sh;
    private int port = 23;
    private String acl;
    private String encoding = "Cp1252";

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        try {
            RestrictedTelnetAppender restrictedTelnetAppender = this;
            this.sh = restrictedTelnetAppender.new SocketHandler(restrictedTelnetAppender.port, this.NTeDI(), this.encoding);
            this.sh.start();
            return;
        }
        catch (Exception ex) {
            LogLog.error((String)(String.valueOf(ex.toString()) + " - " + ex.getMessage()));
            return;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getACL() {
        return this.acl;
    }

    public void setACL(String acl) {
        this.acl = acl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private String[] NTeDI() {
        if (this.acl != null) {
            StringTokenizer st = new StringTokenizer(this.acl, ",");
            Vector<String> vec = null;
            while (st.hasMoreTokens()) {
                if (vec == null) {
                    vec = new Vector<String>();
                }
                vec.add(st.nextToken());
            }
            if (vec != null) {
                Vector<String> vector = vec;
                return vector.toArray(new String[vector.size()]);
            }
        }
        return null;
    }

    public void close() {
        if (this.sh != null) {
            this.sh.finalize();
        }
    }

    protected void append(LoggingEvent event) {
        if (this.sh != null) {
            String[] s;
            this.sh.send(this.layout.format(event));
            if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
                int len = s.length;
                int i = 0;
                while (i < len) {
                    this.sh.send(s[i]);
                    this.sh.send(Layout.LINE_SEP);
                    ++i;
                }
            }
        }
    }

    protected class SocketHandler
    extends Thread {
        private boolean done = false;
        private Vector<PrintWriter> writers = new Vector();
        private Vector<Socket> connections = new Vector();
        private ServerSocket serverSocket;
        private int MAX_CONNECTIONS = 20;
        private List<String> acl_hostnames = null;
        private String encoding;

        public void finalize() {
            Enumeration<Socket> e = this.connections.elements();
            while (e.hasMoreElements()) {
                try {
                    e.nextElement().close();
                }
                catch (Exception exception) {}
            }
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {}
            this.done = true;
        }

        public void send(String message) {
            Enumeration<Socket> ce = this.connections.elements();
            Enumeration<PrintWriter> e = this.writers.elements();
            while (e.hasMoreElements()) {
                Socket sock = ce.nextElement();
                PrintWriter writer = e.nextElement();
                writer.print(message);
                if (!writer.checkError()) continue;
                this.connections.remove(sock);
                this.writers.remove(writer);
            }
        }

        @Override
        public void run() {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
            while (!this.done) {
                try {
                    Socket newClient = this.serverSocket.accept();
                    PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(newClient.getOutputStream(), this.encoding), true);
                    boolean access_denied = false;
                    if (this.acl_hostnames != null) {
                        access_denied = true;
                        for (String acl_hostname : this.acl_hostnames) {
                            try {
                                if (!InetAddress.getByName(acl_hostname).getHostAddress().equals(newClient.getInetAddress().getHostAddress())) continue;
                                access_denied = false;
                                break;
                            }
                            catch (UnknownHostException unknownHostException) {
                                unknownHostException.printStackTrace();
                            }
                        }
                    }
                    if (access_denied) {
                        String errMsg = "Access denied ! [IP: " + newClient.getInetAddress().getHostAddress() + "]";
                        LogLog.error((String)errMsg);
                        pw.print(errMsg);
                        pw.flush();
                        newClient.close();
                        continue;
                    }
                    if (this.connections.size() < this.MAX_CONNECTIONS) {
                        this.connections.addElement(newClient);
                        this.writers.addElement(pw);
                        pw.print("TelnetAppender v1.0 (" + this.connections.size() + " active connections)\r\n\r\n");
                        pw.flush();
                        continue;
                    }
                    pw.print("Too many connections.\r\n");
                    pw.flush();
                    newClient.close();
                }
                catch (Exception ex) {
                    LogLog.error((String)"Encountered error while in SocketHandler loop.", (Throwable)ex);
                }
            }
        }

        public SocketHandler(int port, String[] acl_hosts, String enc) throws IOException {
            this.serverSocket = new ServerSocket(port);
            if (acl_hosts != null) {
                this.acl_hostnames = Arrays.asList(acl_hosts);
            }
            this.encoding = enc;
        }
    }
}

