/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.Charset;

class UnicodeInputStreamReader
extends Reader {
    private static final int BOM_SIZE = 4;
    private final Charset _defaultEncoding;
    private InputStreamReader _reader;
    private final PushbackInputStream _stream;

    UnicodeInputStreamReader(InputStream in, Charset defaultEnc) {
        this._stream = new PushbackInputStream(in, 4);
        this._defaultEncoding = defaultEnc;
    }

    @Override
    public void close() throws IOException {
        this.init();
        this._reader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.init();
        return this._reader.read(cbuf, off, len);
    }

    protected void init() throws IOException {
        int unread;
        Charset encoding;
        if (this._reader != null) {
            return;
        }
        byte[] data = new byte[4];
        int n = this._stream.read(data, 0, data.length);
        Bom bom = Bom.find(data);
        if (bom == null) {
            encoding = this._defaultEncoding;
            unread = n;
        } else {
            encoding = bom._charset;
            unread = data.length - bom._bytes.length;
        }
        if (unread > 0) {
            this._stream.unread(data, n - unread, unread);
        }
        this._reader = new InputStreamReader((InputStream)this._stream, encoding);
    }

    private static final class Bom
    extends Enum<Bom> {
        public static final /* enum */ Bom UTF32BE;
        public static final /* enum */ Bom UTF32LE;
        public static final /* enum */ Bom UTF16BE;
        public static final /* enum */ Bom UTF16LE;
        public static final /* enum */ Bom UTF8;
        private final byte[] _bytes;
        private Charset _charset;
        private static final /* synthetic */ Bom[] ENUM$VALUES;

        static {
            byte[] byArray = new byte[4];
            byArray[2] = -2;
            byArray[3] = -1;
            UTF32BE = new Bom("UTF-32BE", byArray);
            byte[] byArray2 = new byte[4];
            byArray2[0] = -1;
            byArray2[1] = -2;
            UTF32LE = new Bom("UTF-32LE", byArray2);
            UTF16BE = new Bom("UTF-16BE", new byte[]{-2, -1});
            UTF16LE = new Bom("UTF-16LE", new byte[]{-1, -2});
            UTF8 = new Bom("UTF-8", new byte[]{-17, -69, -65});
            ENUM$VALUES = new Bom[]{UTF32BE, UTF32LE, UTF16BE, UTF16LE, UTF8};
        }

        private Bom(String charsetName, byte[] bytes) {
            try {
                this._charset = Charset.forName(charsetName);
            }
            catch (Exception exception) {
                this._charset = null;
            }
            this._bytes = bytes;
        }

        private static Bom find(byte[] data) {
            Bom ret = null;
            Bom[] bomArray = Bom.values();
            int n = bomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bom bom = bomArray[n2];
                if (bom.supported() && bom.match(data)) {
                    ret = bom;
                    break;
                }
                ++n2;
            }
            return ret;
        }

        private boolean match(byte[] data) {
            boolean ok = true;
            int i = 0;
            while (i < this._bytes.length) {
                if (data[i] != this._bytes[i]) {
                    ok = false;
                    break;
                }
                ++i;
            }
            return ok;
        }

        private boolean supported() {
            return this._charset != null;
        }

        public static Bom[] values() {
            Bom[] bomArray = ENUM$VALUES;
            int n = bomArray.length;
            Bom[] bomArray2 = new Bom[n];
            System.arraycopy(ENUM$VALUES, 0, bomArray2, 0, n);
            return bomArray2;
        }

        public static Bom valueOf(String string) {
            return Enum.valueOf(Bom.class, string);
        }
    }
}

