/*
 * Decompiled with CFR 0.152.
 */
package de.bevis.frn.server;

import com.thoughtworks.xstream.XStream;
import de.bevis.frn.commons.ObfFcts;
import de.bevis.frn.server.BANnE;
import de.bevis.frn.server.EWriS;
import de.bevis.frn.server.FIEsT;
import de.bevis.frn.server.GaRdi;
import de.bevis.frn.server.MERWI;
import de.bevis.frn.server.Server;
import de.bevis.frn.server.eRsHe;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TRayS
implements Runnable {
    protected static Log log = LogFactory.getLog(TRayS.class);
    private ThreadGroup threadGroup;
    private Socket socket = null;
    private BufferedReader reader = null;
    private PrintStream writer = null;
    private String challenge;
    private static final String LINE_SEPARATOR = "\r\n";
    private XStream myXStream = null;
    private ConcurrentHashMap<String, Object> clientIDs = null;
    private MERWI passwdList;
    private static Pattern eMailAddrPattern1 = Pattern.compile("^[A-Z0-9][A-Z0-9@._%+-]{5,253}$", 2);
    private static Pattern eMailAddrPattern2 = Pattern.compile("^[A-Z0-9._%+-]{1,64}+@(?:(?=[A-Z0-9-]{1,63}+\\.)[A-Z0-9]++(?:-[A-Z0-9]++)*+\\.){1,8}+[A-Z]{2,63}+$", 2);

    public TRayS(ThreadGroup threadGroup, Socket socket, MERWI passwdList) {
        this.threadGroup = threadGroup;
        this.socket = socket;
        XStream xStream = new XStream();
        XStream.setupDefaultSecurity((XStream)xStream);
        xStream.allowTypesByWildcard(new String[]{"de.bevis.frn.**"});
        xStream.alias("SC", EWriS.class);
        xStream.processAnnotations(EWriS.class);
        xStream.alias("CC", GaRdi.class);
        xStream.processAnnotations(GaRdi.class);
        xStream.alias("CD", FIEsT.class);
        xStream.processAnnotations(FIEsT.class);
        xStream.ignoreUnknownElements();
        this.myXStream = xStream;
        this.clientIDs = new ConcurrentHashMap();
        this.passwdList = passwdList;
    }

    @Override
    public void run() {
        try {
            this.socket.setSoTimeout(5000);
            this.socket.setTcpNoDelay(true);
            this.socket.setSoLinger(true, 3);
            log.trace((Object)("SoTimeout=" + this.socket.getSoTimeout()));
            log.trace((Object)("TcpNoDelay=" + this.socket.getTcpNoDelay()));
            log.trace((Object)("OOBInline=" + this.socket.getOOBInline()));
            log.trace((Object)("KeepAlive=" + this.socket.getKeepAlive()));
            log.trace((Object)("SendBufferSize=" + this.socket.getSendBufferSize()));
            log.trace((Object)("ReceiveBufferSize=" + this.socket.getReceiveBufferSize()));
            log.trace((Object)("SoLinger=" + this.socket.getSoLinger()));
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "Cp1252"));
            this.writer = new PrintStream(this.socket.getOutputStream(), false, "Cp1252");
            while (true) {
                String request;
                if ((request = this.reader.readLine()) == null) {
                    throw new IOException("unexpected EOS");
                }
                String[] str_arr = request.split(":", 2);
                if (str_arr.length == 2) {
                    String string;
                    Object object;
                    Object object2;
                    String cmd = str_arr[0];
                    String data = str_arr[1];
                    if (cmd.equals("SC")) {
                        object2 = data;
                        object = this;
                        string = "<SC>" + (String)object2 + "</SC>";
                        if (log.isTraceEnabled()) {
                            log.trace((Object)(String.valueOf("RA ") + "xml=[" + string + "]"));
                        }
                        EWriS scRequest = (EWriS)((TRayS)object).myXStream.fromXML(string);
                        log.debug((Object)scRequest);
                        StringBuffer line = new StringBuffer();
                        line.append("<SV>" + BANnE.SERVER_VERSION + "</SV>");
                        line.append("<CV>" + BANnE.CLIENT_VERSION + "</CV>");
                        line.append("<MC>" + BANnE.MANAGER_VERSION + "</MC>");
                        String randomStr = String.format("%08d", new SecureRandom().nextInt(99999999));
                        this.challenge = new ObfFcts().mkc(randomStr);
                        line.append("<AL>0</AL>");
                        line.append("<KP>" + randomStr + "</KP>");
                        this.writer.print(String.valueOf(line.toString()) + LINE_SEPARATOR);
                        this.writer.flush();
                        continue;
                    }
                    if ("CC".equalsIgnoreCase(cmd)) {
                        object2 = data;
                        object = this;
                        object2 = TRayS.ONEss(TRayS.ONEss(TRayS.ONEss(TRayS.ONEss(TRayS.ONEss(TRayS.ONEss((String)object2, "ON"), "BC"), "CT"), "DS"), "PW"), "U8TF");
                        string = "<CC>" + (String)object2 + "</CC>";
                        if (log.isTraceEnabled()) {
                            log.trace((Object)(String.valueOf("RA ") + "xml=[" + string + "]"));
                        }
                        GaRdi cc = (GaRdi)((TRayS)object).myXStream.fromXML(string);
                        log.debug((Object)cc);
                        int error = 0;
                        String op = cc.UNdul();
                        String em = cc.FLErs();
                        String pw = cc.arEcL();
                        if (op == null || op.trim().isEmpty()) {
                            log.error((Object)"mandatory field operator name is empty!");
                            error = 1;
                        } else if (em == null || em.trim().isEmpty()) {
                            log.error((Object)"mandatory field eMail address is empty!");
                            error = 1;
                        } else if (pw == null || pw.trim().isEmpty()) {
                            log.error((Object)"mandatory field password is empty!");
                            error = 1;
                        } else {
                            string = cc.FLErs();
                            boolean bl = false;
                            if (eMailAddrPattern1.matcher(string).matches() && eMailAddrPattern2.matcher(string).matches()) {
                                bl = true;
                            }
                            if (!bl) {
                                log.error((Object)("eMailAddr: '" + cc.FLErs() + "' - invalid eMail format!"));
                                error = 1;
                            } else if (pw.contains("yes") || pw.contains("/opt/PiCQ")) {
                                error = 2;
                            } else if ("@".equals(em) && "Password".equals(pw) && "Callsign, Operator".equals(op)) {
                                error = 2;
                            } else {
                                int rVal;
                                int n;
                                object2 = cc;
                                object = this;
                                if (((TRayS)object).passwdList.HyRAn()) {
                                    n = 0;
                                } else if (((GaRdi)object2).forIN() != null && ((GaRdi)object2).forIN().equals(Server.atiMe)) {
                                    n = 1;
                                } else {
                                    int n2 = -2;
                                    for (eRsHe eRsHe2 : ((TRayS)object).passwdList.ioNsh()) {
                                        if (!((GaRdi)object2).UNdul().equals(eRsHe2.OnShu()) || !((GaRdi)object2).FLErs().equals(eRsHe2.acRol())) continue;
                                        if (eRsHe2.sEsSE()) {
                                            n2 = -2;
                                            break;
                                        }
                                        if (((GaRdi)object2).arEcL().equals(eRsHe2.NPreV())) {
                                            n2 = 1;
                                            break;
                                        }
                                        n2 = -1;
                                        break;
                                    }
                                    n = rVal = n2;
                                }
                                if (n == -1) {
                                    error = 1;
                                } else if (rVal == -2) {
                                    error = 2;
                                }
                            }
                        }
                        if (error == 1) {
                            this.writer.print("WRONG\r\n");
                        } else if (error == 2) {
                            this.writer.print("BLOCK\r\n");
                        } else {
                            object = cc;
                            String string2 = String.valueOf(((GaRdi)object).FLErs()) + "|" + ((GaRdi)object).arEcL();
                            String clientID = "~" + UUID.nameUUIDFromBytes(string2.getBytes()).toString() + "~";
                            if (this.clientIDs.containsKey(clientID) || this.clientIDs.containsKey(cc.UNdul()) || this.clientIDs.containsKey(cc.FLErs())) {
                                this.writer.print("DUPL\r\n");
                            } else {
                                this.clientIDs.put(clientID, cc);
                                this.clientIDs.put(cc.UNdul(), clientID);
                                this.clientIDs.put(cc.FLErs(), clientID);
                                this.writer.print(String.valueOf(clientID) + LINE_SEPARATOR);
                            }
                        }
                        this.writer.flush();
                        continue;
                    }
                    if (!"CD".equalsIgnoreCase(cmd)) continue;
                    object2 = data;
                    object = this;
                    string = "<CD>" + (String)object2 + "</CD>";
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(String.valueOf("RA ") + "xml=[" + string + "]"));
                    }
                    FIEsT cd = (FIEsT)((TRayS)object).myXStream.fromXML(string);
                    log.debug((Object)cd);
                    GaRdi cc = (GaRdi)this.clientIDs.get(cd.EOuMs());
                    if (cc != null) {
                        this.clientIDs.remove(cd.EOuMs());
                        this.clientIDs.remove(cc.UNdul());
                        this.clientIDs.remove(cc.FLErs());
                    }
                    this.writer.print("OK\r\n");
                    this.writer.flush();
                    continue;
                }
                if (request.equals("P")) {
                    this.writer.print("F\r\n");
                    this.writer.flush();
                    continue;
                }
                if (!request.equals(this.challenge)) continue;
                this.writer.print("F\r\n");
                this.writer.flush();
            }
        }
        catch (SocketException ex) {
            log.error((Object)(String.valueOf("RA ") + "main loop, " + ex.toString() + " at " + TRayS.NTeDI(ex)));
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)(String.valueOf("RA ") + "main loop, " + ex.toString() + " at " + TRayS.NTeDI(ex)));
        }
        catch (IOException ex) {
            log.error((Object)(String.valueOf("RA ") + "main loop, " + ex.toString() + " at " + TRayS.NTeDI(ex)));
        }
        catch (Exception ex) {
            log.error((Object)(String.valueOf("RA ") + "main loop, " + ex.toString() + " at " + TRayS.NTeDI(ex)));
        }
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.socket != null) {
                this.socket.close();
                return;
            }
        }
        catch (IOException ex) {
            log.error((Object)(String.valueOf("RA ") + "close, " + ex.toString()), (Throwable)ex);
        }
    }

    private static String ONEss(String data, String xmlTag) {
        try {
            String beginTag = "<" + xmlTag + ">";
            String endTag = "</" + xmlTag + ">";
            int idx1 = data.indexOf(beginTag);
            int idx2 = data.lastIndexOf(endTag);
            if (idx1 >= 0 && idx2 >= idx1) {
                String escapedValue = StringEscapeUtils.escapeXml10((String)data.substring(idx1 + beginTag.length(), idx2));
                data = String.valueOf(data.substring(0, idx1 + beginTag.length())) + escapedValue + data.substring(idx2);
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            log.error((Object)("escape4Xml failed ! - data=[" + data + "], xmlTag=[" + xmlTag + "]"), (Throwable)ex);
        }
        return data;
    }

    private static String NTeDI(Exception ex) {
        return ex.getStackTrace()[0].toString().replace("de.bevis.", "");
    }
}

