from owrx.property import PropertyLayer


defaultConfig = PropertyLayer(
    version=8,
    max_clients=20,
    receiver_name="[Callsign]",
    receiver_location="Budapest, Hungary",
    receiver_asl=200,
    receiver_admin="example@example.com",
    receiver_gps=PropertyLayer(lat=47.0, lon=19.0),
    photo_title="Panorama of Budapest from Schönherz Zoltán Dormitory",
    photo_desc="",
    fft_fps=9,
    fft_size=4096,
    fft_voverlap_factor=0.3,
    audio_compression="adpcm",
    fft_compression="adpcm",
    wfm_deemphasis_tau=50e-6,
    wfm_rds_rbds=False,
    digimodes_fft_size=2048,
    digital_voice_dmr_id_lookup=True,
    digital_voice_nxdn_id_lookup=True,
    sdrs=PropertyLayer(
        rtlsdr=PropertyLayer(
            name="RTL-SDR",
            type="rtl_sdr",
            rf_gain=29,
            direct_sampling=0,
            profiles=PropertyLayer(
                **{
                    "70cm": PropertyLayer(
                        name="70cm Repeaters",
                        center_freq=438800000,
                        rf_gain=29,
                        samp_rate=2400000,
                        start_freq=439275000,
                        start_mod="nfm",
                        tuning_step="5000",
                    ),
                    "2m": PropertyLayer(
                        name="2m",
                        center_freq=145000000,
                        rf_gain=29,
                        samp_rate=2048000,
                        start_freq=145725000,
                        start_mod="nfm",
                        tuning_step="5000",
                    ),
                    "10m": PropertyLayer(
                        name="10m + CB",
                        center_freq=28000000,
                        samp_rate=2048000,
                        start_freq=27500000,
                        start_mod="am",
                        tuning_step="500",
                    ),
                    "40m": PropertyLayer(
                        name="40m",
                        center_freq=7500000,
                        samp_rate=1024000,
                        start_freq=7300000,
                        start_mod="lsb",
                        tuning_step="500",
                        direct_sampling=2,
                    ),
                    "80m": PropertyLayer(
                        name="80m",
                        center_freq=3500000,
                        samp_rate=1024000,
                        start_freq=3700000,
                        start_mod="lsb",
                        tuning_step="500",
                        direct_sampling=2,
                    ),
                    "160m": PropertyLayer(
                        name="160m",
                        center_freq=1500000,
                        samp_rate=1024000,
                        start_freq=1800000,
                        start_mod="lsb",
                        tuning_step="500",
                        direct_sampling=2,
                    ),
                    "am": PropertyLayer(
                        name="AM Broadcast",
                        center_freq=1000000,
                        samp_rate=1024000,
                        start_freq=1200000,
                        start_mod="am",
                        tuning_step="5000",
                        direct_sampling=2,
                    ),
                    "adsb1090": PropertyLayer(
                        name="1090MHz ADSB",
                        center_freq=1090000000,
                        rf_gain=29,
                        samp_rate=2400000,
                        start_freq=1090000000,
                        start_mod="nfm",
                        tuning_step="25000",
                    ),
                }
            ),
        ),
        airspy=PropertyLayer(
            name="Airspy HF+",
            type="airspyhf",
            rf_gain="auto",
            profiles=PropertyLayer(
                **{
                    "20m": PropertyLayer(
                        name="20m",
                        center_freq=14150000,
                        samp_rate=384000,
                        start_freq=14070000,
                        start_mod="usb",
                        tuning_step="500",
                    ),
                    "30m": PropertyLayer(
                        name="30m",
                        center_freq=10125000,
                        samp_rate=192000,
                        start_freq=10142000,
                        start_mod="usb",
                        tuning_step="500",
                    ),
                    "40m": PropertyLayer(
                        name="40m",
                        center_freq=7100000,
                        samp_rate=256000,
                        start_freq=7070000,
                        start_mod="lsb",
                        tuning_step="500",
                    ),
                    "80m": PropertyLayer(
                        name="80m",
                        center_freq=3650000,
                        samp_rate=384000,
                        start_freq=3570000,
                        start_mod="lsb",
                        tuning_step="500",
                    ),
                    "49m": PropertyLayer(
                        name="49m Broadcast",
                        center_freq=6050000,
                        samp_rate=384000,
                        start_freq=6070000,
                        start_mod="am",
                        tuning_step="5000",
                    ),
                }
            ),
        ),
        sdrplay=PropertyLayer(
            name="SDRPlay",
            type="sdrplay",
            antenna="Antenna A",
            rf_gain="auto",
            profiles=PropertyLayer(
                **{
                    "70cm": PropertyLayer(
                        name="70cm Repeaters",
                        center_freq=443500000,
                        samp_rate=4000000,
                        start_freq=444000000,
                        start_mod="nfm",
                        tuning_step="5000",
                    ),
                    "125cm": PropertyLayer(
                        name="1.25m",
                        center_freq=223500000,
                        samp_rate=4000000,
                        start_freq=224000000,
                        start_mod="nfm",
                        tuning_step="5000",
                    ),
                    "2m": PropertyLayer(
                        name="2m",
                        center_freq=146000000,
                        samp_rate=4000000,
                        start_freq=147000000,
                        start_mod="nfm",
                        tuning_step="5000",
                    ),
                    "6m": PropertyLayer(
                        name="6m",
                        center_freq=52000000,
                        samp_rate=4000000,
                        start_freq=53000000,
                        start_mod="usb",
                        tuning_step="500",
                    ),
                    "10m": PropertyLayer(
                        name="10m",
                        center_freq=28850000,
                        samp_rate=2000000,
                        start_freq=29000000,
                        start_mod="usb",
                        tuning_step="500",
                    ),
                    "cb": PropertyLayer(
                        name="11m CB",
                        center_freq=27000000,
                        samp_rate=2000000,
                        start_freq=26965000,
                        start_mod="am",
                        tuning_step="5000",
                    ),
                    "12m": PropertyLayer(
                        name="12m",
                        center_freq=24940000,
                        samp_rate=250000,
                        start_freq=24950000,
                        start_mod="usb",
                        tuning_step="500",
                    ),
                    "15m": PropertyLayer(
                        name="15m",
                        center_freq=21225000,
                        samp_rate=500000,
                        start_freq=21220000,
                        start_mod="usb",
                        tuning_step="500",
                    ),
                    "17m": PropertyLayer(
                        name="17m",
                        center_freq=18118000,
                        samp_rate=250000,
                        start_freq=18110000,
                        start_mod="usb",
                        tuning_step="500",
                    ),
                    "20m": PropertyLayer(
                        name="20m",
                        center_freq=14175000,
                        samp_rate=500000,
                        start_freq=14070000,
                        start_mod="usb",
                        tuning_step="500",
                    ),
                    "30m": PropertyLayer(
                        name="30m",
                        center_freq=10125000,
                        samp_rate=250000,
                        start_freq=10142000,
                        start_mod="usb",
                        tuning_step="500",
                    ),
                    "40m": PropertyLayer(
                        name="40m",
                        center_freq=7150000,
                        samp_rate=500000,
                        start_freq=7070000,
                        start_mod="lsb",
                        tuning_step="500",
                    ),
                    "60m": PropertyLayer(
                        name="60m",
                        center_freq=5350000,
                        samp_rate=250000,
                        start_freq=5357000,
                        start_mod="usb",
                        tuning_step="500",
                    ),
                    "80m": PropertyLayer(
                        name="80m",
                        center_freq=3750000,
                        samp_rate=500000,
                        start_freq=3570000,
                        start_mod="lsb",
                        tuning_step="500",
                    ),
                    "160m": PropertyLayer(
                        name="160m",
                        center_freq=1900000,
                        samp_rate=250000,
                        start_freq=1910000,
                        start_mod="lsb",
                        tuning_step="500",
                    ),
                    "am": PropertyLayer(
                        name="AM Broadcast",
                        center_freq=1100000,
                        samp_rate=1000000,
                        start_freq=1300000,
                        start_mod="am",
                        tuning_step="5000",
                    ),
                    "49m": PropertyLayer(
                        name="49m Broadcast",
                        center_freq=6050000,
                        samp_rate=500000,
                        start_freq=6070000,
                        start_mod="am",
                        tuning_step="5000",
                    ),
                    "41m": PropertyLayer(
                        name="41m Broadcast",
                        center_freq=7325000,
                        samp_rate=250000,
                        start_freq=7320000,
                        start_mod="am",
                        tuning_step="5000",
                    ),
                    "31m": PropertyLayer(
                        name="31m Broadcast",
                        center_freq=9650000,
                        samp_rate=500000,
                        start_freq=9700000,
                        start_mod="am",
                        tuning_step="5000",
                    ),
                    "25m": PropertyLayer(
                        name="25m Broadcast",
                        center_freq=11850000,
                        samp_rate=500000,
                        start_freq=12000000,
                        start_mod="am",
                        tuning_step="5000",
                    ),
                    "22m": PropertyLayer(
                        name="22m Broadcast",
                        center_freq=13720000,
                        samp_rate=500000,
                        start_freq=13800000,
                        start_mod="am",
                        tuning_step="5000",
                    ),
                    "ism433": PropertyLayer(
                        name="433MHz ISM",
                        center_freq=433000000,
                        samp_rate=2000000,
                        start_freq=433000000,
                        start_mod="nfm",
                        tuning_step="25000",
                    ),
                    "adsb1090": PropertyLayer(
                        name="1090MHz ADSB",
                        center_freq=1090000000,
                        samp_rate=4000000,
                        start_freq=1090000000,
                        start_mod="nfm",
                        tuning_step="25000",
                    ),
                }
            ),
        ),
    ),
    waterfall_scheme="GoogleTurboWaterfall",
    waterfall_levels=PropertyLayer(min=-88, max=-20),
    waterfall_auto_levels=PropertyLayer(min=3, max=10),
    waterfall_auto_level_default_mode=False,
    waterfall_auto_min_range=50,
    key_locked=False,
    magic_key="memagic",
    allow_center_freq_changes=False,
    allow_audio_recording=True,
    allow_chat=True,
    tuning_precision=2,
    squelch_auto_margin=10,
    google_maps_api_key="",
    openweathermap_api_key="",
    map_type="google",
    map_position_retention_time=2 * 60 * 60,
    map_call_retention_time=5 * 60,
    map_max_calls=5,
    map_prefer_recent_reports=True,
    map_ignore_indirect_reports=False,
    callsign_url="https://www.qrzcq.com/call/{}",
    vessel_url="https://www.vesselfinder.com/vessels/details/{}",
    flight_url="https://flightaware.com/live/flight/{}",
    modes_url="https://flightaware.com/live/modes/{}/redirect",
    usage_policy_url="policy",
    session_timeout=0,
    keep_files=20,
    decoding_queue_workers=2,
    decoding_queue_length=10,
    wsjt_decoding_depth=3,
    wsjt_decoding_depths=PropertyLayer(jt65=1),
    fst4_enabled_intervals=[15, 30],
    fst4w_enabled_intervals=[120, 300],
    q65_enabled_combinations=["A30", "E120", "C60"],
    js8_enabled_profiles=["normal", "slow"],
    js8_decoding_depth=3,
    services_enabled=False,
    services_decoders=["ft8", "ft4", "wspr", "packet"],
    aprs_callsign="N0CALL",
    aprs_igate_enabled=False,
    aprs_igate_server="euro.aprs2.net",
    aprs_igate_password="",
    aprs_igate_beacon=False,
    aprs_igate_symbol="R&",
    aprs_igate_comment="OpenWebRX APRS gateway",
    # aprs_igate_height=None,
    # aprs_igate_gain=None,
    # aprs_igate_dir=None,
    pskreporter_enabled=False,
    pskreporter_callsign="N0CALL",
    # pskreporter_antenna_information=None,
    wsprnet_enabled=False,
    wsprnet_callsign="N0CALL",
    mqtt_enabled=False,
    mqtt_host="localhost",
    mqtt_use_ssl=False,
    paging_filter=True,
    paging_charset="US",
    eibi_bookmarks_range=0,
    repeater_range=0,
    adsb_ttl=900,
    vdl2_ttl=1800,
    hfdl_ttl=1800,
    acars_ttl=1800,
    fax_lpm=120,
    fax_length=1400,
    fax_postprocess=True,
    fax_color=False,
    fax_am=False,
    cw_showcw=False,
    dsc_show_errors=True,
    gps_updates=False,
    bandplan_region=0,
    rig_enabled=False,
    rig_model=2,
    rig_device="127.0.0.1:4533",
    rig_address=0
).readonly()
