VERSION = '0.0.1'
PROGRAM = 'dsame3_simple'
DESCRIPTION = 'dsame3_simple is a program to decode EAS/SAME alert messages'
COPYRIGHT = 'Copyright (C) 2016 Joseph W. Metcalf\nModified by James Kitchens 2023'

TEST_STRING = 'EAS: ZCZC-WXR-RWT-055027-055039-055047-055117-055131-055137-055139-055015-055071+0030-0771800-KMKX/NWS-'

TEST1 = ' ./dsame.py --msg "ZCZC-WXR-RWT-020103-020209-020091-020121-029047- 029165-029095-029037+0030-1051700-KEAX/NWS" '
TEST2 = ' ./dsame.py --msg "ZCZC-WXR-RWT-029005+0030-832300-XDIF/005" '
TEST3 = ' ./dsame.py --msg "ZCZC-WXR-RWT-000000+0030-832300-XDIF/005" '

MSG__TEXT = {
    'EN':
        {'MSG1': '{article} {organization} {preposition} {location} {has} issued a {event} valid until {end}',
         'MSG2': '{conjunction} for the following {division} in {state}: ',
         'MSG3': '{county}{punc} ',
         'MSG4': '',
         'AND': 'and',
         'ALL': 'all',
         'HAS': 'has',
         'HAVE': 'have',
         'THE': 'the',
         'A': 'a',
         'IN': 'in',
         '': '',
         },
    'SP':
        {'MSG1': '{article} {organization} {preposition} {location} {has} emitido una {event} valida hasta {end}',
         'MSG2': '{conjunction} para los siguientes {division} en {state}: ',
         'MSG3': '{county}{punc} ',
         'MSG4': '',
         'AND': 'y',
         'ALL': 'todos',
         'HAS': 'ha',
         'HAVE': 'tiene',
         'THE': 'la',
         'A': 'un',
         'IN': 'en',
         '': '',
         }
}

FIPS_DIVN = {
    '': None,
    '02': 'boroughs',
    '22': 'parishes',
    '11': None,
    '57': None,
    '58': None,
    '59': None,
    '60': None,
    '61': None,
    '64': None,
    '65': None,
    '66': None,
    '68': None,
    '69': None,
    '70': None,
    '73': None,
    '74': None,
    '75': None,
    '77': None,
    '78': None,
    '91': None,
    '92': None,
    '93': None,
    '94': None,
    '96': None,
    '97': None,
    '98': None,
}

US_SAME_AREA = {
    'LOCATION': 'US',
    '00': 'United States of America',
    '01': 'Alabama',
    '02': 'Alaska',
    '04': 'Arizona',
    '05': 'Arkansas',
    '06': 'California',
    '08': 'Colorado',
    '09': 'Connecticut',
    '10': 'Delaware',
    '11': 'District of Columbia',
    '12': 'Florida',
    '13': 'Georgia',
    '15': 'Hawaii',
    '16': 'Idaho',
    '17': 'Illinois',
    '18': 'Indiana',
    '19': 'Iowa',
    '20': 'Kansas',
    '21': 'Kentucky',
    '22': 'Louisiana',
    '23': 'Maine',
    '24': 'Maryland',
    '25': 'Massachusetts',
    '26': 'Michigan',
    '27': 'Minnesota',
    '28': 'Mississippi',
    '29': 'Missouri',
    '30': 'Montana',
    '31': 'Nebraska',
    '32': 'Nevada',
    '33': 'New Hampshire',
    '34': 'New Jersey',
    '35': 'New Mexico',
    '36': 'New York',
    '37': 'North Carolina',
    '38': 'North Dakota',
    '39': 'Ohio',
    '40': 'Oklahoma',
    '41': 'Oregon',
    '42': 'Pennsylvania',
    '44': 'Rhode Island',
    '45': 'South Carolina',
    '46': 'South Dakota',
    '47': 'Tennessee',
    '48': 'Texas',
    '49': 'Utah',
    '50': 'Vermont',
    '51': 'Virginia',
    '53': 'Washington',
    '54': 'West Virginia',
    '55': 'Wisconsin',
    '56': 'Wyoming',
    '57': 'Pacific Coast from Washington to California',
    '58': 'Alaskan Coast',
    '59': 'Hawaiian Coast',
    '60': 'American Samoa',
    '61': 'American Samoa Waters',
    '64': 'Federated States of Micronesia',
    '65': 'Mariana Islands Waters (including Guam)',
    '66': 'Guam',
    '68': 'Marshall Islands',
    '69': 'Northern Mariana Islands',
    '70': 'Palau',
    '72': 'Puerto Rico',
    '73': 'Atlantic Coast from Maine to Virginia',
    '74': 'U.S. Minor Outlying Islands',
    '75': 'Atlantic Coast from North Carolina to Florida, and the Coasts of Puerto Rico and Virgin Islands',
    '77': 'Gulf of Mexico',
    '78': 'Virgin Islands',
    '91': 'Lake Superior',
    '92': 'Lake Michigan',
    '93': 'Lake Huron',
    '94': 'Saint Clair River, Detroit River, and Lake Saint Clair',
    '96': 'Lake Erie',
    '97': 'Niagara River and Lake Ontario',
    '98': 'Saint Lawrence River',
    'XX': 'TEST',
}

CA_SAME_AREA = {
    'LOCATION': 'CA',
    '11': 'Nova Scotia',
    '12': 'Nova Scotia',
    '13': 'Nova Scotia',
    '14': 'Nova Scotia',
    '15': 'New Brunswick',
    '16': 'New Brunswick',
    '17': 'New Brunswick',
    '18': 'Prince Edward Island',
    '21': 'Newfoundland/Labrador',
    '22': 'Newfoundland/Labrador',
    '23': 'Newfoundland/Labrador',
    '24': 'Newfoundland/Labrador',
    '25': 'Newfoundland/Labrador',
    '26': 'Newfoundland/Labrador',
    '27': 'Newfoundland/Labrador',
    '28': 'Newfoundland/Labrador',
    '29': 'Newfoundland/Labrador',
    '31': 'Quebec',
    '32': 'Quebec',
    '33': 'Quebec',
    '34': 'Quebec',
    '35': 'Quebec',
    '36': 'Quebec',
    '37': 'Quebec',
    '38': 'Quebec',
    '39': 'Quebec',
    '41': 'Ontario',
    '42': 'Ontario',
    '43': 'Ontario',
    '44': 'Ontario',
    '45': 'Ontario',
    '46': 'Ontario',
    '47': 'Ontario',
    '48': 'Ontario',
    '49': 'Ontario',
    '51': 'Manitoba',
    '52': 'Manitoba',
    '53': 'Manitoba',
    '54': 'Manitoba',
    '55': 'Manitoba',
    '56': 'Manitoba',
    '57': 'Manitoba',
    '58': 'Manitoba',
    '59': 'Manitoba',
    '61': 'Saskatchewan',
    '62': 'Saskatchewan',
    '63': 'Saskatchewan',
    '64': 'Saskatchewan',
    '65': 'Saskatchewan',
    '66': 'Saskatchewan',
    '67': 'Saskatchewan',
    '68': 'Saskatchewan',
    '71': 'Alberta',
    '72': 'Alberta',
    '73': 'Alberta',
    '74': 'Alberta',
    '75': 'Alberta',
    '76': 'Alberta',
    '77': 'Alberta',
    '78': 'Alberta',
    '79': 'Alberta',
    '81': 'British Columbia',
    '82': 'British Columbia',
    '83': 'British Columbia',
    '84': 'British Columbia',
    '85': 'British Columbia',
    '86': 'British Columbia',
    '87': 'British Columbia',
    '88': 'British Columbia',
    '89': 'British Columbia',
    '91': 'Yukon',
    '92': 'Yukon',
    '93': 'Yukon',
    '94': 'Northwest Territories',
    '95': 'Northwest Territories',
    '96': 'Northwest Territories',
    '97': 'Nunavut',
    '98': 'Nunavut',
    '99': 'Nunavut',
    'XX': 'TEST',
}

MX_SAME_AREA = {
    'LOCATION': 'MX',
    '01': 'Aguascalientes',
    '02': 'Baja California Norte',
    '03': 'Baja California Sur',
    '04': 'Campeche',
    '05': 'Chiapas',
    '06': 'Chihuahua',
    '07': 'Coahuila',
    '08': 'Colima',
    '09': 'CDMX',
    '10': 'Durango',
    '11': 'Estado de Mexico',
    '12': 'Guanajuato',
    '13': 'Guerrero',
    '14': 'Hidalgo',
    '15': 'Jalisco',
    '16': 'Michoacan',
    '17': 'Morelos',
    '18': 'Nayarit',
    '19': 'Nuevo Leon',
    '20': 'Oaxaca',
    '21': 'Puebla',
    '22': 'Queretaro',
    '23': 'Quinatana Roo',
    '24': 'San Luis Potosi',
    '25': 'Sinaloa',
    '26': 'Sonora',
    '27': 'Tabasco',
    '28': 'Tamaulipas',
    '29': 'Tlaxcala',
    '30': 'Veracruz',
    '31': 'Yucatan',
    '32': 'Zacatecas',
    'XX': 'TEST',
}

US_SAME_CODE = {
    '00000': 'All of United States',
    '01000': 'All of Alabama',
    '01001': 'Autauga',
    '01003': 'Baldwin',
    '01005': 'Barbour',
    '01007': 'Bibb',
    '01009': 'Blount',
    '01011': 'Bullock',
    '01013': 'Butler',
    '01015': 'Calhoun',
    '01017': 'Chambers',
    '01019': 'Cherokee',
    '01021': 'Chilton',
    '01023': 'Choctaw',
    '01025': 'Clarke',
    '01027': 'Clay',
    '01029': 'Cleburne',
    '01031': 'Coffee',
    '01033': 'Colbert',
    '01035': 'Conecuh',
    '01037': 'Coosa',
    '01039': 'Covington',
    '01041': 'Crenshaw',
    '01043': 'Cullman',
    '01045': 'Dale',
    '01047': 'Dallas',
    '01049': 'Dekalb',
    '01051': 'Elmore',
    '01053': 'Escambia',
    '01055': 'Etowah',
    '01057': 'Fayette',
    '01059': 'Franklin',
    '01061': 'Geneva',
    '01063': 'Greene',
    '01065': 'Hale',
    '01067': 'Henry',
    '01069': 'Houston',
    '01071': 'Jackson',
    '01073': 'Jefferson',
    '01075': 'Lamar',
    '01077': 'Lauderdale',
    '01079': 'Lawrence',
    '01081': 'Lee',
    '01083': 'Limestone',
    '01085': 'Lowndes',
    '01087': 'Macon',
    '01089': 'Madison',
    '01091': 'Marengo',
    '01093': 'Marion',
    '01095': 'Marshall',
    '01097': 'Mobile',
    '01099': 'Monroe',
    '01101': 'Montgomery',
    '01103': 'Morgan',
    '01105': 'Perry',
    '01107': 'Pickens',
    '01109': 'Pike',
    '01111': 'Randolph',
    '01113': 'Russell',
    '01115': 'Saint Clair',
    '01117': 'Shelby',
    '01119': 'Sumter',
    '01121': 'Talladega',
    '01123': 'Tallapoosa',
    '01125': 'Tuscaloosa',
    '01127': 'Walker',
    '01129': 'Washington',
    '01131': 'Wilcox',
    '01133': 'Winston',
    '02000': 'All of Alaska',
    '02013': 'Aleutians East',
    '02016': 'Aleutians West',
    '02020': 'Anchorage',
    '02050': 'Bethel',
    '02060': 'Bristol Bay',
    '02068': 'Denali',
    '02070': 'Dillingham',
    '02090': 'Fairbanks North Star',
    '02100': 'Haines',
    '02110': 'Juneau',
    '02122': 'Kenai Peninsula',
    '02130': 'Ketchikan Gateway',
    '02150': 'Kodiak Island',
    '02164': 'Lake and Peninsula',
    '02170': 'Matanuska-Susitna',
    '02180': 'Nome',
    '02185': 'North Slope',
    '02188': 'Northwest Arctic',
    '02201': 'Prince of Wales-Outer Ketchikan',
    '02220': 'Sitka',
    '02232': 'Skagway-Hoonah-Angoon',
    '02240': 'Southeast Fairbanks',
    '02261': 'Valdez-Cordova',
    '02270': 'Wade Hampton',
    '02280': 'Wrangell-Petersburg',
    '02282': 'Yakutat',
    '02290': 'Yukon-Koyukuk',
    '04000': 'All of Arizona',
    '04001': 'Apache',
    '04003': 'Cochise',
    '04005': 'Coconino',
    '04007': 'Gila',
    '04009': 'Graham',
    '04011': 'Greenlee',
    '04012': 'La Paz',
    '04013': 'Maricopa',
    '04015': 'Mohave',
    '04017': 'Navajo',
    '04019': 'Pima',
    '04021': 'Pinal',
    '04023': 'Santa Cruz',
    '04025': 'Yavapai',
    '04027': 'Yuma',
    '05000': 'All of Arkansas',
    '05001': 'Arkansas',
    '05003': 'Ashley',
    '05005': 'Baxter',
    '05007': 'Benton',
    '05009': 'Boone',
    '05011': 'Bradley',
    '05013': 'Calhoun',
    '05015': 'Carroll',
    '05017': 'Chicot',
    '05019': 'Clark',
    '05021': 'Clay',
    '05023': 'Cleburne',
    '05025': 'Cleveland',
    '05027': 'Columbia',
    '05029': 'Conway',
    '05031': 'Craighead',
    '05033': 'Crawford',
    '05035': 'Crittenden',
    '05037': 'Cross',
    '05039': 'Dallas',
    '05041': 'Desha',
    '05043': 'Drew',
    '05045': 'Faulkner',
    '05047': 'Franklin',
    '05049': 'Fulton',
    '05051': 'Garland',
    '05053': 'Grant',
    '05055': 'Greene',
    '05057': 'Hempstead',
    '05059': 'Hot Spring',
    '05061': 'Howard',
    '05063': 'Independence',
    '05065': 'Izard',
    '05067': 'Jackson',
    '05069': 'Jefferson',
    '05071': 'Johnson',
    '05073': 'Lafayette',
    '05075': 'Lawrence',
    '05077': 'Lee',
    '05079': 'Lincoln',
    '05081': 'Little River',
    '05083': 'Logan',
    '05085': 'Lonoke',
    '05087': 'Madison',
    '05089': 'Marion',
    '05091': 'Miller',
    '05093': 'Mississippi',
    '05095': 'Monroe',
    '05097': 'Montgomery',
    '05099': 'Nevada',
    '05101': 'Newton',
    '05103': 'Ouachita',
    '05105': 'Perry',
    '05107': 'Phillips',
    '05109': 'Pike',
    '05111': 'Poinsett',
    '05113': 'Polk',
    '05115': 'Pope',
    '05117': 'Prairie',
    '05119': 'Pulaski',
    '05121': 'Randolph',
    '05123': 'Saint Francis',
    '05125': 'Saline',
    '05127': 'Scott',
    '05129': 'Searcy',
    '05131': 'Sebastian',
    '05133': 'Sevier',
    '05135': 'Sharp',
    '05137': 'Stone',
    '05139': 'Union',
    '05141': 'Van Buren',
    '05143': 'Washington',
    '05145': 'White',
    '05147': 'Woodruff',
    '05149': 'Yell',
    '06000': 'All of California',
    '06001': 'Alameda',
    '06003': 'Alpine',
    '06005': 'Amador',
    '06007': 'Butte',
    '06009': 'Calaveras',
    '06011': 'Colusa',
    '06013': 'Contra Costa',
    '06015': 'Del Norte',
    '06017': 'El Dorado',
    '06019': 'Fresno',
    '06021': 'Glenn',
    '06023': 'Humboldt',
    '06025': 'Imperial',
    '06027': 'Inyo',
    '06029': 'Kern',
    '06031': 'Kings',
    '06033': 'Lake',
    '06035': 'Lassen',
    '06037': 'Los Angeles',
    '06039': 'Madera',
    '06041': 'Marin',
    '06043': 'Mariposa',
    '06045': 'Mendocino',
    '06047': 'Merced',
    '06049': 'Modoc',
    '06051': 'Mono',
    '06053': 'Monterey',
    '06055': 'Napa',
    '06057': 'Nevada',
    '06059': 'Orange',
    '06061': 'Placer',
    '06063': 'Plumas',
    '06065': 'Riverside',
    '06067': 'Sacramento',
    '06069': 'San Benito',
    '06071': 'San Bernardino',
    '06073': 'San Diego',
    '06075': 'San Francisco',
    '06077': 'San Joaquin',
    '06079': 'San Luis Obispo',
    '06081': 'San Mateo',
    '06083': 'Santa Barbara',
    '06085': 'Santa Clara',
    '06087': 'Santa Cruz',
    '06089': 'Shasta',
    '06091': 'Sierra',
    '06093': 'Siskiyou',
    '06095': 'Solano',
    '06097': 'Sonoma',
    '06099': 'Stanislaus',
    '06101': 'Sutter',
    '06103': 'Tehama',
    '06105': 'Trinity',
    '06107': 'Tulare',
    '06109': 'Tuolumne',
    '06111': 'Ventura',
    '06113': 'Yolo',
    '06115': 'Yuba',
    '08000': 'All of Colorado',
    '08001': 'Adams',
    '08003': 'Alamosa',
    '08005': 'Arapahoe',
    '08007': 'Archuleta',
    '08009': 'Baca',
    '08011': 'Bent',
    '08013': 'Boulder',
    '08014': 'Broomfield',
    '08015': 'Chaffee',
    '08017': 'Cheyenne',
    '08019': 'Clear Creek',
    '08021': 'Conejos',
    '08023': 'Costilla',
    '08025': 'Crowley',
    '08027': 'Custer',
    '08029': 'Delta',
    '08031': 'Denver',
    '08033': 'Dolores',
    '08035': 'Douglas',
    '08037': 'Eagle',
    '08039': 'Elbert',
    '08041': 'El Paso',
    '08043': 'Fremont',
    '08045': 'Garfield',
    '08047': 'Gilpin',
    '08049': 'Grand',
    '08051': 'Gunnison',
    '08053': 'Hinsdale',
    '08055': 'Huerfano',
    '08057': 'Jackson',
    '08059': 'Jefferson',
    '08061': 'Kiowa',
    '08063': 'Kit Carson',
    '08065': 'Lake',
    '08067': 'La Plata',
    '08069': 'Larimer',
    '08071': 'Las Animas',
    '08073': 'Lincoln',
    '08075': 'Logan',
    '08077': 'Mesa',
    '08079': 'Mineral',
    '08081': 'Moffat',
    '08083': 'Montezuma',
    '08085': 'Montrose',
    '08087': 'Morgan',
    '08089': 'Otero',
    '08091': 'Ouray',
    '08093': 'Park',
    '08095': 'Phillips',
    '08097': 'Pitkin',
    '08099': 'Prowers',
    '08101': 'Pueblo',
    '08103': 'Rio Blanco',
    '08105': 'Rio Grande',
    '08107': 'Routt',
    '08109': 'Saguache',
    '08111': 'San Juan',
    '08113': 'San Miguel',
    '08115': 'Sedgwick',
    '08117': 'Summit',
    '08119': 'Teller',
    '08121': 'Washington',
    '08123': 'Weld',
    '08125': 'Yuma',
    '09000': 'All of Connecticut',
    '09001': 'Fairfield',
    '09003': 'Hartford',
    '09005': 'Litchfield',
    '09007': 'Middlesex',
    '09009': 'New Haven',
    '09011': 'New London',
    '09013': 'Tolland',
    '09015': 'Windham',
    '10000': 'All of Delaware',
    '10001': 'Kent',
    '10003': 'New Castle',
    '10005': 'Sussex',
    '11001': 'District of Columbia',
    '12000': 'All of Florida',
    '12001': 'Alachua',
    '12003': 'Baker',
    '12005': 'Bay',
    '12007': 'Bradford',
    '12009': 'Brevard',
    '12011': 'Broward',
    '12013': 'Calhoun',
    '12015': 'Charlotte',
    '12017': 'Citrus',
    '12019': 'Clay',
    '12021': 'Collier',
    '12023': 'Columbia',
    '12027': 'Desoto',
    '12029': 'Dixie',
    '12031': 'Duval',
    '12033': 'Escambia',
    '12035': 'Flagler',
    '12037': 'Franklin',
    '12039': 'Gadsden',
    '12041': 'Gilchrist',
    '12043': 'Glades',
    '12045': 'Gulf',
    '12047': 'Hamilton',
    '12049': 'Hardee',
    '12051': 'Hendry',
    '12053': 'Hernando',
    '12055': 'Highlands',
    '12057': 'Hillsborough',
    '12059': 'Holmes',
    '12061': 'Indian River',
    '12063': 'Jackson',
    '12065': 'Jefferson',
    '12067': 'Lafayette',
    '12069': 'Lake',
    '12071': 'Lee',
    '12073': 'Leon',
    '12075': 'Levy',
    '12077': 'Liberty',
    '12079': 'Madison',
    '12081': 'Manatee',
    '12083': 'Marion',
    '12085': 'Martin',
    '12086': 'Miami-Dade',
    '12087': 'Monroe',
    '12089': 'Nassau',
    '12091': 'Okaloosa',
    '12093': 'Okeechobee',
    '12095': 'Orange',
    '12097': 'Osceola',
    '12099': 'Palm Beach',
    '12101': 'Pasco',
    '12103': 'Pinellas',
    '12105': 'Polk',
    '12107': 'Putnam',
    '12109': 'Saint Johns',
    '12111': 'Saint Lucie',
    '12113': 'Santa Rosa',
    '12115': 'Sarasota',
    '12117': 'Seminole',
    '12119': 'Sumter',
    '12121': 'Suwannee',
    '12123': 'Taylor',
    '12125': 'Union',
    '12127': 'Volusia',
    '12129': 'Wakulla',
    '12131': 'Walton',
    '12133': 'Washington',
    '13000': 'All of Georgia',
    '13001': 'Appling',
    '13003': 'Atkinson',
    '13005': 'Bacon',
    '13007': 'Baker',
    '13009': 'Baldwin',
    '13011': 'Banks',
    '13013': 'Barrow',
    '13015': 'Bartow',
    '13017': 'Ben Hill',
    '13019': 'Berrien',
    '13021': 'Bibb',
    '13023': 'Bleckley',
    '13025': 'Brantley',
    '13027': 'Brooks',
    '13029': 'Bryan',
    '13031': 'Bulloch',
    '13033': 'Burke',
    '13035': 'Butts',
    '13037': 'Calhoun',
    '13039': 'Camden',
    '13043': 'Candler',
    '13045': 'Carroll',
    '13047': 'Catoosa',
    '13049': 'Charlton',
    '13051': 'Chatham',
    '13053': 'Chattahoochee',
    '13055': 'Chattooga',
    '13057': 'Cherokee',
    '13059': 'Clarke',
    '13061': 'Clay',
    '13063': 'Clayton',
    '13065': 'Clinch',
    '13067': 'Cobb',
    '13069': 'Coffee',
    '13071': 'Colquitt',
    '13073': 'Columbia',
    '13075': 'Cook',
    '13077': 'Coweta',
    '13079': 'Crawford',
    '13081': 'Crisp',
    '13083': 'Dade',
    '13085': 'Dawson',
    '13087': 'Decatur',
    '13089': 'Dekalb',
    '13091': 'Dodge',
    '13093': 'Dooly',
    '13095': 'Dougherty',
    '13097': 'Douglas',
    '13099': 'Early',
    '13101': 'Echols',
    '13103': 'Effingham',
    '13105': 'Elbert',
    '13107': 'Emanuel',
    '13109': 'Evans',
    '13111': 'Fannin',
    '13113': 'Fayette',
    '13115': 'Floyd',
    '13117': 'Forsyth',
    '13119': 'Franklin',
    '13121': 'Fulton',
    '13123': 'Gilmer',
    '13125': 'Glascock',
    '13127': 'Glynn',
    '13129': 'Gordon',
    '13131': 'Grady',
    '13133': 'Greene',
    '13135': 'Gwinnett',
    '13137': 'Habersham',
    '13139': 'Hall',
    '13141': 'Hancock',
    '13143': 'Haralson',
    '13145': 'Harris',
    '13147': 'Hart',
    '13149': 'Heard',
    '13151': 'Henry',
    '13153': 'Houston',
    '13155': 'Irwin',
    '13157': 'Jackson',
    '13159': 'Jasper',
    '13161': 'Jeff Davis',
    '13163': 'Jefferson',
    '13165': 'Jenkins',
    '13167': 'Johnson',
    '13169': 'Jones',
    '13171': 'Lamar',
    '13173': 'Lanier',
    '13175': 'Laurens',
    '13177': 'Lee',
    '13179': 'Liberty',
    '13181': 'Lincoln',
    '13183': 'Long',
    '13185': 'Lowndes',
    '13187': 'Lumpkin',
    '13189': 'Mcduffie',
    '13191': 'Mcintosh',
    '13193': 'Macon',
    '13195': 'Madison',
    '13197': 'Marion',
    '13199': 'Meriwether',
    '13201': 'Miller',
    '13205': 'Mitchell',
    '13207': 'Monroe',
    '13209': 'Montgomery',
    '13211': 'Morgan',
    '13213': 'Murray',
    '13215': 'Muscogee',
    '13217': 'Newton',
    '13219': 'Oconee',
    '13221': 'Oglethorpe',
    '13223': 'Paulding',
    '13225': 'Peach',
    '13227': 'Pickens',
    '13229': 'Pierce',
    '13231': 'Pike',
    '13233': 'Polk',
    '13235': 'Pulaski',
    '13237': 'Putnam',
    '13239': 'Quitman',
    '13241': 'Rabun',
    '13243': 'Randolph',
    '13245': 'Richmond',
    '13247': 'Rockdale',
    '13249': 'Schley',
    '13251': 'Screven',
    '13253': 'Seminole',
    '13255': 'Spalding',
    '13257': 'Stephens',
    '13259': 'Stewart',
    '13261': 'Sumter',
    '13263': 'Talbot',
    '13265': 'Taliaferro',
    '13267': 'Tattnall',
    '13269': 'Taylor',
    '13271': 'Telfair',
    '13273': 'Terrell',
    '13275': 'Thomas',
    '13277': 'Tift',
    '13279': 'Toombs',
    '13281': 'Towns',
    '13283': 'Treutlen',
    '13285': 'Troup',
    '13287': 'Turner',
    '13289': 'Twiggs',
    '13291': 'Union',
    '13293': 'Upson',
    '13295': 'Walker',
    '13297': 'Walton',
    '13299': 'Ware',
    '13301': 'Warren',
    '13303': 'Washington',
    '13305': 'Wayne',
    '13307': 'Webster',
    '13309': 'Wheeler',
    '13311': 'White',
    '13313': 'Whitfield',
    '13315': 'Wilcox',
    '13317': 'Wilkes',
    '13319': 'Wilkinson',
    '13321': 'Worth',
    '15000': 'All of Hawaii',
    '15001': 'Hawaii',
    '15003': 'Honolulu',
    '15005': 'Kalawao',
    '15007': 'Kauai',
    '15009': 'Maui',
    '16000': 'All of Idaho',
    '16001': 'Ada',
    '16003': 'Adams',
    '16005': 'Bannock',
    '16007': 'Bear Lake',
    '16009': 'Benewah',
    '16011': 'Bingham',
    '16013': 'Blaine',
    '16015': 'Boise',
    '16017': 'Bonner',
    '16019': 'Bonneville',
    '16021': 'Boundary',
    '16023': 'Butte',
    '16025': 'Camas',
    '16027': 'Canyon',
    '16029': 'Caribou',
    '16031': 'Cassia',
    '16033': 'Clark',
    '16035': 'Clearwater',
    '16037': 'Custer',
    '16039': 'Elmore',
    '16041': 'Franklin',
    '16043': 'Fremont',
    '16045': 'Gem',
    '16047': 'Gooding',
    '16049': 'Idaho',
    '16051': 'Jefferson',
    '16053': 'Jerome',
    '16055': 'Kootenai',
    '16057': 'Latah',
    '16059': 'Lemhi',
    '16061': 'Lewis',
    '16063': 'Lincoln',
    '16065': 'Madison',
    '16067': 'Minidoka',
    '16069': 'Nez Perce',
    '16071': 'Oneida',
    '16073': 'Owyhee',
    '16075': 'Payette',
    '16077': 'Power',
    '16079': 'Shoshone',
    '16081': 'Teton',
    '16083': 'Twin Falls',
    '16085': 'Valley',
    '16087': 'Washington',
    '17000': 'All of Illinois',
    '17001': 'Adams',
    '17003': 'Alexander',
    '17005': 'Bond',
    '17007': 'Boone',
    '17009': 'Brown',
    '17011': 'Bureau',
    '17013': 'Calhoun',
    '17015': 'Carroll',
    '17017': 'Cass',
    '17019': 'Champaign',
    '17021': 'Christian',
    '17023': 'Clark',
    '17025': 'Clay',
    '17027': 'Clinton',
    '17029': 'Coles',
    '17031': 'Cook',
    '17033': 'Crawford',
    '17035': 'Cumberland',
    '17037': 'Dekalb',
    '17039': 'De Witt',
    '17041': 'Douglas',
    '17043': 'Dupage',
    '17045': 'Edgar',
    '17047': 'Edwards',
    '17049': 'Effingham',
    '17051': 'Fayette',
    '17053': 'Ford',
    '17055': 'Franklin',
    '17057': 'Fulton',
    '17059': 'Gallatin',
    '17061': 'Greene',
    '17063': 'Grundy',
    '17065': 'Hamilton',
    '17067': 'Hancock',
    '17069': 'Hardin',
    '17071': 'Henderson',
    '17073': 'Henry',
    '17075': 'Iroquois',
    '17077': 'Jackson',
    '17079': 'Jasper',
    '17081': 'Jefferson',
    '17083': 'Jersey',
    '17085': 'Jo Daviess',
    '17087': 'Johnson',
    '17089': 'Kane',
    '17091': 'Kankakee',
    '17093': 'Kendall',
    '17095': 'Knox',
    '17097': 'Lake',
    '17099': 'La Salle',
    '17101': 'Lawrence',
    '17103': 'Lee',
    '17105': 'Livingston',
    '17107': 'Logan',
    '17109': 'Mcdonough',
    '17111': 'Mchenry',
    '17113': 'Mclean',
    '17115': 'Macon',
    '17117': 'Macoupin',
    '17119': 'Madison',
    '17121': 'Marion',
    '17123': 'Marshall',
    '17125': 'Mason',
    '17127': 'Massac',
    '17129': 'Menard',
    '17131': 'Mercer',
    '17133': 'Monroe',
    '17135': 'Montgomery',
    '17137': 'Morgan',
    '17139': 'Moultrie',
    '17141': 'Ogle',
    '17143': 'Peoria',
    '17145': 'Perry',
    '17147': 'Piatt',
    '17149': 'Pike',
    '17151': 'Pope',
    '17153': 'Pulaski',
    '17155': 'Putnam',
    '17157': 'Randolph',
    '17159': 'Richland',
    '17161': 'Rock Island',
    '17163': 'Saint Clair',
    '17165': 'Saline',
    '17167': 'Sangamon',
    '17169': 'Schuyler',
    '17171': 'Scott',
    '17173': 'Shelby',
    '17175': 'Stark',
    '17177': 'Stephenson',
    '17179': 'Tazewell',
    '17181': 'Union',
    '17183': 'Vermilion',
    '17185': 'Wabash',
    '17187': 'Warren',
    '17189': 'Washington',
    '17191': 'Wayne',
    '17193': 'White',
    '17195': 'Whiteside',
    '17197': 'Will',
    '17199': 'Williamson',
    '17201': 'Winnebago',
    '17203': 'Woodford',
    '18000': 'All of Indiana',
    '18001': 'Adams',
    '18003': 'Allen',
    '18005': 'Bartholomew',
    '18007': 'Benton',
    '18009': 'Blackford',
    '18011': 'Boone',
    '18013': 'Brown',
    '18015': 'Carroll',
    '18017': 'Cass',
    '18019': 'Clark',
    '18021': 'Clay',
    '18023': 'Clinton',
    '18025': 'Crawford',
    '18027': 'Daviess',
    '18029': 'Dearborn',
    '18031': 'Decatur',
    '18033': 'De Kalb',
    '18035': 'Delaware',
    '18037': 'Dubois',
    '18039': 'Elkhart',
    '18041': 'Fayette',
    '18043': 'Floyd',
    '18045': 'Fountain',
    '18047': 'Franklin',
    '18049': 'Fulton',
    '18051': 'Gibson',
    '18053': 'Grant',
    '18055': 'Greene',
    '18057': 'Hamilton',
    '18059': 'Hancock',
    '18061': 'Harrison',
    '18063': 'Hendricks',
    '18065': 'Henry',
    '18067': 'Howard',
    '18069': 'Huntington',
    '18071': 'Jackson',
    '18073': 'Jasper',
    '18075': 'Jay',
    '18077': 'Jefferson',
    '18079': 'Jennings',
    '18081': 'Johnson',
    '18083': 'Knox',
    '18085': 'Kosciusko',
    '18087': 'Lagrange',
    '18089': 'Lake',
    '18091': 'La Porte',
    '18093': 'Lawrence',
    '18095': 'Madison',
    '18097': 'Marion',
    '18099': 'Marshall',
    '18101': 'Martin',
    '18103': 'Miami',
    '18105': 'Monroe',
    '18107': 'Montgomery',
    '18109': 'Morgan',
    '18111': 'Newton',
    '18113': 'Noble',
    '18115': 'Ohio',
    '18117': 'Orange',
    '18119': 'Owen',
    '18121': 'Parke',
    '18123': 'Perry',
    '18125': 'Pike',
    '18127': 'Porter',
    '18129': 'Posey',
    '18131': 'Pulaski',
    '18133': 'Putnam',
    '18135': 'Randolph',
    '18137': 'Ripley',
    '18139': 'Rush',
    '18141': 'Saint Joseph',
    '18143': 'Scott',
    '18145': 'Shelby',
    '18147': 'Spencer',
    '18149': 'Starke',
    '18151': 'Steuben',
    '18153': 'Sullivan',
    '18155': 'Switzerland',
    '18157': 'Tippecanoe',
    '18159': 'Tipton',
    '18161': 'Union',
    '18163': 'Vanderburgh',
    '18165': 'Vermillion',
    '18167': 'Vigo',
    '18169': 'Wabash',
    '18171': 'Warren',
    '18173': 'Warrick',
    '18175': 'Washington',
    '18177': 'Wayne',
    '18179': 'Wells',
    '18181': 'White',
    '18183': 'Whitley',
    '19000': 'All of Iowa',
    '19001': 'Adair',
    '19003': 'Adams',
    '19005': 'Allamakee',
    '19007': 'Appanoose',
    '19009': 'Audubon',
    '19011': 'Benton',
    '19013': 'Black Hawk',
    '19015': 'Boone',
    '19017': 'Bremer',
    '19019': 'Buchanan',
    '19021': 'Buena Vista',
    '19023': 'Butler',
    '19025': 'Calhoun',
    '19027': 'Carroll',
    '19029': 'Cass',
    '19031': 'Cedar',
    '19033': 'Cerro Gordo',
    '19035': 'Cherokee',
    '19037': 'Chickasaw',
    '19039': 'Clarke',
    '19041': 'Clay',
    '19043': 'Clayton',
    '19045': 'Clinton',
    '19047': 'Crawford',
    '19049': 'Dallas',
    '19051': 'Davis',
    '19053': 'Decatur',
    '19055': 'Delaware',
    '19057': 'Des Moines',
    '19059': 'Dickinson',
    '19061': 'Dubuque',
    '19063': 'Emmet',
    '19065': 'Fayette',
    '19067': 'Floyd',
    '19069': 'Franklin',
    '19071': 'Fremont',
    '19073': 'Greene',
    '19075': 'Grundy',
    '19077': 'Guthrie',
    '19079': 'Hamilton',
    '19081': 'Hancock',
    '19083': 'Hardin',
    '19085': 'Harrison',
    '19087': 'Henry',
    '19089': 'Howard',
    '19091': 'Humboldt',
    '19093': 'Ida',
    '19095': 'Iowa',
    '19097': 'Jackson',
    '19099': 'Jasper',
    '19101': 'Jefferson',
    '19103': 'Johnson',
    '19105': 'Jones',
    '19107': 'Keokuk',
    '19109': 'Kossuth',
    '19111': 'Lee',
    '19113': 'Linn',
    '19115': 'Louisa',
    '19117': 'Lucas',
    '19119': 'Lyon',
    '19121': 'Madison',
    '19123': 'Mahaska',
    '19125': 'Marion',
    '19127': 'Marshall',
    '19129': 'Mills',
    '19131': 'Mitchell',
    '19133': 'Monona',
    '19135': 'Monroe',
    '19137': 'Montgomery',
    '19139': 'Muscatine',
    '19141': 'O\'Brien',
    '19143': 'Osceola',
    '19145': 'Page',
    '19147': 'Palo Alto',
    '19149': 'Plymouth',
    '19151': 'Pocahontas',
    '19153': 'Polk',
    '19155': 'Pottawattamie',
    '19157': 'Poweshiek',
    '19159': 'Ringgold',
    '19161': 'Sac',
    '19163': 'Scott',
    '19165': 'Shelby',
    '19167': 'Sioux',
    '19169': 'Story',
    '19171': 'Tama',
    '19173': 'Taylor',
    '19175': 'Union',
    '19177': 'Van Buren',
    '19179': 'Wapello',
    '19181': 'Warren',
    '19183': 'Washington',
    '19185': 'Wayne',
    '19187': 'Webster',
    '19189': 'Winnebago',
    '19191': 'Winneshiek',
    '19193': 'Woodbury',
    '19195': 'Worth',
    '19197': 'Wright',
    '20000': 'All of Kansas',
    '20001': 'Allen',
    '20003': 'Anderson',
    '20005': 'Atchison',
    '20007': 'Barber',
    '20009': 'Barton',
    '20011': 'Bourbon',
    '20013': 'Brown',
    '20015': 'Butler',
    '20017': 'Chase',
    '20019': 'Chautauqua',
    '20021': 'Cherokee',
    '20023': 'Cheyenne',
    '20025': 'Clark',
    '20027': 'Clay',
    '20029': 'Cloud',
    '20031': 'Coffey',
    '20033': 'Comanche',
    '20035': 'Cowley',
    '20037': 'Crawford',
    '20039': 'Decatur',
    '20041': 'Dickinson',
    '20043': 'Doniphan',
    '20045': 'Douglas',
    '20047': 'Edwards',
    '20049': 'Elk',
    '20051': 'Ellis',
    '20053': 'Ellsworth',
    '20055': 'Finney',
    '20057': 'Ford',
    '20059': 'Franklin',
    '20061': 'Geary',
    '20063': 'Gove',
    '20065': 'Graham',
    '20067': 'Grant',
    '20069': 'Gray',
    '20071': 'Greeley',
    '20073': 'Greenwood',
    '20075': 'Hamilton',
    '20077': 'Harper',
    '20079': 'Harvey',
    '20081': 'Haskell',
    '20083': 'Hodgeman',
    '20085': 'Jackson',
    '20087': 'Jefferson',
    '20089': 'Jewell',
    '20091': 'Johnson',
    '20093': 'Kearny',
    '20095': 'Kingman',
    '20097': 'Kiowa',
    '20099': 'Labette',
    '20101': 'Lane',
    '20103': 'Leavenworth',
    '20105': 'Lincoln',
    '20107': 'Linn',
    '20109': 'Logan',
    '20111': 'Lyon',
    '20113': 'Mcpherson',
    '20115': 'Marion',
    '20117': 'Marshall',
    '20119': 'Meade',
    '20121': 'Miami',
    '20123': 'Mitchell',
    '20125': 'Montgomery',
    '20127': 'Morris',
    '20129': 'Morton',
    '20131': 'Nemaha',
    '20133': 'Neosho',
    '20135': 'Ness',
    '20137': 'Norton',
    '20139': 'Osage',
    '20141': 'Osborne',
    '20143': 'Ottawa',
    '20145': 'Pawnee',
    '20147': 'Phillips',
    '20149': 'Pottawatomie',
    '20151': 'Pratt',
    '20153': 'Rawlins',
    '20155': 'Reno',
    '20157': 'Republic',
    '20159': 'Rice',
    '20161': 'Riley',
    '20163': 'Rooks',
    '20165': 'Rush',
    '20167': 'Russell',
    '20169': 'Saline',
    '20171': 'Scott',
    '20173': 'Sedgwick',
    '20175': 'Seward',
    '20177': 'Shawnee',
    '20179': 'Sheridan',
    '20181': 'Sherman',
    '20183': 'Smith',
    '20185': 'Stafford',
    '20187': 'Stanton',
    '20189': 'Stevens',
    '20191': 'Sumner',
    '20193': 'Thomas',
    '20195': 'Trego',
    '20197': 'Wabaunsee',
    '20199': 'Wallace',
    '20201': 'Washington',
    '20203': 'Wichita',
    '20205': 'Wilson',
    '20207': 'Woodson',
    '20209': 'Wyandotte',
    '21000': 'All of Kentucky',
    '21001': 'Adair',
    '21003': 'Allen',
    '21005': 'Anderson',
    '21007': 'Ballard',
    '21009': 'Barren',
    '21011': 'Bath',
    '21013': 'Bell',
    '21015': 'Boone',
    '21017': 'Bourbon',
    '21019': 'Boyd',
    '21021': 'Boyle',
    '21023': 'Bracken',
    '21025': 'Breathitt',
    '21027': 'Breckinridge',
    '21029': 'Bullitt',
    '21031': 'Butler',
    '21033': 'Caldwell',
    '21035': 'Calloway',
    '21037': 'Campbell',
    '21039': 'Carlisle',
    '21041': 'Carroll',
    '21043': 'Carter',
    '21045': 'Casey',
    '21047': 'Christian',
    '21049': 'Clark',
    '21051': 'Clay',
    '21053': 'Clinton',
    '21055': 'Crittenden',
    '21057': 'Cumberland',
    '21059': 'Daviess',
    '21061': 'Edmonson',
    '21063': 'Elliott',
    '21065': 'Estill',
    '21067': 'Fayette',
    '21069': 'Fleming',
    '21071': 'Floyd',
    '21073': 'Franklin',
    '21075': 'Fulton',
    '21077': 'Gallatin',
    '21079': 'Garrard',
    '21081': 'Grant',
    '21083': 'Graves',
    '21085': 'Grayson',
    '21087': 'Green',
    '21089': 'Greenup',
    '21091': 'Hancock',
    '21093': 'Hardin',
    '21095': 'Harlan',
    '21097': 'Harrison',
    '21099': 'Hart',
    '21101': 'Henderson',
    '21103': 'Henry',
    '21105': 'Hickman',
    '21107': 'Hopkins',
    '21109': 'Jackson',
    '21111': 'Jefferson',
    '21113': 'Jessamine',
    '21115': 'Johnson',
    '21117': 'Kenton',
    '21119': 'Knott',
    '21121': 'Knox',
    '21123': 'Larue',
    '21125': 'Laurel',
    '21127': 'Lawrence',
    '21129': 'Lee',
    '21131': 'Leslie',
    '21133': 'Letcher',
    '21135': 'Lewis',
    '21137': 'Lincoln',
    '21139': 'Livingston',
    '21141': 'Logan',
    '21143': 'Lyon',
    '21145': 'Mccracken',
    '21147': 'Mccreary',
    '21149': 'Mclean',
    '21151': 'Madison',
    '21153': 'Magoffin',
    '21155': 'Marion',
    '21157': 'Marshall',
    '21159': 'Martin',
    '21161': 'Mason',
    '21163': 'Meade',
    '21165': 'Menifee',
    '21167': 'Mercer',
    '21169': 'Metcalfe',
    '21171': 'Monroe',
    '21173': 'Montgomery',
    '21175': 'Morgan',
    '21177': 'Muhlenberg',
    '21179': 'Nelson',
    '21181': 'Nicholas',
    '21183': 'Ohio',
    '21185': 'Oldham',
    '21187': 'Owen',
    '21189': 'Owsley',
    '21191': 'Pendleton',
    '21193': 'Perry',
    '21195': 'Pike',
    '21197': 'Powell',
    '21199': 'Pulaski',
    '21201': 'Robertson',
    '21203': 'Rockcastle',
    '21205': 'Rowan',
    '21207': 'Russell',
    '21209': 'Scott',
    '21211': 'Shelby',
    '21213': 'Simpson',
    '21215': 'Spencer',
    '21217': 'Taylor',
    '21219': 'Todd',
    '21221': 'Trigg',
    '21223': 'Trimble',
    '21225': 'Union',
    '21227': 'Warren',
    '21229': 'Washington',
    '21231': 'Wayne',
    '21233': 'Webster',
    '21235': 'Whitley',
    '21237': 'Wolfe',
    '21239': 'Woodford',
    '22000': 'All of Louisiana',
    '22001': 'Acadia',
    '22003': 'Allen',
    '22005': 'Ascension',
    '22007': 'Assumption',
    '22009': 'Avoyelles',
    '22011': 'Beauregard',
    '22013': 'Bienville',
    '22015': 'Bossier',
    '22017': 'Caddo',
    '22019': 'Calcasieu',
    '22021': 'Caldwell',
    '22023': 'Cameron',
    '22025': 'Catahoula',
    '22027': 'Claiborne',
    '22029': 'Concordia',
    '22031': 'De Soto',
    '22033': 'East Baton Rouge',
    '22035': 'East Carroll',
    '22037': 'East Feliciana',
    '22039': 'Evangeline',
    '22041': 'Franklin',
    '22043': 'Grant',
    '22045': 'Iberia',
    '22047': 'Iberville',
    '22049': 'Jackson',
    '22051': 'Jefferson',
    '22053': 'Jefferson Davis',
    '22055': 'Lafayette',
    '22057': 'Lafourche',
    '22059': 'La Salle',
    '22061': 'Lincoln',
    '22063': 'Livingston',
    '22065': 'Madison',
    '22067': 'Morehouse',
    '22069': 'Natchitoches',
    '22071': 'Orleans',
    '22073': 'Ouachita',
    '22075': 'Plaquemines',
    '22077': 'Pointe Coupee',
    '22079': 'Rapides',
    '22081': 'Red River',
    '22083': 'Richland',
    '22085': 'Sabine',
    '22087': 'Saint Bernard',
    '22089': 'Saint Charles',
    '22091': 'Saint Helena',
    '22093': 'Saint James',
    '22095': 'Saint John the Baptist',
    '22097': 'Saint Landry',
    '22099': 'Saint Martin',
    '22101': 'Saint Mary',
    '22103': 'Saint Tammany',
    '22105': 'Tangipahoa',
    '22107': 'Tensas',
    '22109': 'Terrebonne',
    '22111': 'Union',
    '22113': 'Vermilion',
    '22115': 'Vernon',
    '22117': 'Washington',
    '22119': 'Webster',
    '22121': 'West Baton Rouge',
    '22123': 'West Carroll',
    '22125': 'West Feliciana',
    '22127': 'Winn',
    '23000': 'All of Maine',
    '23001': 'Androscoggin',
    '23003': 'Aroostook',
    '23005': 'Cumberland',
    '23007': 'Franklin',
    '23009': 'Hancock',
    '23011': 'Kennebec',
    '23013': 'Knox',
    '23015': 'Lincoln',
    '23017': 'Oxford',
    '23019': 'Penobscot',
    '23021': 'Piscataquis',
    '23023': 'Sagadahoc',
    '23025': 'Somerset',
    '23027': 'Waldo',
    '23029': 'Washington',
    '23031': 'York',
    '24000': 'All of Maryland',
    '24001': 'Allegany',
    '24003': 'Anne Arundel',
    '24005': 'Baltimore',
    '24009': 'Calvert',
    '24011': 'Caroline',
    '24013': 'Carroll',
    '24015': 'Cecil',
    '24017': 'Charles',
    '24019': 'Dorchester',
    '24021': 'Frederick',
    '24023': 'Garrett',
    '24025': 'Harford',
    '24027': 'Howard',
    '24029': 'Kent',
    '24031': 'Montgomery',
    '24033': 'Prince George\'s',
    '24035': 'Queen Anne\'s',
    '24037': 'Saint Mary\'s',
    '24039': 'Somerset',
    '24041': 'Talbot',
    '24043': 'Washington',
    '24045': 'Wicomico',
    '24047': 'Worcester',
    '24510': 'City of Baltimore',
    '25000': 'All of Massachusetts',
    '25001': 'Barnstable',
    '25003': 'Berkshire',
    '25005': 'Bristol',
    '25007': 'Dukes',
    '25009': 'Essex',
    '25011': 'Franklin',
    '25013': 'Hampden',
    '25015': 'Hampshire',
    '25017': 'Middlesex',
    '25019': 'Nantucket',
    '25021': 'Norfolk',
    '25023': 'Plymouth',
    '25025': 'Suffolk',
    '25027': 'Worcester',
    '26000': 'All of Michigan',
    '26001': 'Alcona',
    '26003': 'Alger',
    '26005': 'Allegan',
    '26007': 'Alpena',
    '26009': 'Antrim',
    '26011': 'Arenac',
    '26013': 'Baraga',
    '26015': 'Barry',
    '26017': 'Bay',
    '26019': 'Benzie',
    '26021': 'Berrien',
    '26023': 'Branch',
    '26025': 'Calhoun',
    '26027': 'Cass',
    '26029': 'Charlevoix',
    '26031': 'Cheboygan',
    '26033': 'Chippewa',
    '26035': 'Clare',
    '26037': 'Clinton',
    '26039': 'Crawford',
    '26041': 'Delta',
    '26043': 'Dickinson',
    '26045': 'Eaton',
    '26047': 'Emmet',
    '26049': 'Genesee',
    '26051': 'Gladwin',
    '26053': 'Gogebic',
    '26055': 'Grand Traverse',
    '26057': 'Gratiot',
    '26059': 'Hillsdale',
    '26061': 'Houghton',
    '26063': 'Huron',
    '26065': 'Ingham',
    '26067': 'Ionia',
    '26069': 'Iosco',
    '26071': 'Iron',
    '26073': 'Isabella',
    '26075': 'Jackson',
    '26077': 'Kalamazoo',
    '26079': 'Kalkaska',
    '26081': 'Kent',
    '26083': 'Keweenaw',
    '26085': 'Lake',
    '26087': 'Lapeer',
    '26089': 'Leelanau',
    '26091': 'Lenawee',
    '26093': 'Livingston',
    '26095': 'Luce',
    '26097': 'Mackinac',
    '26099': 'Macomb',
    '26101': 'Manistee',
    '26103': 'Marquette',
    '26105': 'Mason',
    '26107': 'Mecosta',
    '26109': 'Menominee',
    '26111': 'Midland',
    '26113': 'Missaukee',
    '26115': 'Monroe',
    '26117': 'Montcalm',
    '26119': 'Montmorency',
    '26121': 'Muskegon',
    '26123': 'Newaygo',
    '26125': 'Oakland',
    '26127': 'Oceana',
    '26129': 'Ogemaw',
    '26131': 'Ontonagon',
    '26133': 'Osceola',
    '26135': 'Oscoda',
    '26137': 'Otsego',
    '26139': 'Ottawa',
    '26141': 'Presque Isle',
    '26143': 'Roscommon',
    '26145': 'Saginaw',
    '26147': 'Saint Clair',
    '26149': 'Saint Joseph',
    '26151': 'Sanilac',
    '26153': 'Schoolcraft',
    '26155': 'Shiawassee',
    '26157': 'Tuscola',
    '26159': 'Van Buren',
    '26161': 'Washtenaw',
    '26163': 'Wayne',
    '26165': 'Wexford',
    '27000': 'All of Minnesota',
    '27001': 'Aitkin',
    '27003': 'Anoka',
    '27005': 'Becker',
    '27007': 'Beltrami',
    '27009': 'Benton',
    '27011': 'Big Stone',
    '27013': 'Blue Earth',
    '27015': 'Brown',
    '27017': 'Carlton',
    '27019': 'Carver',
    '27021': 'Cass',
    '27023': 'Chippewa',
    '27025': 'Chisago',
    '27027': 'Clay',
    '27029': 'Clearwater',
    '27031': 'Cook',
    '27033': 'Cottonwood',
    '27035': 'Crow Wing',
    '27037': 'Dakota',
    '27039': 'Dodge',
    '27041': 'Douglas',
    '27043': 'Faribault',
    '27045': 'Fillmore',
    '27047': 'Freeborn',
    '27049': 'Goodhue',
    '27051': 'Grant',
    '27053': 'Hennepin',
    '27055': 'Houston',
    '27057': 'Hubbard',
    '27059': 'Isanti',
    '27061': 'Itasca',
    '27063': 'Jackson',
    '27065': 'Kanabec',
    '27067': 'Kandiyohi',
    '27069': 'Kittson',
    '27071': 'Koochiching',
    '27073': 'Lac Qui Parle',
    '27075': 'Lake',
    '27077': 'Lake of the Woods',
    '27079': 'Le Sueur',
    '27081': 'Lincoln',
    '27083': 'Lyon',
    '27085': 'Mcleod',
    '27087': 'Mahnomen',
    '27089': 'Marshall',
    '27091': 'Martin',
    '27093': 'Meeker',
    '27095': 'Mille Lacs',
    '27097': 'Morrison',
    '27099': 'Mower',
    '27101': 'Murray',
    '27103': 'Nicollet',
    '27105': 'Nobles',
    '27107': 'Norman',
    '27109': 'Olmsted',
    '27111': 'Otter Tail',
    '27113': 'Pennington',
    '27115': 'Pine',
    '27117': 'Pipestone',
    '27119': 'Polk',
    '27121': 'Pope',
    '27123': 'Ramsey',
    '27125': 'Red Lake',
    '27127': 'Redwood',
    '27129': 'Renville',
    '27131': 'Rice',
    '27133': 'Rock',
    '27135': 'Roseau',
    '27137': 'Saint Louis',
    '27139': 'Scott',
    '27141': 'Sherburne',
    '27143': 'Sibley',
    '27145': 'Stearns',
    '27147': 'Steele',
    '27149': 'Stevens',
    '27151': 'Swift',
    '27153': 'Todd',
    '27155': 'Traverse',
    '27157': 'Wabasha',
    '27159': 'Wadena',
    '27161': 'Waseca',
    '27163': 'Washington',
    '27165': 'Watonwan',
    '27167': 'Wilkin',
    '27169': 'Winona',
    '27171': 'Wright',
    '27173': 'Yellow Medicine',
    '28000': 'All of Mississippi',
    '28001': 'Adams',
    '28003': 'Alcorn',
    '28005': 'Amite',
    '28007': 'Attala',
    '28009': 'Benton',
    '28011': 'Bolivar',
    '28013': 'Calhoun',
    '28015': 'Carroll',
    '28017': 'Chickasaw',
    '28019': 'Choctaw',
    '28021': 'Claiborne',
    '28023': 'Clarke',
    '28025': 'Clay',
    '28027': 'Coahoma',
    '28029': 'Copiah',
    '28031': 'Covington',
    '28033': 'Desoto',
    '28035': 'Forrest',
    '28037': 'Franklin',
    '28039': 'George',
    '28041': 'Greene',
    '28043': 'Grenada',
    '28045': 'Hancock',
    '28047': 'Harrison',
    '28049': 'Hinds',
    '28051': 'Holmes',
    '28053': 'Humphreys',
    '28055': 'Issaquena',
    '28057': 'Itawamba',
    '28059': 'Jackson',
    '28061': 'Jasper',
    '28063': 'Jefferson',
    '28065': 'Jefferson Davis',
    '28067': 'Jones',
    '28069': 'Kemper',
    '28071': 'Lafayette',
    '28073': 'Lamar',
    '28075': 'Lauderdale',
    '28077': 'Lawrence',
    '28079': 'Leake',
    '28081': 'Lee',
    '28083': 'Leflore',
    '28085': 'Lincoln',
    '28087': 'Lowndes',
    '28089': 'Madison',
    '28091': 'Marion',
    '28093': 'Marshall',
    '28095': 'Monroe',
    '28097': 'Montgomery',
    '28099': 'Neshoba',
    '28101': 'Newton',
    '28103': 'Noxubee',
    '28105': 'Oktibbeha',
    '28107': 'Panola',
    '28109': 'Pearl River',
    '28111': 'Perry',
    '28113': 'Pike',
    '28115': 'Pontotoc',
    '28117': 'Prentiss',
    '28119': 'Quitman',
    '28121': 'Rankin',
    '28123': 'Scott',
    '28125': 'Sharkey',
    '28127': 'Simpson',
    '28129': 'Smith',
    '28131': 'Stone',
    '28133': 'Sunflower',
    '28135': 'Tallahatchie',
    '28137': 'Tate',
    '28139': 'Tippah',
    '28141': 'Tishomingo',
    '28143': 'Tunica',
    '28145': 'Union',
    '28147': 'Walthall',
    '28149': 'Warren',
    '28151': 'Washington',
    '28153': 'Wayne',
    '28155': 'Webster',
    '28157': 'Wilkinson',
    '28159': 'Winston',
    '28161': 'Yalobusha',
    '28163': 'Yazoo',
    '29000': 'All of Missouri',
    '29001': 'Adair',
    '29003': 'Andrew',
    '29005': 'Atchison',
    '29007': 'Audrain',
    '29009': 'Barry',
    '29011': 'Barton',
    '29013': 'Bates',
    '29015': 'Benton',
    '29017': 'Bollinger',
    '29019': 'Boone',
    '29021': 'Buchanan',
    '29023': 'Butler',
    '29025': 'Caldwell',
    '29027': 'Callaway',
    '29029': 'Camden',
    '29031': 'Cape Girardeau',
    '29033': 'Carroll',
    '29035': 'Carter',
    '29037': 'Cass',
    '29039': 'Cedar',
    '29041': 'Chariton',
    '29043': 'Christian',
    '29045': 'Clark',
    '29047': 'Clay',
    '29049': 'Clinton',
    '29051': 'Cole',
    '29053': 'Cooper',
    '29055': 'Crawford',
    '29057': 'Dade',
    '29059': 'Dallas',
    '29061': 'Daviess',
    '29063': 'Dekalb',
    '29065': 'Dent',
    '29067': 'Douglas',
    '29069': 'Dunklin',
    '29071': 'Franklin',
    '29073': 'Gasconade',
    '29075': 'Gentry',
    '29077': 'Greene',
    '29079': 'Grundy',
    '29081': 'Harrison',
    '29083': 'Henry',
    '29085': 'Hickory',
    '29087': 'Holt',
    '29089': 'Howard',
    '29091': 'Howell',
    '29093': 'Iron',
    '29095': 'Jackson',
    '29097': 'Jasper',
    '29099': 'Jefferson',
    '29101': 'Johnson',
    '29103': 'Knox',
    '29105': 'Laclede',
    '29107': 'Lafayette',
    '29109': 'Lawrence',
    '29111': 'Lewis',
    '29113': 'Lincoln',
    '29115': 'Linn',
    '29117': 'Livingston',
    '29119': 'McDonald',
    '29121': 'Macon',
    '29123': 'Madison',
    '29125': 'Maries',
    '29127': 'Marion',
    '29129': 'Mercer',
    '29131': 'Miller',
    '29133': 'Mississippi',
    '29135': 'Moniteau',
    '29137': 'Monroe',
    '29139': 'Montgomery',
    '29141': 'Morgan',
    '29143': 'New Madrid',
    '29145': 'Newton',
    '29147': 'Nodaway',
    '29149': 'Oregon',
    '29151': 'Osage',
    '29153': 'Ozark',
    '29155': 'Pemiscot',
    '29157': 'Perry',
    '29159': 'Pettis',
    '29161': 'Phelps',
    '29163': 'Pike',
    '29165': 'Platte',
    '29167': 'Polk',
    '29169': 'Pulaski',
    '29171': 'Putnam',
    '29173': 'Ralls',
    '29175': 'Randolph',
    '29177': 'Ray',
    '29179': 'Reynolds',
    '29181': 'Ripley',
    '29183': 'Saint Charles',
    '29185': 'Saint Clair',
    '29186': 'Sainte Genevieve',
    '29187': 'Saint Francois',
    '29189': 'Saint Louis',
    '29195': 'Saline',
    '29197': 'Schuyler',
    '29199': 'Scotland',
    '29201': 'Scott',
    '29203': 'Shannon',
    '29205': 'Shelby',
    '29207': 'Stoddard',
    '29209': 'Stone',
    '29211': 'Sullivan',
    '29213': 'Taney',
    '29215': 'Texas',
    '29217': 'Vernon',
    '29219': 'Warren',
    '29221': 'Washington',
    '29223': 'Wayne',
    '29225': 'Webster',
    '29227': 'Worth',
    '29229': 'Wright',
    '29510': 'City of Saint Louis',
    '30000': 'All of Montana',
    '30001': 'Beaverhead',
    '30003': 'Big Horn',
    '30005': 'Blaine',
    '30007': 'Broadwater',
    '30009': 'Carbon',
    '30011': 'Carter',
    '30013': 'Cascade',
    '30015': 'Chouteau',
    '30017': 'Custer',
    '30019': 'Daniels',
    '30021': 'Dawson',
    '30023': 'Deer Lodge',
    '30025': 'Fallon',
    '30027': 'Fergus',
    '30029': 'Flathead',
    '30031': 'Gallatin',
    '30033': 'Garfield',
    '30035': 'Glacier',
    '30037': 'Golden Valley',
    '30039': 'Granite',
    '30041': 'Hill',
    '30043': 'Jefferson',
    '30045': 'Judith Basin',
    '30047': 'Lake',
    '30049': 'Lewis and Clark',
    '30051': 'Liberty',
    '30053': 'Lincoln',
    '30055': 'Mccone',
    '30057': 'Madison',
    '30059': 'Meagher',
    '30061': 'Mineral',
    '30063': 'Missoula',
    '30065': 'Musselshell',
    '30067': 'Park',
    '30069': 'Petroleum',
    '30071': 'Phillips',
    '30073': 'Pondera',
    '30075': 'Powder River',
    '30077': 'Powell',
    '30079': 'Prairie',
    '30081': 'Ravalli',
    '30083': 'Richland',
    '30085': 'Roosevelt',
    '30087': 'Rosebud',
    '30089': 'Sanders',
    '30091': 'Sheridan',
    '30093': 'Silver Bow',
    '30095': 'Stillwater',
    '30097': 'Sweet Grass',
    '30099': 'Teton',
    '30101': 'Toole',
    '30103': 'Treasure',
    '30105': 'Valley',
    '30107': 'Wheatland',
    '30109': 'Wibaux',
    '30111': 'Yellowstone',
    '31000': 'All of Nebraska',
    '31001': 'Adams',
    '31003': 'Antelope',
    '31005': 'Arthur',
    '31007': 'Banner',
    '31009': 'Blaine',
    '31011': 'Boone',
    '31013': 'Box Butte',
    '31015': 'Boyd',
    '31017': 'Brown',
    '31019': 'Buffalo',
    '31021': 'Burt',
    '31023': 'Butler',
    '31025': 'Cass',
    '31027': 'Cedar',
    '31029': 'Chase',
    '31031': 'Cherry',
    '31033': 'Cheyenne',
    '31035': 'Clay',
    '31037': 'Colfax',
    '31039': 'Cuming',
    '31041': 'Custer',
    '31043': 'Dakota',
    '31045': 'Dawes',
    '31047': 'Dawson',
    '31049': 'Deuel',
    '31051': 'Dixon',
    '31053': 'Dodge',
    '31055': 'Douglas',
    '31057': 'Dundy',
    '31059': 'Fillmore',
    '31061': 'Franklin',
    '31063': 'Frontier',
    '31065': 'Furnas',
    '31067': 'Gage',
    '31069': 'Garden',
    '31071': 'Garfield',
    '31073': 'Gosper',
    '31075': 'Grant',
    '31077': 'Greeley',
    '31079': 'Hall',
    '31081': 'Hamilton',
    '31083': 'Harlan',
    '31085': 'Hayes',
    '31087': 'Hitchcock',
    '31089': 'Holt',
    '31091': 'Hooker',
    '31093': 'Howard',
    '31095': 'Jefferson',
    '31097': 'Johnson',
    '31099': 'Kearney',
    '31101': 'Keith',
    '31103': 'Keya Paha',
    '31105': 'Kimball',
    '31107': 'Knox',
    '31109': 'Lancaster',
    '31111': 'Lincoln',
    '31113': 'Logan',
    '31115': 'Loup',
    '31117': 'Mcpherson',
    '31119': 'Madison',
    '31121': 'Merrick',
    '31123': 'Morrill',
    '31125': 'Nance',
    '31127': 'Nemaha',
    '31129': 'Nuckolls',
    '31131': 'Otoe',
    '31133': 'Pawnee',
    '31135': 'Perkins',
    '31137': 'Phelps',
    '31139': 'Pierce',
    '31141': 'Platte',
    '31143': 'Polk',
    '31145': 'Red Willow',
    '31147': 'Richardson',
    '31149': 'Rock',
    '31151': 'Saline',
    '31153': 'Sarpy',
    '31155': 'Saunders',
    '31157': 'Scotts Bluff',
    '31159': 'Seward',
    '31161': 'Sheridan',
    '31163': 'Sherman',
    '31165': 'Sioux',
    '31167': 'Stanton',
    '31169': 'Thayer',
    '31171': 'Thomas',
    '31173': 'Thurston',
    '31175': 'Valley',
    '31177': 'Washington',
    '31179': 'Wayne',
    '31181': 'Webster',
    '31183': 'Wheeler',
    '31185': 'York',
    '32000': 'All of Nevada',
    '32001': 'Churchill',
    '32003': 'Clark',
    '32005': 'Douglas',
    '32007': 'Elko',
    '32009': 'Esmeralda',
    '32011': 'Eureka',
    '32013': 'Humboldt',
    '32015': 'Lander',
    '32017': 'Lincoln',
    '32019': 'Lyon',
    '32021': 'Mineral',
    '32023': 'Nye',
    '32027': 'Pershing',
    '32029': 'Storey',
    '32031': 'Washoe',
    '32033': 'White Pine',
    '32510': 'City of Carson',
    '33000': 'All of New Hampshire',
    '33001': 'Belknap',
    '33003': 'Carroll',
    '33005': 'Cheshire',
    '33007': 'Coos',
    '33009': 'Grafton',
    '33011': 'Hillsborough',
    '33013': 'Merrimack',
    '33015': 'Rockingham',
    '33017': 'Strafford',
    '33019': 'Sullivan',
    '34000': 'All of New Jersey',
    '34001': 'Atlantic',
    '34003': 'Bergen',
    '34005': 'Burlington',
    '34007': 'Camden',
    '34009': 'Cape May',
    '34011': 'Cumberland',
    '34013': 'Essex',
    '34015': 'Gloucester',
    '34017': 'Hudson',
    '34019': 'Hunterdon',
    '34021': 'Mercer',
    '34023': 'Middlesex',
    '34025': 'Monmouth',
    '34027': 'Morris',
    '34029': 'Ocean',
    '34031': 'Passaic',
    '34033': 'Salem',
    '34035': 'Somerset',
    '34037': 'Sussex',
    '34039': 'Union',
    '34041': 'Warren',
    '35000': 'All of New Mexico',
    '35001': 'Bernalillo',
    '35003': 'Catron',
    '35005': 'Chaves',
    '35006': 'Cibola',
    '35007': 'Colfax',
    '35009': 'Curry',
    '35011': 'Debaca',
    '35013': 'Dona Ana',
    '35015': 'Eddy',
    '35017': 'Grant',
    '35019': 'Guadalupe',
    '35021': 'Harding',
    '35023': 'Hidalgo',
    '35025': 'Lea',
    '35027': 'Lincoln',
    '35028': 'Los Alamos',
    '35029': 'Luna',
    '35031': 'Mckinley',
    '35033': 'Mora',
    '35035': 'Otero',
    '35037': 'Quay',
    '35039': 'Rio Arriba',
    '35041': 'Roosevelt',
    '35043': 'Sandoval',
    '35045': 'San Juan',
    '35047': 'San Miguel',
    '35049': 'Santa Fe',
    '35051': 'Sierra',
    '35053': 'Socorro',
    '35055': 'Taos',
    '35057': 'Torrance',
    '35059': 'Union',
    '35061': 'Valencia',
    '36000': 'All of New York',
    '36001': 'Albany',
    '36003': 'Allegany',
    '36005': 'Bronx',
    '36007': 'Broome',
    '36009': 'Cattaraugus',
    '36011': 'Cayuga',
    '36013': 'Chautauqua',
    '36015': 'Chemung',
    '36017': 'Chenango',
    '36019': 'Clinton',
    '36021': 'Columbia',
    '36023': 'Cortland',
    '36025': 'Delaware',
    '36027': 'Dutchess',
    '36029': 'Erie',
    '36031': 'Essex',
    '36033': 'Franklin',
    '36035': 'Fulton',
    '36037': 'Genesee',
    '36039': 'Greene',
    '36041': 'Hamilton',
    '36043': 'Herkimer',
    '36045': 'Jefferson',
    '36047': 'Kings',
    '36049': 'Lewis',
    '36051': 'Livingston',
    '36053': 'Madison',
    '36055': 'Monroe',
    '36057': 'Montgomery',
    '36059': 'Nassau',
    '36061': 'New York',
    '36063': 'Niagara',
    '36065': 'Oneida',
    '36067': 'Onondaga',
    '36069': 'Ontario',
    '36071': 'Orange',
    '36073': 'Orleans',
    '36075': 'Oswego',
    '36077': 'Otsego',
    '36079': 'Putnam',
    '36081': 'Queens',
    '36083': 'Rensselaer',
    '36085': 'Richmond',
    '36087': 'Rockland',
    '36089': 'Saint Lawrence',
    '36091': 'Saratoga',
    '36093': 'Schenectady',
    '36095': 'Schoharie',
    '36097': 'Schuyler',
    '36099': 'Seneca',
    '36101': 'Steuben',
    '36103': 'Suffolk',
    '36105': 'Sullivan',
    '36107': 'Tioga',
    '36109': 'Tompkins',
    '36111': 'Ulster',
    '36113': 'Warren',
    '36115': 'Washington',
    '36117': 'Wayne',
    '36119': 'Westchester',
    '36121': 'Wyoming',
    '36123': 'Yates',
    '37000': 'All of North Carolina',
    '37001': 'Alamance',
    '37003': 'Alexander',
    '37005': 'Alleghany',
    '37007': 'Anson',
    '37009': 'Ashe',
    '37011': 'Avery',
    '37013': 'Beaufort',
    '37015': 'Bertie',
    '37017': 'Bladen',
    '37019': 'Brunswick',
    '37021': 'Buncombe',
    '37023': 'Burke',
    '37025': 'Cabarrus',
    '37027': 'Caldwell',
    '37029': 'Camden',
    '37031': 'Carteret',
    '37033': 'Caswell',
    '37035': 'Catawba',
    '37037': 'Chatham',
    '37039': 'Cherokee',
    '37041': 'Chowan',
    '37043': 'Clay',
    '37045': 'Cleveland',
    '37047': 'Columbus',
    '37049': 'Craven',
    '37051': 'Cumberland',
    '37053': 'Currituck',
    '37055': 'Dare',
    '37057': 'Davidson',
    '37059': 'Davie',
    '37061': 'Duplin',
    '37063': 'Durham',
    '37065': 'Edgecombe',
    '37067': 'Forsyth',
    '37069': 'Franklin',
    '37071': 'Gaston',
    '37073': 'Gates',
    '37075': 'Graham',
    '37077': 'Granville',
    '37079': 'Greene',
    '37081': 'Guilford',
    '37083': 'Halifax',
    '37085': 'Harnett',
    '37087': 'Haywood',
    '37089': 'Henderson',
    '37091': 'Hertford',
    '37093': 'Hoke',
    '37095': 'Hyde',
    '37097': 'Iredell',
    '37099': 'Jackson',
    '37101': 'Johnston',
    '37103': 'Jones',
    '37105': 'Lee',
    '37107': 'Lenoir',
    '37109': 'Lincoln',
    '37111': 'Mcdowell',
    '37113': 'Macon',
    '37115': 'Madison',
    '37117': 'Martin',
    '37119': 'Mecklenburg',
    '37121': 'Mitchell',
    '37123': 'Montgomery',
    '37125': 'Moore',
    '37127': 'Nash',
    '37129': 'New Hanover',
    '37131': 'Northampton',
    '37133': 'Onslow',
    '37135': 'Orange',
    '37137': 'Pamlico',
    '37139': 'Pasquotank',
    '37141': 'Pender',
    '37143': 'Perquimans',
    '37145': 'Person',
    '37147': 'Pitt',
    '37149': 'Polk',
    '37151': 'Randolph',
    '37153': 'Richmond',
    '37155': 'Robeson',
    '37157': 'Rockingham',
    '37159': 'Rowan',
    '37161': 'Rutherford',
    '37163': 'Sampson',
    '37165': 'Scotland',
    '37167': 'Stanly',
    '37169': 'Stokes',
    '37171': 'Surry',
    '37173': 'Swain',
    '37175': 'Transylvania',
    '37177': 'Tyrrell',
    '37179': 'Union',
    '37181': 'Vance',
    '37183': 'Wake',
    '37185': 'Warren',
    '37187': 'Washington',
    '37189': 'Watauga',
    '37191': 'Wayne',
    '37193': 'Wilkes',
    '37195': 'Wilson',
    '37197': 'Yadkin',
    '37199': 'Yancey',
    '38000': 'All of North Dakota',
    '38001': 'Adams',
    '38003': 'Barnes',
    '38005': 'Benson',
    '38007': 'Billings',
    '38009': 'Bottineau',
    '38011': 'Bowman',
    '38013': 'Burke',
    '38015': 'Burleigh',
    '38017': 'Cass',
    '38019': 'Cavalier',
    '38021': 'Dickey',
    '38023': 'Divide',
    '38025': 'Dunn',
    '38027': 'Eddy',
    '38029': 'Emmons',
    '38031': 'Foster',
    '38033': 'Golden Valley',
    '38035': 'Grand Forks',
    '38037': 'Grant',
    '38039': 'Griggs',
    '38041': 'Hettinger',
    '38043': 'Kidder',
    '38045': 'Lamoure',
    '38047': 'Logan',
    '38049': 'Mchenry',
    '38051': 'Mcintosh',
    '38053': 'Mckenzie',
    '38055': 'Mclean',
    '38057': 'Mercer',
    '38059': 'Morton',
    '38061': 'Mountrail',
    '38063': 'Nelson',
    '38065': 'Oliver',
    '38067': 'Pembina',
    '38069': 'Pierce',
    '38071': 'Ramsey',
    '38073': 'Ransom',
    '38075': 'Renville',
    '38077': 'Richland',
    '38079': 'Rolette',
    '38081': 'Sargent',
    '38083': 'Sheridan',
    '38085': 'Sioux',
    '38087': 'Slope',
    '38089': 'Stark',
    '38091': 'Steele',
    '38093': 'Stutsman',
    '38095': 'Towner',
    '38097': 'Traill',
    '38099': 'Walsh',
    '38101': 'Ward',
    '38103': 'Wells',
    '38105': 'Williams',
    '39000': 'All of Ohio',
    '39001': 'Adams',
    '39003': 'Allen',
    '39005': 'Ashland',
    '39007': 'Ashtabula',
    '39009': 'Athens',
    '39011': 'Auglaize',
    '39013': 'Belmont',
    '39015': 'Brown',
    '39017': 'Butler',
    '39019': 'Carroll',
    '39021': 'Champaign',
    '39023': 'Clark',
    '39025': 'Clermont',
    '39027': 'Clinton',
    '39029': 'Columbiana',
    '39031': 'Coshocton',
    '39033': 'Crawford',
    '39035': 'Cuyahoga',
    '39037': 'Darke',
    '39039': 'Defiance',
    '39041': 'Delaware',
    '39043': 'Erie',
    '39045': 'Fairfield',
    '39047': 'Fayette',
    '39049': 'Franklin',
    '39051': 'Fulton',
    '39053': 'Gallia',
    '39055': 'Geauga',
    '39057': 'Greene',
    '39059': 'Guernsey',
    '39061': 'Hamilton',
    '39063': 'Hancock',
    '39065': 'Hardin',
    '39067': 'Harrison',
    '39069': 'Henry',
    '39071': 'Highland',
    '39073': 'Hocking',
    '39075': 'Holmes',
    '39077': 'Huron',
    '39079': 'Jackson',
    '39081': 'Jefferson',
    '39083': 'Knox',
    '39085': 'Lake',
    '39087': 'Lawrence',
    '39089': 'Licking',
    '39091': 'Logan',
    '39093': 'Lorain',
    '39095': 'Lucas',
    '39097': 'Madison',
    '39099': 'Mahoning',
    '39101': 'Marion',
    '39103': 'Medina',
    '39105': 'Meigs',
    '39107': 'Mercer',
    '39109': 'Miami',
    '39111': 'Monroe',
    '39113': 'Montgomery',
    '39115': 'Morgan',
    '39117': 'Morrow',
    '39119': 'Muskingum',
    '39121': 'Noble',
    '39123': 'Ottawa',
    '39125': 'Paulding',
    '39127': 'Perry',
    '39129': 'Pickaway',
    '39131': 'Pike',
    '39133': 'Portage',
    '39135': 'Preble',
    '39137': 'Putnam',
    '39139': 'Richland',
    '39141': 'Ross',
    '39143': 'Sandusky',
    '39145': 'Scioto',
    '39147': 'Seneca',
    '39149': 'Shelby',
    '39151': 'Stark',
    '39153': 'Summit',
    '39155': 'Trumbull',
    '39157': 'Tuscarawas',
    '39159': 'Union',
    '39161': 'Van Wert',
    '39163': 'Vinton',
    '39165': 'Warren',
    '39167': 'Washington',
    '39169': 'Wayne',
    '39171': 'Williams',
    '39173': 'Wood',
    '39175': 'Wyandot',
    '40000': 'All of Oklahoma',
    '40001': 'Adair',
    '40003': 'Alfalfa',
    '40005': 'Atoka',
    '40007': 'Beaver',
    '40009': 'Beckham',
    '40011': 'Blaine',
    '40013': 'Bryan',
    '40015': 'Caddo',
    '40017': 'Canadian',
    '40019': 'Carter',
    '40021': 'Cherokee',
    '40023': 'Choctaw',
    '40025': 'Cimarron',
    '40027': 'Cleveland',
    '40029': 'Coal',
    '40031': 'Comanche',
    '40033': 'Cotton',
    '40035': 'Craig',
    '40037': 'Creek',
    '40039': 'Custer',
    '40041': 'Delaware',
    '40043': 'Dewey',
    '40045': 'Ellis',
    '40047': 'Garfield',
    '40049': 'Garvin',
    '40051': 'Grady',
    '40053': 'Grant',
    '40055': 'Greer',
    '40057': 'Harmon',
    '40059': 'Harper',
    '40061': 'Haskell',
    '40063': 'Hughes',
    '40065': 'Jackson',
    '40067': 'Jefferson',
    '40069': 'Johnston',
    '40071': 'Kay',
    '40073': 'Kingfisher',
    '40075': 'Kiowa',
    '40077': 'Latimer',
    '40079': 'Le Flore',
    '40081': 'Lincoln',
    '40083': 'Logan',
    '40085': 'Love',
    '40087': 'Mcclain',
    '40089': 'Mccurtain',
    '40091': 'Mcintosh',
    '40093': 'Major',
    '40095': 'Marshall',
    '40097': 'Mayes',
    '40099': 'Murray',
    '40101': 'Muskogee',
    '40103': 'Noble',
    '40105': 'Nowata',
    '40107': 'Okfuskee',
    '40109': 'Oklahoma',
    '40111': 'Okmulgee',
    '40113': 'Osage',
    '40115': 'Ottawa',
    '40117': 'Pawnee',
    '40119': 'Payne',
    '40121': 'Pittsburg',
    '40123': 'Pontotoc',
    '40125': 'Pottawatomie',
    '40127': 'Pushmataha',
    '40129': 'Roger Mills',
    '40131': 'Rogers',
    '40133': 'Seminole',
    '40135': 'Sequoyah',
    '40137': 'Stephens',
    '40139': 'Texas',
    '40141': 'Tillman',
    '40143': 'Tulsa',
    '40145': 'Wagoner',
    '40147': 'Washington',
    '40149': 'Washita',
    '40151': 'Woods',
    '40153': 'Woodward',
    '41000': 'All of Oregon',
    '41001': 'Baker',
    '41003': 'Benton',
    '41005': 'Clackamas',
    '41007': 'Clatsop',
    '41009': 'Columbia',
    '41011': 'Coos',
    '41013': 'Crook',
    '41015': 'Curry',
    '41017': 'Deschutes',
    '41019': 'Douglas',
    '41021': 'Gilliam',
    '41023': 'Grant',
    '41025': 'Harney',
    '41027': 'Hood River',
    '41029': 'Jackson',
    '41031': 'Jefferson',
    '41033': 'Josephine',
    '41035': 'Klamath',
    '41037': 'Lake',
    '41039': 'Lane',
    '41041': 'Lincoln',
    '41043': 'Linn',
    '41045': 'Malheur',
    '41047': 'Marion',
    '41049': 'Morrow',
    '41051': 'Multnomah',
    '41053': 'Polk',
    '41055': 'Sherman',
    '41057': 'Tillamook',
    '41059': 'Umatilla',
    '41061': 'Union',
    '41063': 'Wallowa',
    '41065': 'Wasco',
    '41067': 'Washington',
    '41069': 'Wheeler',
    '41071': 'Yamhill',
    '42000': 'All of Pennsylvania',
    '42001': 'Adams',
    '42003': 'Allegheny',
    '42005': 'Armstrong',
    '42007': 'Beaver',
    '42009': 'Bedford',
    '42011': 'Berks',
    '42013': 'Blair',
    '42015': 'Bradford',
    '42017': 'Bucks',
    '42019': 'Butler',
    '42021': 'Cambria',
    '42023': 'Cameron',
    '42025': 'Carbon',
    '42027': 'Centre',
    '42029': 'Chester',
    '42031': 'Clarion',
    '42033': 'Clearfield',
    '42035': 'Clinton',
    '42037': 'Columbia',
    '42039': 'Crawford',
    '42041': 'Cumberland',
    '42043': 'Dauphin',
    '42045': 'Delaware',
    '42047': 'Elk',
    '42049': 'Erie',
    '42051': 'Fayette',
    '42053': 'Forest',
    '42055': 'Franklin',
    '42057': 'Fulton',
    '42059': 'Greene',
    '42061': 'Huntingdon',
    '42063': 'Indiana',
    '42065': 'Jefferson',
    '42067': 'Juniata',
    '42069': 'Lackawanna',
    '42071': 'Lancaster',
    '42073': 'Lawrence',
    '42075': 'Lebanon',
    '42077': 'Lehigh',
    '42079': 'Luzerne',
    '42081': 'Lycoming',
    '42083': 'Mckean',
    '42085': 'Mercer',
    '42087': 'Mifflin',
    '42089': 'Monroe',
    '42091': 'Montgomery',
    '42093': 'Montour',
    '42095': 'Northampton',
    '42097': 'Northumberland',
    '42099': 'Perry',
    '42101': 'Philadelphia',
    '42103': 'Pike',
    '42105': 'Potter',
    '42107': 'Schuylkill',
    '42109': 'Snyder',
    '42111': 'Somerset',
    '42113': 'Sullivan',
    '42115': 'Susquehanna',
    '42117': 'Tioga',
    '42119': 'Union',
    '42121': 'Venango',
    '42123': 'Warren',
    '42125': 'Washington',
    '42127': 'Wayne',
    '42129': 'Westmoreland',
    '42131': 'Wyoming',
    '42133': 'York',
    '44000': 'All of Rhode Island',
    '44001': 'Bristol',
    '44003': 'Kent',
    '44005': 'Newport',
    '44007': 'Providence',
    '44009': 'Washington',
    '45000': 'All of South Carolina',
    '45001': 'Abbeville',
    '45003': 'Aiken',
    '45005': 'Allendale',
    '45007': 'Anderson',
    '45009': 'Bamberg',
    '45011': 'Barnwell',
    '45013': 'Beaufort',
    '45015': 'Berkeley',
    '45017': 'Calhoun',
    '45019': 'Charleston',
    '45021': 'Cherokee',
    '45023': 'Chester',
    '45025': 'Chesterfield',
    '45027': 'Clarendon',
    '45029': 'Colleton',
    '45031': 'Darlington',
    '45033': 'Dillon',
    '45035': 'Dorchester',
    '45037': 'Edgefield',
    '45039': 'Fairfield',
    '45041': 'Florence',
    '45043': 'Georgetown',
    '45045': 'Greenville',
    '45047': 'Greenwood',
    '45049': 'Hampton',
    '45051': 'Horry',
    '45053': 'Jasper',
    '45055': 'Kershaw',
    '45057': 'Lancaster',
    '45059': 'Laurens',
    '45061': 'Lee',
    '45063': 'Lexington',
    '45065': 'Mccormick',
    '45067': 'Marion',
    '45069': 'Marlboro',
    '45071': 'Newberry',
    '45073': 'Oconee',
    '45075': 'Orangeburg',
    '45077': 'Pickens',
    '45079': 'Richland',
    '45081': 'Saluda',
    '45083': 'Spartanburg',
    '45085': 'Sumter',
    '45087': 'Union',
    '45089': 'Williamsburg',
    '45091': 'York',
    '46000': 'All of South Dakota',
    '46003': 'Aurora',
    '46005': 'Beadle',
    '46007': 'Bennett',
    '46009': 'Bon Homme',
    '46011': 'Brookings',
    '46013': 'Brown',
    '46015': 'Brule',
    '46017': 'Buffalo',
    '46019': 'Butte',
    '46021': 'Campbell',
    '46023': 'Charles Mix',
    '46025': 'Clark',
    '46027': 'Clay',
    '46029': 'Codington',
    '46031': 'Corson',
    '46033': 'Custer',
    '46035': 'Davison',
    '46037': 'Day',
    '46039': 'Deuel',
    '46041': 'Dewey',
    '46043': 'Douglas',
    '46045': 'Edmunds',
    '46047': 'Fall River',
    '46049': 'Faulk',
    '46051': 'Grant',
    '46053': 'Gregory',
    '46055': 'Haakon',
    '46057': 'Hamlin',
    '46059': 'Hand',
    '46061': 'Hanson',
    '46063': 'Harding',
    '46065': 'Hughes',
    '46067': 'Hutchinson',
    '46069': 'Hyde',
    '46071': 'Jackson',
    '46073': 'Jerauld',
    '46075': 'Jones',
    '46077': 'Kingsbury',
    '46079': 'Lake',
    '46081': 'Lawrence',
    '46083': 'Lincoln',
    '46085': 'Lyman',
    '46087': 'Mccook',
    '46089': 'Mcpherson',
    '46091': 'Marshall',
    '46093': 'Meade',
    '46095': 'Mellette',
    '46097': 'Miner',
    '46099': 'Minnehaha',
    '46101': 'Moody',
    '46102': 'Oglala Lakota',
    '46103': 'Pennington',
    '46105': 'Perkins',
    '46107': 'Potter',
    '46109': 'Roberts',
    '46111': 'Sanborn',
    '46113': 'Shannon',  # deprecated 10/2015, use 46102 Oglala Lakota
    '46115': 'Spink',
    '46117': 'Stanley',
    '46119': 'Sully',
    '46121': 'Todd',
    '46123': 'Tripp',
    '46125': 'Turner',
    '46127': 'Union',
    '46129': 'Walworth',
    '46135': 'Yankton',
    '46137': 'Ziebach',
    '47000': 'All of Tennessee',
    '47001': 'Anderson',
    '47003': 'Bedford',
    '47005': 'Benton',
    '47007': 'Bledsoe',
    '47009': 'Blount',
    '47011': 'Bradley',
    '47013': 'Campbell',
    '47015': 'Cannon',
    '47017': 'Carroll',
    '47019': 'Carter',
    '47021': 'Cheatham',
    '47023': 'Chester',
    '47025': 'Claiborne',
    '47027': 'Clay',
    '47029': 'Cocke',
    '47031': 'Coffee',
    '47033': 'Crockett',
    '47035': 'Cumberland',
    '47037': 'Davidson',
    '47039': 'Decatur',
    '47041': 'Dekalb',
    '47043': 'Dickson',
    '47045': 'Dyer',
    '47047': 'Fayette',
    '47049': 'Fentress',
    '47051': 'Franklin',
    '47053': 'Gibson',
    '47055': 'Giles',
    '47057': 'Grainger',
    '47059': 'Greene',
    '47061': 'Grundy',
    '47063': 'Hamblen',
    '47065': 'Hamilton',
    '47067': 'Hancock',
    '47069': 'Hardeman',
    '47071': 'Hardin',
    '47073': 'Hawkins',
    '47075': 'Haywood',
    '47077': 'Henderson',
    '47079': 'Henry',
    '47081': 'Hickman',
    '47083': 'Houston',
    '47085': 'Humphreys',
    '47087': 'Jackson',
    '47089': 'Jefferson',
    '47091': 'Johnson',
    '47093': 'Knox',
    '47095': 'Lake',
    '47097': 'Lauderdale',
    '47099': 'Lawrence',
    '47101': 'Lewis',
    '47103': 'Lincoln',
    '47105': 'Loudon',
    '47107': 'Mcminn',
    '47109': 'Mcnairy',
    '47111': 'Macon',
    '47113': 'Madison',
    '47115': 'Marion',
    '47117': 'Marshall',
    '47119': 'Maury',
    '47121': 'Meigs',
    '47123': 'Monroe',
    '47125': 'Montgomery',
    '47127': 'Moore',
    '47129': 'Morgan',
    '47131': 'Obion',
    '47133': 'Overton',
    '47135': 'Perry',
    '47137': 'Pickett',
    '47139': 'Polk',
    '47141': 'Putnam',
    '47143': 'Rhea',
    '47145': 'Roane',
    '47147': 'Robertson',
    '47149': 'Rutherford',
    '47151': 'Scott',
    '47153': 'Sequatchie',
    '47155': 'Sevier',
    '47157': 'Shelby',
    '47159': 'Smith',
    '47161': 'Stewart',
    '47163': 'Sullivan',
    '47165': 'Sumner',
    '47167': 'Tipton',
    '47169': 'Trousdale',
    '47171': 'Unicoi',
    '47173': 'Union',
    '47175': 'Van Buren',
    '47177': 'Warren',
    '47179': 'Washington',
    '47181': 'Wayne',
    '47183': 'Weakley',
    '47185': 'White',
    '47187': 'Williamson',
    '47189': 'Wilson',
    '48000': 'All of Texas',
    '48001': 'Anderson',
    '48003': 'Andrews',
    '48005': 'Angelina',
    '48007': 'Aransas',
    '48009': 'Archer',
    '48011': 'Armstrong',
    '48013': 'Atascosa',
    '48015': 'Austin',
    '48017': 'Bailey',
    '48019': 'Bandera',
    '48021': 'Bastrop',
    '48023': 'Baylor',
    '48025': 'Bee',
    '48027': 'Bell',
    '48029': 'Bexar',
    '48031': 'Blanco',
    '48033': 'Borden',
    '48035': 'Bosque',
    '48037': 'Bowie',
    '48039': 'Brazoria',
    '48041': 'Brazos',
    '48043': 'Brewster',
    '48045': 'Briscoe',
    '48047': 'Brooks',
    '48049': 'Brown',
    '48051': 'Burleson',
    '48053': 'Burnet',
    '48055': 'Caldwell',
    '48057': 'Calhoun',
    '48059': 'Callahan',
    '48061': 'Cameron',
    '48063': 'Camp',
    '48065': 'Carson',
    '48067': 'Cass',
    '48069': 'Castro',
    '48071': 'Chambers',
    '48073': 'Cherokee',
    '48075': 'Childress',
    '48077': 'Clay',
    '48079': 'Cochran',
    '48081': 'Coke',
    '48083': 'Coleman',
    '48085': 'Collin',
    '48087': 'Collingsworth',
    '48089': 'Colorado',
    '48091': 'Comal',
    '48093': 'Comanche',
    '48095': 'Concho',
    '48097': 'Cooke',
    '48099': 'Coryell',
    '48101': 'Cottle',
    '48103': 'Crane',
    '48105': 'Crockett',
    '48107': 'Crosby',
    '48109': 'Culberson',
    '48111': 'Dallam',
    '48113': 'Dallas',
    '48115': 'Dawson',
    '48117': 'Deaf Smith',
    '48119': 'Delta',
    '48121': 'Denton',
    '48123': 'Dewitt',
    '48125': 'Dickens',
    '48127': 'Dimmit',
    '48129': 'Donley',
    '48131': 'Duval',
    '48133': 'Eastland',
    '48135': 'Ector',
    '48137': 'Edwards',
    '48139': 'Ellis',
    '48141': 'El Paso',
    '48143': 'Erath',
    '48145': 'Falls',
    '48147': 'Fannin',
    '48149': 'Fayette',
    '48151': 'Fisher',
    '48153': 'Floyd',
    '48155': 'Foard',
    '48157': 'Fort Bend',
    '48159': 'Franklin',
    '48161': 'Freestone',
    '48163': 'Frio',
    '48165': 'Gaines',
    '48167': 'Galveston',
    '48169': 'Garza',
    '48171': 'Gillespie',
    '48173': 'Glasscock',
    '48175': 'Goliad',
    '48177': 'Gonzales',
    '48179': 'Gray',
    '48181': 'Grayson',
    '48183': 'Gregg',
    '48185': 'Grimes',
    '48187': 'Guadalupe',
    '48189': 'Hale',
    '48191': 'Hall',
    '48193': 'Hamilton',
    '48195': 'Hansford',
    '48197': 'Hardeman',
    '48199': 'Hardin',
    '48201': 'Harris',
    '48203': 'Harrison',
    '48205': 'Hartley',
    '48207': 'Haskell',
    '48209': 'Hays',
    '48211': 'Hemphill',
    '48213': 'Henderson',
    '48215': 'Hidalgo',
    '48217': 'Hill',
    '48219': 'Hockley',
    '48221': 'Hood',
    '48223': 'Hopkins',
    '48225': 'Houston',
    '48227': 'Howard',
    '48229': 'Hudspeth',
    '48231': 'Hunt',
    '48233': 'Hutchinson',
    '48235': 'Irion',
    '48237': 'Jack',
    '48239': 'Jackson',
    '48241': 'Jasper',
    '48243': 'Jeff Davis',
    '48245': 'Jefferson',
    '48247': 'Jim Hogg',
    '48249': 'Jim Wells',
    '48251': 'Johnson',
    '48253': 'Jones',
    '48255': 'Karnes',
    '48257': 'Kaufman',
    '48259': 'Kendall',
    '48261': 'Kenedy',
    '48263': 'Kent',
    '48265': 'Kerr',
    '48267': 'Kimble',
    '48269': 'King',
    '48271': 'Kinney',
    '48273': 'Kleberg',
    '48275': 'Knox',
    '48277': 'Lamar',
    '48279': 'Lamb',
    '48281': 'Lampasas',
    '48283': 'La Salle',
    '48285': 'Lavaca',
    '48287': 'Lee',
    '48289': 'Leon',
    '48291': 'Liberty',
    '48293': 'Limestone',
    '48295': 'Lipscomb',
    '48297': 'Live Oak',
    '48299': 'Llano',
    '48301': 'Loving',
    '48303': 'Lubbock',
    '48305': 'Lynn',
    '48307': 'Mcculloch',
    '48309': 'Mclennan',
    '48311': 'Mcmullen',
    '48313': 'Madison',
    '48315': 'Marion',
    '48317': 'Martin',
    '48319': 'Mason',
    '48321': 'Matagorda',
    '48323': 'Maverick',
    '48325': 'Medina',
    '48327': 'Menard',
    '48329': 'Midland',
    '48331': 'Milam',
    '48333': 'Mills',
    '48335': 'Mitchell',
    '48337': 'Montague',
    '48339': 'Montgomery',
    '48341': 'Moore',
    '48343': 'Morris',
    '48345': 'Motley',
    '48347': 'Nacogdoches',
    '48349': 'Navarro',
    '48351': 'Newton',
    '48353': 'Nolan',
    '48355': 'Nueces',
    '48357': 'Ochiltree',
    '48359': 'Oldham',
    '48361': 'Orange',
    '48363': 'Palo Pinto',
    '48365': 'Panola',
    '48367': 'Parker',
    '48369': 'Parmer',
    '48371': 'Pecos',
    '48373': 'Polk',
    '48375': 'Potter',
    '48377': 'Presidio',
    '48379': 'Rains',
    '48381': 'Randall',
    '48383': 'Reagan',
    '48385': 'Real',
    '48387': 'Red River',
    '48389': 'Reeves',
    '48391': 'Refugio',
    '48393': 'Roberts',
    '48395': 'Robertson',
    '48397': 'Rockwall',
    '48399': 'Runnels',
    '48401': 'Rusk',
    '48403': 'Sabine',
    '48405': 'San Augustine',
    '48407': 'San Jacinto',
    '48409': 'San Patricio',
    '48411': 'San Saba',
    '48413': 'Schleicher',
    '48415': 'Scurry',
    '48417': 'Shackelford',
    '48419': 'Shelby',
    '48421': 'Sherman',
    '48423': 'Smith',
    '48425': 'Somervell',
    '48427': 'Starr',
    '48429': 'Stephens',
    '48431': 'Sterling',
    '48433': 'Stonewall',
    '48435': 'Sutton',
    '48437': 'Swisher',
    '48439': 'Tarrant',
    '48441': 'Taylor',
    '48443': 'Terrell',
    '48445': 'Terry',
    '48447': 'Throckmorton',
    '48449': 'Titus',
    '48451': 'Tom Green',
    '48453': 'Travis',
    '48455': 'Trinity',
    '48457': 'Tyler',
    '48459': 'Upshur',
    '48461': 'Upton',
    '48463': 'Uvalde',
    '48465': 'Val Verde',
    '48467': 'Van Zandt',
    '48469': 'Victoria',
    '48471': 'Walker',
    '48473': 'Waller',
    '48475': 'Ward',
    '48477': 'Washington',
    '48479': 'Webb',
    '48481': 'Wharton',
    '48483': 'Wheeler',
    '48485': 'Wichita',
    '48487': 'Wilbarger',
    '48489': 'Willacy',
    '48491': 'Williamson',
    '48493': 'Wilson',
    '48495': 'Winkler',
    '48497': 'Wise',
    '48499': 'Wood',
    '48501': 'Yoakum',
    '48503': 'Young',
    '48505': 'Zapata',
    '48507': 'Zavala',
    '49000': 'All of Utah',
    '49001': 'Beaver',
    '49003': 'Box Elder',
    '49005': 'Cache',
    '49007': 'Carbon',
    '49009': 'Daggett',
    '49011': 'Davis',
    '49013': 'Duchesne',
    '49015': 'Emery',
    '49017': 'Garfield',
    '49019': 'Grand',
    '49021': 'Iron',
    '49023': 'Juab',
    '49025': 'Kane',
    '49027': 'Millard',
    '49029': 'Morgan',
    '49031': 'Piute',
    '49033': 'Rich',
    '49035': 'Salt Lake',
    '49037': 'San Juan',
    '49039': 'Sanpete',
    '49041': 'Sevier',
    '49043': 'Summit',
    '49045': 'Tooele',
    '49047': 'Uintah',
    '49049': 'Utah',
    '49051': 'Wasatch',
    '49053': 'Washington',
    '49055': 'Wayne',
    '49057': 'Weber',
    '50000': 'All of Vermont',
    '50001': 'Addison',
    '50003': 'Bennington',
    '50005': 'Caledonia',
    '50007': 'Chittenden',
    '50009': 'Essex',
    '50011': 'Franklin',
    '50013': 'Grand Isle',
    '50015': 'Lamoille',
    '50017': 'Orange',
    '50019': 'Orleans',
    '50021': 'Rutland',
    '50023': 'Washington',
    '50025': 'Windham',
    '50027': 'Windsor',
    '51000': 'All of Virginia',
    '51001': 'Accomack',
    '51003': 'Albemarle',
    '51005': 'Alleghany',
    '51007': 'Amelia',
    '51009': 'Amherst',
    '51011': 'Appomattox',
    '51013': 'Arlington',
    '51015': 'Augusta',
    '51017': 'Bath',
    '51019': 'Bedford',
    '51021': 'Bland',
    '51023': 'Botetourt',
    '51025': 'Brunswick',
    '51027': 'Buchanan',
    '51029': 'Buckingham',
    '51031': 'Campbell',
    '51033': 'Caroline',
    '51035': 'Carroll',
    '51036': 'Charles City',
    '51037': 'Charlotte',
    '51041': 'Chesterfield',
    '51043': 'Clarke',
    '51045': 'Craig',
    '51047': 'Culpeper',
    '51049': 'Cumberland',
    '51051': 'Dickenson',
    '51053': 'Dinwiddie',
    '51057': 'Essex',
    '51059': 'Fairfax',
    '51061': 'Fauquier',
    '51063': 'Floyd',
    '51065': 'Fluvanna',
    '51067': 'Franklin',
    '51069': 'Frederick',
    '51071': 'Giles',
    '51073': 'Gloucester',
    '51075': 'Goochland',
    '51077': 'Grayson',
    '51079': 'Greene',
    '51081': 'Greensville',
    '51083': 'Halifax',
    '51085': 'Hanover',
    '51087': 'Henrico',
    '51089': 'Henry',
    '51091': 'Highland',
    '51093': 'Isle of Wight',
    '51095': 'James City',
    '51097': 'King and Queen',
    '51099': 'King George',
    '51101': 'King William',
    '51103': 'Lancaster',
    '51105': 'Lee',
    '51107': 'Loudoun',
    '51109': 'Louisa',
    '51111': 'Lunenburg',
    '51113': 'Madison',
    '51115': 'Mathews',
    '51117': 'Mecklenburg',
    '51119': 'Middlesex',
    '51121': 'Montgomery',
    '51125': 'Nelson',
    '51127': 'New Kent',
    '51131': 'Northampton',
    '51133': 'Northumberland',
    '51135': 'Nottoway',
    '51137': 'Orange',
    '51139': 'Page',
    '51141': 'Patrick',
    '51143': 'Pittsylvania',
    '51145': 'Powhatan',
    '51147': 'Prince Edward',
    '51149': 'Prince George',
    '51153': 'Prince William',
    '51155': 'Pulaski',
    '51157': 'Rappahannock',
    '51159': 'Richmond',
    '51161': 'Roanoke',
    '51163': 'Rockbridge',
    '51165': 'Rockingham',
    '51167': 'Russell',
    '51169': 'Scott',
    '51171': 'Shenandoah',
    '51173': 'Smyth',
    '51175': 'Southampton',
    '51177': 'Spotsylvania',
    '51179': 'Stafford',
    '51181': 'Surry',
    '51183': 'Sussex',
    '51185': 'Tazewell',
    '51187': 'Warren',
    '51191': 'Washington',
    '51193': 'Westmoreland',
    '51195': 'Wise',
    '51197': 'Wythe',
    '51199': 'York',
    '51510': 'City of Alexandria',
    '51515': 'City of Bedford',
    '51520': 'City of Bristol',
    '51530': 'City of Buena Vista',
    '51540': 'City of Charlottesville',
    '51550': 'City of Chesapeake',
    '51560': 'City of Clifton Forge',
    '51570': 'City of Colonial Heights',
    '51580': 'City of Covington',
    '51590': 'City of Danville',
    '51595': 'City of Emporia',
    '51600': 'City of Fairfax',
    '51610': 'City of Falls Church',
    '51620': 'City of Franklin',
    '51630': 'City of Fredericksburg',
    '51640': 'City of Galax',
    '51650': 'City of Hampton',
    '51660': 'City of Harrisonburg',
    '51670': 'City of Hopewell',
    '51678': 'City of Lexington',
    '51680': 'City of Lynchburg',
    '51683': 'City of Manassas',
    '51685': 'City of Manassas Park',
    '51690': 'City of Martinsville',
    '51700': 'City of Newport News',
    '51710': 'City of Norfolk',
    '51720': 'City of Norton',
    '51730': 'City of Petersburg',
    '51735': 'City of Poquoson',
    '51740': 'City of Portsmouth',
    '51750': 'City of Radford',
    '51760': 'City of Richmond',
    '51770': 'City of Roanoke',
    '51775': 'City of Salem',
    '51790': 'City of Staunton',
    '51800': 'City of Suffolk',
    '51810': 'City of Virginia Beach',
    '51820': 'City of Waynesboro',
    '51830': 'City of Williamsburg',
    '51840': 'City of Winchester',
    '53000': 'All of Washington',
    '53001': 'Adams',
    '53003': 'Asotin',
    '53005': 'Benton',
    '53007': 'Chelan',
    '53009': 'Clallam',
    '53011': 'Clark',
    '53013': 'Columbia',
    '53015': 'Cowlitz',
    '53017': 'Douglas',
    '53019': 'Ferry',
    '53021': 'Franklin',
    '53023': 'Garfield',
    '53025': 'Grant',
    '53027': 'Grays Harbor',
    '53029': 'Island',
    '53031': 'Jefferson',
    '53033': 'King',
    '53035': 'Kitsap',
    '53037': 'Kittitas',
    '53039': 'Klickitat',
    '53041': 'Lewis',
    '53043': 'Lincoln',
    '53045': 'Mason',
    '53047': 'Okanogan',
    '53049': 'Pacific',
    '53051': 'Pend Oreille',
    '53053': 'Pierce',
    '53055': 'San Juan',
    '53057': 'Skagit',
    '53059': 'Skamania',
    '53061': 'Snohomish',
    '53063': 'Spokane',
    '53065': 'Stevens',
    '53067': 'Thurston',
    '53069': 'Wahkiakum',
    '53071': 'Walla Walla',
    '53073': 'Whatcom',
    '53075': 'Whitman',
    '53077': 'Yakima',
    '54000': 'All of West Virginia',
    '54001': 'Barbour',
    '54003': 'Berkeley',
    '54005': 'Boone',
    '54007': 'Braxton',
    '54009': 'Brooke',
    '54011': 'Cabell',
    '54013': 'Calhoun',
    '54015': 'Clay',
    '54017': 'Doddridge',
    '54019': 'Fayette',
    '54021': 'Gilmer',
    '54023': 'Grant',
    '54025': 'Greenbrier',
    '54027': 'Hampshire',
    '54029': 'Hancock',
    '54031': 'Hardy',
    '54033': 'Harrison',
    '54035': 'Jackson',
    '54037': 'Jefferson',
    '54039': 'Kanawha',
    '54041': 'Lewis',
    '54043': 'Lincoln',
    '54045': 'Logan',
    '54047': 'Mcdowell',
    '54049': 'Marion',
    '54051': 'Marshall',
    '54053': 'Mason',
    '54055': 'Mercer',
    '54057': 'Mineral',
    '54059': 'Mingo',
    '54061': 'Monongalia',
    '54063': 'Monroe',
    '54065': 'Morgan',
    '54067': 'Nicholas',
    '54069': 'Ohio',
    '54071': 'Pendleton',
    '54073': 'Pleasants',
    '54075': 'Pocahontas',
    '54077': 'Preston',
    '54079': 'Putnam',
    '54081': 'Raleigh',
    '54083': 'Randolph',
    '54085': 'Ritchie',
    '54087': 'Roane',
    '54089': 'Summers',
    '54091': 'Taylor',
    '54093': 'Tucker',
    '54095': 'Tyler',
    '54097': 'Upshur',
    '54099': 'Wayne',
    '54101': 'Webster',
    '54103': 'Wetzel',
    '54105': 'Wirt',
    '54107': 'Wood',
    '54109': 'Wyoming',
    '55000': 'All of Wisconsin',
    '55001': 'Adams',
    '55003': 'Ashland',
    '55005': 'Barron',
    '55007': 'Bayfield',
    '55009': 'Brown',
    '55011': 'Buffalo',
    '55013': 'Burnett',
    '55015': 'Calumet',
    '55017': 'Chippewa',
    '55019': 'Clark',
    '55021': 'Columbia',
    '55023': 'Crawford',
    '55025': 'Dane',
    '55027': 'Dodge',
    '55029': 'Door',
    '55031': 'Douglas',
    '55033': 'Dunn',
    '55035': 'Eau Claire',
    '55037': 'Florence',
    '55039': 'Fond du Lac',
    '55041': 'Forest',
    '55043': 'Grant',
    '55045': 'Green',
    '55047': 'Green Lake',
    '55049': 'Iowa',
    '55051': 'Iron',
    '55053': 'Jackson',
    '55055': 'Jefferson',
    '55057': 'Juneau',
    '55059': 'Kenosha',
    '55061': 'Kewaunee',
    '55063': 'La Crosse',
    '55065': 'Lafayette',
    '55067': 'Langlade',
    '55069': 'Lincoln',
    '55071': 'Manitowoc',
    '55073': 'Marathon',
    '55075': 'Marinette',
    '55077': 'Marquette',
    '55078': 'Menominee',
    '55079': 'Milwaukee',
    '55081': 'Monroe',
    '55083': 'Oconto',
    '55085': 'Oneida',
    '55087': 'Outagamie',
    '55089': 'Ozaukee',
    '55091': 'Pepin',
    '55093': 'Pierce',
    '55095': 'Polk',
    '55097': 'Portage',
    '55099': 'Price',
    '55101': 'Racine',
    '55103': 'Richland',
    '55105': 'Rock',
    '55107': 'Rusk',
    '55109': 'Saint Croix',
    '55111': 'Sauk',
    '55113': 'Sawyer',
    '55115': 'Shawano',
    '55117': 'Sheboygan',
    '55119': 'Taylor',
    '55121': 'Trempealeau',
    '55123': 'Vernon',
    '55125': 'Vilas',
    '55127': 'Walworth',
    '55129': 'Washburn',
    '55131': 'Washington',
    '55133': 'Waukesha',
    '55135': 'Waupaca',
    '55137': 'Waushara',
    '55139': 'Winnebago',
    '55141': 'Wood',
    '56000': 'All of Wyoming',
    '56001': 'Albany',
    '56003': 'Big Horn',
    '56005': 'Campbell',
    '56007': 'Carbon',
    '56009': 'Converse',
    '56011': 'Crook',
    '56013': 'Fremont',
    '56015': 'Goshen',
    '56017': 'Hot Springs',
    '56019': 'Johnson',
    '56021': 'Laramie',
    '56023': 'Lincoln',
    '56025': 'Natrona',
    '56027': 'Niobrara',
    '56029': 'Park',
    '56031': 'Platte',
    '56033': 'Sheridan',
    '56035': 'Sublette',
    '56037': 'Sweetwater',
    '56039': 'Teton',
    '56041': 'Uinta',
    '56043': 'Washakie',
    '56045': 'Weston',
    '60000': 'All of American Samoa',
    '60010': 'Eastern District',
    '60020': 'Manu\'A District',
    '60030': 'Rose Island',
    '60040': 'Swains Island',
    '60050': 'Western District',
    '66010': 'Guam',
    '69085': 'Northern Islands',
    '69000': 'All of Northern Mariana Islands',
    '69100': 'Rota',
    '69110': 'Saipan',
    '69120': 'Tinian',
    '72000': 'All of Puerto Rico',
    '72001': 'Adjuntas',
    '72003': 'Aguada',
    '72005': 'Aguadilla',
    '72007': 'Aguas Buenas',
    '72009': 'Aibonito',
    '72011': 'Anasco',
    '72013': 'Arecibo',
    '72015': 'Arroyo',
    '72017': 'Barceloneta',
    '72019': 'Barranquitas',
    '72021': 'Bayamo\'N',
    '72023': 'Cabo Rojo',
    '72025': 'Caguas',
    '72027': 'Camuy',
    '72029': 'Canovanas',
    '72031': 'Carolina',
    '72033': 'Catano',
    '72035': 'Cayey',
    '72037': 'Ceiba',
    '72039': 'Ciales',
    '72041': 'Cidra',
    '72043': 'Coamo',
    '72045': 'Comerio',
    '72047': 'Corozal',
    '72049': 'Culebra',
    '72051': 'Dorado',
    '72053': 'Fajardo',
    '72054': 'Florida',
    '72055': 'Guanica',
    '72057': 'Guayama',
    '72059': 'Guayanilla',
    '72061': 'Guaynabo',
    '72063': 'Gurabo',
    '72065': 'Hatillo',
    '72067': 'Hormigueros',
    '72069': 'Humacao',
    '72071': 'Lsabela',
    '72073': 'Jayuya',
    '72075': 'Juana Diaz',
    '72077': 'Juncos',
    '72079': 'Lajas',
    '72081': 'Lares',
    '72083': 'Las Marias',
    '72085': 'Las Piedras',
    '72087': 'Loiza',
    '72089': 'Luquillo',
    '72091': 'Manati',
    '72093': 'Maricao',
    '72095': 'Maunabo',
    '72097': 'Mayaguez',
    '72099': 'Moca',
    '72101': 'Morovis',
    '72103': 'Naguabo',
    '72105': 'Naranjito',
    '72107': 'Orocovis',
    '72109': 'Patillas',
    '72111': 'Penuelas',
    '72113': 'Ponce',
    '72115': 'Quebradillas',
    '72117': 'Rincon',
    '72119': 'Rio Grande',
    '72121': 'Sabana Grande',
    '72123': 'Salinas',
    '72125': 'San German',
    '72127': 'San Juan',
    '72129': 'San Lorenzo',
    '72131': 'San Sebastian',
    '72133': 'Santa Isabel',
    '72135': 'Toa Alta',
    '72137': 'Toa Baja',
    '72139': 'Trujillo Alto',
    '72141': 'Utuado',
    '72143': 'Vega Alta',
    '72145': 'Vega Baja',
    '72147': 'Vieques',
    '72149': 'Villalba',
    '72151': 'Yabucoa',
    '72153': 'Yauco',
    '69000': 'All of Virgin Islands',
    '78010': 'Saint Croix',
    '78020': 'Saint John',
    '78030': 'Saint Thomas',
    '64000': 'All of Federated States of Micronesia',
    '64002': 'Chuuk*',
    '64005': 'Kosrae',
    '64040': 'Pohnpeit*',
    '64060': 'Yap',
    '68000': 'All of Marshall Islands',
    '68007': 'Ailinginae',
    '68010': 'Ailinglaplap',
    '68030': 'Ailuk',
    '68040': 'Arno',
    '68050': 'Aur',
    '68060': 'Bikar',
    '68070': 'Bikini',
    '68073': 'Bokak',
    '68080': 'Ebon',
    '68090': 'Enewetak',
    '68100': 'Erikub',
    '68110': 'Jabat',
    '68120': 'Jaluit',
    '68130': 'Jemo',
    '68140': 'Kili',
    '68150': 'Kwajalein',
    '68160': 'Lae',
    '68170': 'Lib',
    '68180': 'Likiep',
    '68190': 'Majuro',
    '68300': 'Maloelap',
    '68310': 'Mejit',
    '68320': 'Mili',
    '68330': 'Namorik',
    '68340': 'Namu',
    '68350': 'Rongelap',
    '68360': 'Rongrik',
    '68385': 'Toke',
    '68390': 'Ujae',
    '68400': 'Ujelang',
    '68410': 'Utrik',
    '68420': 'Wotho',
    '68430': 'Wotle',
    '70000': 'All of Palau',
    '70002': 'Aimeliik',
    '70004': 'Airai',
    '70010': 'Angaur',
    '70050': 'Hatoboheit*',
    '70100': 'Kayangel',
    '70150': 'Koror',
    '70212': 'Melekeok*',
    '70214': 'Ngaraard',
    '70218': 'Ngarchelong',
    '70222': 'Ngardmau',
    '70224': 'Ngatpang',
    '70226': 'Ngchesar',
    '70227': 'Ngernmlengui*',
    '70228': 'Ngiwal',
    '70350': 'Peleliu',
    '70370': 'Sonsorol',
    '74000': 'All of U.S. Minor Outlying Islands',
    '74050': 'Baker Island',
    '74100': 'Howland Island',
    '74150': 'Jarvis Island',
    '74200': 'Johnston Island',
    '74250': 'Kingman Reef',
    '74300': 'Midway Islands',
    '74350': 'Navassa Island',
    '74400': 'Palmyra Atoll',
    '74450': 'Wake Island',
    # Marine Locations
    '75610': 'Lake Okeechobee',
    '77657': 'Coastal waters from East Cape Sable to Chokoloskee FL out 20 NM',
    '77656': 'Coastal waters from Chokoloskee to Bonita Beach FL out 20 NM',
    '77853': 'Coastal waters from Englewood to Tarpon Springs FL out 20 NM',
    '77830': 'Tampa Bay waters',
    '77250': 'Coastal waters from Baffin Bay to Port Aransas out 20 NM',
    '77255': 'Coastal waters from Port Aransas to Matagorda Ship Channel out 20 NM',
    '77155': 'Coastal waters from Baffin Bay to Port Mansfield TX out 20 NM',
    '77135': 'Laguna Madre From 5 nm North of Port Mansfield To Baffin Bay TX',
    '77150': 'Coastal waters from Port Mansfield TX to the Rio Grande River out 20 NM',
    '77132': 'Laguna Madre From The Arroyo Coloardo To 5 NM North of Port Mansfield TX',
    '77130': 'Laguna Madre From the Port of Brownsville to the Arroyo Colorado',
    '75671': 'Waters from Deerfield Beach to Ocean Reef FL from 20 to 60 NM excluding the territorial waters of Bahamas',
    '77676': 'Waters from Chokoloskee to Bonita Beach FL from 20 to 60 NM',
    '77876': 'Waters from Bonita Beach to Englewood FL out 20 to 60 NM',
    '77873': 'Waters from Englewood to Tarpon Springs FL out 20 to 60 NM',
    '77170': 'Waters from Port Mansfield TX to the Rio Grande River from 20 to 60 NM',
    '77175': 'Waters from Baffin Bay to Port Mansfield TX from 20 to 60 NM',
    '77270': 'Waters from Baffin Bay to Port Aransas from 20 to 60 NM',
    '77275': 'Waters from Port Aransas to Matagorda Ship Channel from 20 to 60 NM',
    '77370': 'Waters from Freeport to Matagorda Ship Channel TX from 20 to 60 NM',
    '75712': 'Coastal Waters of Northern Puerto Rico out 10 NM',
    '75725': 'Coastal Waters of Southern USVI, Vieques, and Eastern Puerto Rico out 10 NM',
    '75745': 'Coastal Waters OF Southwestern Puerto Rico out 10 NM',
    '75735': 'Coastal Waters of Southern Puerto Rico out 10 NM',
    '75742': 'Coastal Waters OF Northwestern Puerto Rico out 10 NM',
    '75741': 'Mona Passage Southward to 17N',
    '75732': 'Caribbean Waters of Puerto Rico from 10 NM to 17N',
    '75651': 'Coastal waters from Deerfield Beach to Ocean Reef FL out 20 NM',
    '59124': 'Big Island Southeast Waters',
    '59123': 'Big Island Leeward Waters',
    '59122': 'Big Island Windward Waters',
    '59119': 'Maalaea Bay',
    '59118': 'Maui County Leeward Waters',
    '59120': 'Pailolo Channel',
    '59116': 'Kaiwi Channel',
    '59115': 'Oahu Leeward Waters',
    '59113': 'Kauai Channel',
    '59114': 'Oahu Windward Waters',
    '59112': 'Kauai Leeward Waters',
    '59111': 'Kauai Windward Waters',
    '59110': 'Kauai Northwest Waters',
    '75710': 'Atlantic Waters of Puerto Rico AND USVI from 10 NM to 19.5N',
    '75722': 'Anegada Passage Southward to 17N',
    '75715': 'Coastal Waters of Northern USVI and Culebra out 10 NM',
    '61150': 'Coastal waters of Tututila and Aunuu',
    '61151': 'Coastal waters of Manua',
    '75650': 'Coastal waters from Jupiter Inlet to Deerfield Beach FL out 20 NM',
    '75630': 'Biscayne Bay',
    '77052': 'Straits of Florida from Ocean Reef to Craig Key out 20 NM',
    '77031': 'Florida Bay including Barnes Sound, Blackwater Sound, and Buttonwood Sound',
    '77053': 'Straits of Florida from Craig Key to west end of Seven Mile Bridge out 20 NM',
    '77054': 'Straits of Florida from west end of Seven Mile Bridge to south of Halfmoon Shoal out 20 NM',
    '77075': 'Straits of Florida from Halfmoon Shoal to 20 NM west of Dry Tortugas 20 to 60 NM out',
    '77073': 'Straits of Florida from Craig Key to west end of Seven Mile Bridge 20 to 60 NM out',
    '77072': 'Straits of Florida from Ocean Reef to Craig Key 20 to 60 NM out',
    '77033': 'Gulf waters from East Cape Sable to Chokoloskee 20 to 60 NM out and beyond 5 fathoms',
    '77042': 'Hawk Channel from Ocean Reef to Craig Key out to the reef',
    '77044': 'Hawk Channel from west end of Seven Mile Bridge to Halfmoon Shoal out to the reef',
    '77074': 'Straits of Florida from west end of Seven Mile Bridge to south of Halfmoon Shoal 20 to 60 NM out',
    '77034': 'Gulf of Mexico including Dry Tortugas and Rebecca Shoal Channel',
    '77055': 'Straits of Florida from Halfmoon Shoal to 20 NM west of Dry Tortugas out 20 NM',
    '77043': 'Hawk Channel from Craig Key to west end of Seven Mile Bridge out to the reef',
    '77035': 'Gulf of Mexico from West End of Seven Mile Bridge to Halfmoon Shoal out to 5 Fathoms',
    '77230': 'Bays and Waterways from Baffin Bay to Port Aransas',
    '65151': 'Guam Coastal Waters',
    '65152': 'Rota Coastal Waters',
    '65153': 'Tinian Coastal Waters',
    '65161': 'Koror Palau Coastal Waters',
    '65171': 'Yap Coastal Waters',
    '65172': 'Chuuk Coastal Waters',
    '65173': 'Pohnpei Coastal Waters',
    '65174': 'Kosrae Coastal Waters',
    '65181': 'Majuro Coastal Waters',
    '65191': 'Waters out to 40 Nautical Miles',
    '73530': 'Chesapeake Bay north of Pooles Island MD',
    '73430': 'Delaware Bay waters north of East Point NJ to Slaughter Beach DE',
    '73431': 'Delaware Bay waters south of East Point NJ to Slaughter Beach DE',
    '73454': 'Coastal waters from Cape May NJ to Cape Henlopen DE out 20 nm',
    '73455': 'Coastal waters from Cape Henlopen to Fenwick Island DE out 20 nm',
    '73650': 'Coastal waters from Fenwick Island DE to Chincoteague VA out 20 nm',
    '73652': 'Coastal waters from Chincoteague to Parramore Island VA out 20 nm',
    '73654': 'Coastal waters from Parramore Island to Cape Charles Light VA out 20 nm',
    '73538': 'Patapsco River including Baltimore Harbor',
    '73531': 'Chesapeake Bay from Pooles Island to Sandy Point MD',
    '73539': 'Chester River to Queenstown MD',
    '73540': 'Eastern Bay',
    '73533': 'Chesapeake Bay from North Beach to Drum Point MD',
    '73534': 'Chesapeake Bay from Drum Point MD to Smith Point VA',
    '73535': 'Tidal Potomac from Key Bridge to Indian Head MD',
    '73536': 'Tidal Potomac from Indian Head to Cobb Island MD',
    '73630': 'Chesapeake Bay from Smith Point to Windmill Point VA',
    '73537': 'Tidal Potomac from Cobb Island MD to Smith Point VA',
    '73631': 'Chesapeake Bay from Windmill Point to New Point Comfort VA',
    '73632': 'Chesapeake Bay from New Point Comfort to Little Creek VA',
    '73532': 'Chesapeake Bay from Sandy Point to North Beach MD',
    '73453': 'Coastal waters from Great Egg Inlet to Cape May NJ out 20 nm',
    '73452': 'Coastal waters from Little Egg Inlet to Great Egg Inlet NJ out 20 nm',
    '73450': 'Coastal waters from Sandy Hook to Manasquan Inlet NJ out 20 nm',
    '73338': 'New York Harbor',
    '73353': 'Fire Island Inlet NY to Moriches Inlet NY out 20 nm',
    '73350': 'Moriches Inlet NY to Montauk Point NY out 20 nm',
    '73256': 'Coastal Waters from Montauk NY to Marthas Vineyard extending out to 20 nm South of Block Island',
    '73340': 'Peconic and Gardiners Bays',
    '73335': 'Long Island Sound West of New Haven CT/Port Jefferson NY',
    '73235': 'Rhode Island Sound',
    '73232': 'Nantucket Sound',
    '73255': 'Coastal Waters extending out to 25 nm South of Marthas Vineyard and Nantucket',
    '73254': 'Coastal waters from Provincetown MA to Chatham MA to Nantucket MA out 20 nm',
    '73231': 'Cape Cod Bay',
    '73230': 'Boston Harbor',
    '73251': 'Massachusetts Bay and Ipswich Bay',
    '73250': 'Coastal waters east of Ipswich Bay and the Stellwagen Bank National Marine Sanctuary',
    '73153': 'Casco Bay',
    '73152': 'Coastal Waters from Port Clyde, ME to Cape Elizabeth, ME out 25 NM',
    '73150': 'Coastal Waters from Stonington, ME to Port Clyde, ME out 25 NM',
    '73051': 'Coastal Waters from Schoodic Point, ME to Stonington, ME out 25 NM',
    '73050': 'Coastal Waters from Eastport, ME to Schoodic Point, ME out 25 NM',
    '73151': 'Penobscot Bay',
    '73633': 'Currituck Sound',
    '75250': 'Coastal waters from Surf City to Cape Fear NC out 20 nm',
    '75254': 'Coastal waters from Little River Inlet to Murrells Inlet SC out 20 nm',
    '75350': 'Coastal waters from South Santee River to Edisto Beach SC out 20 nm',
    '75330': 'Charleston Harbor',
    '75452': 'Coastal waters from Fernandina Beach to St. Augustine FL out 20 NM',
    '75454': 'Coastal waters from St. Augustine to Flagler Beach FL out 20 NM',
    '77765': 'Coastal waters from  Suwannee River to Keaton Beach out 20 NM',
    '77730': 'Apalachee Bay or Coastal Waters From Keaton Beach to Ochlockonee River Fl out to 20 Nm',
    '77755': 'Coastal Waters From  Ochlockonee River to Apalachicola Fl out to 20 Nm',
    '77750': 'Coastal waters from Apalachicola to Destin FL out 20 NM',
    '77530': 'Lake Pontchartrain and Lake Maurepas',
    '77435': 'Vermilion Bay',
    '77452': 'Coastal waters from Intracoastal City to Cameron LA out 20 NM',
    '77432': 'Calcasieu Lake',
    '77450': 'Coastal waters from Cameron LA to High Island TX out 20 NM',
    '77430': 'Sabine Lake',
    '57750': 'Coastal Waters from San Mateo Point to the Mexican Border and out to 30 nm',
    '57565': 'Coastal Waters from Point Pinos to Point Piedras Blancas California out to 10 nm',
    '57576': 'Waters from Point Pinos to Point Piedras Blancas 10-60 NM',
    '57560': 'Coastal Waters from Pigeon Point to Point Pinos California out to 10 nm',
    '57535': 'Monterey Bay',
    '57545': 'Coastal Waters from Point Reyes to Pigeon Point California out to 10 nm',
    '57530': 'San Pablo Bay, Suisun Bay, the West Delta and  the San Francisco Bay north of the Bay Bridge',
    '57540': 'Coastal Waters from Point Arena to Point Reyes California out to 10 nm',
    '57570': 'Waters from Point Arena to Point Reyes 10-60 NM',
    '57455': 'Coastal waters from Cape Mendocino to Pt. Arena CA out 10 nm',
    '57475': 'Waters from Cape Mendocino to Pt. Arena CA from 10 to 60 nm',
    '57450': 'Coastal waters from Pt. St. George to Cape Mendocino CA out 10 nm',
    '57410': 'Humboldt Bay Bar',
    '57470': 'Waters from Pt. St. George to Cape Mendocino CA from 10 to 60 nm',
    '57376': 'Waters from Cape Blanco OR to Pt. St. George CA from 10 to 60 nm',
    '57350': 'Coastal waters from Florence to Cape Blanco OR out 10 nm',
    '57370': 'Waters from Florence to Cape Blanco OR from 10 to 60 nm',
    '57255': 'Coastal waters from Cascade Head to Florence OR out 10 nm',
    '57275': 'Waters from Cascade Head to Florence OR from 10 to 60 nm',
    '57210': 'Columbia River Bar',
    '57250': 'Coastal waters from Cape Shoalwater WA to Cascade Head OR out 10 nm',
    '57270': 'Waters from Cape Shoalwater WA to Cascade Head OR from 10 to 60 nm',
    '57156': 'Coastal Waters From Point Grenville To Cape Shoalwater Out 10 Nm',
    '57176': 'Coastal Waters From Point Grenville To Cape Shoalwater 10 To 60 Nm',
    '57173': 'Waters From James Island To Point Grenville 10 To 60 Nm',
    '57150': 'Coastal Waters From Cape Flattery To James Island Out 10 Nm',
    '57170': 'Coastal Waters From Cape Flattery To James Island 10 To 60 Nm',
    '57130': 'West Entrance U.S. Waters Strait of Juan De Fuca',
    '57131': 'Central U.S. Waters Strait of Juan De Fuca',
    '57132': 'East Entrance U.S. Waters Strait of Juan De Fuca',
    '57134': 'Admiralty Inlet',
    '91144': 'Two Harbors to Duluth MN',
    '91145': 'Duluth MN to Port Wing WI',
    '91143': 'Silver Bay Harbor to Two Harbors MN',
    '91142': 'Taconite Harbor to Silver Bay Harbor MN',
    '91141': 'Grand Marais to Taconite Harbor MN',
    '91140': 'Grand Portage to Grand Marais MN',
    '91146': 'Port Wing to Sand Island WI',
    '91147': 'Sand Island to Bayfield WI',
    '91121': 'Chequamegon Bay-Bayfield to Oak Point WI',
    '91148': 'Oak Point to Saxon Harbor WI',
    '91240': 'Saxon Harbor WI to Black River MI',
    '91241': 'Black River To Ontonagon MI',
    '91242': 'Ontonagon to Upper Entrance of Portage Canal MI',
    '91243': 'Upper Entrance of Portage Canal to Eagle River MI',
    '91244': 'Eagle River to Manitou Island MI',
    '91245': 'Manitou Island to Point Isabelle MI',
    '91246': 'Point Isabelle to Lower Entrance of Portage Canal MI',
    '91247': 'Portage Lake to Huron Island MI to Lower Entrance of Portage Canal To Huron Islands MI Including Keweenaw and Huron Bays',
    '91248': 'Huron Islands to Marquette MI',
    '91249': 'Marquette to Munising MI',
    '91250': 'Munising to Grand Marais MI',
    '91266': 'Lake Superior East of a line from Manitou Island to Marquette MI and West of a line from Grand Marais MI to the US/Canadian Border Beyond 5 NM from shore',
    '91251': 'Grand Marais to Whitefish Point MI',
    '91267': 'Lake Superior from Grand Marais MI to Whitefish Point MI 5 NM off shore to the US/Canadian border',
    '91321': 'Whitefish Bay (U.S. Portion)/Whitefish Point to Point Iroquois MI',
    '91322': 'St. Marys River Point Iroquois to E. Potagannissing Bay',
    '92743': 'Calumet Harbor IL to Gary IN',
    '92742': 'Northerly Island to Calumet Harbor IL',
    '92741': 'Wilmette Harbor to Northerly Island IL',
    '92740': 'Winthrop Harbor to Wilmette Harbor IL',
    '92745': 'Burns Harbor to Michigan City IN',
    '92043': 'New Buffalo MI to St Joseph MI',
    '92779': 'Lake Michigan from Wilmette Harbor to Michigan City in 5 NM offshore to Mid Lake',
    '92080': 'Lake Michigan Michigan City IN to St. Joseph MI 5 NM offshore to mid-line of lake.',
    '92777': 'Lake Michigan from Winthrop Harbor to Wilmette Harbor IL 5 NM offshore to Mid Lake',
    '92878': 'Lake Michigan from St Joseph to South Haven MI 5 NM offshore to Mid Lake',
    '92646': 'Wind Point WI to Winthrop Harbor IL',
    '92645': 'North Point Light to Wind Point WI',
    '92644': 'Port Washington to North Point Light WI',
    '92643': 'Sheboygan to Port Washington WI',
    '92543': 'Two Rivers to Sheboygan WI',
    '92845': 'South Haven to Holland MI',
    '92675': 'Lake Michigan from Wind Point WI to Winthrop Harbor IL 5 NM offshore to Mid Lake',
    '92876': 'Lake Michigan from South Haven to Holland MI 5 NM offshore to Mid lake',
    '92673': 'Lake Michigan from North Point Light to Wind Point WI 5 NM offshore to Mid Lake',
    '92671': 'Lake Michigan from Port Washington to North Point Light WI 5 NM offshore to Mid Lake',
    '92669': 'Lake Michigan from Sheboygan to Port Washington WI 5 NM offshore to Mid Lake',
    '92870': 'Lake Michigan from Whitehall to Pentwater MI 5 NM offshore to Mid Lake',
    '92567': 'Lake Michigan from Two Rivers to Sheboygan WI 5 NM offshore to Mid Lake',
    '92868': 'Lake Michigan from Pentwater to Manistee MI 5 NM offshore to Mid Lake',
    '92542': 'Sturgeon Bay to Two Rivers WI',
    '92565': 'Lake Michigan from Sturgeon Bay to Two Rivers WI 5 NM offshore to Mid Lake',
    '92366': 'Lake Michigan from Point Betsie to Manistee MI 5 NM offshore to Mid Lake',
    '92346': 'Manistee to Point Betsie MI',
    '92744': 'Gary to Burns Harbor IN',
    '92046': 'Michigan City IN to New Buffalo MI',
    '92844': 'St Joseph to South Haven MI',
    '92522': 'Green Bay south of line from Oconto WI to Little Sturgeon Bay WI',
    '92521': 'Green Bay south of line from Cedar River to Rock Island Passage and north of a line from Oconto WI to Little Sturgeon Bay WI',
    '92221': 'Green Bay North of line from Cedar River MI to Rock Island Passage',
    '92541': 'Rock Island Passage to Sturgeon Bay WI',
    '92250': '5NM East of a line from Fairport MI to Rock Island Passage',
    '92563': 'Lake Michigan from Rock Island Passage to Sturgeon Bay WI 5 NM offshore to mid lake',
    '92248': 'Seul Choix Point to Point Detour MI',
    '92364': 'Lake Michigan from Charlevoix to Point Betsie MI 5 NM Offshore to mid lake',
    '92261': 'Lake Michigan from Seul Choix Point to Rock Island Passage 5 NM offshore to Mid Lake',
    '92362': 'Lake Michigan South of a line from Seul Choix Point to the Mackinac Bridge and North of a line from Charlevoix MI to South Fox Island 5 NM offshore',
    '92344': 'Sleeping Bear Point to Grand Traverse Light MI',
    '92342': 'Norwood MI to 5 NM West of Mackinac Bridge including Little Traverse Bay',
    '93361': 'Lake Huron from 5 NM east of Mackinac Bridge to Presque Isle Lt  to the US/Canadian border beyond 5 NM from shore',
    '93362': 'Lake Huron from Presque Isle Lt. to Sturgeon Point  MI 5 NM off shore to US/Canadian border',
    '93346': 'St Ignace to False Detour Channel',
    '93363': 'Lake Huron from Sturgeon Point to Alabaster MI 5 NM off shore to US/Canadian border',
    '93349': 'Sturgeon Pt to Alabaster MI',
    '93347': '5NM East of Mackinac Bridge to Presque Isle Light MI including Bois Blanc Island',
    '93421': 'Outer Saginaw Bay SW of Alabaster to Port Austin MI to Inner Saginaw Bay',
    '93441': 'Port Austin to Harbor Beach MI',
    '93462': 'Lake Huron from Port Austin to Harbor Beach 5 NM Off Shore to the US/Canadian border',
    '93442': 'Harbor Beach to Port Sanilac MI',
    '93463': 'Lake Huron from Harbor Beach to Port Sanilac 5 NM Off Shore to US/Canadian border',
    '93464': 'Lake Huron from Port Sanilac to Port Huron 5 NM Off Shore to US/Canadian border',
    '94460': 'Lake St. Clair Open Lake (U.S. Portion)',
    '94423': 'Detroit River',
    '93443': 'Port Sanilac to Port Huron MI',
    '96444': 'Michigan Waters of Lake Erie from Detroit River to North Cape MI',
    '96142': 'Maumee Bay to Reno Beach OH',
    '96162': 'Detroit River Lt. to Maumee Bay OH to Reno Beach OH beyond 5 NM offshoreline to US-Canadian border',
    '96143': 'Reno Beach to The Islands OH',
    '96144': 'The Islands to Vermilion OH',
    '96163': 'Reno Beach to The Islands OH beyond 5 NM off shoreline to US-Canadian border',
    '96145': 'Vermilion to Avon Point OH',
    '96146': 'Avon Point to Willowick OH',
    '96164': 'The Islands to Vermilion OH beyond 5 nm off shoreline to US-Canadian border',
    '96165': 'Vermilion to Avon Point OH beyond 5 nm off shoreline to US-Canadian border',
    '96166': 'Avon Point to Willowick OH beyond 5 nm off shoreline to US-Canadian border',
    '96147': 'Willowick to Geneva-on-the Lake OH',
    '96167': 'Willowick to Geneva-on-the-Lake OH beyond 5 NM off shoreline to US-Canadian border',
    '96148': 'Geneva-on-the-Lake to Conneaut OH',
    '96168': 'Geneva-on-the-Lake to Conneaut OH beyond 5 nm off shoreline to US-Canadian border',
    '96149': 'Conneaut OH to Ripley NY',
    '96169': 'Conneaut OH to Ripley NY beyond 5 nm off shoreline to US-Canadian border',
    '96061': 'Ripley to Buffalo NY extending from 5 NM off shoreline to US-Canadian border',
    '97042': 'Niagara River to Hamlin Beach NY',
    '97062': 'Niagara River to Hamlin Beach NY beyond 5 NM off shoreline to US-Canadian border',
    '97043': 'Hamlin Beach to Sodus Bay NY',
    '97063': 'Hamlin Beach to Sodus Bay NY beyond 5 NM off shoreline to US-Canadian border',
    '97044': 'Sodus Bay to Mexico Bay NY',
    '97064': 'Sodus Bay to Mexico Bay NY beyond 5 NM off shoreline to US-Canadian border',
    '97045': 'Mexico Bay NY to the St. Lawrence River',
    '98022': 'St. Lawrence River above Ogdensburg NY',
    '98024': 'St. Lawrence River from Ogdensburg to St. Regis NY',
    '97065': 'Mexico Bay NY to the St. Lawrence River beyond 5 NM off shoreline to US-Canadian border',
    '91162': 'Lake Superior west of a line from Saxon Harbor WI to Grand Portage MN beyond 5NM',
    '91265': 'Lake Superior West of Line from Manitou Island to Marquette MI Beyond 5 NM from shore',
    '93422': 'Inner Saginaw Bay SW of Point Au Gres to Bay Port MI',
    '75450': 'Coastal waters from Altamaha Sound to Fernandina Beach FL out 20 NM',
    '73052': 'Intra Coastal Waters from Schoodic Point, ME to Stonington, ME',
    '73658': 'Coastal waters from NC VA border to Currituck Beach Light NC out 20 nm',
    '77455': 'Coastal waters from Lower Atchafalaya River to Intracoastal City LA out 20 NM',
    '73170': 'Waters from Stonington ME to Merrimack River MA from 25 to 40 nm',
    '73271': 'Ocean Waters from Provincetown to Nantucket from 20 to 35 NM offshore',
    '73070': 'Waters from Eastport ME to Stonington (Deer Isle) ME from 25 to 40 nm',
    '73273': 'Ocean Waters from Montauk NY to Marthas Vineyard from 25 to 40 NM offshore',
    '73272': 'Ocean Waters from Marthas Vineyard to Nantucket from 25 to 45 NM offshore',
    '73370': 'Waters from Montauk Point NY to Sandy Hook NJ from 20 to 40 nm',
    '73470': 'Waters from Sandy Hook NJ to Fenwick Island DE from 20 to 40 nm',
    '73670': 'Waters from Fenwick Island DE to Currituck Beach Light NC from 20 to 40 nm',
    '75370': 'Waters from South Santee River SC to Savannah GA extending from 20 nm to 40 nm',
    '75470': 'Waters from Altamaha Sound GA to Fernandina Beach FL from 20 to 60 NM',
    '75374': 'Waters from Savannah GA to Altamaha Sound GA extending from 20 to 60 nm',
    '75472': 'Waters from Fernandina Beach to St. Augustine FL from 20 to 60 NM',
    '75474': 'Waters from St. Augustine to Flagler Beach FL from 20 to 60 NM',
    '57775': 'Waters from San Mateo point to the Mexican Border Extending 30 to 60 nm out including San Clemente Island',
    '57310': 'Coos Bay Bar',
    '77534': 'Lake Borgne',
    '77557': 'Coastal waters from Pascagoula Mississippi to Stake Island out 20 NM',
    '57330': 'Chetco River Bar',
    '73656': 'Coastal Waters from Cape Charles Light to Virginia-North Carolina border out to 20 nm',
    '73634': 'Chesapeake Bay from Little Creek VA to Cape Henry VA including the Chesapeake Bay Bridge Tunnel',
    '73154': 'Coastal Waters from Cape Elizabeth, ME to Merrimack River, MA out 25 NM',
    '57356': 'Coastal waters from Cape Blanco OR to Pt. St. George CA out 10 nm',
    '94422': 'St. Clair River',
    '73541': 'Choptank River to Cambridge MD and the Little Choptank River',
    '96040': 'Ripley to Dunkirk NY',
    '77532': 'Mississippi Sound',
    '77536': 'Chandeleur Sound',
    '77538': 'Breton Sound',
    '73451': 'Coastal waters from Manasquan Inlet to Little Egg Inlet NJ out 20 nm',
    '96020': 'Upper Niagara River and Buffalo Harbor',
    '91263': 'Lake Superior from Saxon Harbor WI to Upper Entrance to Portage Canal MI 5 NM off shore to the US/Canadian border including Isle Royal National Park',
    '91264': 'Lake Superior from Upper Entrance to Portage Canal to Manitou Island MI 5 NM off shore to the US/Canadian Border',
    '92846': 'Holland to Grand Haven MI',
    '92847': 'Grand Haven to Whitehall MI',
    '92849': 'Pentwater to Manistee MI',
    '92848': 'Whitehall to Pentwater MI',
    '92874': 'Lake Michigan from Holland to Grand Haven MI 5 NM offshore to Mid Lake',
    '92872': 'Lake Michigan from Grand Haven to Whitehall MI 5 NM offshore to Mid Lake',
    '92341': 'Seul Choix Point to 5 NM West of Mackinac Bridge',
    '93345': 'Straits of Mackinac within 5 nm of Mackinac Bridge including Mackinac Island',
    '92345': 'Point Betsie to Sleeping Bear Point MI',
    '92323': 'Grand Traverse Bay south of a line Grand Traverse Light to Norwood MI',
    '93348': 'Presque Isle Light to Sturgeon Pt MI Including Thunder Bay National Marine Sanctuary',
    '73543': 'Tangier Sound and the inland waters surrounding Bloodsworth Island',
    '73330': 'Long Island Sound East of New Haven CT/Port Jefferson NY',
    '57110': 'Grays Harbor Bar',
    '96041': 'Dunkirk to Buffalo NY',
    '75352': 'Coastal waters from Edisto Beach SC to Savannah GA out 20 nm',
    '75354': 'Coastal waters from Savannah GA to Altamaha Sound GA out 20 nm ...including Grays Reef National Marine Sanctuary',
    '77850': 'Coastal waters from Tarpon Springs to Suwannee River FL out 20 NM',
    '77355': 'Coastal waters from High Island to Freeport TX out 20 NM',
    '77350': 'Coastal waters from Freeport to Matagorda Ship Channel TX out 20 NM',
    '77550': 'Coastal Waters from Port Fourchon LA to Lower Atchafalaya River LA out 20 nm',
    '77770': 'Waters from Apalachicola to Destin FL from 20 to 60 NM',
    '77775': 'Waters from  Suwannee River to Apalachicola FL from 20 to 60 NM',
    '77870': 'Waters from Tarpon Springs to Suwannee River FL out 20 to 60 NM',
    '77575': 'Coastal Waters from Stake Island LA to Southwest Pass of the Mississippi River from 20 to 60 nm',
    '77472': 'Waters from  Intracoastal City to Cameron LA from 20 to 60 NM',
    '77475': 'Waters from Lower Atchafalaya River to Intracoastal City LA from 20 to 60 NM',
    '77570': 'Coastal waters from Port Fourchon Louisiana to Lower Atchafalaya River LA from 20 to 60 NM',
    '77375': 'Waters from High Island to Freeport TX from 20 to 60 NM',
    '77470': 'Waters from Cameron LA to High Island TX from 20 to 60 NM',
    '77577': 'Coastal waters from Pascagoula Mississippi to Stake Island Louisiana out 20 to 60 NM',
    '77572': 'Coastal waters from Southwest Pass of the Mississippi River to Port Fourchon Louisiana from 20 to 60 NM',
    '77555': 'Coastal Waters from Boothville LA to Southwest Pass of the Mississippi River out 20 nm',
    '77552': 'Coastal waters from the Southwest Pass of the Mississippi River to Port Fourchon Louisiana out 20 NM',
    '65154': 'Saipan Coastal Waters',
    '59121': 'Alenuihaha Channel',
    '59117': 'Maui County Windward Waters',
    '75256': 'Coastal waters from Murrells Inlet to South Santee River SC out 20 nm',
    '97030': 'Lower Niagara River',
    '77330': 'Matagorda Bay',
    '73542': 'Patuxent River to Broomes Island MD',
    '57153': 'Coastal Waters From James Island To Point Grenville Out 10 Nm',
    '73355': 'Sandy Hook NJ to Fire Island Inlet NY out 20 nm',
    '73345': 'South Shore Bays from Jones Inlet through Shinnecock Bay',
    '73636': 'York River',
    '77235': 'Bays and Waterways from Port Aransas to Port O?Connor',
    '73635': 'Rappahannock River from Urbanna to Windmill Point',
    '75670': 'Waters from Jupiter Inlet to Deerfield Beach FL from 20 to 60 NM',
    '73638': 'James River from James River Bridge to Hampton Roads Bridge-Tunnel',
    '57135': 'Puget Sound and Hood Canal',
    '57133': 'Northern Inland Waters Including The San Juan Islands',
    '77335': 'Galveston Bay',
    '77655': 'Coastal waters from Destin to Pensacola FL out 20 NM',
    '77650': 'Coastal waters from Pensacola FL to Pascagoula MS out 20 NM',
    '77670': 'Waters from Pensacola FL to Pascagoula MS from 20 to 60 NM',
    '77675': 'Waters from Destin to Pensacola FL from 20 to 60 NM',
    '77631': 'South Mobile Bay',
    '77632': 'Mississippi Sound',
    '77634': 'Pensacola Bay Area',
    '77635': 'Choctawhatchee Bay',
    '77630': 'North Mobile Bay',
    '57655': 'Inner waters from Point Mugu to San Mateo Pt. CA including Santa Catalina and Anacapa Islands',
    '57650': 'East Santa Barbara Channel from Pt. Conception to Pt. Mugu CA including Santa Cruz Island',
    '57676': 'Outer waters from Santa Cruz Island to San Clemente Island to 60 NM offshore including San Nicolas and Santa Barbara Islands',
    '57673': 'Waters from Pt. Sal to Santa Cruz Island CA and westward 60 nm including San Miguel and Santa Rosa Islands',
    '57645': 'Point Piedras Blancas to Point Sal westward out to 10 NM',
    '77032': 'Bayside and Gulf side from Craig Key to West End of Seven Mile Bridge',
    '75252': 'Coastal waters from Cape Fear NC to Little River Inlet SC out 20 nm',
    '73637': 'James River from Jamestown to the James River Bridge',
    '58245': 'Flaxman Island to Demarcation Point',
    '58240': 'Cape Halkett to Flaxman Island',
    '58235': 'Point Franklin to Cape Halkett',
    '58230': 'Cape Beaufort to Point Franklin',
    '58225': 'Cape Thompson to Cape Beaufort',
    '58220': 'Wales to Cape Thompson',
    '58215': 'Kotzebue Sound',
    '58200': 'Norton Sound',
    '58210': 'Dall Point to Wales',
    '58180': 'Kuskokwim Delta and Etolin Strait',
    '58170': 'Cape Sarichef to Nikoski Bering Side',
    '58179': 'Pribilof Islands Nearshore Waters',
    '58155': 'Castle Cape to Cape Sarichef',
    '58150': 'Sitkinak to Castle Cape',
    '58138': 'Shelikof Strait',
    '58132': 'Shuyak Island To Sitkinak',
    '58139': 'Cook Inlet Kalgin Island to Point Bede',
    '58125': 'Prince William Sound',
    '58128': 'Valdez Arm',
    '58127': 'Valdez Narrows',
    '58126': 'Port of Valdez',
    '58052': 'Icy Cape to Cape Suckling',
    '58051': 'Cape Fairweather to Icy Cape',
    '58053': 'Yakutat Bay',
    '58022': 'Cross Sound',
    '58042': 'Cape Decision to Cape Edgecumbe',
    '58041': 'Dixon Entrance to Cape Decision',
    '58033': 'Southern Chatham Strait',
    '58035': 'Sumner Strait',
    '58034': 'Frederick Sound',
    '58031': 'Stephens Passage',
    '58032': 'Northern Chatham Strait',
    '58021': 'Icy Strait',
    '58011': 'Glacier Bay',
    '58013': 'Southern Lynn Canal',
    '58012': 'Northern Lynn Canal',
    '58043': 'Southeast Alaska Outside Waters From Cape Edgecumbe to Cape Fairweather',
    '58036': 'Clarence Strait',
    '58129': 'Western Prince William Sound',
    '58136': 'Chiniak Bay',
    '58137': 'Marmot Bay',
    '58119': 'Cape Suckling to Cape Cleare',
    '58121': 'Resurrection Bay',
    '58141': 'Kachemak Bay',
    '58131': 'Barren Islands East',
    '58171': 'Unalaska Bay',
    '58140': 'Cook Inlet North Kalgin Island',
    '58130': 'West of Barren Islands Including Kamishak Bay',
    '58160': 'Bristol Bay',
    '58181': 'North and West of Nunivak Island',
    '58174': 'Nikolski to Seguam Pacific Side',
    '58173': 'Nikolski to Seguam Bering Side',
    '58176': 'Seguam to Adak Pacific Side',
    '58175': 'Seguam to Adak Bering Side',
    '58172': 'Cape Sarichef to Nikoski Pacific Side',
    '58165': 'Port Heiden to Cape Sarichef',
    '58120': 'Cape Cleare to Gore Point',
    '58178': 'Kiska to Attu',
    '58177': 'Adak to Kiska',
    '58185': 'St Matthew Island Waters',
    '77856': 'Coastal waters from Bonita Beach to Englewood FL out 20 NM',
    '77836': 'Charlotte Harbor and Pine Island Sound',
    '57575': 'Waters from Pigeon Point to Point Pinos 10-60 NM',
    '57571': 'Waters from Point Reyes to Pigeon Point 10-60 NM',
    '57531': 'San Francisco Bay South of the Bay Bridge',
    '61152': 'Coastal waters of Swain\'s Island',
    '75555': 'Sebastian Inlet to Jupiter Inlet 0-20 nm',
    '75575': 'Sebastian Inlet to Jupiter Inlet 20-60 nm',
    '75570': 'Flagler Beach to Volusia-Brevard County Line 20-60 nm',
    '75550': 'Flagler Beach to Volusia-Brevard County Line 0-20 nm',
    '75552': 'Volusia-Brevard County Line to Sebastian Inlet 0-20 nm',
    '75572': 'Volusia-Brevard County Line to Sebastian Inlet 20-60 nm',
    '77633': 'Perdido Bay Area',
    '75152': 'S of Oregon Inlet NC to Cape Hatteras NC out to 20 nm',
    '75156': 'S of Ocracoke Inlet NC to Cape Lookout NC out to 20 nm',
    '75154': 'S of Cape Hatteras NC to Ocracoke Inlet NC out to 20 nm',
    '75158': 'S of Cape Lookout NC to Surf City NC out to 20 nm',
    '75170': 'Waters from Currituck Beach Light to Surf City NC from 20 to 40 nm',
    '75150': 'S of Currituck Beach Light NC to Oregon Inlet NC out to 20 nm',
    '75130': 'Albemarle Sound',
    '75131': 'Alligator River',
    '75136': 'Pamlico and Pungo Rivers',
    '75137': 'Neuse and Bay Rivers',
    '57670': 'Point Piedras Blancas to Point Sal from 10 to 60 NM',
    '75270': 'Waters from Surf City NC to South Santee River SC from 20 to 40 nm',
    '75135': 'Pamlico Sound',
    '73270': 'Ocean Waters from the Merrimack River to Plymouth from 40 to 60 NM offshore',
    '73234': 'Buzzards Bay',
    '73233': 'Vineyard Sound',
    '73236': 'Narragansett Bay',
    '73237': 'Block Island Sound',
    '75031': 'Caribbean from 11N to 15N between 72W and 80W including Colombia Basin',
    '75013': 'Caribbean N of 18N between 76W and 85W including Cayman Basin',
    '75037': 'Tropical N Atlantic from 7N and 15N between 55W and 60W',
    '75121': 'Atlantic from 22N to 27N between 65W and 70W',
    '75011': 'Caribbean Nof 18N W of 85W including Yucatan Basin',
    '75017': 'Gulf of Honduras',
    '75019': 'Caribbean from 15N to 18N between 80W and 85W',
    '75021': 'Caribbean from 15N to 18N between 72W and 80W',
    '75015': 'Caribbean approaches to the Windward Passage',
    '75039': 'SW Caribbean S of 11N including the approaches to the Panama Canal',
    '75029': 'W Central Caribbean from 11N to 15N W of 80W',
    '75023': 'Caribbean N of 15N between 64W and 72W',
    '75027': 'Tropical N Atlantic from 15N to 19N between 55W and 60W',
    '75113': 'Atlantic from 27N to 31N between 70W and 77W',
    '75125': 'Atlantic S of 22N between 65W and 70W including Puerto Rico Trench',
    '75123': 'Atlantic S of 22N W of 70W including approaches to the Windward Passage',
    '75025': 'Offshore Waters Leeward Islands',
    '75035': 'Offshore Waters Windward Islands including Trinidad and Tobago',
    '75117': 'Bahamas including Cay Sal Bank',
    '75033': 'Caribbean S of 15N between 64W and 72W including Venezuela Basin',
    '75127': 'Atlantic from 19N to 22N between 55W and 65W',
    '75119': 'Atlantic from 22N to 27N E of Bahamas to 70W',
    '75115': 'Atlantic from 27N to 31N between 65W and 70W',
    '75111': 'Atlantic from 27N to 31N W of 77W',
    '73805': 'Georges Bank between Cape Cod and 68W north of 1000 FM',
    '73810': 'South of New England between the Great South Channel and Montauk Point to 1000 FM',
    '73820': 'Hudson Canyon to Baltimore Canyon to 1000 FM',
    '73925': 'Baltimore Canyon to Hatteras Canyon between 100 NM and 250 NM offshore',
    '57900': 'Cape Flattery to Cape Shoalwater between 150 NM and 250 NM offshore',
    '57915': 'Florence, OR to Point St. George between 150 NM and 250 NM offshore',
    '57920': 'Point St. George to Point Arena between 150 NM and 250 NM offshore',
    '57930': 'Pigeon Point to Point Piedras Blancas between 150 NM and 250 NM offshore',
    '57940': 'Santa Cruz Island, CA to 120W between 150 NM and 250 NM offshore',
    '77019': 'Central Gulf from 22N to 26N between 87W and 94W',
    '77015': 'NE Gulf N of 25N E of 87W',
    '77013': 'N Central Gulf including Flower Garden Banks Marine Sanctuary',
    '77011': 'NW Gulf including Stetson Bank',
    '77025': 'E Bay of Campeche including Campeche Bank',
    '77017': 'W Central Gulf from 22N to 26N W of 94W',
    '77021': 'E Gulf from 22N to 25N E of 87W including Straits of Florida',
    '77023': 'SW Gulf S of 22N W of 94W',
    '58510': 'Eastern US Arctic Offshore',
    '58505': 'Central US Arctic Offshore',
    '58500': 'Western US Arctic Offshore',
    '58310': 'Gulf of Alaska North of 55 Degrees North and East of 144 W',
    '58411': 'Bering Sea Offshore  West of 180 and East of the International Date Line',
    '58351': 'Gulf of Alaska Offshore North of 57N and West of 144W',
    '58352': 'Gulf of Alaska Offshore South of 57N North of 55N and West of 144W',
    '58413': 'Bering Sea Offshore 171W to 180 and South of 56N',
    '58414': 'Bering Sea Offshore East of 171W',
    '58412': 'Bering Sea Offshore 171W to 180 and North of 56N',
    '59180': 'Offshore Waters Within 240 nm of Honolulu',
    '73800': 'Gulf of Maine to the Hague Line',
    '73900': 'Georges Bank between 68W and the Hague Line',
    '73815': 'South of Long Island between Montauk Point and Sandy Hook to 1000 FM',
    '73905': 'East of 69W to the Hague Line between 1000 FM and 39N',
    '73910': 'East of 69W and south of 39N to 250 NM offshore',
    '73920': 'Baltimore Canyon to 69W east of 1000 FM and south of 38.5N to 250 NM offshore',
    '73915': 'Between 1000FM and 38.5 N west of 69 W',
    '73825': 'Baltimore Canyon to Cape Charles Light to 100 NM offshore',
    '73828': 'Cape Charles Light to Currituck Beach Light to 100 NM offshore',
    '73833': 'Cape Hatteras to Cape Fear to 100 NM Offshore.',
    '73830': 'Currituck Beach Light to Cape Hatteras to 100 NM offshore',
    '73930': 'Hatteras Canyon to Cape Fear between 100 NM and 250 NM offshore',
    '73835': 'Cape Fear to 31N to 1000 FM',
    '73935': 'Cape Fear to 31N east of 1000 FM to 250 NM offshore',
    '57840': 'Santa Cruz Island, CA to San Clemente Island, CA between 60 NM and 150 NM offshore',
    '57835': 'Point Piedras Blancas to Santa Cruz Island, CA between 60 NM and 150 NM offshore',
    '57935': 'Point Piedras Blancas to Santa Cruz Island, CA between 150 NM and 250 NM offshore',
    '57800': 'Cape Flattery to Cape Shoalwater between 60 NM and 150 NM offshore',
    '57905': 'Cape Shoalwater to Cape Lookout between 150 NM and 250 NM offshore',
    '57805': 'Cape Shoalwater to Cape Lookout between 60 NM and 150 NM offshore',
    '57910': 'Cape Lookout to Florence, OR between 150 NM and 250 NM offshore',
    '57810': 'Cape Lookout to Florence, OR between 60 NM and 150 NM offshore',
    '57815': 'Florence, OR to Point St. George between 60 NM and 150 NM offshore',
    '57820': 'Point St. George to Point Arena between 60 NM and 150 NM offshore',
    '57925': 'Point Arena to Pigeon Point between 150 NM and 250 NM offshore',
    '57825': 'Point Arena to Pigeon Point between 60 NM and 150 NM offshore',
    '57830': 'Pigeon Point to Point Piedras Blancas between 60 NM and 150 NM offshore',
    '57945': 'San Clemente Island, CA to Guadalupe Island from 60 NM offshore west to 120W',
    'XXXXX': 'TEST',
}

CA_SAME_CODE = {
    'LOCATION': 'CA',
    # Nova Scotia
    '11100': 'Kings County',
    '11200': 'Annapolis County',
    '11300': 'Digby County',
    '11400': 'Lunenburg County',
    '11500': 'Queens County',
    '11600': 'Shelburne County',
    '11700': 'Yarmouth County',
    '12100': 'Cumberland County - Minas Shore',
    '12200': 'Cumberland County North and Cobequid Pass',
    '12300': 'Colchester County - Cobequid Bay',
    '12400': 'Colchester County North',
    '12500': 'Hants County',
    '12600': 'Colchester County - Truro and south',
    '12700': 'Halifax Metro and Halifax County West',
    '12800': 'Halifax County - east of Porters Lake',
    '13100': 'Pictou County',
    '13200': 'Guysborough County',
    '13300': 'Antigonish County',
    '14100': 'Richmond County',
    '14200': 'Inverness County - south of Mabou',
    '14300': 'Inverness County - Mabou and north',
    '14400': 'Victoria County',
    '14500': 'Sydney Metro and Cape Breton County',
    # New Brunswick
    '15100': 'Fredericton and southern York County',
    '15200': 'Oromocto and Sunbury County',
    '15300': 'Grand Lake and Queens County',
    '15400': 'Sussex/Kennebecasis Valley and Kings County',
    '15500': 'Saint John and County',
    '15600': 'St. Stephen and northern Charlotte County',
    '15700': 'Grand Manan and coastal Charlotte County',
    '16100': 'Woodstock and Carleton County',
    '16200': 'Stanley-Doaktown-Blackville Area',
    '16300': 'Kent County',
    '16400': 'Moncton and southeast New Brunswick',
    '16500': 'Kouchibouguac National Park',
    '16600': 'Fundy National Park',
    '17100': 'Edmundston and Madawaska County',
    '17200': 'Campbellton and Restigouche County',
    # sub-regions
    '17210': 'Western half of Restigouche County',
    '17220': 'Campbellton and eastern half of Restigouche County',
    '17300': 'Grand Falls and Victoria County',
    '17400': 'Mount Carleton-Renous Highway',
    '17500': 'Bathurst and Chaleur Region',
    '17600': 'Miramichi and Area',
    '17700': 'Acadian Peninsula',
    # Prince Edward Island
    '18100': 'Kings County',
    '18200': 'Prince County',
    '18300': 'Queens County',
    # Newfoundland and Labrador
    '21100': 'Avalon Peninsula North',
    '21200': 'Avalon Peninsula Southeast',
    '21300': 'St. John\'s and vicinity',
    # sub-regions
    '21310': 'North of La Manche',
    '21320': 'La Manche and south',
    '21400': 'Avalon Peninsula Southwest',
    '22100': 'Burin Peninsula',
    '22200': 'Connaigre',
    '22300': 'Burgeo to Ramea',
    '22400': 'Channel-Port aux Basques and vicinity',
    # sub-regions
    '22410': 'South Coast',
    '22420': 'West Coast',
    '23100': 'Corner Brook and vicinity',
    '23200': 'Deer Lake - Humber Valley',
    '23300': 'Gros Morne',
    '23400': 'Bay St. George',
    '24100': 'Buchans and the Interior',
    '24200': 'Grand Falls-Windsor and vicinity',
    '25100': 'Bay of Exploits',
    '25200': 'Bonavista North',
    '25300': 'Bonavista Peninsula',
    '25400': 'Clarenville and vicinity',
    '25500': 'Gander and vicinity',
    '25600': 'Green Bay - White Bay',
    '25700': 'Terra Nova',
    '26100': 'Northern Peninsula East',
    '26200': 'Parson\'s Pond - Hawke\'s Bay',
    '26300': 'Port Saunders and the Straits',
    '27100': 'Red Bay to L\'Anse-au-Clair',
    '27200': 'Norman Bay to Lodge Bay',
    '27300': 'Cartwright to Black Tickle',
    '27400': 'Rigolet and vicinity',
    '27500': 'Postville - Makkovik',
    '27600': 'Hopedale and vicinity',
    '27700': 'Nain and vicinity',
    '28100': 'Upper Lake Melville',
    '28200': 'Eagle River',
    '28300': 'Churchill Valley',
    '29100': 'Churchill Falls and vicinity',
    '29200': 'Labrador City and Wabush',
    # Quebec
    '31100': 'Gatineau',
    '31200': 'Waskaganish',
    '31300': 'Matagami',
    # sub-regions
    '31310': 'Joutel - Matagami area',
    '31320': 'Miquelon - Desmaraisville area',
    '31400': 'Abitibi',
    # sub-regions
    '31410': 'La Sarre area',
    '31420': 'Amos area',
    '31430': 'Lebel-sur-Quevillon area',
    '31440': 'Senneterre area',
    '31450': 'Rouyn area',
    '31460': 'Malartic area',
    '31470': 'Val d\'Or - Louvicourt area',
    '31500': 'Temiscamingue',
    # sub-regions
    '31510': 'Ville-Marie area',
    '31520': 'Temiscaming area',
    '31600': 'Reserve Faunique La Verendrye',
    # sub-regions
    '31610': 'Dorval Lodge area',
    '31620': 'Le Domaine area',
    '31700': 'Pontiac',
    # sub-regions
    '31710': 'Rapides-des-Joachims area',
    '31720': 'Fort William - Shawville area',
    '31800': 'Mont-Laurier',
    # sub-regions
    '31810': 'Mont-Laurier area',
    '31820': 'La Minerve - Rouge River area',
    '31900': 'Upper Gatineau-Lievre-Papineau',
    # sub-regions
    '31910': 'Low - Wakefield area',
    '31920': 'Maniwaki - Gracefield area',
    '31930': 'Papineauville - Cheneville area',
    '31940': 'Papineau-Labelle Reserve area',
    '31950': 'Lievre River area',
    '32100': 'Parc du Mont-Tremblant - Saint-Michel-des-Saints',
    # sub-regions
    '32110': 'Saint-Michel-des-Saints area',
    '32120': 'Saint-Donat - Parc du Mont-Tremblant area',
    '32200': 'Laurentides',
    # sub-regions
    '32210': 'Mont-Tremblant - Sainte-Agathe area',
    '32220': 'Sainte-Adele - Saint-Sauveur area',
    '32300': 'Lachute-Saint-Jerome',
    # sub-regions
    '32310': 'Saint-Jerome area',
    '32320': 'Lachute area',
    '32330': 'Saint-Eustache area',
    '32400': 'Montreal Metropolitain - Laval',
    # sub-regions
    '32410': 'Longueuil - Varennes area',
    '32420': 'Laval area',
    '32430': 'Montreal Island area',
    '32440': 'Chateauguay - La Prairie area',
    '32500': 'Vaudreuil - Soulanges - Huntingdon',
    # sub-regions
    '32510': 'Soulanges area',
    '32520': 'Vaudreuil area',
    '32530': 'Saint-Remi area',
    '32540': 'Valleyfield - Beauharnois area',
    '32550': 'Hemmingford area',
    '32560': 'Huntingdon area',
    '32600': 'Lanaudiere',
    # sub-regions
    '32610': 'Berthierville - Saint-Gabriel area',
    '32620': 'Rawdon - Joliette area',
    '32630': 'Mascouche area',
    '32700': 'Mauricie',
    # sub-regions
    '32710': 'Louiseville area',
    '32720': 'Matawin - Mauricie National Park area',
    '32730': 'Lac-aux-Sables area',
    '32740': 'Shawinigan area',
    '32750': 'Sainte-Anne-de-la-Perade area',
    '32760': 'Trois-Rivieres area',
    '32800': 'Quebec',
    # sub-regions
    '32811': 'Portneuf area',
    '32812': 'Valcartier - Stoneham area',
    '32813': 'Quebec area',
    '32814': 'Cote-de-Beaupre - L\'Ile d\'Orleans area',
    '32821': 'Bellechasse area',
    '32822': 'Levis area',
    '32823': 'Saint-Lambert area',
    '32824': 'Lotbiniere area',
    '33100': 'James-Bay and La-Grande-Riviere',
    '33200': 'LG-Quatre - Laforge and Fontanges',
    '33300': 'Schefferville',
    '33400': 'Fermont',
    '34100': 'Chibougamau',
    '34200': 'Parent-Reservoir Gouin',
    # sub-regions
    '34210': 'Gouin Reservoir area',
    '34220': 'Parent area',
    '34300': 'Lac-Saint-Jean',
    # sub-regions
    '34310': 'Ashuapmushuan Wildlife Reserve area',
    '34320': 'Normandin - Peribonka area',
    '34330': 'Alma - Desbiens area',
    '34340': 'Saint-Felicien - Roberval area',
    '34400': 'La Tuque',
    # sub-regions
    '34410': 'Lake Bouchette area',
    '34420': 'La Tuque area',
    '34500': 'Riviere Manicouagan',
    # sub-regions
    '34510': 'Manic-5 area',
    '34520': 'Manic-3 area',
    '34530': 'Chutes-des-Passes - Pipmuacan Reservoir area',
    '34540': 'Labrieville area',
    '34600': 'Les Escoumins-Forestville',
    # sub-regions
    '34610': 'Forestville area',
    '34620': 'Les Escoumins area',
    '34700': 'Saguenay',
    # sub-regions
    '34710': 'Falardeau - Mont-Valin area',
    '34720': 'Sainte-Rose-du-Nord area',
    '34730': 'Ville de Saguenay area',
    '34740': 'Riviere-eternite - Petit-Saguenay area',
    '34750': 'Tadoussac - Baie-Sainte-Catherine area',
    '34800': 'Charlevoix',
    # sub-regions
    '34810': 'La Malbaie area',
    '34820': 'Baie-Saint-Paul area',
    '34900': 'Reserve Faunique des Laurentides',
    # sub-regions
    '34910': 'Apica Mountain area',
    '34920': 'Grands-Jardins Park area',
    '34930': 'l\'etape area',
    '35100': 'Rimouski - Mont-Joli',
    # sub-regions
    '35110': 'Mont-Joli area',
    '35120': 'Le Bic - Rimouski area',
    '35130': 'Rimouski Wildlife Reserve area',
    '35200': 'Matane',
    '35300': 'Amqui-Vallee de la Matapedia',
    # sub-regions
    '35310': 'Amqui area',
    '35320': 'Matapedia area',
    '35400': 'Sainte-Anne-des-Monts - Grande-Vallee',
    # sub-regions
    '35410': 'Grande-Vallee area',
    '35420': 'Sainte-Anne-des-Monts area',
    '35500': 'Parc National de la Gaspesie - Murdochville',
    # sub-regions
    '35510': 'Murdochville area',
    '35520': 'Mont-Albert area',
    '35530': 'Grande-Riviere - Cascapedia area',
    '35600': 'Restigouche-Bonaventure',
    # sub-regions
    '35610': 'New-Richmond - Bonaventure area',
    '35620': 'Restigouche - Carleton area',
    '35700': 'New-Carlisle - Chandler',
    # sub-regions
    '35710': 'Chandler area',
    '35720': 'New Carlisle - Port-Daniel area',
    '35800': 'Parc National Forillon - Gaspe - Perce',
    # sub-regions
    '35810': 'Parc National Forillon - Gaspe area',
    '35820': 'Perce area',
    '36100': 'Baie-Comeau',
    '36200': 'Sept-Iles - Port-Cartier',
    # sub-regions
    '36210': 'Baie-Trinite area',
    '36220': 'Sept-Iles - Port-Cartier area',
    '36300': 'Minganie',
    '36400': 'Natashquan',
    '36500': 'Chevery',
    '36600': 'Blanc-Sablon',
    '36700': 'Anticosti',
    '36800': 'Iles-de-la-Madeleine',
    '37100': 'Vallee du Richelieu-Saint-Hyacinthe',
    # sub-regions
    '37110': 'Sorel - Yamaska area',
    '37120': 'Saint-Hyacinthe - Acton Vale area',
    '37130': 'Vercheres - Beloeil area',
    '37140': 'Saint-Jean - Marieville area',
    '37150': 'Lacolle area',
    '37200': 'Drummondville - Bois-Francs',
    # sub-regions
    '37210': 'Becancour - Villeroy area',
    '37220': 'Victoriaville area',
    '37230': 'Nicolet area',
    '37240': 'Drummondville area',
    '37300': 'Eastern Townships',
    # sub-regions
    '37311': 'Granby - Waterloo area',
    '37312': 'Brome-Missisquoi area',
    '37321': 'Richmond area',
    '37322': 'Weedon area',
    '37323': 'Thetford Mines area',
    '37331': 'Mont-Orford - Lake Memphremagog area',
    '37332': 'Sherbrooke area',
    '37333': 'Coaticook area',
    '37334': 'Lac-Megantic area',
    '37335': 'Cookshire area',
    '37400': 'Beauce',
    # sub-regions
    '37410': 'Lac-Etchemin area',
    '37420': 'Sainte-Marie-de-Beauce area',
    '37430': 'Saint-Georges-de-Beauce area',
    '37500': 'Montmagny - L\'Islet',
    # sub-regions
    '37510': 'Montmagny - Saint-Jean-Port-Joli area',
    '37520': 'Saint-Fabien - Saint-Pamphile area',
    '37600': 'Kamouraska - Riviere-du-Loup - Trois-Pistoles',
    # sub-regions
    '37610': 'Trois-Pistoles area',
    '37620': 'Pohenegamook area',
    '37630': 'Kamouraska area',
    '37640': 'Riviere-du-Loup area',
    '37700': 'Temiscouata',
    '38100': 'Ivujivik',
    '38200': 'Akulivik',
    '38300': 'Puvirnituq',
    '38400': 'Inukjuak',
    '38500': 'Umiujaq',
    '38600': 'Kuujjuarapik',
    '39100': 'Salluit - Raglan Lake',
    '39200': 'Kangiqsujuaq',
    '39300': 'Quaqtaq',
    '39400': 'Kangirsuk',
    '39500': 'Aupaluk',
    '39600': 'Tasiujaq',
    '39700': 'Kuujjuaq',
    '39800': 'Kangiqsualujjua',
    # Ontario
    '41100': 'Simcoe - Delhi - Norfolk',
    '41200': 'Dunnville - Caledonia - Haldimand',
    '41300': 'Sarnia - Lambton',
    # sub-regions
    '41310': 'Watford - Pinery Park - Eastern Lambton County',
    '41320': 'Sarnia - Petrolia - Western Lambton County',
    '41400': 'Windsor - Essex - Chatham-Kent',
    # sub-regions
    '41410': 'Chatham-Kent - Rondeau Park',
    '41420': 'Windsor - Leamington - Essex County',
    '41500': 'London - Middlesex',
    # sub-regions
    '41510': 'London - Parkhill - Eastern Middlesex County',
    '41520': 'Strathroy - Komoka - Western Middlesex County',
    '41600': 'Elgin',
    # sub-regions
    '41610': 'St. Thomas - Aylmer - Eastern Elgin County',
    '41620': 'Rodney - Shedden - Western Elgin County',
    '41700': 'Oxford - Brant',
    # sub-regions
    '41710': 'Woodstock - Tillsonburg - Oxford County',
    '41720': 'Brantford - County of Brant',
    '42100': 'Attawapiskat',
    '42200': 'Fort Severn',
    '42300': 'Peawanuck',
    '42400': 'Big Trout Lake - Sachigo Lake',
    # sub-regions
    '42410': 'Sachigo Lake - Bearskin Lake',
    '42420': 'Big Trout Lake - Kasabonika',
    '42500': 'Sandy Lake - Pikangikum',
    # sub-regions
    '42510': 'Sandy Lake - Weagamow Lake - Deer Lake',
    '42520': 'Pikangikum - Poplar Hill - MacDowell',
    '42600': 'Pickle Lake - Wunnummin Lake',
    # sub-regions
    '42610': 'Summer Beaver - Wunnummin Lake - Kingfisher Lake',
    '42620': 'Pickle Lake - Cat Lake',
    '42700': 'Fort Hope - Webequie',
    # sub-regions
    '42710': 'Webequie',
    '42720': 'Fort Hope - Lansdowne House - Ogoki',
    '43100': 'City of Toronto',
    '43200': 'York - Durham',
    # sub-regions
    '43210': 'Uxbridge - Beaverton - Northern Durham Region',
    '43220': 'Newmarket - Georgina - Northern York Region',
    '43230': 'Pickering - Oshawa - Southern Durham Region',
    '43240': 'Vaughan - Richmond Hill - Markham',
    '43300': 'Belleville - Quinte - Northumberland',
    # sub-regions
    '43310': 'Belleville - Quinte West - Eastern Northumberland County',
    '43320': 'Cobourg - Colborne - Western Northumberland County',
    '43400': 'Stirling - Tweed - South Frontenac',
    # sub-regions
    '43410': 'Tamworth - Sydenham - South Frontenac',
    '43420': 'Stirling - Tweed - Madoc',
    '43500': 'Kingston - Prince Edward',
    # sub-regions
    '43510': 'Kingston - Odessa - Frontenac Islands',
    '43520': 'Napanee - Consecon',
    '43530': 'Picton - Sandbanks Park',
    '43600': 'Brockville - Leeds and Grenville',
    # sub-regions
    '43610': 'Merrickville-Wolford - Kemptville',
    '43620': 'Westport - Charleston Lake',
    '43630': 'Brockville - Prescott',
    '43640': 'Gananoque - Mallorytown',
    '43700': 'Cornwall - Morrisburg',
    # sub-regions
    '43710': 'Maxville - Alexandria',
    '43720': 'Cornwall - Lancaster',
    '43730': 'Winchester - Newington',
    '43740': 'Morrisburg - Long Sault',
    '44100': 'Barrie - Orillia - Midland',
    # sub-regions
    '44110': 'Midland - Coldwater - Orr Lake',
    '44120': 'Orillia - Lagoon City - Washago',
    '44130': 'Barrie - Collingwood - Hillsdale',
    '44200': 'Burk\'s Falls - Bayfield Inlet',
    # sub-regions
    '44210': 'South River - Burk\'s Falls',
    '44220': 'Bayfield Inlet - Dunchurch',
    '44300': 'Algonquin',
    # sub-regions
    '44310': 'Deep River - Whitney - Eastern Algonquin Park',
    '44320': 'Western Algonquin Park - Lake of Two Rivers',
    '44400': 'Parry Sound - Muskoka',
    # sub-regions
    '44410': 'Huntsville - Baysville',
    '44420': 'Town of Parry Sound - Rosseau - Killbear Park',
    '44430': 'Port Carling - Port Severn',
    '44440': 'Bracebridge - Gravenhurst',
    '44500': 'Haliburton',
    # sub-regions
    '44510': 'Oxtongue Lake - Fort Irwin - Northern Haliburton County',
    '44520': 'Haliburton - Minden - Southern Haliburton County',
    '44600': 'Bancroft - Bon Echo Park',
    # sub-regions
    '44610': 'Bancroft - Hastings Highlands - Denbigh',
    '44620': 'Kaladar - Bannockburn - Bon Echo Park',
    '44700': 'Peterborough - Kawartha Lakes',
    # sub-regions
    '44710': 'Fenelon Falls - Balsam Lake Park - Northern Kawartha Lakes',
    '44720': 'Apsley - Woodview - Northern Peterborough County',
    '44730': 'Lindsay - Southern Kawartha Lakes',
    '44740': 'Peterborough City - Lakefield - Southern Peterborough County',
    '45100': 'Prescott and Russell',
    '45200': 'Renfrew - Pembroke - Barry\'s Bay',
    # sub-regions
    '45210': 'Petawawa - Pembroke - Cobden',
    '45220': 'Barry\'s Bay - Killaloe',
    '45230': 'Renfrew - Arnprior - Calabogie',
    '45300': 'Smiths Falls - Lanark - Sharbot Lake',
    # sub-regions
    '45310': 'Smiths Falls - Perth - Eastern Lanark County',
    '45320': 'Plevna - Sharbot Lake - Western Lanark County',
    '45400': 'City of Ottawa',
    # sub-regions
    '45410': 'Ottawa North - Kanata - Orleans',
    '45420': 'Ottawa South - Richmond - Metcalfe',
    '46100': 'City of Hamilton',
    '46200': 'Grey - Bruce',
    # sub-regions
    '46210': 'Bruce Peninsula - Sauble Beach - Tobermory',
    '46220': 'Owen Sound - Blue Mountains - Northern Grey County',
    '46230': 'Saugeen Shores - Kincardine - Southern Bruce County',
    '46240': 'Hanover - Dundalk - Southern Grey County',
    '46300': 'Huron - Perth',
    # sub-regions
    '46310': 'Wingham - Blyth - Northern Huron County',
    '46320': 'Listowel - Milverton - Northern Perth County',
    '46330': 'Goderich - Bluewater - Southern Huron County',
    '46340': 'Stratford - Mitchell - Southern Perth County',
    '46400': 'Waterloo - Wellington',
    # sub-regions
    '46410': 'Mount Forest - Arthur - Northern Wellington County',
    '46420': 'Guelph - Erin - Southern Wellington County',
    '46430': 'Kitchener - Cambridge - Region of Waterloo',
    '46500': 'Dufferin - Innisfil',
    # sub-regions
    '46510': 'Innisfil - New Tecumseth - Angus',
    '46520': 'Shelburne - Mansfield - Northern Dufferin County',
    '46530': 'Orangeville - Grand Valley - Southern Dufferin County',
    '46600': 'Halton - Peel',
    # sub-regions
    '46610': 'Caledon',
    '46620': 'Mississauga - Brampton',
    '46630': 'Halton Hills - Milton',
    '46640': 'Burlington - Oakville',
    '46700': 'Niagara',
    # sub-regions
    '46710': 'St. Catharines - Grimsby - Northern Niagara Region',
    '46720': 'Niagara Falls - Welland - Southern Niagara Region',
    '47100': 'Red Lake - Ear Falls',
    # sub-regions
    '47110': 'Red Lake - Woodland Caribou Park',
    '47120': 'Ear Falls - Perrault Falls - Western Lac Seul',
    '47200': 'Sioux Lookout - Savant Lake',
    # sub-regions
    '47210': 'Savant Lake - Sturgeon Lake',
    '47220': 'Sioux Lookout - Eastern Lac Seul',
    '47300': 'Kenora - Nestor Falls',
    # sub-regions
    '47310': 'Kenora - Grassy Narrows - Whitedog',
    '47320': 'Sioux Narrows - Nestor Falls - Morson',
    '47400': 'Dryden - Ignace',
    # sub-regions
    '47410': 'Dryden - Vermilion Bay',
    '47420': 'Ignace - English River',
    '47500': 'Fort Frances - Rainy Lake',
    # sub-regions
    '47510': 'Fort Frances - Emo - Rainy River',
    '47520': 'Seine River Village - Mine Centre',
    '48100': 'City of Thunder Bay',
    '48200': 'Lake Nipigon - Wabakimi',
    # sub-regions
    '48210': 'Armstrong - Auden - Wabakimi Park',
    '48220': 'Beardmore - Jellicoe - Macdiarmid',
    '48230': 'Gull Bay - Black Sturgeon Lake',
    '48300': 'Geraldton - Manitouwadge - Hornepayne',
    # sub-regions
    '48310': 'Nakina - Aroland - Pagwa',
    '48320': 'Geraldton - Longlac - Caramat',
    '48330': 'Manitouwadge - Hornepayne',
    '48400': 'Atikokan - Upsala - Quetico',
    # sub-regions
    '48410': 'Upsala - Raith',
    '48420': 'Atikokan - Shebandowan - Quetico Park',
    '48500': 'Superior West',
    # sub-regions
    '48510': 'Cloud Bay - Dorion',
    '48520': 'Kakabeka Falls - Whitefish Lake - Arrow Lake',
    '48600': 'Nipigon - Marathon - Superior North',
    # sub-regions
    '48610': 'Nipigon - Rossport',
    '48620': 'Marathon - Schreiber',
    '48700': 'Wawa - White River - Pukaskwa',
    # sub-regions
    '48710': 'White River - Dubreuilville',
    '48720': 'Wawa - Pukaskwa Park',
    '48800': 'Sault Ste. Marie - Superior East',
    # sub-regions
    '48810': 'Agawa - Lake Superior Park',
    '48820': 'Searchmont - Montreal River Harbour - Batchawana Bay',
    '48830': 'Sault Ste. Marie - St. Joseph Island',
    '49100': 'Greater Sudbury and vicinity',
    '49200': 'Elliot Lake - Ranger Lake',
    '49300': 'Moosonee - Fort Albany',
    # sub-regions
    '49310': 'Fort Albany',
    '49320': 'Moosonee',
    '49400': 'Kapuskasing - Hearst',
    # sub-regions
    '49410': 'Fraserdale - Pledger Lake',
    '49420': 'Kapuskasing - Hearst - Smooth Rock Falls',
    '49500': 'Timmins - Cochrane',
    # sub-regions
    '49510': 'Little Abitibi - Kesagami Lake',
    '49520': 'Timmins - Cochrane - Iroquois Falls',
    '49600': 'Chapleau - Gogama',
    # sub-regions
    '49610': 'Chapleau - Missinaibi Lake',
    '49620': 'Gogama - Foleyet',
    '49700': 'Kirkland Lake - New Liskeard - Temagami',
    # sub-regions
    '49710': 'Kirkland Lake - Englehart',
    '49720': 'New Liskeard - Temagami',
    '49800': 'North Bay - West Nipissing',
    # sub-regions
    '49810': 'West Nipissing - French River',
    '49820': 'North Bay - Powassan - Mattawa',
    '49900': 'Manitoulin - Northshore - Killarney',
    # sub-regions
    '49910': 'Blind River - Thessalon',
    '49920': 'Espanola - Killarney',
    '49930': 'Manitoulin Island',
    # Manitoba
    '51100': 'Virden - Souris',
    # sub-regions
    '51110': 'R.M. of Wallace',
    '51120': 'R.M. of Woodworth',
    '51130': 'R.M. of Daily',
    '51140': 'R.M. of Whitehead',
    '51150': 'R.M. of Sifton',
    '51160': 'R.M. of Pipestone',
    '51170': 'R.M. of Glenwood',
    '51200': 'Brandon - Carberry - Treherne',
    # sub-regions
    '51211': 'R.M. of Elton',
    '51212': 'R.M. of Cornwallis',
    '51213': 'R.M. of Oakland',
    '51220': 'City of Brandon',
    '51231': 'R.M. of North Cypress',
    '51232': 'R.M. of South Cypress',
    '51241': 'R.M. of North Norfolk',
    '51242': 'R.M. of South Norfolk',
    '51243': 'R.M. of Victoria',
    '51300': 'Melita - Boissevain - Turtle Mountain Provincial Park',
    # sub-regions
    '51311': 'R.M. of Albert',
    '51312': 'R.M. of Cameron',
    '51313': 'R.M. of Whitewater',
    '51321': 'R.M. of Edward',
    '51322': 'R.M. of Arthur',
    '51331': 'R.M. of Brenda',
    '51332': 'R.M. of Winchester',
    '51340': 'R.M. of Morton',
    '51400': 'Killarney - Pilot Mound - Manitou',
    # sub-regions
    '51411': 'R.M. of Riverside',
    '51412': 'R.M. of Turtle Mountain',
    '51421': 'R.M. of Strathcona',
    '51422': 'R.M. of Argyle',
    '51431': 'R.M. of Roblin',
    '51432': 'R.M. of Louise',
    '51441': 'R.M. of Lorne',
    '51442': 'R.M. of Pembina',
    '52100': 'City of Winnipeg',
    '52200': 'Selkirk - Gimli - Stonewall - Woodlands - Eriksdale',
    # sub-regions
    '52211': 'R.M. of Eriksdale',
    '52212': 'R.M. of Coldwell',
    '52221': 'R.M. of Armstrong (north)',
    '52222': 'R.M. of Armstrong (south)',
    '52223': 'R.M. of Gimli',
    '52231': 'R.M. of St. Laurent',
    '52232': 'R.M. of Woodlands',
    '52241': 'R.M. of Rockwood (Teulon)',
    '52242': 'R.M. of St. Andrews (Dunnottar)',
    '52243': 'R.M. of Rockwood (Stonewall)',
    '52244': 'R.M. of St. Andrews (St. Andrews)',
    '52251': 'R.M. of Rosser',
    '52252': 'R.M. of West St. Paul',
    '52300': 'Portage la Prairie - Headingley - Brunkild - Carman',
    # sub-regions
    '52311': 'R.M. of Portage la Prairie (St. Ambroise)',
    '52312': 'R.M. of Portage la Prairie (Portage la Prairie)',
    '52321': 'R.M. of St Francois Xavier',
    '52322': 'R.M. of Cartier',
    '52323': 'R.M. of Headingley',
    '52331': 'R.M. of Grey',
    '52332': 'R.M. of Dufferin',
    '52340': 'R.M. of MacDonald',
    '52400': 'Dugald - Beausejour - Grand Beach',
    # sub-regions
    '52411': 'R.M. of Alexander',
    '52412': 'R.M. of St. Clements (Grand Beach and Brokenhead First Nation)',
    '52421': 'R.M. of St. Clements (Libau)',
    '52422': 'R.M. of Brokenhead',
    '52431': 'R.M. of Springfield',
    '52432': 'R.M. of Victoria Beach',
    '52434': 'R.M. of East St. Paul',
    '52500': 'Morden - Winkler - Altona - Emerson - Morris',
    # sub-regions
    '52510': 'R.M. of Morris',
    '52520': 'R.M. of Thompson',
    '52530': 'R.M. of Roland',
    '52540': 'R.M. of Montcalm',
    '52550': 'R.M. of Rhineland',
    '52560': 'R.M. of Stanley',
    '52600': 'Steinbach - St. Adolphe - Dominion City - Vita - Richer',
    # sub-regions
    '52611': 'R.M. of Ritchot',
    '52612': 'R.M. of Tache',
    '52620': 'R.M. of De Salaberry',
    '52630': 'R.M. of Hanover',
    '52641': 'R.M. of Ste. Anne',
    '52642': 'R.M. of La Broquerie',
    '52651': 'R.M. of Franklin',
    '52652': 'R.M. of Stuartburn',
    '53100': 'Bissett - Nopiming Provincial Park - Pine Falls',
    # sub-regions
    '53110': 'Manigotagan, Black River First Nation and Hollow Water First Nation',
    '53120': 'Bissett',
    '53130': 'Nopiming Provincial Park',
    '53140': 'R.M. of Alexander (Pine Falls and Great Falls)',
    '53150': 'R.M. of Alexander west of Great Falls',
    '53200': 'Whiteshell - Lac Du Bonnet - Pinawa',
    # sub-regions
    '53211': 'R.M. of Lac Du Bonnet',
    '53212': 'R.M. of Reynolds',
    '53221': 'L.G.D. of Pinawa',
    '53222': 'R.M. of Whitemouth',
    '53231': 'Point du Bois',
    '53232': 'Falcon Lake and West Hawk Lake',
    '53241': 'R.M. of Reynolds north of Highway 1',
    '53242': 'R.M. of Reynolds south of Highway 1',
    '53243': 'Shoal Lake First Nation',
    '53300': 'Sprague - Northwest Angle Provincial Forest',
    # sub-regions
    '53310': 'Buffalo Point First Nation and Northwest Angle Provincial Forest',
    '53320': 'R.M. of Piney (west)',
    '53330': 'R.M. of Piney (east)',
    '54100': 'Grand Rapids',
    # sub-regions
    '54110': 'Grand Rapids and Easterville',
    '54120': 'Waterhen, Meadow Portage and Skownan',
    '54200': 'Arborg - Hecla - Fisher River - Gypsumville - Ashern',
    # sub-regions
    '54211': 'R.M. of Grahamdale (north)',
    '54212': 'R.M. of Grahamdale (central)',
    '54221': 'Jackhead First Nation',
    '54222': 'R.M. of Fisher (north)',
    '54231': 'R.M. of Siglunes',
    '54232': 'R.M. of Grahamdale (south)',
    '54241': 'R.M. of Fisher (south)',
    '54242': 'R.M. of Bifrost',
    '54243': 'Moose Creek Provincial Forest, Pine Dock and Matheson Island',
    '55100': 'Dauphin - Roblin - Winnipegosis',
    # sub-regions
    '55111': 'R.M. of Park (north)',
    '55112': 'R.M. of Shell River',
    '55113': 'R.M. of Hillsburg',
    '55114': 'R.M. of Shellmouth',
    '55115': 'R.M. of Boulton',
    '55121': 'R.M. of Dauphin',
    '55122': 'R.M. of Ethelbert',
    '55123': 'R.M. of Gilbert Plains',
    '55131': 'R.M. of Mossey River',
    '55132': 'R.M. of Grandview',
    '55133': 'R.M. of Ochre River',
    '55200': 'Minnedosa - Neepawa - Russell - Riding Mountain National Park',
    # sub-regions
    '55211': 'R.M. of Russell',
    '55212': 'R.M. of Silver Creek',
    '55221': 'R.M. of Rossburn',
    '55222': 'Riding Mountain National Park',
    '55223': 'R.M. of Park (south)',
    '55231': 'R.M. of Ellice',
    '55232': 'R.M. of Birtle',
    '55233': 'R.M. of Archie',
    '55234': 'R.M. of Miniota',
    '55241': 'R.M. of Shoal Lake',
    '55242': 'R.M. of Strathclair',
    '55243': 'R.M. of Hamiota',
    '55244': 'R.M. of Blanshard',
    '55251': 'R.M. of Harrison',
    '55252': 'R.M. of Saskatchewan',
    '55253': 'R.M. of Clanwilliam',
    '55254': 'R.M. of Minto',
    '55255': 'R.M. of Odanah',
    '55261': 'R.M. of Langford',
    '55262': 'R.M. of Rosedale',
    '55300': 'Ste. Rose - McCreary - Alonsa - Gladstone',
    # sub-regions
    '55311': 'R.M. of Lawrence',
    '55312': 'R.M. of Alonsa (north)',
    '55321': 'R.M. of Ste. Rose',
    '55322': 'R.M. of Alonsa (central)',
    '55331': 'R.M. of McCreary',
    '55332': 'R.M. of Alonsa (south)',
    '55340': 'R.M. of Glenella',
    '55351': 'R.M. of Lansdowne',
    '55352': 'R.M. of Westbourne',
    '55353': 'R.M. of Lakeview',
    '56100': 'The Pas - Wanless - Westray - Clearwater Lake Provincial Park',
    # sub-regions
    '56110': 'The Pas, Cormorant, Westray and Wanless',
    '56120': 'North and South Moose Lakes',
    '56200': 'Swan River - Duck Mountain Provincial Park - Porcupine Provincial Forest',
    # sub-regions
    '56211': 'Westgate, Red Deer Lake and Barrows',
    '56212': 'Porcupine Provincial Forest',
    '56221': 'R.M. of Mountain (northwest)',
    '56222': 'Pelican Rapids and Shoal River First Nations',
    '56231': 'R.M. of Swan River',
    '56232': 'R.M. of Minitonas',
    '56241': 'Duck Mountain Provincial Park and Forest',
    '56242': 'R.M. of Mountain (southeast)',
    '57100': 'Norway House - Cross Lake - Wabowden',
    # sub-regions
    '57110': 'Molson Lake and Bear Lake',
    '57120': 'Cross Lake and Jenpeg',
    '57130': 'Wabowden',
    '57140': 'Highway 6 between Little Limestone Lake and Ponton',
    '57150': 'Norway House',
    '57200': 'Poplar River',
    '57300': 'Berens River - Little Grand Rapids - Bloodvein - Atikaki',
    # sub-regions
    '57310': 'Berens River',
    '57320': 'Little Grand Rapids and Atikaki Provincial Park',
    '57330': 'Bloodvein',
    '58100': 'Brochet',
    '58200': 'Tadoule Lake',
    '58300': 'Lynn Lake - Leaf Rapids - Pukatawagan',
    # sub-regions
    '58310': 'Lynn Lake',
    '58320': 'Leaf Rapids',
    '58330': 'Pukatawagan',
    '58400': 'Thompson - Nelson House - Split Lake',
    # sub-regions
    '58410': 'South Indian Lake and Amisk Provincial Natural Park',
    '58420': 'Split Lake and York Landing',
    '58430': 'Thompson,Thicket Portage and Pikwitonei',
    '58440': 'Nelson House',
    '58500': 'Flin Flon - Cranberry Portage - Snow Lake',
    # sub-regions
    '58510': 'Snow Lake and Herb Lake Landing',
    '58520': 'Flin Flon, Cranberry Portage and Grass River Provincial Park',
    '59100': 'Churchill',
    '59200': 'York',
    '59300': 'Gillam',
    '59400': 'Shamattawa',
    '59500': 'Island Lake - Oxford House - Gods Lake',
    # sub-regions
    '59510': 'Oxford House and Gods Lake',
    '59520': 'Red Sucker Lake',
    '59530': 'Island Lake',
    # Saskatchewan
    '61100': 'Leader - Gull Lake',
    # sub-regions
    '61111': 'R.M. of Deer Forks',
    '61112': 'R.M. of Happyland',
    '61113': 'R.M. of Enterprise',
    '61114': 'R.M. of Fox Valley',
    '61115': 'R.M. of Big Stick',
    '61121': 'R.M. of Clinworth',
    '61122': 'R.M. of Miry Creek',
    '61123': 'R.M. of Pittville',
    '61131': 'R.M. of Piapot',
    '61132': 'R.M. of Gull Lake',
    '61133': 'R.M. of Carmichael',
    '61200': 'Swift Current - Herbert - Cabri - Kyle - Lucky Lake',
    # sub-regions
    '61211': 'R.M. of Lacadena',
    '61212': 'R.M. of Victory',
    '61213': 'R.M. of Canaan',
    '61221': 'R.M. of Riverside',
    '61222': 'R.M. of Saskatchewan Landing',
    '61223': 'R.M. of Webb',
    '61224': 'R.M. of Swift Current',
    '61225': 'R.M. of Lac Pelletier',
    '61231': 'R.M. of Excelsior',
    '61232': 'R.M. of Morse',
    '61233': 'R.M. of Coulee',
    '61234': 'R.M. of Lawtonia',
    '61235': 'R.M. of Glen Bain',
    '61236': 'R.M. of Whiska Creek',
    '61300': 'Shaunavon - Maple Creek - Val Marie - Cypress Hills',
    # sub-regions
    '61311': 'R.M. of Maple Creek',
    '61312': 'Cypress Hills Provincial Park',
    '61313': 'R.M. of Reno',
    '61321': 'R.M. of Arlington',
    '61322': 'R.M. of White Valley',
    '61323': 'R.M. of Frontier',
    '61331': 'R.M. of Bone Creek',
    '61332': 'R.M. of Grassy Creek',
    '61333': 'R.M. of Wise Creek',
    '61341': 'R.M. of Lone Tree',
    '61342': 'R.M. of Val Marie',
    '61351': 'R.M. of Auvergne',
    '61352': 'R.M. of Pinto Creek',
    '61353': 'R.M. of Glen McPherson',
    '61354': 'R.M. of Mankota',
    '62100': 'City of Regina',
    '62200': 'Moose Jaw - Pense - Central Butte - Craik',
    # sub-regions
    '62211': 'R.M. of Maple Bush',
    '62212': 'R.M. of Huron',
    '62213': 'R.M. of Enfield',
    '62214': 'R.M. of Eyebrow',
    '62221': 'R.M. of Craik',
    '62222': 'R.M. of Sarnia',
    '62223': 'R.M. of Marquis',
    '62224': 'R.M. of Dufferin',
    '62231': 'R.M. of Chaplin',
    '62232': 'R.M. of Wheatlands',
    '62233': 'R.M. of Shamrock',
    '62234': 'R.M. of Rodgers',
    '62241': 'R.M. of Caron',
    '62242': 'R.M. of Moose Jaw',
    '62243': 'R.M. of Pense',
    '62244': 'City of Moose Jaw',
    '62245': 'R.M. of Hillsborough',
    '62246': 'R.M. of Redburn',
    '62247': 'R.M. of Baildon',
    '62300': 'Fort Qu\'Appelle - Indian Head - Lumsden - Pilot Butte',
    # sub-regions
    '62311': 'R.M. of McKillop',
    '62312': 'R.M. of Longlaketon',
    '62313': 'R.M. of Lumsden',
    '62321': 'R.M. of Cupar',
    '62322': 'R.M. of Lipton',
    '62323': 'R.M. of Tullymet',
    '62331': 'R.M. of Sherwood',
    '62332': 'R.M. of Bratt\'s Lake',
    '62341': 'R.M. of Lajord',
    '62342': 'R.M. of Francis',
    '62343': 'R.M. of Montmartre and Assiniboine First Nation',
    '62351': 'R.M. of Edenwold and Piapot First Nation',
    '62352': 'R.M. of North Qu\'Appelle',
    '62353': 'R.M. of South Qu\'Appelle',
    '62361': 'R.M. of Abernethy',
    '62362': 'R.M. of Indian Head',
    '62400': 'Assiniboia - Gravelbourg - Coronach',
    # sub-regions
    '62411': 'R.M. of Gravelbourg',
    '62412': 'R.M. of Sutton',
    '62413': 'R.M. of Wood River',
    '62414': 'R.M. of Stonehenge',
    '62421': 'R.M. of Waverley',
    '62422': 'R.M. of Old Post',
    '62431': 'R.M. of Lake Johnson',
    '62432': 'R.M. of Terrell',
    '62433': 'R.M. of Lake of the Rivers',
    '62434': 'R.M. of Excel',
    '62441': 'R.M. of Willow Bunch',
    '62442': 'R.M. of Poplar Valley',
    '62443': 'R.M. of Hart Butte',
    '62451': 'R.M. of Elmsthorpe',
    '62452': 'R.M. of Key West',
    '62461': 'R.M. of Bengough',
    '62462': 'R.M. of The Gap',
    '62463': 'R.M. of Happy Valley',
    '62464': 'R.M. of Surprise Valley',
    '62500': 'Estevan - Weyburn - Radville - Milestone',
    # sub-regions
    '62511': 'R.M. of Caledonia',
    '62512': 'R.M. of Scott',
    '62513': 'R.M. of Norton',
    '62514': 'R.M. of Brokenshell',
    '62521': 'R.M. of Wellington',
    '62522': 'R.M. of Fillmore',
    '62523': 'R.M. of Weyburn',
    '62524': 'R.M. of Griffin',
    '62531': 'R.M. of Laurier',
    '62532': 'R.M. of Lomond',
    '62533': 'R.M. of Lake Alma',
    '62534': 'R.M. of Souris Valley',
    '62541': 'R.M. of Cymri',
    '62542': 'R.M. of Benson',
    '62543': 'R.M. of Cambria',
    '62544': 'R.M. of Estevan',
    '63100': 'Yorkton - Melville - Esterhazy',
    # sub-regions
    '63111': 'R.M. of Garry',
    '63112': 'R.M. of Orkney',
    '63113': 'R.M. of Stanley',
    '63114': 'R.M. of Cana',
    '63121': 'R.M. of McLeod',
    '63122': 'R.M. of Grayson',
    '63131': 'R.M. of Wallace',
    '63132': 'R.M. of Calder',
    '63133': 'R.M. of Saltcoats',
    '63134': 'R.M. of Churchbridge',
    '63141': 'R.M. of Fertile Belt',
    '63142': 'R.M. of Langenburg',
    '63143': 'R.M. of Spy Hill',
    '63200': 'Moosomin - Grenfell - Kipling - Wawota',
    # sub-regions
    '63211': 'R.M. of Wolseley',
    '63212': 'R.M. of Elcapo and Cowessess First Nation',
    '63221': 'R.M. of Chester',
    '63222': 'R.M. of Hazelwood',
    '63223': 'R.M. of Golden West and Ocean Man First Nation',
    '63224': 'R.M. of Kingsley',
    '63231': 'R.M. of Silverwood',
    '63232': 'R.M. of Wawken',
    '63241': 'R.M. of Martin',
    '63242': 'R.M. of Moosomin',
    '63243': 'R.M. of Walpole',
    '63244': 'R.M. of Maryfield',
    '63251': 'R.M. of Willowdale and Ochapowace First Nation',
    '63252': 'R.M. of Rocanville',
    '63300': 'Carlyle - Oxbow - Carnduff - Bienfait - Stoughton',
    # sub-regions
    '63311': 'R.M. of Tecumseh',
    '63312': 'R.M. of Brock',
    '63321': 'R.M. of Browning',
    '63322': 'R.M. of Coalfields',
    '63331': 'R.M. of Moose Creek',
    '63332': 'R.M. of Enniskillen',
    '63341': 'R.M. of Moose Mountain',
    '63342': 'R.M. of Antler',
    '63351': 'R.M. of Storthoaks',
    '63352': 'R.M. of Reciprocity',
    '63353': 'R.M. of Mount Pleasant',
    '63354': 'R.M. of Argyle',
    '64100': 'Hudson Bay - Porcupine Plain',
    # sub-regions
    '64110': 'R.M. of Hudson Bay including Shoal Lake and Red Earth First Nations',
    '64120': 'R.M. of Hudson Bay including Hudson Bay proper and Reserve',
    '64130': 'R.M. of Porcupine',
    '64200': 'Kamsack - Canora - Preeceville',
    # sub-regions
    '64211': 'R.M. of Hazel Dell',
    '64212': 'R.M. of Preeceville',
    '64213': 'R.M. of Invermay',
    '64214': 'R.M. of Buchanan',
    '64221': 'R.M. of Insinger',
    '64222': 'R.M. of Good Lake',
    '64231': 'R.M. of Keys and The Key First Nation',
    '64232': 'R.M. of St. Philips',
    '64233': 'R.M. of Sliding Hills',
    '64234': 'R.M. of Cote',
    '64241': 'R.M. of Clayton',
    '64242': 'R.M. of Livingston',
    '65100': 'City of Saskatoon',
    '65200': 'Prince Albert - Shellbrook - Spiritwood - Duck Lake',
    # sub-regions
    '65211': 'R.M. of Spiritwood',
    '65212': 'R.M. of Canwood and Big River First Nation',
    '65221': 'R.M. of Meeting Lake and Lucky Man First Nation',
    '65222': 'R.M. of Leask and Mistawasis First Nation',
    '65230': 'R.M. of Shellbrook and Sturgeon Lake First Nation',
    '65240': 'R.M. of Duck Lake and Beardy\'s First Nation',
    '65251': 'R.M. of Lakeland',
    '65252': 'R.M. of Paddockwood',
    '65261': 'R.M. of Buckland and Wahpeton First Nation',
    '65262': 'R.M. of Garden River',
    '65263': 'City of Prince Albert',
    '65271': 'R.M. of Prince Albert',
    '65272': 'R.M. of Birch Hills and Muskoday First Nation',
    '65273': 'R.M. of St. Louis and One Arrow First Nation',
    '65300': 'Melfort - Tisdale - Nipawin - Carrot River',
    # sub-regions
    '65310': 'R.M. of Torch River',
    '65321': 'R.M. of Nipawin',
    '65322': 'R.M. of Moose Range',
    '65331': 'R.M. of Kinistino and James Smith First Nation',
    '65332': 'R.M. of Invergordon',
    '65333': 'R.M. of Flett\'s Springs',
    '65334': 'R.M. of Three Lakes',
    '65335': 'R.M. of Lake Lenore',
    '65341': 'R.M. of Willow Creek',
    '65342': 'R.M. of Connaught',
    '65343': 'R.M. of Star City',
    '65344': 'R.M. of Tisdale',
    '65345': 'R.M. of Pleasantdale',
    '65346': 'R.M. of Barrier Valley',
    '65351': 'R.M. of Arborfield',
    '65352': 'R.M. of Bjorkdale',
    '65400': 'Martensville - Warman - Rosthern - Delisle - Wakaw',
    # sub-regions
    '65411': 'R.M. of Redberry',
    '65412': 'R.M. of Blaine Lake',
    '65413': 'R.M. of Great Bend',
    '65421': 'R.M. of Laird',
    '65422': 'R.M. of Rosthern',
    '65431': 'R.M. of Eagle Creek',
    '65432': 'R.M. of Corman Park',
    '65433': 'R.M. of Perdue',
    '65434': 'R.M. of Vanscoy',
    '65441': 'R.M. of Aberdeen',
    '65442': 'R.M. of Fish Creek',
    '65443': 'R.M. of Hoodoo',
    '65444': 'R.M. of Grant',
    '65445': 'R.M. of Bayne',
    '65451': 'R.M. of Colonsay',
    '65452': 'R.M. of Viscount',
    '65453': 'R.M. of Blucher',
    '65500': 'Outlook - Watrous - Hanley - Imperial - Dinsmore',
    # sub-regions
    '65511': 'R.M. of Harris',
    '65512': 'R.M. of Montrose',
    '65513': 'R.M. of Milden',
    '65514': 'R.M. of Fertile Valley',
    '65515': 'R.M. of King George',
    '65516': 'R.M. of Coteau',
    '65521': 'R.M. of Dundurn',
    '65522': 'R.M. of Rudy',
    '65523': 'R.M. of Rosedale',
    '65524': 'R.M. of Loreburn',
    '65531': 'R.M. of Lost River',
    '65532': 'R.M. of Morris',
    '65533': 'R.M. of McCraney',
    '65534': 'R.M. of Wood Creek',
    '65541': 'R.M. of Arm River',
    '65542': 'R.M. of Willner',
    '65543': 'R.M. of Big Arm',
    '65600': 'Humboldt - Wynyard - Wadena - Lanigan - Foam Lake',
    # sub-regions
    '65611': 'R.M. of Humboldt',
    '65612': 'R.M. of St. Peter',
    '65613': 'R.M. of Wolverine',
    '65614': 'R.M. of Leroy',
    '65621': 'R.M. of Spalding',
    '65622': 'R.M. of Ponass Lake',
    '65623': 'R.M. of Lakeside',
    '65624': 'R.M. of Lakeview',
    '65631': 'R.M. of Usborne',
    '65632': 'R.M. of Prairie Rose',
    '65633': 'R.M. of Wreford',
    '65634': 'R.M. of Mount Hope',
    '65635': 'R.M. of Last Mountain Valley',
    '65641': 'R.M. of Big Quill',
    '65642': 'R.M. of Elfros',
    '65643': 'R.M. of Kutawa and Poor Man First Nation',
    '65644': 'R.M. of Emerald',
    '65645': 'R.M. of Touchwood',
    '65646': 'R.M. of Kellross',
    '65651': 'R.M. of Kelvington and Yellowquill First Nation',
    '65652': 'R.M. of Sasman',
    '65653': 'R.M. of Foam Lake and Fishing Lake First Nation',
    '65654': 'R.M. of Ituna Bon Accord',
    '66100': 'Meadow Lake - Big River - Green Lake - Pierceland',
    # sub-regions
    '66110': 'R.M. of Meadow Lake and Waterhen First Nation',
    '66120': 'R.M. of Beaver River',
    '66130': 'Green Lake',
    '66140': 'R.M. of Loon Lake',
    '66150': 'R.M. of Big River',
    '66200': 'The Battlefords - Unity - Maidstone - St. Walburg',
    # sub-regions
    '66211': 'R.M. of Frenchman Butte',
    '66212': 'R.M. of Mervin',
    '66213': 'R.M. of Turtle River',
    '66221': 'R.M. of Britannia',
    '66222': 'R.M. of Wilton',
    '66223': 'R.M. of Eldon',
    '66224': 'R.M. of Paynton',
    '66231': 'R.M. of Manitou Lake',
    '66232': 'R.M. of Hillsdale',
    '66233': 'R.M. of Senlac',
    '66234': 'R.M. of Round Valley',
    '66241': 'R.M. of Cut Knife',
    '66242': 'R.M. of Battle River and Sweet Grass First Nation',
    '66243': 'R.M. of Buffalo',
    '66244': 'R.M. of Prairie, Red Pheasant and Mosquito First Nations',
    '66251': 'R.M. of Parkdale',
    '66252': 'R.M. of Medstead',
    '66253': 'R.M. of Meota',
    '66254': 'R.M. of Round Hill',
    '66260': 'The Battlefords',
    '66271': 'R.M. of North Battleford',
    '66272': 'R.M. of Douglas',
    '66273': 'R.M. of Mayfield',
    '66280': 'R.M. of Glenside',
    '66300': 'Kindersley - Rosetown - Biggar - Wilkie - Macklin',
    # sub-regions
    '66311': 'R.M. of Eye Hill',
    '66312': 'R.M. of Grass Lake',
    '66313': 'R.M. of Heart\'s Hill',
    '66314': 'R.M. of Progress',
    '66321': 'R.M. of Tramping Lake',
    '66322': 'R.M. of Reform',
    '66323': 'R.M. of Mariposa',
    '66324': 'R.M. of Grandview',
    '66331': 'R.M. of Rosemount',
    '66332': 'R.M. of Biggar',
    '66341': 'R.M. of Antelope Park',
    '66342': 'R.M. of Prairiedale',
    '66343': 'R.M. of Milton',
    '66351': 'R.M. of Oakdale',
    '66352': 'R.M. of Winslow',
    '66353': 'R.M. of Kindersley',
    '66361': 'R.M. of Mountain View',
    '66362': 'R.M. of Marriott',
    '66363': 'R.M. of Pleasant Valley',
    '66364': 'R.M. of St. Andrews',
    '66371': 'R.M. of Chesterfield',
    '66372': 'R.M. of Newcombe',
    '66381': 'R.M. of Monet',
    '66382': 'R.M. of Snipe Lake',
    '66400': 'City of Lloydminster - SK',
    '67100': 'Ile a la Crosse - Buffalo Narrows - Beauval',
    # sub-regions
    '67110': 'Buffalo Narrows and Peter Pond Lake',
    '67120': 'Ile a la Crosse and Beauval',
    '67200': 'La Ronge - Prince Albert National Park - Narrow Hills Provincial Park',
    # sub-regions
    '67210': 'Highway 165 between Highway 2 and Route 914 including Pinehouse Lake',
    '67220': 'Lac La Ronge Provincial Park including La Ronge',
    '67230': 'Candle Lake and Narrow Hills Provincial Parks',
    '67240': 'Montreal Lake and Molanosa',
    '67250': 'Prince Albert National Park',
    '67300': 'Pelican Narrows - Cumberland House - Creighton',
    # sub-regions
    '67310': 'Highway 135 including Pelican Narrows and Sandy Bay',
    '67320': 'Seabee Mine',
    '67330': 'Hanson Lake Road east of Hwy 135 including Creighton',
    '67340': 'Hanson Lake Road between Highways 165 and 135',
    '67350': 'Cumberland House',
    '68100': 'Uranium City - Camsell Portage',
    '68200': 'Fond du Lac - Stony Rapids',
    # sub-regions
    '68210': 'Fond du Lac',
    '68220': 'Stony Rapids and Black Lake',
    '68300': 'La Loche - Clearwater River Provincial Park - Cluff Lake',
    # sub-regions
    '68310': 'Cluff Lake Mine',
    '68320': 'La Loche and Clearwater River Provincial Park',
    '68400': 'Cree Lake - Key Lake',
    '68500': 'Wollaston Lake - Collins Bay',
    '68600': 'Southend - Brabant Lake - Kinoosao',
    # Alberta
    '71100': 'Jasper National Park',
    # sub-regions
    '71110': 'Jasper National Park near Pocahontas',
    '71120': 'Jasper National Park near Jasper',
    '71130': 'Jasper National Park near Columbia Icefield and Sunwapta Falls',
    '71200': 'Nordegg - Forestry Trunk Road Highway 734',
    # sub-regions
    '71210': 'Yellowhead County near Cadomin and Robb',
    '71220': 'Clearwater County near Chungo Creek',
    '71230': 'Clearwater County near Nordegg and Big Horn First Nation',
    '71240': 'Clearwater County near Ya-Ha-Tinda Ranch',
    '71300': 'Rocky Mountain House - Caroline',
    # sub-regions
    '71310': 'M.D. of Brazeau near Cynthia and Lodgepole',
    '71320': 'Yellowhead County near Wolf Lake and Dismal Creek',
    '71330': 'Clearwater County near Sunchild First Nation',
    '71340': 'M.D. of Brazeau near the Brazeau Dam',
    '71350': 'Clearwater County near Rocky Mountain House and Crimson Lake',
    '71360': 'Clearwater County near Caroline and James River Bridge',
    '71400': 'Banff National Park',
    # sub-regions
    '71410': 'Clearwater County near Siffleur Wilderness area',
    '71420': 'Banff National Park near Saskatchewan River Crossing',
    '71430': 'Banff National Park near Lake Louise',
    '71440': 'Banff National Park near Banff',
    '71500': 'Kananaskis - Canmore',
    # sub-regions
    '71510': 'M.D. of Bighorn near Ghost River Wilderness',
    '71520': 'M.D. of Bighorn near Canmore, Bow Valley Park and Ghost Lake',
    '71530': 'Northern Kananaskis Country near Peter Lougheed Provincial Park',
    '71540': 'Southern Kananaskis Country near Highwood and Cataract Creek',
    '72100': 'Red Deer - Ponoka - Innisfail - Stettler',
    # sub-regions
    '72111': 'Lacombe County near Eckville',
    '72112': 'Lacombe County near Lacombe, Blackfalds and Gull Lake',
    '72113': 'Lacombe County near Clive and Alix',
    '72121': 'Red Deer County near Sylvan Lake',
    '72122': 'Red Deer County near Spruce View and Red Lodge Provincial Park',
    '72123': 'Red Deer County near Penhold, Innisfail and Bowden',
    '72124': 'Red Deer County near Pine Lake',
    '72125': 'Red Deer County near Elnora, Lousana and Delburne',
    '72131': 'County of Stettler near Stettler, Erskine and Rochon Sands',
    '72132': 'County of Stettler near Big Valley',
    '72133': 'County of Stettler near Donalda',
    '72134': 'County of Stettler near Gadsby',
    '72135': 'County of Stettler near Byemoor',
    '72140': 'City of Red Deer',
    '72150': 'County of Paintearth near Halkirk',
    '72160': 'Flagstaff County near Forestburg',
    '72170': 'County of Camrose near Bashaw',
    '72180': 'Ponoka county near Ponoka, Hobbema and the Sampson First Nation',
    '72200': 'Airdrie - Cochrane - Olds - Sundre',
    # sub-regions
    '72210': 'Mountain View County near Sundre',
    '72220': 'Mountain View County near Olds and Didsbury',
    '72230': 'Mountain View County near Cremona',
    '72240': 'Mountain View County near Carstairs',
    '72250': 'M.D. of Rocky View near Airdrie and Crossfield',
    '72260': 'M.D. of Rocky View near Bottrell',
    '72270': 'M.D. of Rocky View near Cochrane',
    '72300': 'Drumheller - Three Hills',
    # sub-regions
    '72311': 'Kneehill County near Torrington',
    '72312': 'Kneehill County near Trochu and Dry Island Buffalo Jump Park',
    '72313': 'Kneehill County near Three Hills',
    '72321': 'Kneehill County near Linden and Acme',
    '72322': 'Kneehill County near Carbon',
    '72331': 'Starland County near Rumsey',
    '72332': 'Starland County near Morrin',
    '72333': 'Starland County near Delia',
    '72341': 'Wheatland County near Rockyland and Rosebud',
    '72342': 'Wheatland County near Highways 569 and 848',
    '72350': 'Town of Drumheller',
    '72360': 'M.D. of Rocky View near Irricana and Kathryn',
    '72370': 'Special Area 2 near Finnegan and Little Fish Lake Provincial Park',
    '72400': 'City of Calgary',
    '72500': 'Okotoks - High River - Claresholm',
    # sub-regions
    '72510': 'M.D. of Rocky View near Sarcee First Nation',
    '72521': 'M.D. of Foothills near Priddis',
    '72522': 'M.D. of Foothills near Turner Valley',
    '72523': 'M.D. of Foothills near Longview',
    '72531': 'M.D. of Foothills near Okotoks',
    '72532': 'M.D. of Foothills near High River',
    '72533': 'M.D. of Foothills near Cayley',
    '72541': 'M.D. of Willow Creek near Nanton',
    '72542': 'M.D. of Willow Creek near Claresholm and Stavely',
    '72600': 'Brooks - Strathmore - Vulcan',
    # sub-regions
    '72610': 'M.D. of Rocky View near Langdon and Dalemead',
    '72620': 'M.D. of Foothills near Blackie',
    '72631': 'Wheatland County near Strathmore, Carseland and Lyalta',
    '72632': 'Wheatland County near Standard',
    '72633': 'Wheatland County near Siksika First Nation and Gleichen',
    '72634': 'Wheatland County near Hussar',
    '72641': 'Vulcan County near Mossleigh and Arrowwood',
    '72642': 'Vulcan County near Vulcan and ensign',
    '72643': 'Vulcan County near Champion',
    '72644': 'Vulcan County near Lomond',
    '72645': 'Vulcan County near Milo',
    '72651': 'Newell County near Bassano',
    '72652': 'Newell County near Gem',
    '72653': 'Newell County near Brooks and Rosemary',
    '72654': 'Newell County near Scandia and Bow City',
    '72660': 'M.D. of Taber near Enchant',
    '73100': 'Crowsnest Pass - Pincher Creek - Waterton Park',
    # sub-regions
    '73110': 'M.D. of Ranchland including Chain Lakes Provincial Park',
    '73120': 'M.D. of Pincher Creek near Cowley',
    '73130': 'Peigan First Nation',
    '73140': 'Municipality of Crowsnest Pass',
    '73150': 'M.D. of Pincher Creek near Beauvais Lake Provincial Park',
    '73160': 'M.D. of Pincher Creek near Pincher Creek and Twin Butte',
    '73170': 'Waterton Lakes National Park',
    '73200': 'Cardston - Fort MacLeod - Magrath',
    # sub-regions
    '73211': 'M.D. of Willow Creek near Granum',
    '73212': 'M.D. of Willow Creek near Fort MacLeod',
    '73221': 'Blood First Nation including Stand Off',
    '73222': 'Cardston county near Glenwood',
    '73231': 'Cardston county near Magrath and Spring Coulee',
    '73232': 'Cardston county near Del Bonita and Whiskey Gap',
    '73241': 'Cardston county near Mountain View and Police Outpost Provincial Park',
    '73242': 'Cardston county near Cardston and Carway',
    '73300': 'Lethbridge - Taber - Milk River',
    # sub-regions
    '73311': 'Lethbridge County near Barons and Nobleford',
    '73312': 'Lethbridge County near Picture Butte and Turin',
    '73313': 'Lethbridge County near Coaldale',
    '73314': 'City of Lethbridge',
    '73321': 'M.D. of Taber near Vauxhall and Hayes',
    '73322': 'M.D. of Taber near Taber and Cranford',
    '73323': 'M.D. of Taber near Grassy Lake',
    '73331': 'Warner County near Raymond and New Dayton',
    '73332': 'Warner County near Wrentham',
    '73341': 'Warner County near Warner',
    '73342': 'Warner County near Milk River and Coutts',
    '73343': 'Warner County near Writing-On-Stone Provincial Park',
    '73350': 'County of Forty Mile near Skiff',
    '74100': 'Hanna - Coronation - Oyen',
    # sub-regions
    '74111': 'County of Paintearth near Castor',
    '74112': 'County of Paintearth near Brownfield',
    '74113': 'County of Paintearth near Coronation',
    '74121': 'Special Area 2 near Scapa',
    '74122': 'Special Area 2 near Hanna and Richdale',
    '74123': 'Special Area 2 near Sunnynook',
    '74124': 'Special Area 2 near Cessford',
    '74131': 'Special Area 4 near Veteran and Consort',
    '74132': 'Special Area 4 near Hemaruka',
    '74133': 'Special Area 4 near Kirriemuir and Compeer',
    '74141': 'Special Area 3 near Youngstown',
    '74142': 'Special Area 3 near Big Stone',
    '74143': 'Special Area 3 near New Brigden',
    '74144': 'Special Area 3 near Cereal and Oyen',
    '74145': 'Special Area 3 near Sibbald',
    '74150': 'M.D. of Provost near Bodo',
    '74160': 'M.D. of Acadia including Acadia Valley',
    '74200': 'Medicine Hat - Bow Island - Suffield',
    # sub-regions
    '74211': 'Cypress County near Tide Lake',
    '74212': 'Cypress County near Suffield',
    '74221': 'Special Area 2 near Dinosaur Provincial Park',
    '74222': 'Special Area 2 near Jenner',
    '74223': 'Special Area 2 near Buffalo',
    '74224': 'Special Area 2 near Bindloss and Empress',
    '74231': 'Newell County near Patricia',
    '74232': 'Newell County near Tilley and Rolling Hills',
    '74241': 'Cypress County near CFB Suffield',
    '74242': 'Cypress County near Redcliff',
    '74251': 'Cypress County near Seven Persons',
    '74252': 'Cypress County near Dunmore',
    '74253': 'Cypress County near Irvine and Walsh',
    '74261': 'Cypress County near Schuler',
    '74262': 'Cypress County near McNeill',
    '74270': 'City of Medicine Hat',
    '74280': 'County of Forty Mile near Bow Island and Whitla',
    '74300': 'Cypress Hills Provincial Park - Foremost',
    # sub-regions
    '74310': 'County of Forty Mile near Foremost',
    '74320': 'County of Forty Mile near Etzikom',
    '74330': 'County of Forty Mile near Manyberries',
    '74340': 'Cypress County near Cypress Hills Provincial Park',
    '74350': 'County of Forty Mile near Aden',
    '74360': 'Cypress County near Onefour',
    '75100': 'Bonnyville - St. Paul - Cold Lake - Lac La Biche',
    # sub-regions
    '75111': 'Lakeland County near Plamondon',
    '75112': 'Lakeland County near Imperial Mills, Heart Lake and Philomena',
    '75113': 'Lakeland County near Lac La Biche and Sir Winston Churchill Park',
    '75114': 'Lakeland County near Lakeland Provincial Park',
    '75115': 'Lakeland County near Rich Lake',
    '75116': 'Lakeland County near Cold Lake air weapons range',
    '75121': 'Smoky Lake County near Kikino',
    '75122': 'Smoky Lake County near Vilna and Whitefish Lake First Nation',
    '75131': 'County of St. Paul near Ashmont',
    '75132': 'County of St. Paul near St. Paul',
    '75133': 'County of St. Paul near Elk Point',
    '75134': 'County of St. Paul near Riverview and Unipouheos First Nation',
    '75141': 'M.D. of Bonnyville near La Corey and Wolf Lake',
    '75142': 'M.D. of Bonnyville near Glendon and Moose Lake Provincial Park',
    '75143': 'M.D. of Bonnyville near Bonnyville and Ardmore',
    '75144': 'M.D. of Bonnyville near Cold Lake and Grand Centre',
    '75145': 'M.D. of Bonnyville near Beaverdam, Elizabeth and Cold Lake First Nation',
    '75146': 'M.D. of Bonnyville near Sputinow',
    '75200': 'Lloydminster - Wainwright - Vermilion - Provost',
    # sub-regions
    '75211': 'County of Two Hills near Two Hills',
    '75212': 'County of Two Hills near Myrnam and Derwent',
    '75221': 'County of Minburn near Ranfurly and Innisfree',
    '75222': 'County of Minburn near Mannville and Minburn',
    '75230': 'Beaver County near Viking',
    '75241': 'Flagstaff County near Killam and Sedgewick',
    '75242': 'Flagstaff County near Lougheed and Hardisty',
    '75243': 'Flagstaff County near Alliance',
    '75251': 'County of Vermilion River near Vermilion',
    '75252': 'County of Vermilion River near Islay',
    '75253': 'County of Vermilion River near Clandonald and Dewberry',
    '75254': 'County of Vermilion River near Tulliby Lake',
    '75255': 'County of Vermilion River near Kitscoty and Marwayne',
    '75256': 'County of Vermilion River near Paradise Valley',
    '75260': 'City of Lloydminster - AB',
    '75271': 'M.D. of Wainwright near Irma',
    '75272': 'M.D. of Wainwright near Wainwright',
    '75273': 'M.D. of Wainwright near Edgerton',
    '75274': 'M.D. of Wainwright near Chauvin',
    '75281': 'M.D. of Provost near Hughenden',
    '75282': 'M.D. of Provost near Czar and Metiskow',
    '75283': 'M.D. of Provost near Provost',
    '76100': 'Westlock - Barrhead - Athabasca',
    # sub-regions
    '76110': 'Woodlands County near Fort Assiniboine',
    '76121': 'County of Barrhead near Thunder Lake Provincial Park',
    '76122': 'County of Barrhead near Bloomsbury and Neerlandia',
    '76123': 'County of Barrhead near Barrhead and Lac La Nonne',
    '76130': 'M.D. of Lesser Slave River near Chisholm and Cross Lake Park',
    '76141': 'Westlock County near Jarvie',
    '76142': 'Westlock County near Westlock and Clyde',
    '76151': 'County of Athabasca near Athabasca and Island Lake',
    '76152': 'County of Athabasca near Rochester and Meanook',
    '76153': 'County of Athabasca near Grassland',
    '76154': 'County of Athabasca near Boyle and Caslan',
    '76160': 'County of Thorhild near Newbrook and Long Lake Provincial Park',
    '76200': 'Spruce Grove - Morinville - Mayerthorpe - Evansburg',
    # sub-regions
    '76210': 'Yellowhead County near Evansburg, Wildwood and MacKay',
    '76221': 'Lac Ste. Anne County near Mayerthorpe and Sangudo',
    '76222': 'Lac Ste. Anne County near Cherhill and Glenevis',
    '76223': 'Lac Ste. Anne County near Onoway, Rich Valley and Lac Ste. Anne',
    '76231': 'Parkland County near Tomahawk and Entwistle',
    '76232': 'Parkland County near Wabamun Lake Provincial Park',
    '76233': 'Parkland County near Stony Plain and Spruce Grove',
    '76241': 'Sturgeon County near Calahoo, Villeneuve and Riviere Qui Barre',
    '76242': 'Sturgeon County near Legal and Mearns',
    '76243': 'Sturgeon County near Morinville',
    '76300': 'Fort Saskatchewan - Vegreville - Redwater - Smoky Lake',
    # sub-regions
    '76310': 'County of Thorhild near Thorhild',
    '76321': 'Sturgeon County near Bon Accord and Gibbons',
    '76322': 'Sturgeon County near Redwater',
    '76331': 'Lamont County near Bruderheim and Lamont',
    '76332': 'Lamont County near Andrew',
    '76333': 'Lamont County near Mundare and Chipman',
    '76340': 'Smoky Lake County near Smoky Lake and Waskatenau',
    '76350': 'County of Two Hills near Willingdon',
    '76360': 'City of Fort Saskatchewan and Northern Strathcona County',
    '76370': 'Elk Island National Park',
    '76380': 'County of Minburn near Vegreville',
    '76400': 'City of Edmonton - St. Albert - Sherwood Park',
    '76500': 'Drayton Valley - Devon - Rimbey - Pigeon Lake',
    # sub-regions
    '76510': 'Leduc County near Warburg and Thorsby',
    '76520': 'Leduc County near Devon and Calmar',
    '76530': 'M.D. of Brazeau near Drayton Valley and Breton',
    '76540': 'County of Wetaskiwin near Pigeon Lake',
    '76550': 'County of Wetaskiwin near Alder Flats and Winfield',
    '76560': 'Ponoka County near Rimbey, Bluffton and Hoadley',
    '76570': 'Ponoka County near Crestomere',
    '76600': 'Leduc - Camrose - Wetaskiwin - Tofield',
    # sub-regions
    '76611': 'Leduc County near Leduc and Beaumont',
    '76612': 'Leduc County near New Sarepta',
    '76620': 'County of Wetaskiwin near Wetaskiwin, Millet and Gwynne',
    '76630': 'Strathcona County near Cooking Lake',
    '76641': 'Beaver County near Tofield',
    '76642': 'Beaver County near Ryley and Holden',
    '76651': 'County of Camrose near Hay Lakes and Miquelon Lake Provincial Park',
    '76652': 'County of Camrose near Camrose',
    '76653': 'County of Camrose near New Norway',
    '76654': 'County of Camrose near Bawlf',
    '76660': 'Flagstaff County near Daysland',
    '77100': 'Grande Prairie - Beaverlodge - Valleyview',
    # sub-regions
    '77111': 'County of Grande Prairie near Beaverlodge, Hythe and Demmitt',
    '77112': 'County of Grande Prairie near Sexsmith and La Glace',
    '77113': 'County of Grande Prairie near Grande Prairie and Wembley',
    '77121': 'M.D. of Greenview near Amundson',
    '77122': 'M.D. of Greenview near DeBolt',
    '77123': 'M.D. of Greenview near Little Smoky',
    '77124': 'M.D. of Greenview near Young\'s Point and Sturgeon Lake First Nation',
    '77125': 'M.D. of Greenview near Valleyview',
    '77200': 'Hinton - Grande Cache',
    # sub-regions
    '77210': 'M.D. of Greenview near Grande Cache',
    '77220': 'M.D. of Greenview near Kakwa Wildland Provincial Park',
    '77230': 'Yellowhead County near William A. Switzer Provincial Park',
    '77240': 'Willmore Wilderness Park',
    '77250': 'Yellowhead County near Hinton and Obed Lake Provincial Park',
    '77300': 'Slave Lake',
    # sub-regions
    '77311': 'M.D. of Big Lakes near Joussard and East Prairie',
    '77312': 'M.D. of Big Lakes near Grouard Mission and Hilliards Bay Park',
    '77313': 'M.D. of Big Lakes near Faust and Kinuso',
    '77321': 'M.D. of Lesser Slave River near Slave Lake',
    '77322': 'M.D. of Lesser Slave River near Slave Lake Provincial Park',
    '77323': 'M.D. of Lesser Slave River near Smith',
    '77330': 'M.D. of Opportunity near Calling Lake',
    '77340': 'County of Athabasca near Wandering River',
    '77400': 'Whitecourt - Edson - Fox Creek - Swan Hills',
    # sub-regions
    '77410': 'M.D. of Greenview near Fox Creek',
    '77421': 'Yellowhead County near Edson and Marlboro',
    '77422': 'Yellowhead County near Peers and Niton Junction',
    '77431': 'Woodlands County near Windfall Creek',
    '77432': 'Woodlands County near Carson-Pegasus Provincial Park',
    '77433': 'Woodlands County near Lone Pine',
    '77434': 'Woodlands County near Whitecourt and Blue Ridge',
    '77440': 'M.D. of Big Lakes near Swan Hills',
    '78100': 'High Level - Rainbow Lake - Fort Vermilion - Mackenzie Highway',
    # sub-regions
    '78111': 'M.D. of Mackenzie near Bistcho Lake',
    '78112': 'M.D. of Mackenzie near Zama Lake, Chateh and Rainbow Lake',
    '78113': 'M.D. of Mackenzie near Indian Cabins and Steen River',
    '78114': 'M.D. of Mackenzie near Meander River',
    '78115': 'M.D. of Mackenzie near High Level',
    '78120': 'M.D. of Northern Lights near Paddle Prairie and Carcajou',
    '78131': 'M.D. of MacKenzie near the Caribou Mountains',
    '78132': 'M.D. of Mackenzie near Fort Vermilion and Child Lake First Nation',
    '78133': 'M.D. of MacKenzie near John D\'or Prairie and Fox Creek',
    '78134': 'M.D. of Mackenzie near Buffalo Head Prairie and La Crete',
    '78135': 'M.D. of Mackenzie near Tall Cree First Nation and Wadlin Lake',
    '78200': 'Peace River - Fairview - High Prairie - Manning',
    # sub-regions
    '78211': 'M.D. of Clear Hills near Notikewin River',
    '78212': 'M.D. of Clear Hills near Cleardale and Worsley',
    '78213': 'M.D. of Clear Hills near Eureka River and Hines Creek',
    '78221': 'Saddle Hills County near Silver Valley and Bay Tree',
    '78222': 'Saddle Hills County near Moonshine Lake Provincial Park',
    '78223': 'Saddle Hills County near Woking',
    '78231': 'M.D. of Spirit River including Spirit River and Rycroft',
    '78232': 'M.D. of Fairview including Fairview, Whitelaw and Dunvegan Provincial Park',
    '78233': 'M.D. of Peace including Peace River and Grimshaw',
    '78241': 'M.D. of Northern Lights near Manning and Notikewin Provincial Park',
    '78242': 'M.D. of Northern Lights near Dixonville and Chinook Valley',
    '78251': 'Birch Hills County near Wanham and Peoria',
    '78252': 'Birch Hills County near Eaglesham',
    '78261': 'M.D. of East Peace near Keppler Creek',
    '78262': 'M.D. of East Peace near Nampa and Three Creeks',
    '78270': 'M.D. of Smoky River including McLennan, Falher and Girouxville',
    '78280': 'M.D. of Big Lakes near High Prairie and Winagami Lake Provincial Park',
    '78300': 'Wabasca - Peerless Lake - Gift Lake - Cadotte Lake',
    # sub-regions
    '78311': 'M.D. of East Peace near Bison Lake',
    '78312': 'M.D. of East Peace near Woodland Cree First Nation and Little Buffalo',
    '78313': 'M.D. of East Peace near Utikoomak Lake First Nation',
    '78320': 'M.D. of Big Lakes near Peavine and Gift Lake settlements',
    '78331': 'M.D. of Opportunity near Peerless Lake and Trout Lake',
    '78332': 'M.D. of Opportunity near Red Earth Creek',
    '78333': 'M.D. of Opportunity near Wabasca-Desmarais and Sandy Lake',
    '78334': 'M.D. of Opportunity near Chipewyan Lake',
    '79100': 'Fort Chipewyan - Wood Buffalo National Park',
    # sub-regions
    '79111': 'Wood Buffalo National Park near Buffalo river',
    '79112': 'Wood Buffalo National Park near Hay Camp',
    '79113': 'Wood Buffalo National Park near Garden Creek',
    '79114': 'Wood Buffalo National Park near Peace Point and Lake Claire',
    '79121': 'R.M. of Wood Buffalo near Namur River',
    '79122': 'R.M. of Wood Buffalo near Fort Hills',
    '79123': 'R.M. of Wood Buffalo near Old Fort and Chipewyan First Nation',
    '79131': 'R.M. of Wood Buffalo near Fitzgerald',
    '79132': 'R.M. of Wood Buffalo near Colin-Cornwall Lakes Wildland Park',
    '79133': 'R.M. of Wood Buffalo near Fort Chipewyan',
    '79200': 'Fort McMurray - Fort MacKay',
    # sub-regions
    '79210': 'R.M. of Wood Buffalo near Fort Mackay',
    '79220': 'R.M. of Wood Buffalo near Fort McMurray',
    '79230': 'R.M. of Wood Buffalo near Anzac and Gregoire Lake Provincial Park',
    '79240': 'Lakeland County near Highway 63 and Crow Lake Provincial Park',
    '79250': 'R.M. of Wood Buffalo near Conklin and Chard',
    # British Columbia
    '81100': 'Haida Gwaii',
    '81200': 'North Vancouver Island',
    # sub-regions
    '81210': 'North- and west-facing coasts',
    '81220': 'East-facing coasts',
    '81300': 'East Vancouver Island',
    '81400': 'West Vancouver Island',
    # sub-regions
    '81410': 'Sombrio Point and north',
    '81420': 'South of Sombrio Point',
    '81500': 'Inland Vancouver Island',
    '81600': 'Greater Victoria',
    '82100': 'Central Coast - Coastal sections',
    '82200': 'Central Coast - Inland sections',
    '82300': 'Sunshine Coast',
    '82400': 'Whistler',
    '82500': 'Howe Sound',
    '82600': 'Metro Vancouver',
    '82700': 'Fraser Valley',
    # sub-regions
    '82710': 'West including Abbotsford',
    '82720': 'East including Chilliwack',
    '82800': 'Southern Gulf Islands',
    '83100': 'Fraser Canyon',
    '83200': 'South Thompson',
    '83300': 'Nicola',
    '83400': 'Similkameen',
    '83500': 'Okanagan Valley',
    # sub-regions
    '83510': 'North including Vernon',
    '83520': 'Central including Kelowna',
    '83530': 'South including Penticton',
    '83600': 'Shuswap',
    '84100': 'Arrow and Slocan Lakes',
    '84200': 'Boundary',
    '84300': 'West Kootenay',
    '84400': 'Kootenay Lake',
    '84500': 'East Kootenay',
    # sub-regions
    '84510': 'South including Cranbrook',
    '84520': 'North including Invermere',
    '84600': 'Elk Valley',
    '85100': 'North Thompson',
    '85200': 'North Columbia',
    '85300': 'Kinbasket',
    '85400': 'West Columbia',
    '85500': 'East Columbia',
    '85600': 'Yoho and Kootenay Parks',
    '86100': 'Chilcotin',
    '86200': 'Cariboo',
    # sub-regions
    '86210': 'North including Quesnel',
    '86220': 'South including Williams Lake',
    '86300': '100 Mile',
    '86400': 'Yellowhead',
    '87100': 'Bulkley Valley - The Lakes',
    # sub-regions
    '87110': 'Northwest including Smithers',
    '87120': 'Southeast including Burns Lake',
    '87200': 'Williston',
    '87300': 'BC Peace River',
    # sub-regions
    '87310': 'South',
    '87320': 'North',
    '87400': 'Prince George',
    '87500': 'McGregor',
    '88100': 'Fort Nelson',
    '88200': 'Muncho Lake and Stone Mountain Provincial Parks',
    '88300': 'Watson Lake - BC',
    '89100': 'North Coast - Coastal sections',
    # sub-regions
    '89110': 'Banks Island and north',
    '89120': 'South of Banks Island',
    '89200': 'North Coast - Inland sections',
    # sub-regions
    '89210': 'North of Kitimat',
    '89220': 'Kitimat and south',
    '89300': 'Dease Lake',
    '89400': 'Cassiar Mountains - BC',
    '89500': 'Teslin - BC',
    '89600': 'Atlin',
    '89700': 'South Klondike Highway - Carcross to White Pass',
    '89800': 'Haines Road - Haines Junction to Pleasant Camp',
    # Yukon
    '91100': 'Dawson',
    '91200': 'Mayo',
    '91300': 'Beaver Creek',
    '91400': 'Pelly - Carmacks',
    '91500': 'Kluane Lake',
    '91600': 'Haines Junction',
    '91700': 'Whitehorse',
    '92100': 'Teslin - YT',
    '92200': 'Cassiar Mountains - YT',
    '92300': 'Watson Lake - YT',
    '92400': 'Faro - Ross River',
    '93100': 'Dempster',
    '93200': 'Old Crow',
    # Northwest Territories
    '94210': 'Wrigley Region',
    '94220': 'Fort Simpson Region including Jean Marie River',
    '94230': 'Fort Liard Region including Nahanni Butte - Trout Lake',
    '94310': 'North Slave Region including Wekweti - Wha Ti - Behchoko',
    '94320': 'Fort Providence Region including Kakisa - Chan Lake',
    '94330': 'Yellowknife Region',
    '94510': 'Hay River Region including Enterprise',
    '94520': 'Fort Resolution Region including Highway 6',
    '94530': 'Lutsel K\'e Region',
    '94540': 'Thebacha Region including Fort Smith - Salt River Reserve',
    '95100': 'Tuktoyaktuk - East Channel Region',
    '95200': 'Aklavik Region',
    '95300': 'Inuvik Region',
    '95400': 'South Delta Region including Fort McPherson - Tsiigehtchic',
    '95610': 'Fort Good Hope Region',
    '95620': 'Norman Wells - Tulita Region',
    '95630': 'Colville Lake',
    '95640': 'Deline',
    '95800': 'Paulatuk',
    '96210': 'Sachs Harbour',
    '96310': 'Ulukhaktok',
    # Nunavut
    '97110': 'Cambridge Bay',
    '97210': 'Kugluktuk',
    '97310': 'Taloyoak',
    '97410': 'Gjoa Haven',
    '97420': 'Kugaaruk',
    '97510': 'Baker Lake',
    '97610': 'Arviat',
    '97620': 'Rankin Region including Whale Cove',
    '97630': 'Chesterfield Inlet',
    '97710': 'Hall Beach',
    '97720': 'Igloolik',
    '97740': 'Repulse Bay',
    '97810': 'Coral Harbour',
    '97820': 'Sanikiluaq',
    '98110': 'Arctic Bay',
    '98120': 'Pond Inlet',
    '98130': 'Clyde River',
    '98210': 'Qikiqtarjuaq',
    '98220': 'Pangnirtung',
    '98230': 'Iqaluit',
    '98240': 'Kimmirut',
    '98250': 'Cape Dorset',
    '99110': 'Resolute',
    '99210': 'Grise Fjord',
    'XXXXX': 'TEST',
}

MX_SAME_CODE = {
    '09001': 'Alguna Del',
    '09003': 'Cuauhtemoc',
    '09004': 'Iztacalco',
    '09005': 'Benito Juarez',
    '09007': 'Coyoacan',
    '09011': 'Tlalpan',
    'XXXXX': 'TEST',
}

SAME_LOCA = {
    '0': None,
    '1': 'Northwest',
    '2': 'North Central',
    '3': 'Northeast',
    '4': 'West Central',
    '5': 'Central',
    '6': 'East Central',
    '7': 'Southwest',
    '8': 'South Central',
    '9': 'Southeast',
}

SAME_LOCB = {
    '0': None,
    '1': 'MOUNTAIN/HIGH',
    '2': 'MOUNTAIN',
    '3': 'VALLEY',
}

# SAME_CTYB is a list of "B" class counties for geographic subdivisons. If this applies to your area, add your county code to this list, and modify SAME_LOCB as needed.
# A, C and D counties all use SAME_LOCA

SAME_CTYB = ['SAME1', 'SAME2']

SAME__ORG = {
    'EN':
{
    '': None,
    'EAS': {'NAME': {'US': 'Broadcast station or cable system', 'CA': 'Broadcast station or cable system', 'MX': 'A1'},
            'PLURAL': False, 'ARTICLE': {'US': 'A', 'CA': 'A', 'MX': 'A2'}},
    'CIV': {'NAME': {'US': 'Civil authorities', 'CA': 'Civil authorities', 'MX': 'Civil Protection'}, 'PLURAL': True,
            'ARTICLE': {'US': 'THE', 'CA': 'THE', 'MX': ''}},
    'WXR': {
        'NAME': {'US': 'National Weather Service', 'CA': 'Environment Canada', 'MX': 'Secretary of Civil Protection'},
        'PLURAL': False, 'ARTICLE': {'US': 'THE', 'CA': '', 'MX': 'THE'}},
    'PEP': {'NAME': {'US': 'Primary Entry Point System', 'CA': 'Primary Entry Point System', 'MX': 'D1'},
            'PLURAL': False, 'ARTICLE': {'US': 'THE', 'CA': 'THE', 'MX': 'D2'}},
    'EAN': {'NAME': {'US': 'Emergency Action Notification Network ', 'CA': 'Emergency Action Notification Network ',
                     'MX': 'E1'}, 'PLURAL': False, 'ARTICLE': {'US': 'THE', 'CA': 'THE', 'MX': 'E2'}},
},
    'SP':
{
    '': None,
    'EAS': {'NAME': {'US': 'Estación de transmisión o sistema de cable', 'CA': 'Estación de transmisión o sistema de cable', 'MX': 'A1'},
            'PLURAL': False, 'ARTICLE': {'US': 'A', 'CA': 'A', 'MX': 'A2'}},
    'CIV': {'NAME': {'US': 'Autoridades Civiles', 'CA': 'Autoridades Civiles', 'MX': 'Proteccion Civil'}, 'PLURAL': True,
            'ARTICLE': {'US': 'THE', 'CA': 'THE', 'MX': ''}},
    'WXR': {
        'NAME': {'US': 'National Weather Service', 'CA': 'Environment Canada', 'MX': 'Secretaria de Protecion Civil'},
        'PLURAL': False, 'ARTICLE': {'US': 'THE', 'CA': '', 'MX': 'THE'}},
    'PEP': {'NAME': {'US': 'Sistema de punto de entrada principal', 'CA': 'Sistema de punto de entrada principal', 'MX': 'D1'},
            'PLURAL': False, 'ARTICLE': {'US': 'THE', 'CA': 'THE', 'MX': 'D2'}},
    'EAN': {'NAME': {'US': 'Red de notificación de acciones de emergencia ', 'CA': 'Red de notificación de acciones de emergencia ',
                     'MX': 'E1'}, 'PLURAL': False, 'ARTICLE': {'US': 'THE', 'CA': 'THE', 'MX': 'E2'}},
}
}

SAME_UEEE = {
    'W': 'Warning',
    'A': 'Watch',
    'E': 'Emergency',
    'S': 'Statement',
    'T': 'Test',
    'M': 'Message',
    'R': 'Warning',
    'N': 'Notification',
}

# SAME__EEE is a list of current and proposed event codes.

SAME__EEE = {
    '': None,
    'BZW': 'Blizzard Warning',
    'CFA': 'Coastal Flood Watch',
    'CFW': 'Coastal Flood Warning',
    'DSW': 'Dust Storm Warning',
    'EWW': 'Extreme Wind Warning',
    'FFA': 'Flash Flood Watch',
    'FFW': 'Flash Flood Warning',
    'FFS': 'Flash Flood Statement',
    'FLA': 'Flood Watch',
    'FLW': 'Flood Warning',
    'FLS': 'Flood Statement',
    'HWA': 'High Wind Watch',
    'HWW': 'High Wind Warning',
    'HUA': 'Hurricane Watch',
    'HUW': 'Hurricane Warning',
    'HLS': 'Hurricane Statement',
    'SVA': 'Severe Thunderstorm Watch',
    'SVR': 'Severe Thunderstorm Warning',
    'SVS': 'Severe Weather Statement',
    'SQW': 'Snow Squall Warning',
    'SMW': 'Special Marine Warning',
    'SPS': 'Special Weather Statement',
    'TOA': 'Tornado Watch',
    'TOR': 'Tornado Warning',
    'TRA': 'Tropical Storm Watch',
    'TRW': 'Tropical Storm Warning',
    'TSA': 'Tsunami Watch',
    'TSW': 'Tsunami Warning',
    'WSA': 'Winter Storm Watch',
    'WSW': 'Winter Storm Warning',
    'EAN': 'Emergency Action Notification',
    'EAT': 'Emergengy Action Termination',
    'NIC': 'National Information Center',
    'NPT': 'National Periodic Test',
    'NAT': 'National Audible Test',
    'NST': 'National Silent Test',
    'RMT': 'Required Monthly Test',
    'RWT': 'Required Weekly Test',
    'ADR': 'Administrative Message',
    'AVA': 'Avalanche Watch',
    'AVW': 'Avalanche Warning',
    'CAE': 'Child Abduction Emergency',
    'CDW': 'Civil Danger Warning',
    'CEM': 'Civil Emergency Message',
    'EQW': 'Earthquake Warning',
    'EVI': 'Evacuation Immediate',
    'FRW': 'Fire Warning',
    'HMW': 'Hazardous Materials Warning',
    'LEW': 'Law Enforcement Warning',
    'LAE': 'Local Area Emergency',
    'TOE': '911 Outage Emergency',
    'NUW': 'Nuclear Plant Warning',
    'RHW': 'Radiological Hazard Warning',
    'SPW': 'Shelter in Place Warning',
    'VOW': 'Volcano Warning',
    'NMN': 'Network Message Notification',
    'DMO': 'Demo Warning',
    'SSA': 'Storm Surge Watch',
    'SSW': 'Storm Surge Warning',
    'FSW': 'Flash Freeze Warning',
    'FZW': 'Freeze Warning',
    'HLS': 'Hurricane Local Statement',
    'SMW': 'Special Marine Warning',
    'BHW': 'Biological Hazard Warning',
    'BWW': 'Boil Water Warning',
    'CHW': 'Chemical Hazard Warning',
    'CWW': 'Contaminated Water Warning',
    'DBA': 'Dam Watch',
    'DBW': 'Dam Break Warning',
    'DEW': 'Contagious Disease Warning',
    'EVA': 'Evacuation Watch',
    'FCW': 'Food Contamination Warning',
    'IBW': 'Iceberg Warning',
    'IFW': 'Industrial Fire Warning',
    'LSW': 'Land Slide Warning',
    'POS': 'Power Outage Statement',
    'WFA': 'Wild Fire Watch',
    'WFW': 'Wild Fire Warning',
}

SAME__EEE__SP = {
    '': None,
    'CFA': 'Vigilancia de Inundacion Costera',
    'CFW': 'Advertencia de Inundacion Costera',
    'DSW': 'Advertencia de Tormenta de Polvo',
    'FFA': 'Vigilancia de Inundacion Repentina',
    'FFW': 'Advertencia de Inundacion Repentina',
    'FFS': 'Declaracion de Inundacion Repentina',
    'FLA': 'Vigilancia de Inundacion',
    'FLW': 'Advertencia de Inundacion',
    'FLS': 'Declaracion de Inundacion',
    'HWA': 'Vigilancia de Viento Fuerte',
    'HWW': 'Advertencia de Viento Fuerte',
    'HUA': 'Vigilancia de Huracan',
    'HUW': 'Advertencia de Huracan',
    'HLS': 'Declaracion de Huracan',
    'SVA': 'Vigilancia de Tormenta Severa',
    'SVR': 'Advertencia de Tormenta Severa',
    'SVS': 'Declaracion de tiempo Severo',
    'SMW': 'Advertencia Marina Especial',
    'SPS': 'Declaracion Meteorologica Especial',
    'TOA': 'Vigilancia de Tornado',
    'TOR': 'Advertencia de Tornado',
    'TRA': 'Vigilancia de Tormenta Tropical',
    'TRW': 'Advertencia de Tormenta Tropical',
    'TSA': 'Vigilancia de Tsunami',
    'TSW': 'Advertencia de Tsunami',
    'WSA': 'Vigilancia de Tormenta de Invierno',
    'WSW': 'Advertencia de Tormenta de Invierno',
    'EAN': 'Notificacion de Accion de Emergencia',
    'EAT': 'Terminacion de Accion de Emergencia',
    'NIC': 'Centro Nacional de Informacion',
    'NPT': 'Prueba Periodica Nacional',
    'NAT': 'Prueba Audible Nacional',
    'NST': 'Prueba Silenciosa Nacional',
    'RMT': 'Prueba Mensual Requerida',
    'RWT': 'Prueba Semanal Requerida',
    'ADR': 'Mensaje Administrativo',
    'AVA': 'Vigilancia de Avalancha',
    'AVW': 'Advertencia de Avalancha',
    'CAE': 'Emergencia de Sustraccion de Menores',
    'CDW': 'Advertencia de Peligro Civil',
    'CEM': 'Mensaje de Emergencia Civil',
    'EQW': 'Advertencia de Terremoto',
    'EVI': 'Evacuacion Inmediata',
    'FRW': 'Advertencia de Incendio',
    'HMW': 'Advertencia de Materiales Peligrosos',
    'LEW': 'Advertencia de Aplicacion de la Ley',
    'LAE': 'Emergencia de Area Local',
    'TOE': '911 Interrupcion de Emergencia',
    'NUW': 'Advertencia de Planta Nuclear',
    'RHW': 'Advertencia de Peligro Radiologico',
    'SPW': 'Advertencia de Refugio en el Lugar',
    'VOTO': 'Advertencia de Volcan',
    'NMN': 'Notificacion de Mensaje de Red',
    'DMO': 'Advertencia de Demostracion',
    'EWW': 'Advertencia de Viento Extremo',
    'SSA': 'Vigilancia de Marejada Ciclonica',
    'SSW': 'Advertencia de Marejada Ciclonica',
    'FSW': 'Advertencia de Congelacion Repentina',
    'FZW': 'Advertencia de Congelamiento',
    'HLS': 'Declaracion Local de Huracan',
    'SMW': 'Advertencia Marina Especial',
    'BHW': 'Advertencia de Peligro Biologico',
    'BWW': 'Advertencia de Agua Hirviendo',
    'CHW': 'Advertencia de Peligro Quimico',
    'CWW': 'Advertencia de Agua Contaminada',
    'DBA': 'Reloj de la Presa',
    'DBW': 'Advertencia de Rotura de Presa',
    'DEW': 'Advertencia de Enfermedad Contagiosa',
    'EVA': 'Vigilancia de Evacuacion',
    'FCW': 'Advertencia de Contaminacion de Alimentos',
    'IBW': 'Advertencia de Iceberg',
    'IFW': 'Advertencia de Incendio Industrial',
    'LSW': 'Advertencia de Deslizamiento de Tierra',
    'POS': 'Declaracion de Corte de Energia',
    'WFA': 'Vigilancia de Incendios Forestales',
    'WFW': 'Advertencia de Incendio Forestal',
}

# This list is a NOAA list of meteorological station locations cross referenced with the FAA list of airport codes and locations.
# Without a definative list of ICAO codes used with NWS alerts, this is the best available information. No source matches all ICAO codes in use.

ICAO_LIST = {
    'LOCATION': 'US',
    'K01R': 'CLAIBORNE RANGE, LOUISANA',
    'K04V': 'SAGAUCHE, COLORADO',
    'K06D': 'ROLLA, NORTH DAKOTA',
    'K07S': 'BEAUMONT, KANSAS',
    'K08D': 'STANLEY, NORTH DAKOTA',
    'K0J4': 'FLORALA, ALABAMA',
    'K0VG': 'JONESVILLE, VIRGINIA',
    'K11J': 'ONONDAGA, MICHIGAN',
    'K11R': 'BRENHAM, TEXAS',
    'K12N': 'ANDOVER, NEW JERSEY',
    'K14Y': 'LONG PRAIRIE, MINNESOTA',
    'K1A5': 'FRANKLIN, NORTH CAROLINA',
    'K1A6': 'MIDDLESBORO, KENTUCKY',
    'K1B7': 'BOOTHVILLE, LOUISANA',
    'K1F0': 'ARDMORE, OKLAHOMA',
    'K1H2': 'EFFINGHAM, ILLINOIS',
    'K1J1': 'SAINT SIMON ISLAND, GEORGIA',
    'K1K5': 'ELKHART, KANSAS',
    'K1L2': 'SANTA MONICA, CALIFORNIA',
    'K1M4': 'HALEYVILLE, ALABAMA',
    'K1O5': 'MONTAGUE, CALIFORNIA',
    'K1P1': 'PLYMOUTH, NEW HAMPSHIRE',
    'K1V1': 'RIFLE, COLORADO',
    'K1V4': 'ST JOHNSBURY, VERMONT',
    'K20C': 'SAINT JOSEPH, MICHIGAN',
    'K20U': 'BEACH, NORTH DAKOTA',
    'K20V': 'KREMMLING, COLORADO',
    'K21D': 'LAKE ELMO, MINNESOTA',
    'K27A': 'ELBERT, GEORGIA',
    'K29G': 'RAVENNA, OHIO',
    'K2C8': 'CAVALIER, NORTH DAKOTA',
    'K2D5': 'OAKES, NORTH DAKOTA',
    'K2DP': 'ENGELHARD, NORTH CAROLINA',
    'K2G6': 'MEADVILLE, PENNSYLVANIA',
    'K2S9': 'WILLAPA HARBOR, WASHINGTON',
    'K2U7': 'STANLEY, IDAHO',
    'K33G': 'PORT HURON, MICHIGAN',
    'K36U': 'HEBER CITY, UTAH',
    'K3A1': 'CULLMAN, ALABAMA',
    'K3A6': 'STEVENSON RANCH, CALIFORNIA',
    'K3B1': 'GREENVILLE, MAINE',
    'K3I2': 'POINT PLEASANT, WEST VIRGINIA',
    'K3J7': 'GREENSBORO, GEORGIA',
    'K3LF': 'LITCHFIELD, ILLINOIS',
    'K3OI': 'LAMONI, IOWA',
    'K3R1': 'BAY CITY, TEXAS',
    'K3S2': 'AURORA STATE, OREGON',
    'K3T5': 'LA GRANGE, TEXAS',
    'K40B': 'CLAYTON LAKE, MAINE',
    'K40G': 'VALLE, ARIZONA',
    'K40J': 'PERRY, FLORIDA',
    'K41G': 'BATH, MICHIGAN',
    'K44N': 'MILLBROOK, NEW YORK',
    'K46D': 'CARRINGTON, NORTH DAKOTA',
    'K47A': 'CANTON, GEORGIA',
    'K48I': 'SUTTON, WEST VIRGINIA',
    'K49N': 'EAST MORICHES, NEW YORK',
    'K4A9': 'FORT PAYNE, ALABAMA',
    'K4O4': 'IDABEL, OKLAHOMA',
    'K4SL': 'STAR LAKE JOHNSON RANCH, NEW MEXICO',
    'K5H4': 'HARVEY, NORTH DAKOTA',
    'K5T6': 'SANTA TERESA, NEW MEXICO',
    'K6R6': 'DRYDEN, TEXAS',
    'K75S': 'FREDONIA, WASHINGTON',
    'K76S': 'PENN COVE PARK, WASHINGTON',
    'K79J': 'ANDALUSIA, ALABAMA',
    'K7A9': 'PLAINS, GEORGIA',
    'K7L2': 'LINTON, NORTH DAKOTA',
    'K8A0': 'ALBERTVILLE, ALABAMA',
    'K8D3': 'SISSETON, SOUTH DAKOTA',
    'K8S0': 'KIOWA, MONTANA',
    'K96D': 'WALHALLA, NORTH DAKOTA',
    'K96S': 'DUNGENESS, WASHINGTON',
    'K9BB': 'WELLS, NEVADA',
    'K9D7': 'CANDO, NORTH DAKOTA',
    'K9L2': 'EDWARDS AFB, CALIFORNIA',
    'K9V9': 'CHAMBERLAIN, SOUTH DAKOTA',
    'KAAA': 'LINCOLN, ILLINOIS',
    'KAAF': 'APALACHICOLA, FLORIDA',
    'KAAO': 'WICHITA, KANSAS',
    'KAAT': 'ALTURAS, CALIFORNIA',
    'KABE': 'ALLENTOWN, PENNSYLVANIA',
    'KABI': 'ABILENE, TEXAS',
    'KABQ': 'ALBUQUERQUE, NEW MEXICO',
    'KABR': 'ABERDEEN, SOUTH DAKOTA',
    'KABX': 'ALBUQUERQUE, NEW MEXICO',
    'KABY': 'ALBANY, GEORGIA',
    'KACB': 'BELLAIRE, MICHIGAN',
    'KACK': 'NANTUCKET, MASSACHUSETTS',
    'KACP': 'OAKDALE, LOUISIANA',
    'KACQ': 'WASECA, MINNESOTA',
    'KACT': 'WACO, TEXAS',
    'KACV': 'ARCATA, CALIFORNIA',
    'KACY': 'ATLANTIC CITY, NEW JERSEY',
    'KADC': 'WADENA, MINNESOTA',
    'KADG': 'ADRIAN, MICHIGAN',
    'KADH': 'ADA, OKLAHOMA',
    'KADM': 'ARDMORE, OKLAHOMA',
    'KADS': 'DALLAS, TEXAS',
    'KADU': 'AUDUBON, IOWA',
    'KADW': 'CAMP SPRINGS, MARYLAND',
    'KAEG': 'ALBUQUERQUE, NEW MEXICO',
    'KAEJ': 'BUENA VISTA, COLORADO',
    'KAEL': 'ALBERT LEA, MINNESOTA',
    'KAEX': 'ALEXANDRIA, LOUISIANA',
    'KAFF': 'COLORADO SPRINGS, COLORADO',
    'KAFJ': 'WASHINGTON, PENNSYLVANIA',
    'KAFK': 'NEBRASKA CITY, NEBRASKA',
    'KAFN': 'JAFFREY, NEW HAMPSHIRE',
    'KAFP': 'WADESBORO, NORTH CAROLINA',
    'KAFW': 'FORT WORTH, TEXAS',
    'KAGC': 'PITTSBURGH, PENNSYLVANIA',
    'KAGR': 'AVON PARK, FLORIDA',
    'KAGS': 'AUGUSTA, GEORGIA',
    'KAHN': 'ATHENS, GEORGIA',
    'KAIA': 'ALLIANCE, NEBRASKA',
    'KAID': 'ANDERSON, INDIANA',
    'KAIG': 'ANTIGO, WISCONSIN',
    'KAIO': 'ATLANTIC, IOWA',
    'KAIT': 'AITKIN, MINNESOTA',
    'KAIZ': 'LAKE OZARK, MISSOURI',
    'KAJG': 'MOUNT CARMEL, ILLINOIS',
    'KAKH': 'GASTONIA, NORTH CAROLINA',
    'KAKO': 'AKRON, COLORADO',
    'KAKQ': 'WAKEFIELD, VIRGINIA',
    'KAKR': 'AKRON, OHIO',
    'KALB': 'ALBANY, NEW YORK',
    'KALI': 'ALICE, TEXAS',
    'KALM': 'ALAMOGORDO, NEW MEXICO',
    'KALN': 'ALTON, ILLINOIS',
    'KALO': 'WATERLOO, IOWA',
    'KALS': 'ALAMOSA, COLORADO',
    'KALW': 'WALLA WALLA, WASHINGTON',
    'KALX': 'ALEXANDER CITY, ALABAMA',
    'KAMA': 'AMARILLO, TEXAS',
    'KAMG': 'ALMA, GEORGIA',
    'KAMN': 'ALMA, MICHIGAN',
    'KAMW': 'AMES, IOWA',
    'KANB': 'ANNISTON, ALABAMA',
    'KAND': 'ANDERSON, SOUTH CAROLINA',
    'KANE': 'MINNEAPOLIS, MINNESOTA',
    'KANJ': 'SAULT STE MARIE, MICHIGAN',
    'KANW': 'AINSWORTH, NEBRASKA',
    'KAOH': 'LIMA, OHIO',
    'KAOO': 'ALTOONA, PENNSYLVANIA',
    'KAPA': 'DENVER, COLORADO',
    'KAPC': 'NAPA, CALIFORNIA',
    'KAPF': 'NAPLES, FLORIDA',
    'KAPG': 'ABERDEEN PROVING GROUND, MARYLAND',
    'KAPN': 'ALPENA, MICHIGAN',
    'KAPV': 'APPLE VALLEY, CALIFORNIA',
    'KAQO': 'LLANO, TEXAS',
    'KAQP': 'APPLETON, MINNESOTA',
    'KAQR': 'ATOKA, OKLAHOMA',
    'KAQV': 'FORT POLK, LOUISANA',
    'KAQW': 'NORTH ADAMS, MASSACHUSETTS',
    'KARA': 'NEW IBERIA, LOUISIANA',
    'KARB': 'ANN ARBOR, MICHIGAN',
    'KARG': 'WALNUT RIDGE, ARKANSAS',
    'KARM': 'WHARTON, TEXAS',
    'KARR': 'CHICAGO, ILLINOIS',
    'KART': 'WATERTOWN, NEW YORK',
    'KARV': 'MINOCQUA, WISCONSIN',
    'KASD': 'SLIDELL, LOUISIANA',
    'KASE': 'ASPEN, COLORADO',
    'KASG': 'SPRINGDALE, ARKANSAS',
    'KASH': 'NASHUA, NEW HAMPSHIRE',
    'KASJ': 'AHOSKIE, NORTH CAROLINA',
    'KAST': 'ASTORIA, OREGON',
    'KASW': 'WARSAW, INDIANA',
    'KASX': 'ASHLAND, WISCONSIN',
    'KATL': 'ATLANTA, GEORGIA',
    'KATS': 'ARTESIA, NEW MEXICO',
    'KATT': 'AUSTIN, TEXAS',
    'KATW': 'APPLETON, WISCONSIN',
    'KATY': 'WATERTOWN, SOUTH DAKOTA',
    'KAUG': 'AUGUSTA, MAINE',
    'KAUH': 'AURORA, NEBRASKA',
    'KAUM': 'AUSTIN, MINNESOTA',
    'KAUN': 'AUBURN, CALIFORNIA',
    'KAUO': 'AUBURN, ALABAMA',
    'KAUS': 'AUSTIN, TEXAS',
    'KAUW': 'WAUSAU, WISCONSIN',
    'KAVC': 'SOUTH HILL, VIRGINIA',
    'KAVK': 'ALVA, OKLAHOMA',
    'KAVL': 'ASHEVILLE, NORTH CAROLINA',
    'KAVP': 'SCRANTON, PENNSYLVANIA',
    'KAVX': 'AVALON, CALIFORNIA',
    'KAWG': 'WASHINGTON, IOWA',
    'KAWM': 'WEST MEMPHIS, ARKANSAS',
    'KAWO': 'ARLINGTON, WASHINGTON',
    'KAXA': 'ALGONA, IOWA',
    'KAXN': 'ALEXANDRIA, MINNESOTA',
    'KAXS': 'ALTUS, OKLAHOMA',
    'KAYE': 'AYER, MASSACHUSETTS',
    'KAYS': 'WAYCROSS, GEORGIA',
    'KAZC': 'COLORADO CITY, ARIZONA',
    'KAZO': 'KALAMAZOO, MICHIGAN',
    'KBAB': 'MARYSVILLE, CALIFORNIA',
    'KBAC': 'VALLEY CITY, NORTH DAKOTA',
    'KBAD': 'SHREVEPORT, LOUISANA',
    'KBAF': 'WESTFIELD, MASSACHUSETTS',
    'KBAK': 'COLUMBUS, INDIANA',
    'KBAN': 'BRIDGEPORT, CALIFORNIA',
    'KBAX': 'BAD AXE, MICHIGAN',
    'KBAZ': 'NEW BRAUNFELS, TEXAS',
    'KBBB': 'BENSON, MINNESOTA',
    'KBBD': 'BRADY, TEXAS',
    'KBBW': 'BROKEN BOW, NEBRASKA',
    'KBCB': 'BLACKSBURG, VIRGINIA',
    'KBCE': 'BRYCE CANYON, UTAH',
    'KBCT': 'BOCA RATON, FLORIDA',
    'KBDE': 'BAUDETTE, MINNESOTA',
    'KBDL': 'WINDSOR LOCKS, CONNECTICUT',
    'KBDR': 'BRIDGEPORT, CONNECTICUT',
    'KBED': 'BEDFORD, MASSACHUSETTS',
    'KBEH': 'BENTON HARBOR, MICHIGAN',
    'KBFD': 'BRADFORD, PENNSYLVANIA',
    'KBFF': 'SCOTTSBLUFF, NEBRASKA',
    'KBFI': 'SEATTLE, WASHINGTON',
    'KBFL': 'BAKERSFIELD, CALIFORNIA',
    'KBFM': 'MOBILE, ALABAMA',
    'KBFW': 'SILVER BAY, MINNESOTA',
    'KBGD': 'BORGER, TEXAS',
    'KBGE': 'BAINBRIDGE, GEORGIA',
    'KBGM': 'BINGHAMTON, NEW YORK',
    'KBGR': 'BANGOR, MAINE',
    'KBHB': 'BAR HARBOR, MAINE',
    'KBHK': 'BAKER, MONTANA',
    'KBHM': 'BIRMINGHAM, ALABAMA',
    'KBID': 'BLOCK ISLAND, RHODE ISLAND',
    'KBIE': 'BEATRICE, NEBRASKA',
    'KBIF': 'EL PASO, TEXAS',
    'KBIH': 'BISHOP, CALIFORNIA',
    'KBIL': 'BILLINGS, MONTANA',
    'KBIS': 'BISMARCK, NORTH DAKOTA',
    'KBIV': 'HOLLAND, MICHIGAN',
    'KBIX': 'BILOXI, MISSISSIPPI',
    'KBJC': 'DENVER, COLORADO',
    'KBJI': 'BEMIDJI, MINNESOTA',
    'KBJJ': 'WOOSTER, OHIO',
    'KBJN': 'TONOPAH TEST RANGE, NEVADA',
    'KBKB': 'FORT POLK, LOUISANA',
    'KBKE': 'BAKER CITY, OREGON',
    'KBKF': 'DENVER, COLORADO',
    'KBKL': 'CLEVELAND, OHIO',
    'KBKS': 'FALFURRIAS, TEXAS',
    'KBKT': 'BLACKSTONE, VIRGINIA',
    'KBKV': 'BROOKSVILLE, FLORIDA',
    'KBKW': 'BECKLEY, WEST VIRGINIA',
    'KBKX': 'BROOKINGS, SOUTH DAKOTA',
    'KBLF': 'BLUEFIELD, WEST VIRGINIA',
    'KBLH': 'BLYTHE, CALIFORNIA',
    'KBLI': 'BELLINGHAM, WASHINGTON',
    'KBLM': 'BELMAR, NEW JERSEY',
    'KBLU': 'EMIGRANT GAP, CALIFORNIA',
    'KBLV': 'BELLEVILLE, ILLINOIS',
    'KBMG': 'BLOOMINGTON, INDIANA',
    'KBMI': 'BLOOMINGTON-NORMAL, ILLINOIS',
    'KBML': 'BERLIN, NEW HAMPSHIRE',
    'KBMQ': 'BURNET, TEXAS',
    'KBMX': 'BIRMINGHAM, ALABAMA',
    'KBNA': 'NASHVILLE, TENNESSEE',
    'KBNO': 'BURNS, OREGON',
    'KBNW': 'BOONE, IOWA',
    'KBOI': 'BOISE, IDAHOAHO',
    'KBOK': 'BROOKINGS, OREGON',
    'KBOS': 'BOSTON, MASSACHUSETTS',
    'KBOW': 'BARTOW, FLORIDA',
    'KBOX': 'BOSTON, MASSACHUSETTS',
    'KBPG': 'BIG SPRING, TEXAS',
    'KBPI': 'BIG PINEY, WYOMING',
    'KBPK': 'MOUNTAIN HOME, ARKANSAS',
    'KBPP': 'BOWMAN, NORTH DAKOTA',
    'KBPT': 'BEAUMONT, TEXAS',
    'KBQK': 'BRUNSWICK, GEORGIA',
    'KBRD': 'BRAINERD, MINNESOTA',
    'KBRL': 'BURLINGTON, IOWA',
    'KBRO': 'BROWNSVILLE, TEXAS',
    'KBRX': 'BORDEAUX, WYOMING',
    'KBTL': 'BATTLE CREEK, MICHIGAN',
    'KBTM': 'BUTTE, MONTANA',
    'KBTP': 'BUTLER, PENNSYLVANIA',
    'KBTR': 'BATON ROUGE, LOUISIANA',
    'KBTV': 'BURLINGTON, VERMONT',
    'KBUF': 'BUFFALO, NEW YORK',
    'KBUR': 'BURBANK, CALIFORNIA',
    'KBUU': 'BURLINGTON, WISCONSIN',
    'KBUY': 'BURLINGTON, NORTH CAROLINA',
    'KBVE': 'BOOTHVILLE, LOUISANA',
    'KBVI': 'BEAVER FALLS, PENNSYLVANIA',
    'KBVN': 'ALBION, NEBRASKA',
    'KBVO': 'BARTLESVILLE, OKLAHOMA',
    'KBVS': 'BURLINGTON, WASHINGTON',
    'KBVX': 'BATESVILLE, ARKANSAS',
    'KBVY': 'BEVERLY, MASSACHUSETTS',
    'KBWD': 'BROWNWOOD, TEXAS',
    'KBWG': 'BOWLING GREEN, KENTUCKY',
    'KBWI': 'BALTIMORE, MARYLAND',
    'KBWP': 'WAHPETON, NORTH DAKOTA',
    'KBXA': 'BOGALUSA, LOUISIANA',
    'KBYG': 'BUFFALO, WYOMING',
    'KBYH': 'BLYTHEVILLE, ARKANSAS',
    'KBYI': 'BURLEY, IDAHOAHO',
    'KBYS': 'FORT IRWIN, CALIFORNIA',
    'KBYY': 'BAY CITY, TEXAS',
    'KBZN': 'BOZEMAN, MONTANA',
    'KC09': 'SARATOGA, ILLINOIS',
    'KC73': 'DIXON, ILLINOIS',
    'KC75': 'SPARLAND, ILLINOIS',
    'KCAD': 'CADILLAC, MICHIGAN',
    'KCAE': 'COLUMBIA, SOUTH CAROLINA',
    'KCAG': 'CRAIG, COLORADO',
    'KCAK': 'AKRON, OHIO',
    'KCAO': 'CLAYTON, NEW MEXICO',
    'KCAR': 'CARIBOU, MAINE',
    'KCAV': 'CLARION, IOWA',
    'KCBE': 'CUMBERLAND, MARYLAND',
    'KCBF': 'COUNCIL BLUFFS, IOWA',
    'KCBG': 'CAMBRIDGE, MINNESOTA',
    'KCBM': 'COLUMBUS, MISSISSIPPI',
    'KCCO': 'ATLANTA, GEORGIA',
    'KCCR': 'CONCORD, CALIFORNIA',
    'KCCU': 'COPPER MOUNTAIN, COLORADO',
    'KCCY': 'CHARLES CITY, IOWA',
    'KCDC': 'CEDAR CITY, UTAH',
    'KCDD': 'CRANE LAKE, MINNESOTA',
    'KCDH': 'CAMDEN, ARKANSAS',
    'KCDJ': 'CHILLICOTHE, MISSOURI',
    'KCDR': 'CHADRON, NEBRASKA',
    'KCDS': 'CHILDRESS, TEXAS',
    'KCDW': 'CALDWELL, NEW JERSEY',
    'KCEC': 'CRESCENT CITY, CALIFORNIA',
    'KCEF': 'SPRINGFIELD, MASSACHUSETTS',
    'KCEU': 'CLEMSON, SOUTH CAROLINA',
    'KCEW': 'CRESTVIEW, FLORIDA',
    'KCEZ': 'CORTEZ, COLORADO',
    'KCFE': 'BUFFALO, MINNESOTA',
    'KCFS': 'CARO, MICHIGAN',
    'KCFT': 'CLIFTON, ARIZONA',
    'KCFV': 'COFFEYVILLE, KANSAS',
    'KCGF': 'CLEVELAND, OHIO',
    'KCGI': 'CAPE GIRARDEAU, MISSOURI',
    'KCGX': 'CHICAGO, ILLINOIS',
    'KCGZ': 'CASA GRANDE, ARIZONA',
    'KCHA': 'CHATTANOOGA, TENNESSEE',
    'KCHD': 'CHANDLER, ARIZONA',
    'KCHI': 'CHICAGO, ILLINOIS',
    'KCHK': 'CHICKASHA, OKLAHOMA',
    'KCHO': 'CHARLOTTESVILLE, VIRGINIA',
    'KCHS': 'CHARLESTON, SOUTH CAROLINA',
    'KCIC': 'CHICO, CALIFORNIA',
    'KCID': 'CEDAR RAPIDS, IOWA',
    'KCIN': 'CARROLL, IOWA',
    'KCIR': 'CAIRO, ILLINOIS',
    'KCIU': 'SAULT STE MARIE, MICHIGAN',
    'KCJR': 'CULPEPER, VIRGINIA',
    'KCKB': 'CLARKSBURG, WEST VIRGINIA',
    'KCKC': 'GRAND MARAIS, MINNESOTA',
    'KCKN': 'CROOKSTON, MINNESOTA',
    'KCKP': 'CHEROKEE, IOWA',
    'KCKV': 'CLARKSVILLE, TENNESSEE',
    'KCLE': 'CLEVELAND, OHIO',
    'KCLI': 'CLINTONVILLE, WISCONSIN',
    'KCLK': 'CLINTON, OKLAHOMA',
    'KCLL': 'COLLEGE STATION, TEXAS',
    'KCLM': 'PORT ANGELES, WASHINGTON',
    'KCLT': 'CHARLOTTE, NORTH CAROLINA',
    'KCMA': 'CAMARILLO, CALIFORNIA',
    'KCMH': 'COLUMBUS, OHIO',
    'KCMI': 'CHAMPAIGN-URBANA, ILLINOIS',
    'KCMX': 'HANCOCK, MICHIGAN',
    'KCMY': 'SPARTA, WISCONSIN',
    'KCNB': 'CANBY, MINNESOTA',
    'KCNC': 'CHARITON, IOWA',
    'KCNK': 'CONCORDIA, KANSAS',
    'KCNM': 'CARLSBAD, NEW MEXICO',
    'KCNO': 'CHINO, CALIFORNIA',
    'KCNU': 'CHANUTE, KANSAS',
    'KCNY': 'MOAB, UTAH',
    'KCOD': 'CODY, WYOMING',
    'KCOE': 'COEUR D\'ALENE, IDAHO',
    'KCOF': 'COCOA BEACH, FLORIDA',
    'KCOI': 'MERRITT ISLAND, FLORIDA',
    'KCON': 'CONCORD, NEW HAMPSHIRE',
    'KCOQ': 'CLOQUET, MINNESOTA',
    'KCOS': 'COLORADO SPRINGS, COLORADO',
    'KCOT': 'COTULLA, TEXAS',
    'KCOU': 'COLUMBIA, MISSOURI',
    'KCPC': 'WHITEVILLE, NORTH CAROLINA',
    'KCPK': 'NORFOLK, VIRGINIA',
    'KCPR': 'CASPER, WYOMING',
    'KCPS': 'CAHOKIA, ILLINOIS',
    'KCPT': 'CLEBURNE, TEXAS',
    'KCPW': 'WOLF CREEK PASS, COLORADO',
    'KCQB': 'CHANDLER, OKLAHOMA',
    'KCQC': 'CLINES CORNER, NEW MEXICO',
    'KCQM': 'COOK, MINNESOTA',
    'KCQT': 'LOS ANGELES, CALIFORNIA',
    'KCQX': 'CHATHAM, MASSACHUSETTS',
    'KCRE': 'NORTH MYRTLE BEACH, SOUTH CAROLINA',
    'KCRG': 'JACKSONVILLE, FLORIDA',
    'KCRP': 'CORPUS CHRISTI, TEXAS',
    'KCRQ': 'CARLSBAD, CALIFORNIA',
    'KCRS': 'CORSICANA, TEXAS',
    'KCRW': 'CHARLESTON, WEST VIRGINIA',
    'KCSG': 'COLUMBUS, GEORGIA',
    'KCSL': 'SAN LUIS OBISPO, CALIFORNIA',
    'KCSM': 'CLINTON, OKLAHOMA',
    'KCSQ': 'CRESTON, IOWA',
    'KCSV': 'CROSSVILLE, TENNESSEE',
    'KCTB': 'CUT BANK, MONTANA',
    'KCTY': 'CROSS CITY, FLORIDA',
    'KCTZ': 'CLINTON, NORTH CAROLINA',
    'KCUB': 'COLUMBIA, SOUTH CAROLINA',
    'KCUH': 'CUSHING, OKLAHOMA',
    'KCUL': 'CARMI, ILLINOIS',
    'KCUT': 'CUSTER, SOUTH DAKOTA',
    'KCVG': 'COVINGTON, KENTUCKY',
    'KCVN': 'CLOVIS, NEW MEXICO',
    'KCVO': 'CORVALLIS, OREGON',
    'KCVS': 'CLOVIS, NEW MEXICO',
    'KCVX': 'CHARLEVOIX, MICHIGAN',
    'KCWA': 'MOSINEE, WISCONSIN',
    'KCWF': 'LAKE CHARLES, LOUISIANA',
    'KCWI': 'CLINTON, IOWA',
    'KCXO': 'HOUSTON, TEXAS',
    'KCXP': 'CARSON CITY, NEVADA',
    'KCXY': 'HARRISBURG, PENNSYLVANIA',
    'KCYS': 'CHEYENNE, WYOMING',
    'KCZD': 'COZAD, NEBRASKA',
    'KCZK': 'CASCADE LOCKS, OREGON',
    'KCZZ': 'CAMPO, CALIFORNIA',
    'KD07': 'FAITH, SOUTH DAKOTA',
    'KD50': 'CROSBY, NORTH DAKOTA',
    'KD55': 'LANGDON, NORTH DAKOTA',
    'KD60': 'TIOGA, NORTH DAKOTA',
    'KDAA': 'FORT BELVOIR, VIRGINIA',
    'KDAB': 'DAYTONA BEACH, FLORIDA',
    'KDAG': 'DAGGETT, CALIFORNIA',
    'KDAL': 'DALLAS, TEXAS',
    'KDAN': 'DANVILLE, VIRGINIA',
    'KDAW': 'ROCHESTER, NEW HAMPSHIRE',
    'KDAY': 'DAYTON, OHIO',
    'KDBN': 'DUBLIN, GEORGIA',
    'KDBQ': 'DUBUQUE, IOWA',
    'KDCA': 'WASHINGTON, DC',
    'KDCU': 'DECATUR, ALABAMA',
    'KDDC': 'DODGE CITY, KANSAS',
    'KDDH': 'BENNINGTON, VERMONT',
    'KDEC': 'DECATUR, ILLINOIS',
    'KDEH': 'DECORAH, IOWA',
    'KDEN': 'DENVER, COLORADO',
    'KDEQ': 'DE QUEEN, ARKANSAS',
    'KDET': 'DETROIT, MICHIGAN',
    'KDEW': 'DEER PARK, WASHINGTON',
    'KDFI': 'DEFIANCE, OHIO',
    'KDFW': 'DALLAS-FORT WORTH, TEXAS',
    'KDGW': 'DOUGLAS, WYOMING',
    'KDHN': 'DOTHAN, ALABAMA',
    'KDHT': 'DALHART, TEXAS',
    'KDIK': 'DICKINSON, NORTH DAKOTA',
    'KDKB': 'DE KALB, ILLINOIS',
    'KDKK': 'DUNKIRK, NEW YORK',
    'KDKR': 'CROCKETT, TEXAS',
    'KDKX': 'KNOXVILLE, TENNESSEE',
    'KDLF': 'DEL RIO, TEXAS',
    'KDLH': 'DULUTH, MINNESOTA',
    'KDLL': 'BARABOO, WISCONSIN',
    'KDLN': 'DILLON, MONTANA',
    'KDLS': 'THE DALLES, OREGON',
    'KDMA': 'TUCSON, ARIZONA',
    'KDMH': 'BALTIMORE, MARYLAND',
    'KDMN': 'DEMING, NEW MEXICO',
    'KDMO': 'SEDALIA, MISSOURI',
    'KDNK': 'POLK AAF, LOUISANA',
    'KDNL': 'AUGUSTA, GEORGIA',
    'KDNN': 'DALTON, GEORGIA',
    'KDNR': 'DENVER, COLORADO',
    'KDNS': 'DENISON, IOWA',
    'KDNV': 'DANVILLE, ILLINOIS',
    'KDOV': 'DOVER, DELAWARE',
    'KDPA': 'CHICAGO, ILLINOIS',
    'KDPG': 'DUGWAY, UTAH',
    'KDPL': 'KENANSVILLE, NORTH CAROLINA',
    'KDQH': 'DOUGLAS, GEORGIA',
    'KDRA': 'MERCURY, NEVADA',
    'KDRI': 'DE RIDDER, LOUISIANA',
    'KDRO': 'DURANGO, COLORADO',
    'KDRT': 'DEL RIO, TEXAS',
    'KDSM': 'DES MOINES, IOWA',
    'KDSV': 'DANSVILLE, NEW YORK',
    'KDTL': 'DETROIT LAKES, MINNESOTA',
    'KDTN': 'SHREVEPORT, LOUISIANA',
    'KDTO': 'DENTON, TEXAS',
    'KDTS': 'DESTIN, FLORIDA',
    'KDTW': 'DETROIT, MICHIGAN',
    'KDTX': 'DETROIT, MICHIGAN',
    'KDUA': 'DURANT, OKLAHOMA',
    'KDUC': 'DUNCAN, OKLAHOMA',
    'KDUG': 'DOUGLAS BISBEE, ARIZONA',
    'KDUH': 'LAMBERTVILLE, MICHIGAN',
    'KDUJ': 'DUBOIS, PENNSYLVANIA',
    'KDUX': 'DUMAS, TEXAS',
    'KDVL': 'DEVILS LAKE, NORTH DAKOTA',
    'KDVN': 'DAVENPORT, IOWA',
    'KDVP': 'SLAYTON, MINNESOTA',
    'KDVT': 'PHOENIX, ARIZONA',
    'KDWH': 'HOUSTON, TEXAS',
    'KDXR': 'DANBURY, CONNECTICUT',
    'KDXX': 'MADISON, MINNESOTA',
    'KDYL': 'DOYLESTOWN, PENNSYLVANIA',
    'KDYR': 'DYERSBURG, TENNESSEE',
    'KDYS': 'ABILENE, TEXAS',
    'KDYT': 'DULUTH, MINNESOTA',
    'KE24': 'FT APACHE, ARIZONA',
    'KE33': 'CHAMA, NEW MEXICO',
    'KE38': 'ALPINE, TEXAS',
    'KE80': 'BELEN, NEW MEXICO',
    'KEAR': 'KEARNEY, NEBRASKA',
    'KEAT': 'WENATCHEE, WASHINGTON',
    'KEAU': 'EAU CLAIRE, WISCONSIN',
    'KEAX': 'PLEASANT HILL, MISSOURI',
    'KEBG': 'EDINBURG, TEXAS',
    'KEBS': 'WEBSTER CITY, IOWA',
    'KECG': 'ELIZABETH CITY, NORTH CAROLINA',
    'KECP': 'PANAMA CITY, FLORIDA',
    'KECU': 'ROCKSPRINGS, TEXAS',
    'KEDE': 'EDENTON, NORTH CAROLINA',
    'KEDW': 'EDWARDS AFB, CALIFORNIA',
    'KEED': 'NEEDLES, CALIFORNIA',
    'KEEN': 'KEENE, NEW HAMPSHIRE',
    'KEEO': 'MEEKER, COLORADO',
    'KEET': 'ALABASTER, ALABAMA',
    'KEFC': 'BELLE FOURCHE, SOUTH DAKOTA',
    'KEFD': 'HOUSTON, TEXAS',
    'KEFT': 'MONROE, WISCONSIN',
    'KEGE': 'EAGLE, COLORADO',
    'KEGI': 'DUKE FLD, FLORIDA',
    'KEGV': 'EAGLE RIVER, WISCONSIN',
    'KEHA': 'ELKHART, KANSAS',
    'KEHO': 'SHELBY, NORTH CAROLINA',
    'KEHR': 'HENDERSON, KENTUCKY',
    'KEKA': 'EUREKA, CALIFORNIA',
    'KEKM': 'ELKHART, INDIANA',
    'KEKN': 'ELKINS, WEST VIRGINIA',
    'KEKO': 'ELKO, NEVADA',
    'KEKQ': 'MONTICELLO, KENTUCKY',
    'KELD': 'EL DORADO, ARKANSAS',
    'KELM': 'ELMIRA, NEW YORK',
    'KELN': 'ELLENSBURG, WASHINGTON',
    'KELO': 'ELY, MINNESOTA',
    'KELP': 'EL PASO, TEXAS',
    'KELY': 'ELY, NEVADA',
    'KELZ': 'WELLSVILLE, NEW YORK',
    'KEMP': 'EMPORIA, KANSAS',
    'KEMT': 'EL MONTE, CALIFORNIA',
    'KEMV': 'EMPORIA, VIRGINIA',
    'KEND': 'ENID, OKLAHOMA',
    'KENL': 'CENTRALIA, ILLINOIS',
    'KENV': 'WENDOVER, UTAH',
    'KENW': 'KENOSHA, WISCONSIN',
    'KEOK': 'KEOKUK, IOWA',
    'KEPH': 'EPHRATA, WASHINGTON',
    'KEPZ': 'SANTA TERESA, NEW MEXICO',
    'KEQY': 'MONROE, NORTH CAROLINA',
    'KERI': 'ERIE, PENNSYLVANIA',
    'KERV': 'KERRVILLE, TEXAS',
    'KERY': 'NEWBERRY, MICHIGAN',
    'KESC': 'ESCANABA, MICHIGAN',
    'KESF': 'ALEXANDRIA, LOUISIANA',
    'KESN': 'EASTON, MARYLAND',
    'KEST': 'ESTHERVILLE, IOWA',
    'KETB': 'WEST BEND, WISCONSIN',
    'KETH': 'WHEATON, MINNESOTA',
    'KEUF': 'EUFAULA, ALABAMA',
    'KEUG': 'EUGENE, OREGON',
    'KEUL': 'CALDWELL, IDAHOAHO',
    'KEVB': 'NEW SMYRNA BEACH, FLORIDA',
    'KEVM': 'EVELETH, MINNESOTA',
    'KEVV': 'EVANSVILLE, INDIANA',
    'KEVW': 'EVANSTON, WYOMING',
    'KEWB': 'NEW BEDFORD, MASSACHUSETTS',
    'KEWK': 'NEWTON, KANSAS',
    'KEWN': 'NEW BERN, NORTH CAROLINA',
    'KEWR': 'NEWARK, NEW JERSEY',
    'KEXX': 'LEXINGTON, NORTH CAROLINA',
    'KEYE': 'INDIANAPOLIS, INDIANA',
    'KEYF': 'ELIZABETHTOWN, NORTH CAROLINA',
    'KEYW': 'KEY WEST, FLORIDA',
    'KEZF': 'FREDERICKSBURG, VIRGINIA',
    'KEZM': 'EASTMAN, GEORGIA',
    'KF05': 'VERNON, TEXAS',
    'KF10': 'HENRYETTA, OKLAHOMA',
    'KF30': 'SULPHUR, OKLAHOMA',
    'KFAF': 'FORT EUSTIS, VIRGINIA',
    'KFAM': 'FARMINGTON, MISSOURI',
    'KFAR': 'FARGO, NORTH DAKOTA',
    'KFAT': 'FRESNO, CALIFORNIA',
    'KFAY': 'FAYETTEVILLE, NORTH CAROLINA',
    'KFBG': 'FORT BRAGG, NORTH CAROLINA',
    'KFBL': 'FARIBAULT, MINNESOTA',
    'KFCH': 'FRESNO, CALIFORNIA',
    'KFCM': 'MINNEAPOLIS, MINNESOTA',
    'KFCS': 'FORT CARSON, COLORADO',
    'KFDK': 'FREDERICK, MARYLAND',
    'KFDR': 'FREDERICK, OKLAHOMA',
    'KFDY': 'FINDLAY, OHIO',
    'KFEP': 'FREEPORT, ILLINOIS',
    'KFET': 'FREMONT, NEBRASKA',
    'KFFA': 'KILL DEVIL HILLS, NORTH CAROLINA',
    'KFFC': 'ATLANTA, GEORGIA',
    'KFFL': 'FAIRFIELD, IOWA',
    'KFFM': 'FERGUS FALLS, MINNESOTA',
    'KFFO': 'DAYTON, OHIO',
    'KFFT': 'FRANKFORT, KENTUCKY',
    'KFFZ': 'MESA, ARIZONA',
    'KFGN': 'FLAG ISLAND, MINNESOTA',
    'KFHR': 'FRIDAY HARBOR, WASHINGTON',
    'KFHU': 'FORT HUACHUCA SIERRA VISTA, ARIZONA',
    'KFIG': 'CLEARFIELD, PENNSYLVANIA',
    'KFIT': 'FITCHBURG, MASSACHUSETTS',
    'KFKA': 'PRESTON, MINNESOTA',
    'KFKL': 'FRANKLIN, PENNSYLVANIA',
    'KFKN': 'FRANKLIN, VIRGINIA',
    'KFKS': 'FRANKFORT, MICHIGAN',
    'KFLD': 'FOND DU LAC, WISCONSIN',
    'KFLG': 'FLAGSTAFF, ARIZONA',
    'KFLL': 'FORT LAUDERDALE, FLORIDA',
    'KFLO': 'FLORENCE, SOUTH CAROLINA',
    'KFLP': 'FLIPPIN, ARKANSAS',
    'KFLV': 'FORT LEAVENWORTH, KANSAS',
    'KFME': 'FORT MEADE(ODENTON), MARYLAND',
    'KFMH': 'FALMOUTH, MASSACHUSETTS',
    'KFMN': 'FARMINGTON, NEW MEXICO',
    'KFMY': 'FORT MYERS, FLORIDA',
    'KFNB': 'FALLS CITY, NEBRASKA',
    'KFNL': 'FORT COLLINS, COLORADO',
    'KFNT': 'FLINT, MICHIGAN',
    'KFOA': 'FLORA, ILLINOIS',
    'KFOD': 'FORT DODGE, IOWA',
    'KFOE': 'TOPEKA, KANSAS',
    'KFOK': 'WESTHAMPTON BEACH, NEW YORK',
    'KFOZ': 'BIGFORK, MINNESOTA',
    'KFPK': 'CHARLOTTE, MICHIGAN',
    'KFPR': 'FORT PIERCE, FLORIDA',
    'KFQD': 'RUTHERFORDTON, NORTH CAROLINA',
    'KFRG': 'FARMINGDALE, NEW YORK',
    'KFRI': 'FORT RILEY, KANSAS',
    'KFRM': 'FAIRMONT, MINNESOTA',
    'KFSD': 'SIOUX FALLS, SOUTH DAKOTA',
    'KFSE': 'FOSSTON, MINNESOTA',
    'KFSI': 'LAWTON, OKLAHOMA',
    'KFSM': 'FORT SMITH, ARKANSAS',
    'KFST': 'FORT STOCKTON, TEXAS',
    'KFSW': 'FORT MADISON, IOWA',
    'KFTG': 'DENVER, COLORADO',
    'KFTK': 'FORT KNOX, KENTUCKY',
    'KFTW': 'FORT WORTH, TEXAS',
    'KFTY': 'ATLANTA, GEORGIA',
    'KFUL': 'FULLERTON, CALIFORNIA',
    'KFVE': 'FRENCHVILLE, MAINE',
    'KFVX': 'FARMVILLE, VIRGINIA',
    'KFWA': 'FORT WAYNE, INDIANA',
    'KFWC': 'FAIRFIELD, ILLINOIS',
    'KFWN': 'SUSSEX, NEW JERSEY',
    'KFWQ': 'MONONGAHELA, PENNSYLVANIA',
    'KFWS': 'FORT WORTH, TEXAS',
    'KFXE': 'FORT LAUDERDALE, FLORIDA',
    'KFYJ': 'WEST POINT, VIRGINIA',
    'KFYV': 'FAYETTEVILLE, ARKANSAS',
    'KFZY': 'FULTON, NEW YORK',
    'KGAD': 'GADSDEN, ALABAMA',
    'KGAF': 'GRAFTON, NORTH DAKOTA',
    'KGAG': 'GAGE, OKLAHOMA',
    'KGAO': 'GALLIANO, LOUISIANA',
    'KGBD': 'GREAT BEND, KANSAS',
    'KGBG': 'GALESBURG, ILLINOIS',
    'KGBN': 'GILA BEND, ARIZONA',
    'KGCC': 'GILLETTE, WYOMING',
    'KGCK': 'GARDEN CITY, KANSAS',
    'KGCM': 'CLAREMORE, OKLAHOMA',
    'KGCN': 'GRAND CANYON, ARIZONA',
    'KGDB': 'GRANITE FALLS, MINNESOTA',
    'KGDJ': 'GRANBURY, TEXAS',
    'KGDP': 'GUADALUPE PASS, TEXAS',
    'KGDV': 'GLENDIVE, MONTANA',
    'KGED': 'GEORGETOWN, DELAWARE',
    'KGEG': 'SPOKANE, WASHINGTON',
    'KGEU': 'GLENDALE, ARIZONA',
    'KGEV': 'JEFFERSON, NORTH CAROLINA',
    'KGEY': 'GREYBULL, WYOMING',
    'KGEZ': 'SHELBYVILLE, INDIANA',
    'KGFA': 'GREAT FALLS, MONTANA',
    'KGFK': 'GRAND FORKS, NORTH DAKOTA',
    'KGFL': 'GLENS FALLS, NEW YORK',
    'KGGG': 'LONGVIEW, TEXAS',
    'KGGW': 'GLASGOW, MONTANA',
    'KGHW': 'GLENWOOD, MINNESOTA',
    'KGID': 'GRAND ISLAND, NEBRASKA',
    'KGIF': 'WINTER HAVEN, FLORIDA',
    'KGJT': 'GRAND JUNCTION, COLORADO',
    'KGKJ': 'MEADVILLE, PENNSYLVANIA',
    'KGKY': 'ARLINGTON, TEXAS',
    'KGLD': 'GOODLAND, KANSAS',
    'KGLE': 'GAINESVILLE, TEXAS',
    'KGLH': 'GREENVILLE, MISSISSIPPI',
    'KGLR': 'GAYLORD, MICHIGAN',
    'KGLS': 'GALVESTON, TEXAS',
    'KGLW': 'GLASGOW, KENTUCKY',
    'KGMJ': 'GROVE, OKLAHOMA',
    'KGMU': 'GREENVILLE, SOUTH CAROLINA',
    'KGNA': 'GRAND MARAIS, MINNESOTA',
    'KGNC': 'SEMINOLE, TEXAS',
    'KGNR': 'GREENVILLE, MAINE',
    'KGNT': 'GRANTS, NEW MEXICO',
    'KGNV': 'GAINESVILLE, FLORIDA',
    'KGOK': 'GUTHRIE, OKLAHOMA',
    'KGON': 'GROTON, CONNECTICUT',
    'KGOP': 'GATESVILLE, TEXAS',
    'KGOV': 'GRAYLING, MICHIGAN',
    'KGPI': 'KALISPELL, MONTANA',
    'KGPM': 'GRAND PRAIRIE, TEXAS',
    'KGPT': 'GULFPORT, MISSISSIPPI',
    'KGPZ': 'GRAND RAPIDS, MINNESOTA',
    'KGRB': 'GREEN BAY, WISCONSIN',
    'KGRD': 'GREENWOOD, SOUTH CAROLINA',
    'KGRF': 'TACOMA, WASHINGTON',
    'KGRI': 'GRAND ISLAND, NEBRASKA',
    'KGRK': 'FORT HOOD, TEXAS',
    'KGRN': 'GORDON, NEBRASKA',
    'KGRR': 'GRAND RAPIDS, MICHIGAN',
    'KGSB': 'GOLDSBORO, NORTH CAROLINA',
    'KGSH': 'GOSHEN, INDIANA',
    'KGSO': 'GREENSBORO, NORTH CAROLINA',
    'KGSP': 'GREER, SOUTH CAROLINA',
    'KGTB': 'FORT DRUM, NEW YORK',
    'KGTF': 'GREAT FALLS, MONTANA',
    'KGTR': 'COLUMBUS, MISSISSIPPI',
    'KGTU': 'GEORGETOWN, TEXAS',
    'KGUC': 'GUNNISON, COLORADO',
    'KGUP': 'GALLUP, NEW MEXICO',
    'KGUS': 'BUNKER HILL, INDIANA',
    'KGUY': 'GUYMON, OKLAHOMA',
    'KGVL': 'GAINESVILLE, GEORGIA',
    'KGVT': 'GREENVILLE, TEXAS',
    'KGVW': 'KANSAS CITY, MISSOURI',
    'KGWO': 'GREENWOOD, MISSISSIPPI',
    'KGWR': 'GWINNER, NORTH DAKOTA',
    'KGWW': 'GOLDSBORO, NORTH CAROLINA',
    'KGXY': 'GREELEY, COLORADO',
    'KGYB': 'GIDDINGS, TEXAS',
    'KGYI': 'SHERMAN, TEXAS',
    'KGYL': 'GLENCOE, MINNESOTA',
    'KGYR': 'GOODYEAR, ARIZONA',
    'KGYY': 'GARY, INDIANA',
    'KGZH': 'EVERGREEN, ALABAMA',
    'KH92': 'HOMINY, OKLAHOMA',
    'KHAO': 'HAMILTON, OHIO',
    'KHAT': 'CAPE HATTERAS, NORTH CAROLINA',
    'KHBG': 'HATTIESBURG, MISSISSIPPI',
    'KHBI': 'ASHEBORO, NORTH CAROLINA',
    'KHBR': 'HOBART, OKLAHOMA',
    'KHBV': 'HEBBRONVILLE, TEXAS',
    'KHCD': 'HUTCHINSON, MINNESOTA',
    'KHCO': 'HALLOCK, MINNESOTA',
    'KHDC': 'HAMMOND, LOUISIANA',
    'KHDE': 'HOLDREGE, NEBRASKA',
    'KHDN': 'HAYDEN, COLORADO',
    'KHDO': 'HONDO, TEXAS',
    'KHEF': 'WASHINGTON, DIST, OF COLUMBIA',
    'KHEI': 'HETTINGER, NORTH DAKOTA',
    'KHEY': 'OZARK, ALABAMA',
    'KHEZ': 'NATCHEZ, MISSISSIPPI',
    'KHFD': 'HARTFORD, CONNECTICUT',
    'KHFF': 'HOFFMAN, NORTH CAROLINA',
    'KHGR': 'HAGERSTOWN, MARYLAND',
    'KHGX': 'HOUSTON, TEXAS',
    'KHHF': 'CANADIAN, TEXAS',
    'KHHR': 'HAWTHORNE, CALIFORNIA',
    'KHIB': 'HIBBING, MINNESOTA',
    'KHIE': 'WHITEFIELD, NEW HAMPSHIRE',
    'KHIF': 'OGDEN, UTAH',
    'KHIO': 'PORTLAND, OREGON',
    'KHJH': 'HEBRON, NEBRASKA',
    'KHJO': 'HANFORD, CALIFORNIA',
    'KHKA': 'BLYTHEVILLE, ARKANSAS',
    'KHKS': 'JACKSON, MISSISSIPPI',
    'KHKY': 'HICKORY, NORTH CAROLINA',
    'KHLC': 'HILL CITY, KANSAS',
    'KHLG': 'WHEELING, WEST VIRGINIA',
    'KHLN': 'HELENA, MONTANA',
    'KHLR': 'KILLEEN, TEXAS',
    'KHLX': 'GALAX HILLSVILLE, VIRGINIA',
    'KHMN': 'ALAMOGORDO, NEW MEXICO',
    'KHMZ': 'BEDFORD, PENNSYLVANIA',
    'KHNB': 'HUNTINGBURG, INDIANA',
    'KHND': 'LAS VEGAS, NEVADA',
    'KHNR': 'HARLAN, IOWA',
    'KHNZ': 'OXFORD, NORTH CAROLINA',
    'KHOB': 'HOBBS, NEW MEXICO',
    'KHON': 'HURON, SOUTH DAKOTA',
    'KHOP': 'FORT CAMPBELL, KENTUCKY',
    'KHOT': 'HOT SPRINGS, ARKANSAS',
    'KHOU': 'HOUSTON, TEXAS',
    'KHPN': 'WHITE PLAINS, NEW YORK',
    'KHQM': 'HOQUIAM, WASHINGTON',
    'KHQU': 'THOMSON, GEORGIA',
    'KHQZ': 'MESQUITE, TEXAS',
    'KHRI': 'HERMISTON, OREGON',
    'KHRJ': 'ERWIN, NORTH CAROLINA',
    'KHRL': 'HARLINGEN, TEXAS',
    'KHRO': 'HARRISON, ARKANSAS',
    'KHRT': 'MARY ESTHER, FLORIDA',
    'KHSA': 'BAY ST LOUIS, MISSISSIPPI',
    'KHSB': 'HARRISBURG, ILLINOIS',
    'KHSE': 'HATTERAS, NORTH CAROLINA',
    'KHSI': 'HASTINGS, NEBRASKA',
    'KHSP': 'HOT SPRINGS, VIRGINIA',
    'KHST': 'HOMESTEAD, FLORIDA',
    'KHSV': 'HUNTSVILLE, ALABAMA',
    'KHTH': 'HAWTHORNE, NEVADA',
    'KHTL': 'HOUGHTON LAKE, MICHIGAN',
    'KHTO': 'EAST HAMPTON, NEW YORK',
    'KHTS': 'HUNTINGTON, WEST VIRGINIA',
    'KHUF': 'TERRE HAUTE, INDIANA',
    'KHUL': 'HOULTON, MAINE',
    'KHUM': 'HOUMA, LOUISIANA',
    'KHUN': 'HUNTSVILLE, ALABAMA',
    'KHUT': 'HUTCHINSON, KANSAS',
    'KHVN': 'NEW HAVEN, CONNECTICUT',
    'KHVR': 'HAVRE, MONTANA',
    'KHWD': 'HAYWARD, CALIFORNIA',
    'KHWO': 'HOLLYWOOD, FLORIDA',
    'KHWV': 'SHIRLEY, NEW YORK',
    'KHXD': 'HILTON HEAD ISLAND, SOUTH CAROLINA',
    'KHYA': 'HYANNIS, MASSACHUSETTS',
    'KHYI': 'SAN MARCOS, TEXAS',
    'KHYR': 'HAYWARD, WISCONSIN',
    'KHYS': 'HAYS, KANSAS',
    'KHYX': 'SAGINAW, MICHIGAN',
    'KHZE': 'HAZEN, NORTH DAKOTA',
    'KHZX': 'MC GREGOR, MINNESOTA',
    'KHZY': 'ASHTABULA, OHIO',
    'KI12': 'SIDNEY, OHIO',
    'KI16': 'WINDOM, WEST VIRGINIA',
    'KI63': 'MOUNT STERLING, ILLINOIS',
    'KIAB': 'WICHITA, KANSAS',
    'KIAD': 'WASHINGTON, DIST, OF COLUMBIA',
    'KIAG': 'NIAGARA FALLS, NEW YORK',
    'KIAH': 'HOUSTON, TEXAS',
    'KIBM': 'KIMBALL, NEBRASKA',
    'KICL': 'CLARINDA, IOWA',
    'KICR': 'WINNER, SOUTH DAKOTA',
    'KICT': 'WICHITA, KANSAS',
    'KIDA': 'IDAHO FALLS, IDAHOAHO',
    'KIDI': 'INDIANA, PENNSYLVANIA',
    'KIEN': 'PINE RIDGE, SOUTH DAKOTA',
    'KIER': 'NATCHITOCHES, LOUISIANA',
    'KIFP': 'BULLHEAD CITY, ARIZONA',
    'KIGM': 'KINGMAN, ARIZONA',
    'KIGQ': 'CHICAGO, ILLINOIS',
    'KIGX': 'CHAPEL HILL, NORTH CAROLINA',
    'KIIB': 'INDEPENDENCE, IOWA',
    'KIIY': 'WASHINGTON, GEORGIA',
    'KIJD': 'WILLIMANTIC, CONNECTICUT',
    'KIJX': 'JACKSONVILLE, ILLINOIS',
    'KIKK': 'KANKAKEE, ILLINOIS',
    'KIKV': 'ANKENY, IOWA',
    'KILE': 'KILLEEN, TEXAS',
    'KILG': 'WILMINGTON, DELAWARE',
    'KILM': 'WILMINGTON, NORTH CAROLINA',
    'KILN': 'WILMINGTON, OHIO',
    'KILX': 'LINCOLN, ILLINOIS',
    'KIML': 'IMPERIAL, NEBRASKA',
    'KIMT': 'IRON MOUNTAIN KINGSFORD, MICHIGAN',
    'KIND': 'INDIANAPOLIS, INDIANA',
    'KINJ': 'HILLSBORO, TEXAS',
    'KINK': 'WINK, TEXAS',
    'KINL': 'INTERNATIONAL FALLS, MINNESOTA',
    'KINS': 'INDIAN SPRINGS, NEVADA',
    'KINT': 'WINSTON SALEM, NORTH CAROLINA',
    'KINW': 'WINSLOW, ARIZONA',
    'KIOW': 'IOWA CITY, IOWA',
    'KIPJ': 'LINCOLNTON, NORTH CAROLINA',
    'KIPL': 'IMPERIAL, CALIFORNIA',
    'KIPT': 'WILLIAMSPORT, PENNSYLVANIA',
    'KIRK': 'KIRKSVILLE, MISSOURI',
    'KIRS': 'STURGIS, MICHIGAN',
    'KISM': 'ORLANDO, FLORIDA',
    'KISN': 'WILLISTON, NORTH DAKOTA',
    'KISO': 'KINSTON, NORTH CAROLINA',
    'KISP': 'NEW YORK, NEW YORK',
    'KISQ': 'MANISTIQUE, MICHIGAN',
    'KISW': 'WISCONSIN RAPIDS, WISCONSIN',
    'KITH': 'ITHACA, NEW YORK',
    'KITR': 'BURLINGTON, COLORADO',
    'KIWA': 'PHOENIX, ARIZONA',
    'KIWD': 'IRONWOOD, MICHIGAN',
    'KIWI': 'WISCASSET, MAINE',
    'KIWS': 'HOUSTON, TEXAS',
    'KIXD': 'OLATHE, KANSAS',
    'KIYK': 'INYOKERN, CALIFORNIA',
    'KIZA': 'SANTA YNEZ, CALIFORNIA',
    'KIZG': 'FRYEBURG, MAINE',
    'KJAC': 'JACKSON, WYOMING',
    'KJAN': 'JACKSON, MISSISSIPPI',
    'KJAS': 'JASPER, TEXAS',
    'KJAX': 'JACKSONVILLE, FLORIDA',
    'KJBR': 'JONESBORO, ARKANSAS',
    'KJCT': 'JUNCTION, TEXAS',
    'KJDD': 'MINEOLA, TEXAS',
    'KJDN': 'JORDAN, MONTANA',
    'KJEF': 'JEFFERSON CITY, MISSOURI',
    'KJER': 'JEROME, IDAHOAHO',
    'KJES': 'JESUP, GEORGIA',
    'KJFK': 'NEW YORK, NEW YORK',
    'KJGG': 'WILLIAMSBURG, VIRGINIA',
    'KJHW': 'JAMESTOWN, NEW YORK',
    'KJKJ': 'MOORHEAD, MINNESOTA',
    'KJKL': 'JACKSON, KENTUCKY',
    'KJLN': 'JOPLIN, MISSOURI',
    'KJMR': 'MORA, MINNESOTA',
    'KJMS': 'JAMESTOWN, NORTH DAKOTA',
    'KJNX': 'SMITHFIELD, NORTH CAROLINA',
    'KJOT': 'JOLIET, ILLINOIS',
    'KJQF': 'CONCORD, NORTH CAROLINA',
    'KJSO': 'JACKSONVILLE, TEXAS',
    'KJST': 'JOHNSTOWN, PENNSYLVANIA',
    'KJSV': 'SALLISAW, OKLAHOMA',
    'KJVL': 'JANESVILLE, WISCONSIN',
    'KJWG': 'WATONGA, OKLAHOMA',
    'KJWY': 'MIDLOTHIAN, TEXAS',
    'KJXI': 'GILMER, TEXAS',
    'KJXN': 'JACKSON, MICHIGAN',
    'KJYG': 'ST JAMES, MINNESOTA',
    'KJYL': 'SYLVANIA, GEORGIA',
    'KJYM': 'HILLSDALE, MICHIGAN',
    'KJYO': 'LEESBURG, VIRGINIA',
    'KJYR': 'YORK, NEBRASKA',
    'KKLS': 'KELSO, WASHINGTON',
    'KL49': 'ROSEMONT, CALIFORNIA',
    'KLAA': 'LAMAR, COLORADO',
    'KLAF': 'LAFAYETTE, INDIANA',
    'KLAL': 'LAKELAND, FLORIDA',
    'KLAM': 'LOS ALAMOS, NEW MEXICO',
    'KLAN': 'LANSING, MICHIGAN',
    'KLAR': 'LARAMIE, WYOMING',
    'KLAS': 'LAS VEGAS, NEVADA',
    'KLAW': 'LAWTON, OKLAHOMA',
    'KLAX': 'LOS ANGELES, CALIFORNIA',
    'KLBB': 'LUBBOCK, TEXAS',
    'KLBE': 'LATROBE, PENNSYLVANIA',
    'KLBF': 'NORTH PLATTE, NEBRASKA',
    'KLBL': 'LIBERAL, KANSAS',
    'KLBR': 'CLARKSVILLE, TEXAS',
    'KLBT': 'LUMBERTON, NORTH CAROLINA',
    'KLBX': 'ANGLETON, TEXAS',
    'KLCG': 'WAYNE, NEBRASKA',
    'KLCH': 'LAKE CHARLES, LOUISIANA',
    'KLCI': 'LACONIA, NEW HAMPSHIRE',
    'KLCK': 'COLUMBUS, OHIO',
    'KLDM': 'LUDINGTON, MICHIGAN',
    'KLEB': 'LEBANON, NEW HAMPSHIRE',
    'KLEE': 'LEESBURG, FLORIDA',
    'KLEW': 'AUBURN, MAINE',
    'KLEX': 'LEXINGTON, KENTUCKY',
    'KLFI': 'HAMPTON, VIRGINIA',
    'KLFK': 'LUFKIN, TEXAS',
    'KLFT': 'LAFAYETTE, LOUISIANA',
    'KLGA': 'NEW YORK, NEW YORK',
    'KLGB': 'LONG BEACH, CALIFORNIA',
    'KLGC': 'LAGRANGE, GEORGIA',
    'KLGD': 'LA GRANDE, OREGON',
    'KLGU': 'LOGAN, UTAH',
    'KLHB': 'HEARNE, TEXAS',
    'KLHQ': 'LANCASTER, OHIO',
    'KLHW': 'FORT STEWART(HINESVILLE), GEORGIA',
    'KLHX': 'LA JUNTA, COLORADO',
    'KLHZ': 'LOUISBURG, NORTH CAROLINA',
    'KLIC': 'LIMON, COLORADO',
    'KLIT': 'LITTLE ROCK, ARKANSAS',
    'KLIX': 'SLIDELL, LOUISANA',
    'KLJF': 'LITCHFIELD, MINNESOTA',
    'KLKU': 'LOUISA, VIRGINIA',
    'KLKV': 'LAKEVIEW, OREGON',
    'KLLJ': 'CHALLIS, IDAHOAHO',
    'KLLQ': 'MONTICELLO, ARKANSAS',
    'KLMT': 'KLAMATH FALLS, OREGON',
    'KLNC': 'LANCASTER, TEXAS',
    'KLND': 'LANDER, WYOMING',
    'KLNK': 'LINCOLN, NEBRASKA',
    'KLNL': 'LAND O\' LAKES, WISCONSIN',
    'KLNN': 'WILLOUGHBY, OHIO',
    'KLNP': 'WISE, VIRGINIA',
    'KLNR': 'LONE ROCK, WISCONSIN',
    'KLNS': 'LANCASTER, PENNSYLVANIA',
    'KLOL': 'LOVELOCK, NEVADA',
    'KLOM': 'PHILADELPHIA, PENNSYLVANIA',
    'KLOR': 'FORT RUCKER, ALABAMA',
    'KLOT': 'CHICAGO, ILLINOIS',
    'KLOU': 'LOUISVILLE, KENTUCKY',
    'KLOZ': 'LONDON, KENTUCKY',
    'KLPC': 'LOMPOC, CALIFORNIA',
    'KLPR': 'LORAIN, OHIO',
    'KLRD': 'LAREDO, TEXAS',
    'KLRF': 'LITTLE ROCK, ARKANSAS',
    'KLRJ': 'LE MARS, IOWA',
    'KLRU': 'LAS CRUCES, NEW MEXICO',
    'KLSE': 'LA CROSSE, WISCONSIN',
    'KLSF': 'COLUMBUS, GEORGIA',
    'KLSV': 'LAS VEGAS, NEVADA',
    'KLSX': 'ST CHARLES, MISSOURI',
    'KLTS': 'ALTUS, OKLAHOMA',
    'KLUD': 'DECATUR, TEXAS',
    'KLUF': 'PHOENIX, ARIZONA',
    'KLUK': 'CINCINNATI, OHIO',
    'KLUM': 'MENOMONIE, WISCONSIN',
    'KLVJ': 'HOUSTON, TEXAS',
    'KLVK': 'LIVERMORE, CALIFORNIA',
    'KLVM': 'LIVINGSTON, MONTANA',
    'KLVN': 'MINNEAPOLIS, MINNESOTA',
    'KLVS': 'LAS VEGAS, NEW MEXICO',
    'KLWA': 'SOUTH HAVEN, MICHIGAN',
    'KLWB': 'LEWISBURG, WEST VIRGINIA',
    'KLWC': 'LAWRENCE, KANSAS',
    'KLWD': 'LAMONI, IOWA',
    'KLWM': 'LAWRENCE, MASSACHUSETTS',
    'KLWS': 'LEWISTON, IDAHOAHO',
    'KLWT': 'LEWISTOWN, MONTANA',
    'KLWV': 'LAWRENCEVILLE, ILLINOIS',
    'KLWX': 'STERLING, MARYLAND',
    'KLXL': 'LITTLE FALLS, MINNESOTA',
    'KLXN': 'LEXINGTON, NEBRASKA',
    'KLXT': 'LEE\'S SUMMIT, MISSOURI',
    'KLXV': 'LEADVILLE, COLORADO',
    'KLYH': 'LYNCHBURG, VIRGINIA',
    'KLYV': 'LUVERNE, MINNESOTA',
    'KLZK': 'NORTH LITTLE ROCK, ARKANSAS',
    'KLZU': 'LAWRENCEVILLE, GEORGIA',
    'KLZZ': 'LAMPASAS, TEXAS',
    'KM19': 'NEWPORT, ARKANSAS',
    'KM30': 'METROPOLIS, ILLINOIS',
    'KM82': 'HUNTSVILLE, ALABAMA',
    'KM97': 'TUNICA, MISSISSIPPI',
    'KMAE': 'MADERA, CALIFORNIA',
    'KMAF': 'MIDLAND, TEXAS',
    'KMAI': 'MARIANNA, FLORIDA',
    'KMAN': 'NAMPA, IDAHOAHO',
    'KMBG': 'MOBRIDGE, SOUTH DAKOTA',
    'KMBL': 'MANISTEE, MICHIGAN',
    'KMBS': 'SAGINAW, MICHIGAN',
    'KMCB': 'MC COMB, MISSISSIPPI',
    'KMCC': 'SACRAMENTO, CALIFORNIA',
    'KMCD': 'MACKINAC ISLAND, MICHIGAN',
    'KMCE': 'MERCED, CALIFORNIA',
    'KMCF': 'TAMPA, FLORIDA',
    'KMCI': 'KANSAS CITY, MISSOURI',
    'KMCK': 'MC COOK, NEBRASKA',
    'KMCN': 'MACON, GEORGIA',
    'KMCO': 'ORLANDO, FLORIDA',
    'KMCW': 'MASON CITY, IOWA',
    'KMDD': 'MIDLAND, TEXAS',
    'KMDH': 'CARBONDALE, ILLINOIS',
    'KMDQ': 'HUNTSVILLE, ALABAMA',
    'KMDT': 'HARRISBURG, PENNSYLVANIA',
    'KMDW': 'CHICAGO, ILLINOIS',
    'KMDZ': 'MEDFORD, WISCONSIN',
    'KMEB': 'MAXTON, NORTH CAROLINA',
    'KMEG': 'MEMPHIS, TENNESSEE',
    'KMEH': 'MEACHAM, OREGON',
    'KMEI': 'MERIDIAN, MISSISSIPPI',
    'KMEM': 'MEMPHIS, TENNESSEE',
    'KMER': 'ATWATER, CALIFORNIA',
    'KMEZ': 'MENA, ARKANSAS',
    'KMFD': 'MANSFIELD, OHIO',
    'KMFE': 'MC ALLEN, TEXAS',
    'KMFI': 'MARSHFIELD, WISCONSIN',
    'KMFR': 'MEDFORD, OREGON',
    'KMFV': 'MELFA, VIRGINIA',
    'KMGE': 'MARIETTA, GEORGIA',
    'KMGG': 'MAPLE LAKE, MINNESOTA',
    'KMGJ': 'MONTGOMERY, NEW YORK',
    'KMGM': 'MONTGOMERY, ALABAMA',
    'KMGN': 'HARBOR SPRINGS, MICHIGAN',
    'KMGR': 'MOULTRIE, GEORGIA',
    'KMGW': 'MORGANTOWN, WEST VIRGINIA',
    'KMGY': 'DAYTON, OHIO',
    'KMHE': 'MITCHELL, SOUTH DAKOTA',
    'KMHK': 'MANHATTAN, KANSAS',
    'KMHN': 'MULLEN, NEBRASKA',
    'KMHR': 'SACRAMENTO, CALIFORNIA',
    'KMHS': 'MOUNT SHASTA, CALIFORNIA',
    'KMHT': 'MANCHESTER, NEW HAMPSHIRE',
    'KMHV': 'MOJAVE, CALIFORNIA',
    'KMHX': 'MOREHEAD CITY, NORTH CAROLINA',
    'KMIA': 'MIAMI, FLORIDA',
    'KMIB': 'MINOT, NORTH DAKOTA',
    'KMIC': 'MINNEAPOLIS, MINNESOTA',
    'KMIE': 'MUNCIE, INDIANA',
    'KMIV': 'MILLVILLE, NEW JERSEY',
    'KMIW': 'MARSHALLTOWN, IOWA',
    'KMJQ': 'JACKSON, MINNESOTA',
    'KMKC': 'KANSAS CITY, MISSOURI',
    'KMKE': 'MILWAUKEE, WISCONSIN',
    'KMKG': 'MUSKEGON, MICHIGAN',
    'KMKJ': 'MARION, VIRGINIA',
    'KMKL': 'JACKSON, TENNESSEE',
    'KMKN': 'COMANCHE, TEXAS',
    'KMKO': 'MUSKOGEE, OKLAHOMA',
    'KMKT': 'MANKATO, MINNESOTA',
    'KMKX': 'MILWAUKEE, WISCONSIN',
    'KMLB': 'MELBOURNE, FLORIDA',
    'KMLC': 'MC ALESTER, OKLAHOMA',
    'KMLD': 'MALAD CITY, IDAHOAHO',
    'KMLE': 'OMAHA, NEBRASKA',
    'KMLF': 'MILFORD, UTAH',
    'KMLI': 'MOLINE, ILLINOIS',
    'KMLJ': 'MILLEDGEVILLE, GEORGIA',
    'KMLP': 'MULLAN PASS, IDAHO',
    'KMLS': 'MILES CITY, MONTANA',
    'KMLT': 'MILLINOCKET, MAINE',
    'KMLU': 'MONROE, LOUISIANA',
    'KMMH': 'MAMMOTH LAKES, CALIFORNIA',
    'KMMK': 'MERIDEN, CONNECTICUT',
    'KMML': 'MARSHALL, MINNESOTA',
    'KMMT': 'EASTOVER, SOUTH CAROLINA,',
    'KMMU': 'MORRISTOWN, NEW JERSEY',
    'KMMV': 'MC MINNVILLE, OREGON',
    'KMNH': 'MONUMENT, COLORADO',
    'KMNI': 'MANNING, SOUTH CAROLINA',
    'KMNM': 'MENOMINEE, MICHIGAN',
    'KMNN': 'MARION, OHIO',
    'KMOB': 'MOBILE, ALABAMA',
    'KMOD': 'MODESTO, CALIFORNIA',
    'KMOP': 'MOUNT PLEASANT, MICHIGAN',
    'KMOT': 'MINOT, NORTH DAKOTA',
    'KMOX': 'MORRIS, MINNESOTA',
    'KMPO': 'MOUNT POCONO, PENNSYLVANIA',
    'KMPV': 'BARRE, VERMONT',
    'KMPZ': 'MOUNT PLEASANT, IOWA',
    'KMQB': 'MACOMB, ILLINOIS',
    'KMQE': 'MILTON, MASSACHUSETTS',
    'KMQI': 'MANTEO, NORTH CAROLINA',
    'KMQT': 'MARQUETTE, MICHIGAN',
    'KMQY': 'SMYRNA, TENNESSEE',
    'KMRB': 'MARTINSBURG, WEST VIRGINIA',
    'KMRC': 'COLUMBIA, TENNESSEE',
    'KMRF': 'MARFA, TEXAS',
    'KMRH': 'BEAUFORT, NORTH CAROLINA',
    'KMRJ': 'MINERAL POINT, WISCONSIN',
    'KMRN': 'MORGANTON, NORTH CAROLINA',
    'KMRY': 'MONTEREY, CALIFORNIA',
    'KMSL': 'MUSCLE SHOALS, ALABAMA',
    'KMSN': 'MADISON, WISCONSIN',
    'KMSO': 'MISSOULA, MONTANA',
    'KMSP': 'MINNEAPOLIS, MINNESOTA',
    'KMSS': 'MASSENA, NEW YORK',
    'KMSV': 'MONTICELLO, NEW YORK',
    'KMSY': 'NEW ORLEANS, LOUISIANA',
    'KMTC': 'MOUNT CLEMENS, MICHIGAN',
    'KMTH': 'MARATHON, FLORIDA',
    'KMTJ': 'MONTROSE, COLORADO',
    'KMTN': 'BALTIMORE, MARYLAND',
    'KMTO': 'MATTOON, ILLINOIS',
    'KMTP': 'MONTAUK, NEW YORK',
    'KMTV': 'MARTINSVILLE, VIRGINIA',
    'KMTW': 'MANITOWOC, WISCONSIN',
    'KMTX': 'MISSION, TEXAS',
    'KMUI': 'INDIANTOWN, PENNSYLVANIA',
    'KMUO': 'MOUNTAIN HOME, IDAHO',
    'KMUT': 'MUSCATINE, IOWA',
    'KMVE': 'MONTEVIDEO, MINNESOTA',
    'KMVL': 'MORRISVILLE, VERMONT',
    'KMVN': 'MOUNT VERNON, ILLINOIS',
    'KMVY': 'VINEYARD HAVEN, MASSACHUSETTS',
    'KMWA': 'MARION, ILLINOIS',
    'KMWC': 'MILWAUKEE, WISCONSIN',
    'KMWH': 'MOSES LAKE, WASHINGTON',
    'KMWK': 'MOUNT AIRY, NORTH CAROLINA',
    'KMWL': 'MINERAL WELLS, TEXAS',
    'KMWM': 'WINDOM, MINNESOTA',
    'KMWN': 'MT WASHINGTON, NEW HAMPSHIRE',
    'KMWS': 'MOUNT WILSON, CALIFORNIA',
    'KMWT': 'MOUNT IDA, ARKANSAS',
    'KMXF': 'MONTGOMERY, ALABAMA',
    'KMXO': 'MONTICELLO, IOWA',
    'KMYF': 'SAN DIEGO, CALIFORNIA',
    'KMYL': 'MC CALL, IDAHOAHO',
    'KMYP': 'MONARCH PASS, COLORADO',
    'KMYR': 'MYRTLE BEACH, SOUTH CAROLINA',
    'KMYV': 'MARYSVILLE, CALIFORNIA',
    'KMZH': 'MOOSE LAKE, MINNESOTA',
    'KN00': 'FULTON, NEW YORK',
    'KN60': 'GARRISON, NORTH DAKOTA',
    'KNAK': 'ANNAPOLIS, MARYLAND',
    'KNBC': 'BEAUFORT, SOUTH CAROLINA,',
    'KNBE': 'DALLAS, TEXAS',
    'KNBG': 'NEW ORLEANS, LOUISANA',
    'KNBJ': 'BARIN, ALABAMA',
    'KNBT': 'PINEY ISLAND, NORTH CAROLINA',
    'KNCA': 'JACKSONVILLE, NORTH CAROLINA',
    'KNDZ': 'MILTON, FLORIDA',
    'KNEL': 'LAKEHURST, NEW JERSEY',
    'KNEN': 'JACKSON, FLORIDA',
    'KNEW': 'NEW ORLEANS, LOUISIANA',
    'KNFE': 'FENTRESS, VIRGINIA',
    'KNFG': 'OCEANSIDE, CALIFORNIA',
    'KNFJ': 'MILTON, FLORIDA',
    'KNFL': 'FALLON, NEVADA',
    'KNFW': 'FORT WORTH, TEXAS',
    'KNGP': 'CORPUS CHRISTI, TEXAS',
    'KNGU': 'NORFOLK, VIRGINIA',
    'KNGW': 'CORPUS CHRISTI, TEXAS',
    'KNHK': 'PATUXENT RIVER, MARYLAND',
    'KNHZ': 'BRUNSWICK, MAINE',
    'KNID': 'INYOKERN, CALIFORNIA',
    'KNIP': 'JACKSONVILLE, FLORIDA',
    'KNJK': 'EL CENTRO, CALIFORNIA',
    'KNJM': 'SWANSBORO, NORTH CAROLINA',
    'KNJW': 'MERIDIAN, MISSISSIPPI',
    'KNKT': 'CHERRY POINT, NORTH CAROLINA',
    'KNKX': 'SAN DIEGO, CALIFORNIA',
    'KNLC': 'LEMOORE, CALIFORNIA',
    'KNMM': 'MERIDIAN, MISSISSIPPI',
    'KNOG': 'ORANGE GROVE, TEXAS',
    'KNOW': 'PORT ANGELES, WASHINGTON',
    'KNPA': 'PENSACOLA, FLORIDA',
    'KNQA': 'MILLINGTON, TENNESSEE',
    'KNQI': 'KINGSVILLE, TEXAS',
    'KNQX': 'KEY WEST, FLORIDA',
    'KNRA': 'COUPEVILLE, WASHINGTON',
    'KNRB': 'MAYPORT, FLORIDA',
    'KNRC': 'CROWS LANDING, CALIFORNIA',
    'KNRS': 'IMPERIAL BEACH, CALIFORNIA',
    'KNSE': 'MILTON, FLORIDA',
    'KNSI': 'SAN NICOLAS ISLAND, CALIFORNIA',
    'KNTD': 'POINT MUGU, CALIFORNIA',
    'KNTU': 'VIRGINIA BEACH, VIRGINIA',
    'KNUC': 'SAN CLEMENTE, CALIFORNIA',
    'KNUI': 'ST INIGOES, MARYLAND',
    'KNUQ': 'MOUNTAIN VIEW, CALIFORNIA',
    'KNUW': 'WHIDBEY ISLAND, WASHINGTON',
    'KNXP': 'TWENTYNINE PALMS, CALIFORNIA',
    'KNXX': 'WILLOW GROVE, PENNSYLVANIA',
    'KNYC': 'NEW YORK CITY, NEW YORK',
    'KNYG': 'QUANTICO, VIRGINIA',
    'KNYL': 'YUMA, ARIZONA',
    'KNZY': 'SAN DIEGO, CALIFORNIA',
    'KO18': 'HANFORD, CALIFORNIA',
    'KO54': 'WEAVERVILLE, CALIFORNIA',
    'KO64': 'FORT BRAGG, CALIFORNIA',
    'KOAJ': 'JACKSONVILLE, NORTH CAROLINA',
    'KOAK': 'OAKLAND, CALIFORNIA',
    'KOAX': 'OMAHA, NEBRASKA',
    'KOBE': 'OKEECHOBEE, FLORIDA',
    'KOCF': 'OCALA, FLORIDA',
    'KOCH': 'NACOGDOCHES, TEXAS',
    'KOCW': 'WASHINGTON, NORTH CAROLINA',
    'KODO': 'ODESSA, TEXAS',
    'KODX': 'ORD, NEBRASKA',
    'KOEB': 'COLDWATER, MICHIGAN',
    'KOEO': 'OSCEOLA, WISCONSIN',
    'KOFF': 'OMAHA, NEBRASKA',
    'KOFK': 'NORFOLK, NEBRASKA',
    'KOFP': 'RICHMOND, VIRGINIA',
    'KOGA': 'OGALLALA, NEBRASKA',
    'KOGB': 'ORANGEBURG, SOUTH CAROLINA',
    'KOGD': 'OGDEN, UTAH',
    'KOGS': 'OGDENSBURG, NEW YORK',
    'KOJA': 'WEATHERFORD, OKLAHOMA',
    'KOJC': 'OLATHE, KANSAS',
    'KOKB': 'OCEANSIDE, CALIFORNIA',
    'KOKC': 'OKLAHOMA CITY, OKLAHOMA',
    'KOKH': 'OAK HARBOR, WASHINGTON',
    'KOKK': 'KOKOMO, INDIANA',
    'KOKM': 'OKMULGEE, OKLAHOMA',
    'KOKV': 'WINCHESTER, VIRGINIA',
    'KOKX': 'NEW YORK CITY, NEW YORK',
    'KOLD': 'OLD TOWN, MAINE',
    'KOLE': 'OLEAN, NEW YORK',
    'KOLF': 'WOLF POINT, MONTANA',
    'KOLM': 'OLYMPIA, WASHINGTON',
    'KOLS': 'NOGALES, ARIZONA',
    'KOLU': 'COLUMBUS, NEBRASKA',
    'KOLV': 'OLIVE BRANCH, MISSISSIPPI',
    'KOLY': 'OLNEY-NOBLE, ILLINOIS',
    'KOLZ': 'OELWEIN, IOWA',
    'KOMA': 'OMAHA, NEBRASKA',
    'KOMH': 'ORANGE, VIRGINIA',
    'KOMK': 'OMAK, WASHINGTON',
    'KOMN': 'ORMOND BEACH, FLORIDA',
    'KONA': 'WINONA, MINNESOTA',
    'KONL': 'O\'NEILL, NEBRASKA',
    'KONM': 'SOCORRO, NEW MEXICO',
    'KONO': 'ONTARIO, OREGON',
    'KONP': 'NEWPORT, OREGON',
    'KONT': 'ONTARIO, CALIFORNIA',
    'KONX': 'CURRITUCK, NORTH CAROLINA',
    'KONZ': 'DETROIT, MICHIGAN',
    'KOOA': 'OSKALOOSA, IOWA',
    'KOPF': 'MIAMI, FLORIDA',
    'KOPN': 'THOMASTON, GEORGIA',
    'KOQT': 'OAK RIDGE, TENNESSEE',
    'KOQU': 'NORTH KINGSTOWN, RHODE ISLAND',
    'KORB': 'ORR, MINNESOTA',
    'KORC': 'ORANGE CITY, IOWA',
    'KORD': 'CHICAGO, ILLINOIS',
    'KORE': 'ORANGE, MASSACHUSETTS',
    'KORF': 'NORFOLK, VIRGINIA',
    'KORG': 'ORANGE, TEXAS',
    'KORH': 'WORCESTER, MASSACHUSETTS',
    'KORL': 'ORLANDO, FLORIDA',
    'KORS': 'EASTSOUND, WASHINGTON',
    'KOSA': 'MOUNT PLEASANT, TEXAS',
    'KOSC': 'OSCODA, MICHIGAN',
    'KOSH': 'OSHKOSH, WISCONSIN',
    'KOSU': 'COLUMBUS, OHIO',
    'KOTG': 'WORTHINGTON, MINNESOTA',
    'KOTH': 'NORTH BEND, OREGON',
    'KOTM': 'OTTUMWA, IOWA',
    'KOUN': 'NORMAN, OKLAHOMA',
    'KOVE': 'OROVILLE, CALIFORNIA',
    'KOVL': 'OLIVIA, MINNESOTA',
    'KOVS': 'BOSCOBEL, WISCONSIN',
    'KOWA': 'OWATONNA, MINNESOTA',
    'KOWB': 'OWENSBORO, KENTUCKY',
    'KOWD': 'NORWOOD, MASSACHUSETTS',
    'KOXB': 'OCEAN CITY, MARYLAND',
    'KOXC': 'OXFORD, CONNECTICUT',
    'KOXR': 'OXNARD, CALIFORNIA',
    'KOXV': 'KNOXVILLE, IOWA',
    'KOZR': 'FORT RUCKER, ALABAMA',
    'KOZW': 'HOWELL, MICHIGAN',
    'KP01': 'AJO, ARIZONA',
    'KP28': 'MEDICINE LODGE, KANSAS',
    'KP53': 'MUNSING LAKESHORE, MICHIGAN',
    'KP58': 'PORT HOPE, MICHIGAN',
    'KP59': 'COPPER HARBOR, MICHIGAN',
    'KP60': 'YELLOWSTONE, WYOMING',
    'KP68': 'EUREKA, NEVADA',
    'KP69': 'LOWELL, IDAHO',
    'KP92': 'SALT POINT, LOUISANA',
    'KPAE': 'EVERETT, WASHINGTON',
    'KPAH': 'PADUCAH, KENTUCKY',
    'KPAM': 'PANAMA CITY, FLORIDA',
    'KPAO': 'PALO ALTO, CALIFORNIA',
    'KPBF': 'PINE BLUFF, ARKANSAS',
    'KPBG': 'PLATTSBURGH, NEW YORK',
    'KPBH': 'PHILLIPS, WISCONSIN',
    'KPBI': 'WEST PALM BEACH, FLORIDA',
    'KPCM': 'PLANT CITY, FLORIDA',
    'KPCZ': 'WAUPACA, WISCONSIN',
    'KPDC': 'PRAIRIE DU CHIEN, WISCONSIN',
    'KPDK': 'ATLANTA, GEORGIA',
    'KPDT': 'PENDLETON, OREGON',
    'KPDX': 'PORTLAND, OREGON',
    'KPEA': 'PELLA, IOWA',
    'KPEO': 'PENN YAN, NEW YORK',
    'KPEQ': 'PECOS, TEXAS',
    'KPEX': 'PAYNESVILLE, MINNESOTA',
    'KPFC': 'PACIFIC CITY, OREGON',
    'KPFN': 'PANAMA CITY, FLORIDA',
    'KPGA': 'PAGE, ARIZONA',
    'KPGD': 'PUNTA GORDA, FLORIDA',
    'KPGV': 'GREENVILLE, NORTH CAROLINA',
    'KPHD': 'NEW PHILADELPHIA, OHIO',
    'KPHF': 'NEWPORT NEWS, VIRGINIA',
    'KPHL': 'PHILADELPHIA, PENNSYLVANIA',
    'KPHN': 'PORT HURON, MICHIGAN',
    'KPHP': 'PHILIP, SOUTH DAKOTA',
    'KPHX': 'PHOENIX, ARIZONA',
    'KPIA': 'PEORIA, ILLINOIS',
    'KPIB': 'HATTIESBURG, MISSISSIPPI',
    'KPIE': 'ST PETERSBURG-CLEARWATER, FLORIDA',
    'KPIH': 'POCATELLO, IDAHOAHO',
    'KPIL': 'PORT ISABEL, TEXAS',
    'KPIR': 'PIERRE, SOUTH DAKOTA',
    'KPIT': 'PITTSBURGH, PENNSYLVANIA',
    'KPKB': 'PARKERSBURG, WEST VIRGINIA',
    'KPKD': 'PARK RAPIDS, MINNESOTA',
    'KPKF': 'PARK FALLS, WISCONSIN',
    'KPKV': 'PORT LAVACA, TEXAS',
    'KPLB': 'PLATTSBURGH, NEW YORK',
    'KPLN': 'PELLSTON, MICHIGAN',
    'KPMD': 'PALMDALE, CALIFORNIA',
    'KPMP': 'POMPANO BEACH, FLORIDA',
    'KPMV': 'PLATTSMOUTH, NEBRASKA',
    'KPNA': 'PINEDALE, WYOMING',
    'KPNC': 'PONCA CITY, OKLAHOMA',
    'KPNE': 'PHILADELPHIA, PENNSYLVANIA',
    'KPNM': 'PRINCETON, MINNESOTA',
    'KPNS': 'PENSACOLA, FLORIDA',
    'KPNT': 'PONTIAC, ILLINOIS',
    'KPOB': 'FORT BRAGG, NORTH CAROLINA',
    'KPOC': 'LA VERNE, CALIFORNIA',
    'KPOE': 'FORT POLK, LOUISANA',
    'KPOF': 'POPLAR BLUFF, MISSOURI',
    'KPOU': 'POUGHKEEPSIE, NEW YORK',
    'KPPA': 'PAMPA, TEXAS',
    'KPPF': 'PARSONS, KANSAS',
    'KPPQ': 'PITTSFIELD, ILLINOIS',
    'KPQI': 'PRESQUE ISLE, MAINE',
    'KPQL': 'PASCAGOULA, MISSISSIPPI',
    'KPQN': 'PIPESTONE, MINNESOTA',
    'KPRB': 'PASO ROBLES, CALIFORNIA',
    'KPRC': 'PRESCOTT, ARIZONA',
    'KPRG': 'PARIS, ILLINOIS',
    'KPRN': 'GREENVILLE, ALABAMA',
    'KPRX': 'PARIS, TEXAS',
    'KPSC': 'PASCO, WASHINGTON',
    'KPSF': 'PITTSFIELD, MASSACHUSETTS',
    'KPSK': 'DUBLIN, VIRGINIA',
    'KPSM': 'PORTSMOUTH, NEW HAMPSHIRE',
    'KPSN': 'PALESTINE, TEXAS',
    'KPSP': 'PALM SPRINGS, CALIFORNIA',
    'KPSX': 'PALACIOS, TEXAS',
    'KPTB': 'PETERSBURG, VIRGINIA',
    'KPTK': 'PONTIAC, MICHIGAN',
    'KPTN': 'PATTERSON, LOUISIANA',
    'KPTT': 'PRATT, KANSAS',
    'KPTV': 'PORTERVILLE, CALIFORNIA',
    'KPTW': 'POTTSTOWN, PENNSYLVANIA',
    'KPUB': 'PUEBLO, COLORADO',
    'KPUC': 'PRICE, UTAH',
    'KPUW': 'PULLMAN, WASHINGTON',
    'KPVC': 'PROVINCETOWN, MASSACHUSETTS',
    'KPVD': 'PROVIDENCE, RHODE ISLAND',
    'KPVJ': 'PAULS VALLEY, OKLAHOMA',
    'KPVU': 'PROVO, UTAH',
    'KPVW': 'PLAINVIEW, TEXAS',
    'KPWA': 'OKLAHOMA CITY, OKLAHOMA',
    'KPWC': 'PINE RIVER, MINNESOTA',
    'KPWG': 'WACO, TEXAS',
    'KPWK': 'CHICAGO, ILLINOIS',
    'KPWM': 'PORTLAND, MAINE',
    'KPWT': 'BREMERTON, WASHINGTON',
    'KPYM': 'PLYMOUTH, MASSACHUSETTS',
    'KPYX': 'PERRYTON, TEXAS',
    'KPZQ': 'ROGERS CITY, MICHIGAN',
    'KQCA': 'GRANITE PEAK, UTAH',
    'KQCB': 'GRANITE PEAK, UTAH',
    'KRAC': 'RACINE, WISCONSIN',
    'KRAD': 'WARROAD, MINNESOTA',
    'KRAL': 'RIVERSIDE, CALIFORNIA',
    'KRAP': 'RAPID CITY, SOUTH DAKOTA',
    'KRAS': 'PORT ARANSAS, TEXAS',
    'KRBD': 'DALLAS, TEXAS',
    'KRBG': 'ROSEBURG, OREGON',
    'KRBL': 'RED BLUFF, CALIFORNIA',
    'KRBO': 'ROBSTOWN, TEXAS',
    'KRCA': 'RAPID CITY, SOUTH DAKOTA',
    'KRCX': 'LADYSMITH, WISCONSIN',
    'KRDD': 'REDDING, CALIFORNIA',
    'KRDG': 'READING, PENNSYLVANIA',
    'KRDK': 'RED OAK, IOWA',
    'KRDM': 'REDMOND, OREGON',
    'KRDR': 'GRAND FORKS, NORTH DAKOTA',
    'KRDU': 'RALEIGH-DURHAM, NORTH CAROLINA',
    'KRED': 'RED LODGE, MONTANA',
    'KREE': 'JANESVILLE, WISCONSIN',
    'KREO': 'ROME, OREGON',
    'KRFD': 'CHICAGO, ILLINOIS',
    'KRGK': 'RED WING, MINNESOTA',
    'KRHI': 'RHINELANDER, WISCONSIN',
    'KRHP': 'ANDREWS, NORTH CAROLINA',
    'KRHV': 'SAN JOSE, CALIFORNIA',
    'KRIC': 'RICHMOND, VIRGINIA',
    'KRIL': 'RIFLE, COLORADO',
    'KRIV': 'RIVERSIDE, CALIFORNIA',
    'KRIW': 'RIVERTON, WYOMING',
    'KRKD': 'ROCKLAND, MAINE',
    'KRKP': 'ROCKPORT, TEXAS',
    'KRKR': 'POTEAU, OKLAHOMA',
    'KRKS': 'ROCK SPRINGS, WYOMING',
    'KRLX': 'CHARLESTON, WEST VIRGINIA',
    'KRME': 'ROME, NEW YORK',
    'KRMG': 'ROME, GEORGIA',
    'KRMN': 'STAFFORD, VIRGINIA',
    'KRMY': 'MARSHALL, MICHIGAN',
    'KRND': 'SAN ANTONIO, TEXAS',
    'KRNH': 'NEW RICHMOND, WISCONSIN',
    'KRNM': 'RAMONA, CALIFORNIA',
    'KRNO': 'RENO, NEVADA',
    'KRNP': 'OWOSSO, MICHIGAN',
    'KRNT': 'RENTON, WASHINGTON',
    'KROA': 'ROANOKE, VIRGINIA',
    'KROC': 'ROCHESTER, NEW YORK',
    'KROG': 'ROGERS, ARKANSAS',
    'KROS': 'RUSH CITY, MINNESOTA',
    'KROW': 'ROSWELL, NEW MEXICO',
    'KROX': 'ROSEAU, MINNESOTA',
    'KRPD': 'RICE LAKE, WISCONSIN',
    'KRPH': 'GRAHAM, TEXAS',
    'KRPJ': 'ROCHELLE, ILLINOIS',
    'KRQB': 'BIG RAPIDS, MICHIGAN',
    'KRQE': 'WINDOW ROCK, ARIZONA',
    'KRQO': 'EL RENO, OKLAHOMA',
    'KRRL': 'MERRILL, WISCONSIN',
    'KRRT': 'WARROAD, MINNESOTA',
    'KRSL': 'RUSSELL, KANSAS',
    'KRSN': 'RUSTON, LOUISIANA',
    'KRST': 'ROCHESTER, MINNESOTA',
    'KRSV': 'ROBINSON, ILLINOIS',
    'KRSW': 'FORT MYERS, FLORIDA',
    'KRTN': 'RATON, NEW MEXICO',
    'KRUE': 'RUSSELLVILLE, ARKANSAS',
    'KRUG': 'RUGBY, NORTH DAKOTA',
    'KRUQ': 'SALISBURY, NORTH CAROLINA',
    'KRUT': 'RUTLAND, VERMONT',
    'KRVL': 'REEDSVILLE, PENNSYLVANIA',
    'KRVS': 'TULSA, OKLAHOMA',
    'KRWF': 'REDWOOD FALLS, MINNESOTA',
    'KRWI': 'ROCKY MOUNT, NORTH CAROLINA',
    'KRWL': 'RAWLINS, WYOMING',
    'KRWV': 'CALDWELL, TEXAS',
    'KRXE': 'REXBURG, IDAHOAHO',
    'KRYV': 'WATERTOWN, WISCONSIN',
    'KRYY': 'ATLANTA, GEORGIA',
    'KRZN': 'SIREN, WISCONSIN',
    'KRZZ': 'ROANOKE RAPIDS, NORTH CAROLINA',
    'KS21': 'SUNRIVER, OREGON',
    'KS25': 'WATFORD CITY, NORTH DAKOTA',
    'KS32': 'COOPERSTOWN, NORTH DAKOTA',
    'KS47': 'HATHAWAY MEAD, OREGON',
    'KS80': 'GRANGEVILLE, IDAHO',
    'KS88': 'ARLINGTON, WASHINGTON',
    'KSAC': 'SACRAMENTO, CALIFORNIA',
    'KSAD': 'SAFFORD, ARIZONA',
    'KSAF': 'SANTA FE, NEW MEXICO',
    'KSAN': 'SAN DIEGO, CALIFORNIA',
    'KSAR': 'SPARTA, ILLINOIS',
    'KSAT': 'SAN ANTONIO, TEXAS',
    'KSAV': 'SAVANNAH, GEORGIA',
    'KSAW': 'MARQUETTE, MICHIGAN',
    'KSAZ': 'STAPLES, MINNESOTA',
    'KSBA': 'SANTA BARBARA, CALIFORNIA',
    'KSBD': 'SAN BERNARDINO, CALIFORNIA',
    'KSBM': 'SHEBOYGAN, WISCONSIN',
    'KSBN': 'SOUTH BEND, INDIANA',
    'KSBP': 'SAN LUIS OBISPO, CALIFORNIA',
    'KSBS': 'STEAMBOAT SPRINGS, COLORADO',
    'KSBY': 'SALISBURY, MARYLAND',
    'KSCH': 'SCHENECTADY, NEW YORK',
    'KSCK': 'STOCKTON, CALIFORNIA',
    'KSDA': 'SHENANDOAH, IOWA',
    'KSDB': 'SANDBERG, CALIFORNIA',
    'KSDF': 'LOUISVILLE, KENTUCKY',
    'KSDL': 'SCOTTSDALE, ARIZONA',
    'KSDM': 'SAN DIEGO, CALIFORNIA',
    'KSDY': 'SIDNEY, MONTANA',
    'KSEA': 'SEATTLE, WASHINGTON',
    'KSEE': 'SAN DIEGO, CALIFORNIA',
    'KSEG': 'SELINSGROVE, PENNSYLVANIA',
    'KSEM': 'SELMA, ALABAMA',
    'KSEP': 'STEPHENVILLE, TEXAS',
    'KSET': 'ST CHARLES, MISSOURI',
    'KSEW': 'SEATTLE, WASHINGTON',
    'KSEZ': 'SEDONA, ARIZONA',
    'KSFB': 'ORLANDO, FLORIDA',
    'KSFF': 'SPOKANE, WASHINGTON',
    'KSFM': 'SANFORD, MAINE',
    'KSFO': 'SAN FRANCISCO, CALIFORNIA',
    'KSFQ': 'SUFFOLK, VIRGINIA',
    'KSFY': 'SAVANNA, ILLINOIS',
    'KSFZ': 'PAWTUCKET, RHODE ISLAND',
    'KSGF': 'SPRINGFIELD, MISSOURI',
    'KSGH': 'SPRINGFIELD, OHIO',
    'KSGJ': 'ST AUGUSTINE, FLORIDA',
    'KSGR': 'HOUSTON, TEXAS',
    'KSGS': 'SOUTH ST PAUL, MINNESOTA',
    'KSGT': 'STUTTGART, ARKANSAS',
    'KSGU': 'ST GEORGE, UTAH',
    'KSHD': 'STAUNTON, VIRGINIA',
    'KSHL': 'SHELDON, IOWA',
    'KSHN': 'SHELTON, WASHINGTON',
    'KSHR': 'SHERIDAN, WYOMING',
    'KSHV': 'SHREVEPORT, LOUISIANA',
    'KSIY': 'MONTAGUE, CALIFORNIA',
    'KSJC': 'SAN JOSE, CALIFORNIA',
    'KSJN': 'ST JOHNS, ARIZONA',
    'KSJT': 'SAN ANGELO, TEXAS',
    'KSJX': 'BEAVER ISLAND, MICHIGAN',
    'KSKA': 'SPOKANE, WASHINGTON',
    'KSKF': 'SAN ANTONIO, TEXAS',
    'KSKX': 'TAOS, NEW MEXICO',
    'KSLB': 'STORM LAKE, IOWA',
    'KSLC': 'SALT LAKE CITY, UTAH',
    'KSLE': 'SALEM, OREGON',
    'KSLG': 'SILOAM SPRINGS, ARKANSAS',
    'KSLH': 'CHEBOYGAN, MICHIGAN',
    'KSLI': 'LOS ALAMITOS, CALIFORNIA',
    'KSLK': 'SARANAC LAKE, NEW YORK',
    'KSLN': 'SALINA, KANSAS',
    'KSLO': 'SALEM, ILLINOIS',
    'KSLR': 'SULPHUR SPRINGS, TEXAS',
    'KSME': 'SOMERSET, KENTUCKY',
    'KSMF': 'SACRAMENTO, CALIFORNIA',
    'KSMN': 'SALMON, IDAHOAHO',
    'KSMO': 'SANTA MONICA, CALIFORNIA',
    'KSMQ': 'SOMERVILLE, NEW JERSEY',
    'KSMX': 'SANTA MARIA, CALIFORNIA',
    'KSNA': 'SANTA ANA, CALIFORNIA',
    'KSNC': 'CHESTER, CONNECTICUT',
    'KSNK': 'SNYDER, TEXAS',
    'KSNL': 'SHAWNEE, OKLAHOMA',
    'KSNS': 'SALINAS, CALIFORNIA',
    'KSNT': 'STANLEY, IDAHO',
    'KSNY': 'SIDNEY, NEBRASKA',
    'KSOA': 'SONORA, TEXAS',
    'KSOP': 'PINEHURST, NORTH CAROLINA',
    'KSOW': 'SHOW LOW, ARIZONA',
    'KSPA': 'SPARTANBURG, SOUTH CAROLINA',
    'KSPB': 'SCAPPOOSE, OREGON',
    'KSPD': 'SPRINGFIELD, COLORADO',
    'KSPF': 'SPEARFISH, SOUTH DAKOTA',
    'KSPG': 'ST PETERSBURG, FLORIDA',
    'KSPI': 'SPRINGFIELD, ILLINOIS',
    'KSPL': 'SOUTH PADRE ISLAND, TEXAS',
    'KSPS': 'WICHITA FALLS, TEXAS',
    'KSPW': 'SPENCER, IOWA',
    'KSQI': 'STERLING, ILLINOIS',
    'KSQL': 'SAN CARLOS, CALIFORNIA',
    'KSRC': 'SEARCY, ARKANSAS',
    'KSRE': 'SEMINOLE, OKLAHOMA',
    'KSRQ': 'SARASOTA, FLORIDA',
    'KSRR': 'RUIDOSO, NEW MEXICO',
    'KSSC': 'SUMTER, SOUTH CAROLINA,',
    'KSSF': 'SAN ANTONIO, TEXAS',
    'KSSI': 'BRUNSWICK, GEORGIA',
    'KSTC': 'ST CLOUD, MINNESOTA',
    'KSTE': 'STEVENS POINT, WISCONSIN',
    'KSTJ': 'ST JOSEPH, MISSOURI',
    'KSTL': 'ST LOUIS, MISSOURI',
    'KSTP': 'ST PAUL, MINNESOTA',
    'KSTS': 'SANTA ROSA, CALIFORNIA',
    'KSTT': 'CHARLOTTE AMALIE, VIRGIN ISLANDS',
    'KSTX': 'CHRISTIANSTED, VIRGIN ISLANDS',
    'KSUA': 'STUART, FLORIDA',
    'KSUE': 'STURGEON BAY, WISCONSIN',
    'KSUN': 'HAILEY, IDAHOAHO',
    'KSUS': 'ST LOUIS, MISSOURI',
    'KSUT': 'OAK ISLAND, NORTH CAROLINA',
    'KSUU': 'FAIRFIELD, CALIFORNIA',
    'KSUW': 'SUPERIOR, WISCONSIN',
    'KSUX': 'SIOUX CITY, IOWA',
    'KSVC': 'SILVER CITY, NEW MEXICO',
    'KSVE': 'SUSANVILLE, CALIFORNIA',
    'KSVH': 'STATESVILLE, NORTH CAROLINA',
    'KSVN': 'SAVANNAH, GEORGIA',
    'KSWD': 'SEWARD, ALASKA',
    'KSWF': 'NEWBURGH, NEW YORK',
    'KSWO': 'STILLWATER, OKLAHOMA',
    'KSWW': 'SWEETWATER, TEXAS',
    'KSXT': 'SEXTON SUMMIT, OREGON',
    'KSYN': 'STANTON, MINNESOTA',
    'KSYR': 'SYRACUSE, NEW YORK',
    'KSZL': 'KNOB NOSTER, MISSOURI',
    'KSZN': 'SANTA CRUZ, CALIFORNIA',
    'KSZT': 'SANDPOINT, IDAHOAHO',
    'KT65': 'WESLACO, TEXAS',
    'KT82': 'FREDERICKSBURG, TEXAS',
    'KTAD': 'TRINIDAD, COLORADO',
    'KTAN': 'TAUNTON, MASSACHUSETTS',
    'KTAZ': 'TAYLORVILLE, ILLINOIS',
    'KTBN': 'FORT LEONARD WOOD, MISSOURI',
    'KTBR': 'STATESBORO, GEORGIA',
    'KTBW': 'TAMPA, FLORIDA',
    'KTCC': 'TUCUMCARI, NEW MEXICO',
    'KTCL': 'TUSCALOOSA, ALABAMA',
    'KTCM': 'SEATTLE, WASHINGTON',
    'KTCS': 'TRUTH OR CONSEQUENCES, NEW MEXICO',
    'KTDF': 'ROXBORO, NORTH CAROLINA',
    'KTDO': 'TOLEDO, WASHINGTON',
    'KTDZ': 'TOLEDO, OHIO',
    'KTEB': 'TETERBORO, NEW JERSEY',
    'KTEW': 'MASON, MICHIGAN',
    'KTEX': 'TELLURIDE, COLORADO',
    'KTFX': 'GREAT FALLS, MONTANA',
    'KTHV': 'YORK, PENNSYLVANIA',
    'KTIF': 'THEDFORD, NEBRASKA',
    'KTIK': 'OKLAHOMA CITY, OKLAHOMA',
    'KTIP': 'RANTOUL, ILLINOIS',
    'KTIW': 'TACOMA, WASHINGTON',
    'KTIX': 'TITUSVILLE, FLORIDA',
    'KTKC': 'TRACY, MINNESOTA',
    'KTKI': 'DALLAS, TEXAS',
    'KTKV': 'TOMAHAWK, WISCONSIN',
    'KTLH': 'TALLAHASSEE, FLORIDA',
    'KTMB': 'MIAMI, FLORIDA',
    'KTNB': 'BOONE, NORTH CAROLINA',
    'KTNU': 'NEWTON, IOWA',
    'KTNX': 'MELLAN, NEVADA',
    'KTOA': 'TORRANCE, CALIFORNIA',
    'KTOB': 'DODGE CENTER, MINNESOTA',
    'KTOI': 'TROY, ALABAMA',
    'KTOL': 'TOLEDO, OHIO',
    'KTOP': 'TOPEKA, KANSAS',
    'KTOR': 'TORRINGTON, WYOMING',
    'KTPA': 'TAMPA, FLORIDA',
    'KTPF': 'TAMPA, FLORIDA',
    'KTPH': 'TONOPAH, NEVADA',
    'KTPL': 'TEMPLE, TEXAS',
    'KTQE': 'TEKAMAH, NEBRASKA',
    'KTQH': 'TAHLEQUAH, OKLAHOMA',
    'KTRI': 'BRISTOL, TENNESSEE',
    'KTRK': 'TRUCKEE, CALIFORNIA',
    'KTRL': 'TERRELL, TEXAS',
    'KTRM': 'PALM SPRINGS, CALIFORNIA',
    'KTTA': 'SANFORD, NORTH CAROLINA',
    'KTTD': 'PORTLAND, OREGON',
    'KTTF': 'MONROE, MICHIGAN',
    'KTTN': 'TRENTON, NEW JERSEY',
    'KTTS': 'CAPE KENNEDY, FLORIDA',
    'KTUL': 'TULSA, OKLAHOMA',
    'KTUP': 'TUPELO, MISSISSIPPI',
    'KTUS': 'TUCSON, ARIZONA',
    'KTVC': 'TRAVERSE CITY, MICHIGAN',
    'KTVF': 'THIEF RIVER FALLS, MINNESOTA',
    'KTVI': 'THOMASVILLE, GEORGIA',
    'KTVL': 'SOUTH LAKE TAHOE, CALIFORNIA',
    'KTVR': 'TALLULAH, LOUISIANA',
    'KTWF': 'TWIN FALLS, IDAHOAHO',
    'KTWM': 'TWO HARBORS, MINNESOTA',
    'KTXK': 'TEXARKANA, ARKANSAS',
    'KTYR': 'TYLER, TEXAS',
    'KTYS': 'KNOXVILLE, TENNESSEE',
    'KTZR': 'COLUMBUS, OHIO',
    'KU16': 'HILL RANGE, UTAH',
    'KU24': 'DELTA, UTAH',
    'KU42': 'SALT LAKE CITY, UTAH',
    'KU67': 'ROOSEVELT, UTAH',
    'KU78': 'SODA SPRINGS, IDAHO',
    'KUAO': 'AURORA, OREGON',
    'KUCA': 'UTICA, NEW YORK',
    'KUCP': 'NEW CASTLE, PENNSYLVANIA',
    'KUDG': 'DARLINGTON, SOUTH CAROLINA',
    'KUES': 'WAUKESHA, WISCONSIN',
    'KUGN': 'CHICAGO, ILLINOIS',
    'KUIL': 'QUILLAYUTE, WASHINGTON',
    'KUIN': 'QUINCY, ILLINOIS',
    'KUKF': 'NORTH WILKESBORO, NORTH CAROLINA',
    'KUKI': 'UKIAH, CALIFORNIA',
    'KUKL': 'BURLINGTON, KANSAS',
    'KUKT': 'QUAKERTOWN, PENNSYLVANIA',
    'KULM': 'NEW ULM, MINNESOTA',
    'KUNO': 'WEST PLAINS, MISSOURI',
    'KUNU': 'JUNEAU, WISCONSIN',
    'KUNV': 'STATE COLLEGE, PENNSYLVANIA',
    'KUOX': 'OXFORD, MISSISSIPPI',
    'KUTA': 'TUNICA, MISSISSIPPI',
    'KUTS': 'HUNTSVILLE, TEXAS',
    'KUUU': 'NEWPORT, RHODE ISLAND',
    'KUVA': 'UVALDE, TEXAS',
    'KUZA': 'ROCK HILL, SOUTH CAROLINA',
    'KVAD': 'VALDOSTA, GEORGIA',
    'KVAY': 'MOUNT HOLLY, NEW JERSEY',
    'KVBG': 'VANDENBERG, CALIFORNIA',
    'KVBT': 'BENTONVILLE, ARKANSAS',
    'KVCB': 'VACAVILLE, CALIFORNIA',
    'KVCT': 'VICTORIA, TEXAS',
    'KVCV': 'VICTORVILLE, CALIFORNIA',
    'KVDF': 'TAMPA, FLORIDA',
    'KVDI': 'VIDALIA, GEORGIA',
    'KVDW': 'VEDAUWOO, WYOMING',
    'KVEL': 'VERNAL, UTAH',
    'KVGT': 'LAS VEGAS, NEVADA',
    'KVIH': 'ROLLA, MISSOURI',
    'KVIS': 'VISALIA, CALIFORNIA',
    'KVJI': 'ABINGDON, VIRGINIA',
    'KVKS': 'VICKSBURG, MISSISSIPPI',
    'KVLD': 'VALDOSTA, GEORGIA',
    'KVLL': 'TROY, MICHIGAN',
    'KVNY': 'VAN NUYS, CALIFORNIA',
    'KVOK': 'VOLK, WISCONSIN',
    'KVPC': 'CARTERSVILLE, GEORGIA',
    'KVPS': 'VALPARAISO, FLORIDA',
    'KVPZ': 'VALPARAISO, INDIANA',
    'KVQQ': 'JACKSONVILLE, FLORIDA',
    'KVRB': 'VERO BEACH, FLORIDA',
    'KVSF': 'SPRINGFIELD, VERMONT',
    'KVTA': 'NEWARK, OHIO',
    'KVTI': 'VINTON, IOWA',
    'KVTN': 'VALENTINE, NEBRASKA',
    'KVTP': 'LA VETA PASS, COLORADO',
    'KVUJ': 'ALBEMARLE, NORTH CAROLINA',
    'KVUO': 'VANCOUVER, WASHINGTON',
    'KVVG': 'LADY LAKE, FLORIDA',
    'KVVV': 'ORTONVILLE, MINNESOTA',
    'KVWU': 'WASKISH, MINNESOTA',
    'KVYS': 'PERU, ILLINOIS',
    'KW22': 'BUCKHANNON, WEST VIRGINIA',
    'KW39': 'ROCHE HARBOR SPB, WASHINGTON',
    'KW45': 'LURAY, VIRGINIA',
    'KW51': 'CAPE CHARLES, VIRGINIA',
    'KW63': 'CLARKSVILLE, VIRGINIA',
    'KW99': 'TOWN HILL, WEST VIRGINIA',
    'KWAL': 'CHINCOTEAGUE, VIRGINIA',
    'KWDG': 'ENID, OKLAHOMA',
    'KWDR': 'WINDER, GEORGIA',
    'KWHP': 'LOS ANGELES, CALIFORNIA',
    'KWJF': 'LANCASTER, CALIFORNIA',
    'KWLD': 'WINFIELD, KANSAS',
    'KWMC': 'WINNEMUCCA, NEVADA',
    'KWRB': 'WARNER ROBINS, GEORGIA',
    'KWRI': 'WRIGHTSTOWN, NEW JERSEY',
    'KWRL': 'WORLAND, WYOMING',
    'KWST': 'WESTERLY, RHODE ISLAND',
    'KWVI': 'WATSONVILLE, CALIFORNIA',
    'KWVL': 'WATERVILLE, MAINE',
    'KWWD': 'WILDWOOD, NEW JERSEY',
    'KWWR': 'WOODWARD, OKLAHOMA',
    'KWYS': 'WEST YELLOWSTONE, MONTANA',
    'KX21': 'TITUSVILLE, FLORIDA',
    'KXBP': 'BRIDGEPORT, TEXAS',
    'KXMR': 'COCOA BEACH, FLORIDA',
    'KXNA': 'FAYETTEVILLE, ARKANSAS',
    'KXVG': 'LONGVILLE, MINNESOTA',
    'KY19': 'MANDAN, NORTH DAKOTA',
    'KY50': 'WAUTOMA, WISCONSIN',
    'KY51': 'VIROQUA, WISCONSIN',
    'KY63': 'ELBOW LAKE, MINNESOTA',
    'KYIP': 'DETROIT, MICHIGAN',
    'KYKM': 'YAKIMA, WASHINGTON',
    'KYKN': 'YANKTON, SOUTH DAKOTA',
    'KYNG': 'YOUNGSTOWN, OHIO',
    'KYUM': 'YUMA, ARIZONA',
    'KZAB': 'ALBUQUERQUE, NEW MEXICO',
    'KZLC': 'SALT LAKE CITY, UTAH',
    'KZSE': 'AUBURN, WASHINGTON',
    'KZZV': 'ZANESVILLE, OHIO',
    'PAAK': 'ATKA, ALASKA',
    'PAAP': 'PORT ALEXANDER, ALASKA',
    'PAAQ': 'PALMER, ALASKA',
    'PABA': 'BARTER ISLAND LRRS, ALASKA',
    'PABE': 'BETHEL, ALASKA',
    'PABG': 'BELUGA, ALASKA',
    'PABI': 'DELTA JUNCTION, ALASKA',
    'PABL': 'BUCKLAND, ALASKA',
    'PABN': 'NABESNA, ALASKA',
    'PABR': 'BARROW, ALASKA',
    'PABT': 'BETTLES, ALASKA',
    'PABV': 'BIRCHWOOD, ALASKA',
    'PACD': 'COLD BAY, ALASKA',
    'PACE': 'CENTRAL, ALASKA',
    'PACL': 'CLEAR, ALASKA',
    'PACP': 'CAPE SAINT ELIAS, ALASKA',
    'PACR': 'CIRCLE, ALASKA',
    'PACS': 'CAPE SARICHEF, ALASKA',
    'PACV': 'CORDOVA, ALASKA',
    'PACY': 'YAKATAGA, ALASKA',
    'PACZ': 'CAPE ROMANZOFF, ALASKA',
    'PADE': 'DEERING, ALASKA',
    'PADK': 'ADAK ISLAND, ALASKA',
    'PADL': 'DILLINGHAM, ALASKA',
    'PADQ': 'KODIAK, ALASKA',
    'PADT': 'SLANA, ALASKA',
    'PADU': 'UNALASKA, ALASKA',
    'PAEC': 'CHULITNA, ALASKA',
    'PAED': 'ANCHORAGE, ALASKA',
    'PAEG': 'EAGLE, ALASKA',
    'PAEH': 'CAPE NEWENHAM, ALASKA',
    'PAEI': 'FAIRBANKS, ALASKA',
    'PAEL': 'ELFIN COVE, ALASKA',
    'PAEM': 'EMMONAK, ALASKA',
    'PAEN': 'KENAI, ALASKA',
    'PAER': 'MERRILL PASS WEST, ALASKA',
    'PAFA': 'FAIRBANKS, ALASKA',
    'PAFB': 'FAIRBANKS, ALASKA',
    'PAFE': 'KAKE, ALASKA',
    'PAFK': 'FAREWELL LAKE, ALASKA',
    'PAFM': 'AMBLER, ALASKA',
    'PAFR': 'FORT RICHARDSON, ALASKA',
    'PAFW': 'FAREWELL, ALASKA',
    'PAGA': 'GALENA, ALASKA',
    'PAGB': 'GALBRAITH LAKE, ALASKA',
    'PAGK': 'GULKANA, ALASKA',
    'PAGL': 'GOLOVIN, ALASKA',
    'PAGM': 'GAMBELL, ALASKA',
    'PAGN': 'ANGOON, ALASKA',
    'PAGS': 'GUSTAVUS, ALASKA',
    'PAGT': 'NIGHTMUTE, ALASKA',
    'PAGY': 'SKAGWAY, ALASKA',
    'PAHL': 'HUSLIA, ALASKA',
    'PAHN': 'HAINES, ALASKA',
    'PAHO': 'HOMER, ALASKA',
    'PAHP': 'HOOPER BAY, ALASKA',
    'PAHV': 'HEALY, ALASKA',
    'PAHY': 'HYDABURG, ALASKA',
    'PAHZ': 'HAYES RIVER, ALASKA',
    'PAII': 'EGEGIK, ALASKA',
    'PAIK': 'KIANA, ALASKA',
    'PAIL': 'ILIAMNA, ALASKA',
    'PAIM': 'UTOPIA CREEK, ALASKA',
    'PAIN': 'MCKINLEY PARK, ALASKA',
    'PAIW': 'WALES, ALASKA',
    'PAIZ': 'LAZY MTN, ALASKA',
    'PAJB': 'BIORKA ISLAND, ALASKA',
    'PAJC': 'CHIGNIK, ALASKA',
    'PAJN': 'JUNEAU, ALASKA',
    'PAJO': 'CAPE HINCHINBROOK, ALASKA',
    'PAJV': 'SUTTON, ALASKA',
    'PAKI': 'KIPNUK, ALASKA',
    'PAKK': 'KOYUK, ALASKA',
    'PAKN': 'KING SALMON, ALASKA',
    'PAKO': 'NIKOLSKI, ALASKA',
    'PAKP': 'ANAKTUVUK PASS, ALASKA',
    'PAKT': 'KETCHIKAN, ALASKA',
    'PAKU': 'KUPARUK, ALASKA',
    'PAKV': 'KALTAG, ALASKA',
    'PAKW': 'KLAWOCK, ALASKA',
    'PALH': 'ANCHORAGE, ALASKA',
    'PALJ': 'PORT ALSWORTH, ALASKA',
    'PALK': 'SNOWSHOE LAKE, ALASKA',
    'PALP': 'DEADHORSE, ALASKA',
    'PALR': 'CHANDALAR LAKE, ALASKA',
    'PALU': 'CAPE LISBURNE, ALASKA',
    'PALV': 'BIG RIVER LAKE, ALASKA',
    'PAMC': 'MCGRATH, ALASKA',
    'PAMD': 'MIDDLETON ISLAND, ALASKA',
    'PAMH': 'MINCHUMINA, ALASKA',
    'PAML': 'MANLEY HOT SPRINGS, ALASKA',
    'PAMM': 'METLAKATLA, ALASKA',
    'PAMR': 'ANCHORAGE, ALASKA',
    'PAMX': 'MCCARTHY, ALASKA',
    'PAMY': 'MEKORYUK, ALASKA',
    'PANC': 'ANCHORAGE, ALASKA',
    'PANI': 'ANIAK, ALASKA',
    'PANN': 'NENANA, ALASKA',
    'PANR': 'FUNTER BAY, ALASKA',
    'PANT': 'ANNETTE ISLAND, ALASKA',
    'PANV': 'ANVIK, ALASKA',
    'PAOH': 'HOONAH, ALASKA',
    'PAOM': 'NOME, ALASKA',
    'PAOR': 'NORTHWAY, ALASKA',
    'PAOT': 'KOTZEBUE, ALASKA',
    'PAPB': 'ST GEORGE, ALASKA',
    'PAPC': 'PORT CLARENCE, ALASKA',
    'PAPG': 'PETERSBURG, ALASKA',
    'PAPH': 'PORT HEIDEN, ALASKA',
    'PAPM': 'PLATINUM, ALASKA',
    'PAPO': 'POINT HOPE, ALASKA',
    'PAPR': 'PROSPECT CREEK, ALASKA',
    'PAPT': 'PUNTILLA, ALASKA',
    'PAQT': 'NUIQSUT, ALASKA',
    'PARC': 'ARCTIC VILLAGE, ALASKA',
    'PARD': 'RED DOG MINE, ALASKA',
    'PARL': 'CENTRAL, ALASKA',
    'PASA': 'SAVOONGA, ALASKA',
    'PASC': 'DEADHORSE, ALASKA',
    'PASD': 'SAND POINT, ALASKA',
    'PASH': 'SHISHMAREF, ALASKA',
    'PASI': 'SITKA, ALASKA',
    'PASK': 'SELAWIK, ALASKA',
    'PASL': 'SLEETMUTE, ALASKA',
    'PASM': 'ST MARY\'S, ALASKA',
    'PASN': 'ST PAUL ISLAND, ALASKA',
    'PASO': 'SELDOVIA, ALASKA',
    'PASP': 'SHEEP MOUNTAIN, ALASKA',
    'PASV': 'SPARREVOHN, ALASKA',
    'PASW': 'SKWENTNA, ALASKA',
    'PASX': 'SOLDOTNA, ALASKA',
    'PASY': 'SHEMYA, ALASKA',
    'PATA': 'TANANA, ALASKA',
    'PATC': 'TIN CITY, ALASKA',
    'PATE': 'TELLER, ALASKA',
    'PATG': 'TOGIAK VILLAGE, ALASKA',
    'PATJ': 'TOK, ALASKA',
    'PATK': 'TALKEETNA, ALASKA',
    'PATL': 'TATALINA, ALASKA',
    'PATO': 'WHITTIER, ALASKA',
    'PATW': 'CANTWELL, ALASKA',
    'PAUM': 'UMIAT, ALASKA',
    'PAUN': 'UNALAKLEET, ALASKA',
    'PAUO': 'WILLOW, ALASKA',
    'PAVD': 'VALDEZ, ALASKA',
    'PAVL': 'KIVALINA, ALASKA',
    'PAVW': 'VALDEZ, ALASKA',
    'PAWD': 'SEWARD, ALASKA',
    'PAWG': 'WRANGELL, ALASKA',
    'PAWI': 'WAINWRIGHT, ALASKA',
    'PAWN': 'NOATAK, ALASKA',
    'PAWR': 'WHITTIER, ALASKA',
    'PAWS': 'WASILLA, ALASKA',
    'PAXK': 'PAXSON, ALASKA',
    'PAYA': 'YAKUTAT, ALASKA',
    'PAZK': 'EUREKA, ALASKA',
    'PFYU': 'FORT YUKON, ALASKA',
    'PGRO': 'ROTA ISLAND, NORTH MARIANA ISLANDS',
    'PGSN': 'SAIPAN ISLAND, NORTH MARIANA ISLANDS',
    'PGUM': 'GUAM, GUAM',
    'PGWT': 'TINIAN ISLAND, NORTH MARIANA ISLANDS',
    'PHBK': 'KEKAHA, HAWAII',
    'PHFO': 'HONOLULU, HAWAII',
    'PHHI': 'WAHIAWA, HAWAII',
    'PHHN': 'HANA, HAWAII',
    'PHIK': 'HONOLULU, HAWAII',
    'PHJH': 'LAHAINA, HAWAII',
    'PHJR': 'KAPOLEI, HAWAII',
    'PHKO': 'KAILUA, HAWAII',
    'PHLI': 'LIHUE, HAWAII',
    'PHMK': 'KAUNAKAKAI, HAWAII',
    'PHMO': 'MOLOKAI, HAWAII',
    'PHMU': 'KAMUELA, HAWAII',
    'PHNG': 'KANEOHE, HAWAII',
    'PHNL': 'HONOLULU, HAWAII',
    'PHNY': 'LANAI CITY, HAWAII',
    'PHOG': 'KAHULUI, HAWAII',
    'PHSF': 'POHAKULOA, HAWAII',
    'PHTO': 'HILO, HAWAII',
    'PHWH': 'SOUTH KONA, HAWAII',
    'PMDY': 'MIDWAY ATOLL, MIDWAY ATOLL',
    'POLI': 'OLIKTOK POINT, ALASKA',
    'PPIZ': 'POINT LAY, ALASKA',
    'XDIF': 'Zacatenco, CDMX',
}

