# 2019-04-23 RS41 Demod Chain High-Pass Filtering

In many basic FSK demodulators the incoming signal is passed through a FM demodulator, and the DC level of the output compared with a reference level. This technique is commonly called 'data slicing'. In a FM demodulator, a frequency offset between the incoming signal and the FM receiver centre frequency will result in a DC offset in the output. If the DC offset is such that the 'top' and 'bottom' of the FSK signal come close to the reference level, then the demodulator cannot discriminate between 1s and 0s, and performance can be degraded significantly.

In the case of the [RS demodulators](https://github.com/rs1729/RS) in use by auto_rx, a better FSK demodulation technique is used, but is still sensitive to DC offsets in the input waveform. 

Up until now auto_rx has not applied high-pass filtering in the demodulation chain for Vaisala RS41s, as there was some concern that it would degrade receive performance due to relatively high (4800) baud rate used by these sondes. The decode chains for the RS92, DFM and iMet decoders include a 20 Hz high-pass filter, applied during a resampling step. Not much time has been spent investigating the effect of the high-pass filter, as when using the recommended RTLSDR type (RTLSDR v3, with a TCXO) the observed drift was negligible and 'real-world' performance seemed OK.

Some discussions with a user attempting to use auto_rx with a 'drifty' SDR prompted a re-investigation of the use of a high-pass filter in the demodulation chain. Using the [demodulator test scripts](https://github.com/projecthorus/radiosonde_auto_rx/tree/master/auto_rx/test), the RS41 demod PER-vs-Eb/N0 performance was calculated for a a range of frequency offsets, both with and without a high-pass filter (20Hz cutoff) applied. Eb/N0 values in the range 5 to 20dB were used, and the point at which the PER crossed over 50% was determined for use in comparing performance between the different scenarios. The results appear in the table below:


### Relative PER Performance vs Frequency Offset

Offset (Hz) | Equivalent PPM Error | No High-Pass (dB) | High-Pass (dB)
------------|----------------------|-------------------|-----------------
0 | 0 | 0 | -0.55
250 | 0.5 | -0.05 | -0.55
500 | 1.25 | -0.45 | -0.55
750 | 1.875 | -2.35 | -0.60
1000 | 2.5 | No Decodes | -0.70
2000 | 5 | No Decodes | -1.45
3000 | 7.5 | No Decodes | -3.60
4000 | 10 | No Decodes | -8.90
5000 | 12.5 | No Decodes | No Decodes

The dB values are given as a relative value compared with the 'ideal' case (no high-pass filter and zero frequency offset). Also shown is the PPM error equivalent to the frequency offset, calculated at 400 MHz.

We can see that the non-highpass decode chain (the current decode chain as of 1.0.3.1) degrades significantly above 500 Hz offset, and completely breaks for offsets of 1kHz and above. When a high-pass filter is used, there is an immediate 0.55 dB degradation compared to the ideal case, but the drop-off in performance is much slower with frequency offset. Above 2kHz frequency offset the FSK signal approaches the edges of the FM channel filter resulting in unavoidable performance degradation (unless the channel filter is widened, which causes further performance issues).

## Discussion

The RTLSDR type recommended in the installation guide are those with TCXOs. These commonly come in 0.5 and 1ppm varieties, which indicates the approximate expected drift over the rated operating temperature range (often -40 to +85˚C). Asuming the SDR has been calibrated against some kind of reference ( [GSM](https://www.rtl-sdr.com/how-to-calibrate-rtl-sdr-using-kalibrate-rtl-on-linux/), [LTE](https://gist.github.com/darksidelemm/b517e6a9b821c50c170f1b9b7d65b824)), then according to the results above, drift-related performance degradation won't be an issue for these SDRs.

For SDRs *without* TCXOs temperature related drift can be significant, even just from self-heating of the SDR during regular operation. 10-20 ppm drift during warm-up is not unheard of. Looking at the above table, depending on the SDRs initial frequency offset, that kind of drift could cause significant performance degradation. Even if the high-pass filter is added to the decode chain, there is no guarantee that non-TCXO RTLSDRs will work reliably, if at all.

I am somewhat loathe to intentionally introduce a change that degrades receive performance with the recommended receive hardware, even if it is only by a fraction of a dB. Still, to at least enable some experimentation with the cheaper non-TCXO SDRs, an 'advanced' option will be added to enable the high-pass filter for the RS41 decode chain. Users with the cheaper SDRs may be be able to get *some* operation out of auto_rx, but should not expect the same level of performance as a TCXO SDR. 