# 2019-04-26 Experimental fsk_demod-based Demod Chains
auto_rx release 1.1.0 introduces an alternate 'experimental' demodulation chain, which provides some potential improvements over the existing FM-demod based demodulation for certain receive situations.

The new demodulation chains utilise the 'fsk_demod' demodulator from [David Rowe](https://rowetel.com/)'s [codec2](https://github.com/drowe67/codec2) repository. This FSK demodulator was developed for use in VHF/UHF digital voice applications, ans has also been used in high-altitude balloon telemetry, in particular for the Project Horus ['Wenet'](https://github.com/projecthorus/wenet) imagery payload. The modem is [well tested](https://github.com/drowe67/codec2/blob/master/README_fsk.txt), and performs within a fraction of a dB of theoretical incoherent FSK modem performance. 

With tuning of filter bandwidth, the existing FM-demod system has been optimized to acheive very good PER performance (possibly close to theoretical, but this needs to be verified), however where it has problems is with frequency offsets. These offsets can be due to thermal drift in the radiosonde (DFM, LMS6, and RS92-NGPs are known to drift), or drift in the receiver (due a poor-quality LO). As has been [noted previously](https://github.com/darksidelemm/radiosonde_auto_rx/blob/testing/auto_rx/test/notes/2019-04-23_rs41_highpass.md), the performance of the existing decoders falls off considerably with frequency offsets, with approx 3dB degradation at 3kHz offset.

Instead of passing the radiosonde signal through a FM demodulator and performing data-slicing, bandpass filtered and resampled complex samples are fed into fsk_demod, which performs frequency estimation, enabling it to track the radiosonde signal anywhere within the supplied passband (approx 35 kHz of bandwidth). The advantage is that ideal FSK demodulation performance is acheived so long as the signal is contained within that passband. The downside of this approach is that it is susceptible to in-band interference that is equal-to or stronger-than the wanted signal. In these situations the modem will 'lock on' to the strongest two peaks, resulting in no decode.

## Demodulator Performance

To quantify the performance of the experimental decode chain, the test_demod.py script was use to run a set of known-Eb/No signals through the demodulator, and count the number of received packets. The method of producing the test signals is [described here](https://github.com/projecthorus/radiosonde_auto_rx/blob/master/auto_rx/test/notes/2019-03-03_generate_lowsnr_validation.md). The number of packets received (`rxed`) is compared with the known number of packets in each test file (based on demodulation of the 'reference', high-SNR, file), and the Packet Error Rate (PER) calculated as `1 - (rxed/reference)`.


### Existing FM-demod
![PER Performance - FM Demod 2019-04-26](https://rfhead.net/sondes/plots/per_20190426_rtlfm.png)

### Existing FM-demod - 3kHz Frequency Offset
![PER Performance - FM Demod, 3kHz offset](https://rfhead.net/sondes/plots/per_20190426_rtlfm_3khz.png)

### fsk_demod
![PER Performance - fsk_demod 2019-04-26](https://rfhead.net/sondes/plots/per_20190426_fsk_demod.png)

### fsk_demod - 3kHz Frequency Offset
![PER Performance - fsk_demod, 3kHz offset](https://rfhead.net/sondes/plots/per_20190426_fsk_demod_3khz.png)

We can see there is a small amount (approx 1dB) degradation in performance between the FM and fsk_demod chains (observed at the 0.5 PER point) for RS41 and RS92 sondes. DFM sondes have an improvement of approx 1dB, and M10 sonde decoding performance is unchanged.

With a 3kHz frequency offset, the performance of the FM-demod decode chains degraded significantly, to the point at which the RS92 decoder fails completely due to the tight filtering used. No degradation is observed on the fsk_demod chain.

There is likely some optimizations that can be performed to improve performance, but in real-world decoding situations the slight performance changes between the FM and FSK demodulators are unlikely to be noticable - except in situations where frequency drift is encountered.


## Modem Statistics
Thanks to Brady O'Brien, fsk_demod can output modem statistics in JSON format. These statistics include:
* Eb/N0 estimates
* Frequency estimator outputs
* Symbol Rate error estimates
* Passband spectrum data

Shown below are a few plots showing the Eb/N0 estimate and frequency estimator outputs over an entire tracked radiosonde flight:

![fsk_demod Eb/N0 Estimate](https://rfhead.net/sondes/plots/fsk_demod_ebno_estimate.png)
![fsk_demod FSK Frequency Estimate](https://rfhead.net/sondes/plots/fsk_demod_fest.png)

In these plots we can see the modem locking onto the signal at the start of the flight, with the Eb/N0 varying throughout the flight. Some dips possibly due to antenna nulls can be seen near the start (sample 9000) and end (sample 42000) of the flight. As the sonde drops in elevation, the Eb/N0 falls quickly, before the modem loses lock on the signal. The erratic Eb/N0 values at the end is likely the modem locking onto a CW interferer within the receiver passband.

Eventually these statistics will be integrated into auto_rx, and available on the Web interface. For now, they are saved to disk, and can be viewed using the `test/plot_fsk_demod_stats.py` script.

## Enabling the experimental demodulators
Users will now find a 'Demodulator / Decoder Tweaks' section near the bottom of the station.cfg file, where usage of the experimental decode chain can be enabled on a per-sonde-type basis. 

It is expected that the new experimental demod chain will have a higher CPU usage than the legacy chains, though the exact impact is yet to be determined. Users running more than one RTLSDR would be advised to use a Raspberry Pi 3 or newer.

It should be noted that these demodulators are really only intended for use in situations where radiosonde frequency drift is encountered. Stations that only receive RS41 radiosondes are advised to continue using the legacy receive chain due to its slightly higher performance. Stations that experience a high level of interference should also continue using the legacy decoders.

Situations where the experimental demod may provide improvements include:

* Areas with predominantly DFM-06 and DFM-09 radiosondes.
* Areas flying RS92-NGP radiosondes on 1680 MHz (the performance improvement on this sonde type is untested so far).

Please report any issues!
