#!/usr/bin/env python
#
#   Investigate dft_detect correlation outputs - Plotting
#	Plots the CSV output generated by dft_detect_scores.py
#
#   Copyright (C) 2018  Mark Jessop <vk5qi@rfhead.net>
#   Released under GNU GPL v3 or later
#

import glob
import argparse
import os
import sys
import time
import subprocess
import numpy as np
import matplotlib.pyplot as plt

parser = argparse.ArgumentParser()
parser.add_argument("-f", "--filename", type=str, default=None, help="CSV Filename to plot.")
parser.add_argument("-t", "--title", type=str, default="Correlation Scores", help="Plot Title")
parser.add_argument("-s", "--save", type=str, default=None, help="Save plot to file.")
parser.add_argument("-v", "--verbose", action='store_true', default=False, help="Show additional debug info.")
args = parser.parse_args()



# Sonde types to show on the plot.
# Lines are shown as dashed when below their threshold value.
TYPES = {
	'RS41':{'color':'C0', 'threshold':0.53}, 
	'RS92':{'color':'C1','threshold':0.54}, 
	'DFM9':{'color':'C2','threshold':0.62}, 
	'M10':{'color':'C3','threshold':0.75}, 
	'LMS6':{'color':'C4','threshold':0.70}
}


data = np.genfromtxt(args.filename,dtype=float, delimiter=',', names=True,usecols=(0,1,2,3,4,5))


plt.figure(figsize=(10,5))

for _type in TYPES:
	# Plot 
	plt.plot(data['snr'], data[_type], color=TYPES[_type]['color'])
	plt.scatter(data['snr'][ data[_type]>=TYPES[_type]['threshold'] ], data[_type][ data[_type]>=TYPES[_type]['threshold'] ], label=_type, color=TYPES[_type]['color'])

	_max = np.max(data[_type])
	print("%s Maximum Correlation Score: %.4f" % (_type, _max))

plt.title("dft_detect Correlation - " + args.title)
plt.xlabel("Eb/N0 (db)")
plt.ylabel("Correlation Score")
plt.legend()
plt.grid()

if args.save != None:
	plt.savefig(args.save, bbox_inches='tight')

plt.show()