#!/bin/sh
##############################################################################
# Configuration
##############################################################################
product="TomTom GO"
fstype="vfat"
fsdevs="ttsd mmcblk0 hda"
mntopt="rw,sync,exec,noatime,nodev,nosuid"
devbase="/dev"
sdmnt="/mnt/sdcard"
flashdir="/mnt/flash"
ttnapp="ttn"
ttndir="/bin"
ttpnpdapp="ttpnpd"
ttpnpddir="/bin"

#Change for GL gps receiver
gl_baudrate="115200"
gl_asic="/dev/gpsdata"
flash_gl=/mnt/flash/extra_settings

##############################################################################
# Functions
##############################################################################

start_ttn() {
  if test "${hw_gldetected}" = "0"; then
    if test "${hw_gpsephemeris}" = "0" -a -f /var/run/sirfreset.pid; then
      echo "* Waiting for application to finish..."
      wait $(cat /var/run/sirfreset.pid)
      echo "*  ...finished"
    fi
  fi
  if test -f /etc/debug; then
    appdir=${ttndir}
    echo "* Starting ${appdir}/${ttnapp}" >> /mnt/$1/ttMaps/ttmaps.log
    ${appdir}/${ttnapp} &
  else
    echo "* Starting ${product}" >> /mnt/$1/ttMaps/ttmaps.log
    ${ttndir}/${ttnapp} </dev/null >/dev/null 2>&1 &
  fi
}

##############################################################################
# Test TomTom Application version
if [ -f /mnt/sdcard/ttgo.ori ] ; then
	VersionString=$(grep ApplicationVersionVersionNumber /mnt/sdcard/ttgo.ori)
else
	VersionString=$(grep ApplicationVersionVersionNumber /mnt/sdcard/ttgo.bif)
fi
AppMainVersion=$(echo $VersionString | cut -c 33)
AppVersion=$(echo $VersionString | cut -c 33-34)
echo "Application Version="$AppVersion >> /mnt/$1/ttMaps/ttmaps.log
echo "Main Version="$AppMainVersion >> /mnt/$1/ttMaps/ttmaps.log
echo -n "Battery Type="${hw_batterytype} >> /mnt/$1/ttMaps/ttmaps.log
case ${hw_batterytype} in
	0) echo " (Undefined)"  >> /mnt/$1/ttMaps/ttmaps.log;;
	1) echo " (ICR18650, 2200 mAh)" >> /mnt/$1/ttMaps/ttmaps.log ;;
	2) echo " (1100 mAh)" >> /mnt/$1/ttMaps/ttmaps.log ;;
	3) echo " (ICP803443; 1350 mAh)" >> /mnt/$1/ttMaps/ttmaps.log ;;
	4) echo " (1320 mAh)" >> /mnt/$1/ttMaps/ttmaps.log ;;
	5) echo " (920 mAh)" >> /mnt/$1/ttMaps/ttmaps.log ;;
	6) echo " (VARTA 1460 100)" >> /mnt/$1/ttMaps/ttmaps.log ;;
	7) echo " (MAXELL 1100 130)" >> /mnt/$1/ttMaps/ttmaps.log ;;
	8) echo " (LISHEN 900 mAh)" >> /mnt/$1/ttMaps/ttmaps.log ;;
	9) echo " (LISHEN 1100 mAh)" >> /mnt/$1/ttMaps/ttmaps.log ;;
	*) echo " (Unknown)" >> /mnt/$1/ttMaps/ttmaps.log ;;
esac

if [ "$AppMainVersion" = "" ] ; then
	echo "The ttgo.bif file is missing."   >> /mnt/$1/ttMaps/ttmaps.log
elif [ "$AppMainVersion" = "4" ] || [ "$AppMainVersion" = "5" ]  || [ "$AppMainVersion" = "6" ] ; then
	echo "The TomTom application you are using is too old, please update it with TomTom Home"   >> /mnt/$1/ttMaps/ttmaps.log
else
	cd /mnt/$1/ttMaps/
	if [ "$2" = "" ] ; then
		running=0
		while [ "$running" -eq "0" ] ; do
			ps | grep -v grep | grep startttmaps.sh
			running=$?
		done
	
		killall ttn >>ttmaps.log 2>&1
		killall ttsserver

		running=0
		while [ "$running" -eq "0" ] ; do
			ps | grep -v grep | grep ttn
			running=$?
		done
	
		# Copy ttn script to sdcard root to allow automatic restart of ttMaps if the TomTom reboots
		if [ -f /mnt/sdcard/ttn ] ; then
			mv /mnt/sdcard/ttn /mnt/sdcard/ttn.orig
		fi
		cp /mnt/$1/ttMaps/ttn.autorun /mnt/sdcard/ttn
	fi

	# Launch ttMaps
	if [ "$AppMainVersion" = "7" ]  || [ "$AppVersion" = "80" ] || [ "$AppVersion" = "81" ] ; then
		bug=0
		PROJ_LIB=/mnt/$1/ttMaps/proj GCONV_PATH=/mnt/$1/ttMaps LOCPATH=/mnt/$1/ttMaps /mnt/$1/ttMaps/ttmaps -p >>ttmaps.log 2>&1
	else
		bug=1
		PROJ_LIB=/mnt/$1/ttMaps/proj GCONV_PATH=/mnt/$1/ttMaps LOCPATH=/mnt/$1/ttMaps /mnt/$1/ttMaps/ttmaps >>ttmaps.log 2>&1
	fi
	rc=$?
	echo "ttMaps return code =" $rc >> ttmaps.log 
	
	if [ $rc -eq 32 ] || [ $rc -eq 78 ] || ( [ $rc -eq 79 ] && [ $bug -ne 0 ] ); then
		if [ -f /mnt/sdcard/ttn.orig ] ; then
			echo "Restoring old ttn file" >>ttmaps.log
			mv  /mnt/sdcard/ttn.orig /mnt/sdcard/ttn
		else
			echo "Removing ttn" >>ttmaps.log
			rm /mnt/sdcard/ttn >>ttmaps.log 2>&1
		fi
	fi

	if [ $rc -eq 32 ] || [ $rc -eq 33 ]; then
		killall ttpnpd
		killall clmapp
		killall gltt
		killall glgps
		echo "/etc/showopenfiles" >> ttmaps.log 
		/etc/showopenfiles >> ttmaps.log 2>&1
		echo "Power off" >> ttmaps.log 
		cd /
		umount /mnt/$1
		umount /mnt/sdcard
		sync
		sync
		ln -s /sbin/sysreboot /bin/poweroff
		sleep 1
		/bin/poweroff
	else
		if ( [ $rc -eq 78 ] || [ $rc -eq 79 ] ) && ( [ $bug -eq 0 ] || [ "$2" = "auto" ] ); then
			if [ -f /mnt/sdcard/ttn ] ; then
				grep ttMaps /mnt/sdcard/ttn
				if [ $? -eq 1 ] ; then
					echo "Launch ttn" >> ttmaps.log 
					/mnt/sdcard/ttn &
					exit
				fi
			fi
			echo "Relaunch ttn" >> ttmaps.log 
			sync
			sync
			start_ttn &
		else
			killall ttpnpd
			killall clmapp
			killall gltt
			killall glgps
			echo "/etc/showopenfiles" >> ttmaps.log
			/etc/showopenfiles >> ttmaps.log 2>&1
			echo "Reboot" >> ttmaps.log 
			cd /
			umount /mnt/movinand
			umount /mnt/sdcard
			sync
			sync
			/sbin/reboot
		fi
	fi
fi

